#ifndef __PGGrid__
#define __PGGrid__

#include "Globals.h"

enum Grid_Direction { GD_NULL=0, NE=2, EE, SE, SS, SW, WW, NW, NN, UU, DD };
enum EG_LinkMode { kL_Output, kL_Input };

const byte kGP_NoData = 255;
const byte kGP_MaxInValue = 200;
const byte kGP_MinInValue = 1;
const byte kGP_DebugPointValue = 200;
const int  kGP_LinkTagBottom = 1000;

inline int GMR(int& rr, int& rc, Grid_Direction index) 
{
  switch(index) {
  case SE: rr= 1; rc= 1; break;  
  case SS: rr= 1; rc= 0; break;
  case SW: rr= 1; rc=-1; break;   
  case WW: rr= 0; rc=-1; break;
  case NW: rr=-1; rc=-1; break;
  case NN: rr=-1; rc= 0; break;
  case NE: rr=-1; rc= 1; break;
  case EE: rr= 0; rc= 1; break;
  default: return 0;
  }
  return 1;
}
inline Grid_Direction firstGD() { return NN; }
inline Bool moreGD(Grid_Direction index) { return (index != GD_NULL); }

inline void incrGD(Grid_Direction& index) 
{
  switch(index) {
  case SE: index = SS;  break;
  case SS: index =  SW;   break;
  case SW: index =  WW;  break;   
  case WW: index =  NW;  break; 
  case NW: index =  GD_NULL;   break;
  case NN: index =  NE;  break; 
  case NE: index =  EE;   break;
  case EE: index =  SE;   break;
  default: index =  GD_NULL;  break; 
  }
}

inline void incrGD_NEWS(Grid_Direction& index) 
{
  switch(index) {
  case SE: index =  SS;   break; 
  case SS: index =  WW;   break;
  case SW: index =  WW;   break;  
  case WW: index =  GD_NULL;   break;
  case NW: index =  GD_NULL;  break; 
  case NN: index =  EE;   break;
  case NE: index =  EE;   break;
  case EE: index =  SS;   break;
  default: index =  GD_NULL;   break;
  }
}
#endif
