#include "HDFMgr.h"
#include "Environ.h"
#include "TMap.h"
#include "Series.h"
// #include "TDataSet.h"
// #include "TPipe.h"

//----------------------------------------------------------------------------------------
// HDFMgr
//----------------------------------------------------------------------------------------


int LogLevel = 2;

CPathString HDFM::fPath;
int32  HDFM::fFile = 0;
int32  HDFM::fTopRef = 0; 
int32  HDFM::fArraysRef = 0; 
int32  HDFM::fMapsRef = 0; 
int32  HDFM::fSeriesRef = 0; 
int32  HDFM::fDataRef = 0;
int32  HDFM::fNTagRefs = 0;
int32  HDFM::fCurrentRef = -1;
int32  HDFM::fParentRef = -1;
int32  HDFM::fVGID_Current = -1;
int32  HDFM::fSD_id = 0;

byte  HDFM::fInfo[16] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }; 
int32  HDFM::fSDSRef=0;
int32  HDFM::fRef;

char  HDFM::fTmp0[kAttrStrLen];
char  HDFM::fTmp1[kAttrStrLen];
char  HDFM::fTmp2[kAttrStrLen];
	
SDSObject*  HDFM::fSDSObject = NULL;
ArgArray HDFM::fArg;
TMap* HDFM::fCurrentMap = NULL;
// TAnimPipe* fAnim = NULL; 			

// void HDFM::ClearAnim() { if( fAnim) delete fAnim; fAnim = NULL; }

int32 HDFM::Open ( EIOType ioType ) {
#ifdef HAS_HDF
  if( ioType != fInfo[kIOMode] ) { 
    if( fInfo[kIOMode] != kFNone ) HDFM::Close();
    if( ioType == kFInput  ) {
      HDFM::Open( Env::DataPath(),"ri"); 
      fInfo[kIOMode] = kFInput;
    } else if ( ioType == kFOutput ) {
      if( fInfo[kFirstOut] ) HDFM::Open( Env::ArchivePath(), "wo");
      else HDFM::Open( Env::ArchivePath(), "co" );
      fInfo[kIOMode]= kFOutput;
      fInfo[kFirstOut] = 1;
    } else if ( ioType ==  kFReadArchive ) {
			if( HDFM::Open( Env::ArchivePath(), "ro") == FAIL ) return FAIL;
			fInfo[kIOMode] = kFInput;
    }
  }
#endif
  return fSD_id;
}

int32 HDFM::Open(const CPathString& filePath, const char* mode) {
#ifdef HAS_HDF
  static int firstCall = 1;
  fPath = filePath;
 
  if( mode[1]=='i' ) fPath += Env::HDFInputFile();
  else if( mode[1]=='o' ) fPath += "DriverOutput.hdf";
  else { gPrintErr("Unknown HDF Read Mode(1) (i/o)");  }
  if( mode[0]=='c' ) { fSD_id = SDstart(fPath, DFACC_CREATE); fFile = Hopen(fPath, DFACC_RDWR, 0); } 
  else if(mode[0]=='r') { fSD_id = SDstart(fPath, DFACC_READ); fFile = Hopen(fPath, DFACC_READ, 0); }
  else if( mode[0]=='w' ) { fSD_id = SDstart(fPath, DFACC_WRITE); fFile = Hopen(fPath, DFACC_WRITE, 0); }
  else { gPrintErr("Unknown HDF Read Mode(0) (c/r/w)"); }
  if(fFile == FAIL) { sprintf(gMsgStr,"Not using HDF SimIO global input file."); gPrintScreen(); return FAIL; }
  else { sprintf(gMsgStr,"Opened HDF File %s, SD_id = %d.",fPath.chars(),fSD_id); gPrintScreen();}
  Vstart(fFile);

  int32 vgid_Top, vgid_Arrays , vgid_Maps , vgid_Series , vgid_Data;  
  if( mode[0]=='c' || ( mode[0]=='w' && ( fTopRef = GetVG( -1, "Top", kRef ) ) == FAIL ) ) {
    vgid_Top = Vattach((HFILEID)fFile, -1, "w");
    if( vgid_Top == FAIL ) { printf("VGroup Top Allocation Error."); BreakToSourceDebugger_(); }
    Vsetname(vgid_Top,"Top");
    fTopRef = GetVG( -1, "Top", kRef );
    vgid_Arrays = Vattach((HFILEID)fFile, -1, "w");
    Vsetname(vgid_Arrays,"Arrays");
    Vinsert(vgid_Top,vgid_Arrays);
    fArraysRef = GetVG( -1, "Arrays", kRef  );
    Vdetach(vgid_Arrays);	
    vgid_Maps = Vattach((HFILEID)fFile, -1, "w");
    Vsetname(vgid_Maps,"Maps");
    Vinsert(vgid_Top,vgid_Maps);
    fMapsRef = GetVG( -1, "Maps", kRef  );
    Vdetach(vgid_Maps);	
    vgid_Series = Vattach((HFILEID)fFile, -1, "w");
    Vsetname(vgid_Series,"Series");
    Vinsert(vgid_Top,vgid_Series);
    fSeriesRef = GetVG( -1, "Series", kRef  );
    Vdetach(vgid_Series);	
    vgid_Data = Vattach((HFILEID)fFile, -1, "w");
    Vsetname(vgid_Data,"Data");
    Vinsert(vgid_Top,vgid_Data);
    fDataRef = GetVG( -1, "Data", kRef  );
    Vdetach(vgid_Data);
    Vdetach(vgid_Top);		
  } else {
    fArraysRef = GetVG( -1, "Arrays", kRef  );
    fMapsRef = GetVG( -1, "Maps", kRef  );
    fSeriesRef = GetVG( -1, "Series", kRef  );
    fDataRef = GetVG( -1, "Data", kRef  );
  }
  firstCall = 0;
#endif
  return fSD_id;
}

void HDFM::Close() {
#ifdef HAS_HDF
  if( fInfo[kIOMode] != kFNone ) { 
    Vend(fFile);
    Hclose(fFile); 
    SDend(fSD_id);
  }
#endif
}

int32 HDFM::GetVG( int32 vgRef, const char* name, EVDataRef ref  ) {
#ifdef HAS_HDF
  int32 vgID;
  while( ( vgRef = GetNextRef(vgRef) ) != -1 ) {
    vgID = Vattach((HFILEID)fFile,vgRef,"r");
    Vgetname(vgID,fTmp0);
    if( strcmp(fTmp0,name) == 0 ) { 
      if( ref == kID ) return vgID;
      else  {
	Vdetach(vgID);
	return vgRef;
      }
    }
    Vdetach(vgID);
  }
#endif
  return -1;
}

int32 HDFM::GetChild( int32 vgParentID, const char* name, const char* className, EVDataType tag, EVDataRef rtype ) {
#ifdef HAS_HDF
  if(LogLevel>1) { 
    sprintf(gMsgStr,"\n-------------GetChild: Checking for Group/Data %s, type = %d, classPtr = %x, parent = %d",
	    name,tag,className,vgParentID); gPrintLog();
    if(className) sprintf(gMsgStr," class = %s\n",className);
    else sprintf(gMsgStr,"\n");  
    gPrintLog();
  }
  int32 found = 0, vgsID, ref;
  int32 ntags = Vntagrefs(vgParentID);
  for( int i=0; i<ntags; i++ ) {
    int32 atag;
    if( Vgettagref(vgParentID,i,&atag,&ref) == FAIL) {
      printf("VGroup read error."); BreakToSourceDebugger_();
      break; 
    } else { 
      if( GetType(atag) == kVData && tag == kVData ) {
				vgsID = VSattach((HFILEID)fFile,ref,"r");
				VSgetname(vgsID,fTmp0);
				if(LogLevel>1) { sprintf(gMsgStr," Checking Data %s\n",fTmp0);  gPrintLog(); }
				if( strcmp(fTmp0,name) == 0 )  { 
					if( className == NULL ) { found = 1; VSdetach(vgsID); break; }
					else {
						VSgetclass(vgsID,fTmp0);
						if( strcmp(fTmp0,className) == 0 ) { found = 1; VSdetach(vgsID); break; }
					}  
				}
				VSdetach(vgsID);
      } else  if(  GetType(atag) == kSData && tag == kSData ) {
				int32 sd_index = SDreftoindex(fSD_id,ref);
				int32 sds_id = SDselect(fSD_id,sd_index);
				int32 rank, dim[3] = { 0, 0, 0 }, dtype, nattr; 
				SDgetinfo(sds_id,fTmp0,&rank,dim,&dtype,&nattr);
				if(LogLevel>1) { sprintf(gMsgStr," Checking Data %s\n",fTmp0);  gPrintLog(); }
				if( strcmp(fTmp0,name) == 0 )  { found = 1; SDendaccess(sds_id); break; }
				SDendaccess(sds_id);
      } else if( GetType(atag) == kVGroup && tag == kVGroup ) {
				vgsID = Vattach((HFILEID)fFile,ref,"r");
				Vgetname(vgsID,fTmp0);
				if(LogLevel>1) { sprintf(gMsgStr," Checking Group %s\n",fTmp0); gPrintLog(); }
				if( strcmp(fTmp0,name) == 0 )  { 
					if( className == NULL ) { found = 1; VSdetach(vgsID); break; }
					else {
						Vgetclass(vgsID,fTmp0);
						if( strcmp(fTmp0,className) == 0 ) { found = 1; Vdetach(vgsID); break; }
					}  
				}
				Vdetach(vgsID);
			}
    }
  }
  if( found == 1 ) {
    if( rtype == kID ) return vgsID;
    else  return ref;
  }
#endif
	return (int32)(-1);
}

int32 HDFM::CreateDSetSubgroup( const char* dsetName, const char* subgroupName, const char* className ) {
  int32 vg = -1;
#ifdef HAS_HDF
  int32 vgid_Top = Vattach((HFILEID)fFile,fTopRef,"r");
  int32 vgmRef = GetChild( vgid_Top, dsetName, NULL, kVGroup, kRef );
  if( !vgmRef ) { printf("Error, No Vgroup dset Found."); BreakToSourceDebugger_(); }
  int32 vgm = Vattach((HFILEID)fFile, vgmRef, "w");
  int32 vgRef = GetChild( vgm, subgroupName, className,  kVGroup, kRef );
  if(vgRef < 0) {
    vg = Vattach((HFILEID)fFile, -1, "w");
    Vsetname(vg,subgroupName);
    if(className != NULL) Vsetclass(vg,className);
    int vindex = Vinsert(vgm,vg);
    if(vg>0 && gDebug>1) { 
			int32 atag, ref;
			Vgettagref(vgm,vindex,&atag,&ref);
			sprintf(gMsgStr,"Created SubGroup %s, Tag = %d, Ref = %d",subgroupName,atag,ref); gPrintScreen(); 
		}
  }
  else vg = Vattach((HFILEID)fFile, vgRef, "w");
  if(vg < 0) { printf("Error, Can't make Subgroup."); BreakToSourceDebugger_(); }  
  Vdetach(vgm);
  Vdetach(vgid_Top);
#endif
  return vg;
}

void HDFM::SetSDS(int32 ref) { 
#ifdef HAS_HDF
  Finalize(); 
  SDSObject* sobj; 
  fRef = ref;
  switch( Class() ) {
//  case kFArray: 
//    sobj = new Plex; 
//    break; 
  case kFMap:
    sobj = new TMap;  
    break; 
  case kFSeries: 
  case kFPointSeries:
    sobj = new TTemporalSeries;  
    break; 
  case kFDataSet: 
  case kFDBaseParm:
//    sobj = new TDataSet;  
    break; 
  }
  fSDSObject = sobj;
#endif
}

HDFM::EVDataType HDFM::GetType( int32 tag ) {
#ifdef HAS_HDF
  switch( tag ) {
  case DFTAG_VG: return kVGroup; 
  case DFTAG_VH: return kVData; 
  case DFTAG_NDG: case DFTAG_SD: return kSData; 
  default: return kUnknown;
  }
#endif
	return kUnknown;
}

int  HDFM::PopDir( int toTop ) {
  int32 tag, ref;
  fInfo[kStatus] = 1;
  byte mode = Mode();
  if(toTop) {
    fCurrentRef = fTopRef; 
    fParentRef = -1; 
    fInfo[kClass] = kFUndefined;
    fInfo[kHLevel] = 0; 
    fInfo[kType]  = kVGroup;
  } 
  else if( fParentRef == -1 ) return 0;
  else {
    fCurrentRef = fParentRef;
    if( --fInfo[kHLevel] == 0 ) { fInfo[kClass] = kFUndefined; }
    fInfo[kType]  = kVGroup;
  }
  return GetArgs();
} 

int HDFM::PushDir( int index  ) 
{
  int32 tag, ref;
#ifdef HAS_HDF
  fInfo[kStatus] = 1;
  byte mode = Mode();
  if(index<0) { 
    fCurrentRef = fTopRef; 
    fParentRef = -1; 
    fInfo[kClass] = kFUndefined;
    fInfo[kHLevel] = 0; 
  }
  else if ( index > fNTagRefs ) { 
    gPrintErr("Error, Illegal Index"); 
    fInfo[kStatus] = 0;  
    return 0; 
	}
  else {
    fParentRef = fCurrentRef;
    fVGID_Current = Vattach((HFILEID)fFile,fCurrentRef,"r");
    if( Vgettagref(fVGID_Current,index,&tag,&ref) == FAIL) {
      gPrintErr("No data or Subgroups.");
      fInfo[kStatus] = 0;
			fInfo[kNArgs]  = 0;
			fArg.clear();
			fSDSObject = NULL;
      return 0;
    }
    if( fInfo[kHLevel]++ == 0 ) {
      fInfo[kClass] = Class(ref);
    }
    fInfo[kType]  = GetType( tag );
    fCurrentRef = ref;
    Vdetach(fVGID_Current);
  }
  return GetArgs();
#endif
  return 0;
}
	
HDFM::EVDataClass HDFM::Class(int32 vgRef) { 
  if(vgRef == fArraysRef) return kFArray; 
  else if(vgRef == fMapsRef) return kFMap; 
  else if(vgRef == fSeriesRef) return kFSeries; 
  else if(vgRef == fDataRef) return kFDataSet;
  else return kFUndefined; 
}

HDFM::EVDataType HDFM::GetRefAndType(int32 vgID, int igroup) {
  int32 ref, tag;
#ifdef HAS_HDF
  if( Vgettagref( vgID, igroup, &tag, &ref ) == FAIL) {
    gPrintErr("VGroup read error."); 
    fInfo[kStatus] = 0;
    return kUnknown;
  }
  fRef = ref;
  return GetType( tag );
#endif
  return (EVDataType)0;
}
  
int HDFM::GetArgs() {
#ifdef HAS_HDF
	fArg.clear();
  fSDSObject = NULL;
  if( Type() == kVGroup) {
		fVGID_Current = Vattach((HFILEID)fFile,fCurrentRef,"r");
		if(fVGID_Current == FAIL) { return -1;  }
		if( (fNTagRefs = Vntagrefs(fVGID_Current)) == 0 ) { fInfo[kNArgs]  = 0; return 1;  }
		else { fInfo[kNArgs]  = fNTagRefs; }
		int32 vgs, ntags;
    for( int ig=0; ig<fNTagRefs; ig++ ) {
      switch ( GetRefAndType( fVGID_Current, ig ) ) { 
      case kVData: 
				vgs = VSattach((HFILEID)fFile,fRef,"r");
				if(vgs == FAIL) {
					fArg.Add("bogus d 0");
				} else {
					VSgetname(vgs,fTmp0);
					sprintf(fTmp1,"%s d %d",fTmp0,fRef);
					fArg.Add(fTmp1);
					VSdetach(vgs);
				}
				break;
      case kVGroup:
				vgs = Vattach((HFILEID)fFile,fRef,"r");
				if(vgs == FAIL) {
					sprintf(fTmp1,"bogus g 0 %d",fTmp0,fRef);
					fArg.Add(fTmp1);
				} else {
					Vgetname(vgs,fTmp0);
					ntags = Vntagrefs(vgs);
					sprintf(fTmp1,"%s g %d %d",fTmp0,ntags,fRef);
					fArg.Add(fTmp1);
					Vdetach(vgs);
				}
				break;
      case kSData:
				int32 sd_index = SDreftoindex(fSD_id,fRef);
				int32 sds_id = SDselect(fSD_id,sd_index);
				int32 rank, dim[3] = { 0, 0, 0 }, dtype, nattr; 
				SDgetinfo(sds_id,fTmp0,&rank,dim,&dtype,&nattr);
				sprintf(fTmp1,"%s sds%d (%d %d %d) %d",fTmp0,rank,dim[0],dim[1],dim[2],fRef);
				fArg.Add(fTmp1);
				SDendaccess(sds_id);
      }
    }
		Vdetach(fVGID_Current);
  } else if( Type() == kSData ) {
    SetSDS(fCurrentRef);
    SetInfo(kType,kSData);
		int32 sd_index = SDreftoindex(fSD_id,fCurrentRef);
		int32 sds_id = SDselect(fSD_id,sd_index);
    if( fCurrentMap == NULL )  fCurrentMap = new TMap((EMapClass)kUnknown,kIOex); 
		int32 rank, dim[3] = { 0, 0, 0 }, dtype, nattr; 
		SDgetinfo(sds_id,fTmp0,&rank,dim,&dtype,&nattr);
		fCurrentMap->DSetName(fTmp0);
		((ByteGrid*)fCurrentMap)->ReAlloc( 0, 0, dim[1]-1, dim[2]-1, 1 );
		fCurrentMap->SetByteConversion( 1.0, 0.0, 1 );
		int32 vgp = Vattach((HFILEID)fFile,fParentRef,"r");		
		Vgetname(vgp,fTmp1);
		fCurrentMap->VariableName(fTmp1);
/*
		if( fAnim == NULL ) {
			fAnim = new TAnimPipe(fTmp0,fCurrentMap);
			fAnim->Initialize();
		}
		for( int i=0; i<dim[0]; i++) {
			if( fCurrentMap->SDRead(i) == FAIL ) { return 0; }
			fAnim->Execute();
		}
*/
		sprintf(fTmp2,"Animate %s:%s sds%d (%d %d %d) %d",fTmp1,fTmp0,rank,dim[0],dim[1],dim[2],fRef);
		fArg.Add(fTmp2);
		fCurrentMap->ClearSDS();
		SDendaccess(sds_id);
  }
#endif
  return 1;
}

int HDFM::ReadSDSToMap(TMap& map, const char* dSetName, const char* varName, int index ) {
	int rv = 1;
#ifdef HDF
	Open ( kFReadArchive );
	map.DSetName(dSetName);
	map.VariableName(varName);
	if( map.SDRead(index) == FAIL ) { rv =  0; }
	map.ClearSDS();
#endif
	return rv;
}

int HDFM::AddSDS( int32 sds_id, EVDataClass type, const char* variableName ) {
  CString className;
  int rv = -1;
#ifdef HAS_HDF
  switch( type) {
  case kFArray: 
    className = "Arrays"; 
    break; 
  case kFMap: 
    className = "Maps"; 
    break; 
  case kFSeries: 
  case kFPointSeries: 
    className = "Series"; 
    break; 
  case kFDataSet: 
  case kFDBaseParm:
    className = "Data"; 
    break; 
  } 
    int32 ref = SDidtoref(sds_id);
    int32 vg = CreateDSetSubgroup( className.chars(), variableName, NULL );
    rv = Vaddtagref(vg, DFTAG_NDG, ref );
    Vdetach(vg);
#endif
    return rv;
}

int ImportMap( char* name, char* pathName, char* fileName, int format ) {
  if( gIProc == 0 ) { 
    TMap map;
    map.Import(pathName,fileName,format);
    map.VariableName("Import");
    map.DSetName(name);
    return map.SDWrite();
  }
  return 0;
}

int ImportSeries( char* name, char* pathName, char* fileName, int format ) {
  if( gIProc == 0 ) { 
    TTemporalSeries s;
    CString path(pathName); path += fileName;
    s.Import(path,format);
    s.VariableName("Import");
    s.DSetName(name);
    return s.SDWrite();
  }
  return 0;
}

int ImportPtSeries( char* name, char* dataPathName, char* fileName, int format ) {

  CString s0(dataPathName); s0 += fileName;
  FILE* cfile = fopen(s0.chars(),"r");
  if(cfile==NULL) { sprintf(gMsgStr,"ERROR: Unable to open pts file %s",fileName); gFatal(); }
  else { sprintf(gMsgStr,"Reading file %s",fileName); gPrintScreen(); }
  int itest = Util::scan_forward(cfile,"Data Directory"); if(itest==-1)  { return 0; }  
  itest = Util::scan_forward(cfile,"="); if(itest==-1)  { return 0; }

  char tmp[100];
  fscanf(cfile,"%s",tmp);
  CString spath(tmp);

  TPtSeries ptseries(name);
  ptseries.VariableName("Import");
  ptseries.DSetName(name);

  int ix, iy, sCnt=0;
  while(1) {
    int tst = fscanf(cfile,"%d",&ix);
    if( tst > 0  ) {
      fscanf(cfile,"%d",&iy); 
      tst = fscanf(cfile,"%s",tmp); 
    }
    if(tst<1) break;

    Point2 pt(ix,iy);
    ptseries.SetPoint(pt);

    for(int index=0; index<100; index++) {
      CString sfile(spath); sfile+= tmp; sfile.appendIndex(index); sfile += ".ts";
      int rv =  ptseries.Import(sfile,format);
      if(rv = 0) break;
      ptseries.SeriesIndex(sCnt);
      ptseries.SDWrite();
    } 
  }
  fclose(cfile);  
  return sCnt;
}


int32 HDFM::GetSDS( EVDataClass type,   const char* dsetName,  const char* variableName ) {
  int32 vgR;
#ifdef HAS_HDF
  switch( type) {
  case kFArray: 
    vgR = fArraysRef; 
    break; 
  case kFMap: 
    vgR = fMapsRef; 
    break; 
  case kFSeries: 
  case kFPointSeries: 
    vgR = fSeriesRef; 
    break; 
  case kFDataSet: 
  case kFDBaseParm:
    vgR = fDataRef; 
    break; 
  }
	int32 vgid = Vattach((HFILEID)fFile, vgR, "r");
  int32 vgRef = GetChild( vgid,  variableName, NULL, kVGroup, kRef  );
  Vdetach(vgid);
	int32 vgsid = Vattach((HFILEID)fFile, vgRef, "r");
  int32 sdRef = GetChild( vgsid,  dsetName, NULL, kSData, kRef );
	Vdetach(vgsid);
  if( sdRef < 0 ) return -1;
  return SDreftoindex(fSD_id,sdRef);
#endif
  return 0;
}

void HDFM::SDSExport( char* pathName ) {
    if(fSDSObject) fSDSObject->SDExport( pathName );
}
void HDFM::Finalize() {  if(fSDSObject) { delete fSDSObject; fSDSObject = NULL; }  }
const char* HDFM::DSetName()  { return fSDSObject->DSetName(); }
const char* HDFM::VariableName()  { return fSDSObject->VariableName(); }

int32 HDFM::SDRead( int index ) { 
  char info[kAttrStrLen], units[kAttrStrLen], format[kAttrStrLen];
  int32 rv = fSDSObject->SDRead(index,fRef,info,units,format );
  fArg.elem(0) = info; fArg.elem(0) = units; fArg.elem(0) = format;
  return rv;
}

int HDFM::NData() { if(fSDSObject) return fSDSObject->NData(); else return 0; }

void HDFM::TextDump( const CString& path, int index, int nData ) {
  SDRead( index );
  fSDSObject->TextDump( path, index, nData, fArg[0], fArg[1], fArg[2] );
}

#ifdef HAS_X

int HDFM::ViewData(TSheet* aSheet, int index=0, int nData=1) { 
  SDRead( index );
  return fSDSObject->ViewData(aSheet, index, nData, fArg[0]); 
}
int HDFM::GraphData(TGraph* aGraph, int index=0, int nData=1) { 
  SDRead( index );
  return fSDSObject->GraphData(aGraph, index, nData, fArg[0]); 
}
int HDFM::AnimateData(XAnim* aAnim, int index=0, int nData=1) { 
  SDRead( index );
  return fSDSObject->AnimateData(aAnim, index, nData, fArg[0]); 
}

#endif

int HDFM::DumpMap(CString& path, int index, int nData) { 
  SDRead( index );
  return fSDSObject->DumpMap(path, index, nData, fArg.elem(0).data() ); 
}
int HDFM::DumpHDF(CString& path, int index, int nData) { 
  SDRead( index );
  return fSDSObject->DumpHDF(path, index, nData, fArg.elem(0).data() ); 
}



  






  


	
	
	
	
