#ifndef _included_IndexArray1_h
#define _included_IndexArray1_h
// #include <generic.h>

/*
*************************************************************************
*									*
* Define some looping constructs for the Arrays.  Note that these will	*
* take either an array or a region as the second argument.		*
*									*
* Copy the region extents into a local constant integer to aid the	*
* compiler in doing some loop optimizations.				*
*									*
*************************************************************************
*/



#ifndef for_1
#define for_1(i, r) {							\
   const int name2(i,_L) = (r).lower(0), name2(i,_U) = (r).upper(0);	\
   for (int i = name2(i,_L); i <= name2(i,_U); i++) {
#define for_point_1(p, region) 						\
   for_1(name2(p,_i), region)						\
      const Point1 p(name2(p,_i));
#endif



#ifndef end_for
#define end_for } }
#endif

/*
*************************************************************************
*									*
* These macros provide simple access to ``fast indexing'' from C++.	*
* Current C++ compilers do not do a good job of optimizing C++ loops	*
* with array access.  Using these macros should speed up loops by a	*
* factor of about three.  Note that we still use the Fortran indexing	*
* convention.								*
*									*
* These macros should be used as follows:				*
*									*
*	BeginFastIndex2(a, double);					*
*	for_2(i, j, a)							*
*	   FastIndex2(a, i, j) = 0.0;					*
*	end_for								*
*	EndFastIndex2(a);						*
*									*
*************************************************************************
*/



#ifndef BeginFastIndex1
#define BeginFastIndex1(a, type) {					\
const int  name2(a,_B)  = a.bottom();					\
type *const name2(a,_D)  = a.data()
#define FastIndex1(a, i)						\
name2(a,_D)[name2(a,_B)+i]
#define EndFastIndex1(a) }
#endif



#endif
