#include "IntGrid.h"

//----------------------------------------------------------------------------------------
//						IntGrid
//----------------------------------------------------------------------------------------

IntGrid::IntGrid(int r0, int c0, int r1, int c1, int r_inc, int c_inc) : Region2(r0,c0,r1,c1,r_inc,c_inc) { 
  fData = NULL; 
  ReAlloc(r0,c0,r1,c1,r_inc,c_inc); 
}

IntGrid::IntGrid(const IntGrid& md)  : Region2(md) {
  fData = NULL; 
  ReAlloc(md); 
}

IntGrid::IntGrid(const Region2& r) : Region2(r) { fData = NULL; ReAlloc(r); }

void IntGrid::CopyData( int* data, const Region2& r) {   // Copies from fData to data in region r.
  Region2 ri(r); ri *= (*this);                      // data should be of size r.size().
                                                 // data should be of size r.nelem()
  for(int ir = ri.lower(0); ir<= ri.upper(0); ir+=ri.increment(0) ) {
    for(int ic = ri.lower(1); ic<= ri.upper(1); ic+=ri.increment(1) ) {
      data[ ri.bindex(ir,ic) ] = fData[ bindex(ir,ic) ];      
    }
  }
}

void IntGrid::ReAlloc(int r0, int c0, int r1, int c1, int r_inc, int c_inc) {
  if(r_inc<0) r_inc = inc(0);   if(c_inc<0) c_inc = inc(1);
  const Region2 r(r0,c0,r1,c1,r_inc,c_inc);
  int* data = new int[ r.nelem() ];
  if(fData) {
    CopyData(data,r);
    delete[] fData;
  }
  setregion(r);
  fData = data;
}

void IntGrid::ReAlloc( const Region2& r ) {
  int* data = new int[r.nelem()];
  if(fData) {
    CopyData(data,r);
    delete[] fData;
  }
  setregion(r);
  fData = data;
}

int IntArray::fGarbage = 0;

void IntArray::realloc( int newsize ) { 
	if( newsize > fSize ) {
		int* new_data = new int[newsize];
		if(fData) {
			memcpy(new_data,fData,BSize());
			delete[] fData;
		}
		fData = new_data;
		fill(fFill_value,fSize);
		fSize = newsize;
	}
}

