#ifndef __IntGrid__
#define __IntGrid__

#include "Point1.h"
#include "Point2.h"
#include "Region1.h"
#include "Region2.h"
#include "TObjects.h"
#include "Environ.h"
#include <math.h>

//----------------------------------------------------------------------------------------
//						IntGrid
//----------------------------------------------------------------------------------------


class IntGrid : public Region2
{
  int* fData;
  

  public:
                         // Constructors

  IntGrid(int r0, int c0, int r1, int c1, int r_inc = 1, int c_inc = 1);
  IntGrid(const IntGrid& md);
  IntGrid(const Region2& r);
  inline IntGrid() : Region2() { fData = NULL; }
  
  inline int BSize() { return nelem()*sizeof(int); }
  inline int NElements() { return nelem(); }
  inline void SetFields(int r0, int c0, int r1, int c1, int r_inc=1, int c_inc=1 ) 
  { setupper(r1,c1); setlower(r0,c0); setincrement(r_inc=1,c_inc); }        	  
  
  inline int Value( int ir, int ic ) const { 
#ifdef DEBUG
    if( !inside(ir,ic) ) { gPrintErr("Illegal Index");  return -1; }
#endif
    return fData [ bindex(ir,ic) ];
  }
  inline int Value( const Point2& p  ) const { return Value(p(0),p(1)); }
  
  inline int SetValue( int value, int ir, int ic ) { 
#ifdef DEBUG
    if( !inside(ir,ic) )  { gPrintErr("Illegal Index"); return -1; }
#endif
    return fData [ bindex(ir,ic) ] = value;
  }
  
  inline void Alloc(Region2& r) {
    (*this) = r;
    if(fData) delete[] fData;
    fData = new int[nelem()];
  }
  inline void Alloc() {
    if(fData) delete[] fData;
    fData = new int[nelem()];
  }
  
  void ReAlloc( int r0, int c0, int r1, int c1, int r_inc = 1, int c_inc = 1);
  void ReAlloc( const Region2& r );
  void CopyData( int* data, const Region2& r);
};

class IntArray : public TObject {
  int* fData;
  int fSize;
  int fIncr;
  int fMarker;
  int fFill_value;
  static int fGarbage;
  
  void realloc( int newsize ) ;
  public:
                         // Constructors

  IntArray() { fData = NULL; fSize = 0; fIncr = 100; fFill_value = 0; fMarker=0; } 
  inline IntArray( int size, int incr=100, int fill_val = 0 )  { 
		fData = new int[fSize=size]; fIncr = incr; fMarker=0; fill( fFill_value = fill_val ); 
	}
  
  inline int BSize() { return fSize*sizeof(int); }
  inline int Size() { return fSize; }

	inline void fill( int value, int start = 0 ) { 
		for(int i=start; i<fSize; i++ ) {  fData[i] =  value; } 
	} 
	
	inline int& operator [] (int n) {
		if ((unsigned)n >= (unsigned)fSize) { gPrintErr("Illegal Index"); return fGarbage; }
		return fData[n];
	}
	inline int operator () (int n) {
		if ((unsigned)n >= (unsigned)fSize) { realloc( n + fIncr ); }
		return fData[n];
	}

	inline int& elem (int n) {
		if ((unsigned)n >= (unsigned)fSize) {  realloc( n + fIncr );  }
		return fData[n];
	}
	
	inline int* ptr( unsigned int offset = 0 ) { return fData + offset; }

	inline const int mark() const { return( fMarker ); }
	inline const int movemark(int i) { return( fMarker += i ); }
	
	inline int setvalue( int ivalue, int index ) { 
		if( index >= fSize ) { realloc( index + fIncr ); }
		return fData[index] = ivalue;
	}
	inline int setvalue( int ivalue ) { 
		if( fMarker >= fSize ) { realloc( fMarker + fIncr ); }
		return fData[fMarker] = ivalue; 
	}

	inline int incr_value( int ivalue, int index ) { 
		if( index >= fSize ) { realloc( index + fIncr ); }
		return fData[index] += ivalue;
	}
	inline int incr_value( int ivalue ) { 
		if( fMarker >= fSize ) { realloc( fMarker + fIncr ); }
		return fData[fMarker] += ivalue; 
	}
 
 
};

#endif
