//-*-Mode: C++;-*-
#ifndef _TLayer_
#define _TLayer_

#if __GNUG__ >= 2
#  pragma interface
#endif

#include "TCell.h"
#include "FLBase.h"
#include "MML_Frame.h"
#include "Point2.h"
#include "Region2.h"
#include "TMap2.h"

typedef class TPartition2  TPartition2;
typedef class MultiGrid  MultiGrid;

//---- TLayer -----------------------------------------------------------

class TLayer : public TOrderedObject {

public:
		struct Coord { float val[2]; };
		enum CoordType { kLower=0, kUpper=1 };
		enum AxisType { kRows=0, kCols=1 };
		static EInfoIndex kType;
		
protected:

	unsigned int _dim[2];
	uint32 _maxKey;
	TCell** _cells;
	TCell* _firstCell;
	TCell* _lastCell;
	float _cellsize;
	float _height;
	float _depth;
	Coord _coords[2];
	Coord _extent;
	Coord _tempCoord;
	static Point2 _tmpP;
	TPartition2* _partition;
	MultiGrid* _grid;

	inline void compute_cellsize() { 	_cellsize = (_extent.val[0]*_extent.val[1])/(_maxKey); }
	
	inline float getGblCoord( AxisType axis, unsigned int loc_coord ) {
		float fval = ((float)loc_coord) / _dim[(int)axis];
		float rval = fval *  _extent.val[(int)axis];
		float origin = _coords[kLower].val[(int)axis];
		return  origin + rval ;
	}
	
	unsigned int getLocCoord( AxisType axis, float gbl_coord ) {
		return (unsigned int) (((gbl_coord-_coords[0].val[(int)axis])/ _extent.val[axis] )*_dim[(int)axis]);
	}
	
	float getGblCoordFromKey( AxisType axis, int32 key ) {
		return getGblCoord( axis, getLocCoordFromKey( axis, key ) );
	}	
	
	inline int invalid( unsigned int ir, unsigned int ic ) {
		return ( (ir < 0) || (ic < 0) || (ir >= _dim[0]) || (ic >= _dim[1]) );
	}
	
	inline int32 getKey( unsigned int ir, unsigned int ic ) {
		if( invalid( ir, ic ) ) return -1;
		return ((int32)ir)*_dim[1] + ic;
	}
	
public:

    TLayer( MultiGrid* g, int index, unsigned int rows, unsigned int cols );
    ~TLayer();
		
		void setCoords( CoordType ct, float f0, float f1 );
		void addCells( int boundarySize=0 );
		
		inline Coord& getGblCoord( unsigned int ir, unsigned int ic ) { 
			_tempCoord.val[0] = getGblCoord(kRows,ir);
			_tempCoord.val[1] = getGblCoord(kCols,ic);
			return _tempCoord; 
		}
		
		TCell* addCell( unsigned int ir, unsigned int ic );
		
		inline TCell* getCell(int32 key) { return ( (key > 0 ) && (key < _maxKey) ) ? _cells[ key ] : (TCell*)NULL; }
		
		inline TCell* getCell(unsigned int ir, unsigned int ic) {
			int32 key = getKey( ir, ic ); 
			return (key >= 0 ) ? _cells[ key ] : NULL; 
		}
		
		inline TCell* getCell( Point2& p ) {
			int32 key = getKey( p(0), p(1) ); 
			return (key >= 0 ) ? _cells[ key ] : NULL; 
		}
		
		inline TCell* translateNEWS( TCell* cell, int dr, int dc ) {
			int32 key = getKey( (cell->Index()/_dim[1]) + dr,  (cell->Index() % _dim[1]) + dc );
			return ( key < 0 ) ? NULL : _cells[ key ];
		} 
		inline TCell* translateByLinks( TCell* cell, int link_index, int nlinks, int link_layer ) {
			for( int i=0; i<nlinks; i++ ) { cell = (cell) ? cell->getNeighbor( link_layer, link_index ) : 0; } 
			return cell;
		}
		inline TCell* neighborCell( TCell* cell, int link_layer, int link_index ) {
			return cell->getNeighbor( link_layer, link_index );
		}
		
		inline TCell* getCell(float c0, float c1) { return getCell( getLocCoord( kRows, c0 ), getLocCoord( kCols, c1 ) ); }
		inline TCell* firstCell() { return _firstCell; }
		inline void nextCell(TCell*& c) { if(c) { c = c->_next; } }
		
		unsigned int getLocCoordFromKey( AxisType axis, int32 key ) {
			return (unsigned int) ((axis==kRows) ? key/_dim[1] : key % _dim[1]);
		}	
		unsigned int getLocCoordFromKey( int dim, int32 key ) {
			return (unsigned int) ((dim==0) ? key/_dim[1] : key % _dim[1]);
		}	
		
		inline unsigned int getCellLocCoord(AxisType axis, TCell* c) { return getLocCoordFromKey( axis, c->Index() ); }
		inline Point2& getCellLocPoint( TCell*  c ) { _tmpP.elem(0) = c->Index()/_dim[1]; _tmpP.elem(1) = c->Index() % _dim[1]; return _tmpP; }
		Point2& getCellPartitionPoint( TCell*  c );
		int getCellPartitionIndex( TCell*  c );
		inline Point2& getCellLocPoint( int key ) { _tmpP.elem(0) = key/_dim[1]; _tmpP.elem(1) = key % _dim[1]; return _tmpP; }
		inline float getCellGblCoord(AxisType axis, TCell* c) { return getGblCoordFromKey( axis, c->Index() ); }
		inline float cellsize() { return _cellsize; }

		void addActivationLayer(int activation_index);
		void addChildLinkLayer(uint16 nlinks=0);
		void addNeighborLinkLayer(byte link_layer, uint16 nlinks=0, byte max_link_layer=0);
		void linkNeighbors( byte link_layer, int activationLayer,  TMap2* linkmap, ETopology type, FLBase* flBase, const char* methodName, int maxLayers = 0 );
		TPartition2* partition( TPartition2* default_partition = NULL );
		inline void setPartition( TPartition2* p ) {  _partition = p;  }
		inline void setDepthValues( float height, float depth ) { _height = height; _depth = depth; }
		inline float getDepth() { return _depth; }
		inline float getHeight() { return _height; }
		inline void globalRegion(Region2& r) const {  r.setlower(0,0); r.setupper(_dim[0]-1,_dim[1]-1); }
		inline int Dim(int idim) { return _dim[idim]; }
		inline void getUTM( int index, GeoCoord2 c ) { c( _coords[index].val[0], _coords[index].val[1] ); }
		inline float getUTMResolution(AxisType axis) { return ( _extent.val[(int)axis]/ _dim[(int)axis] ); }


};

#endif
