#include "MemoryMgr.h"

int MemObject::fCount=0;
int MemObject::kPermanentMemory = -1;

/*
*************************************************************************
*									*
* FloatStore          					                *
*									*
*************************************************************************
*/
EInfoIndex FloatStore::kPermanent = kO_Info0;

int FloatStore::CheckAvail( int index ) { 
  if( GetObjInfo(kPermanent) == True ) return 0;
  if( index>=0 && fFlags.test(index) ) return 0;
  else return 1;
}

int FloatStore::CheckSlot( MemObject* mobj, int index ) {
  if( mobj == NULL ) return 0;
  if( fMemObjList.find(mobj) ) {
    if( index>=0 && fFlags.test(index) ) return 0;
    else return 1;
  }
  else return 0;
}

int FloatStore::CheckFlags() { 
	int i;
	fFlags.clear();
	printf("\nFlag test:\n");
	for ( i=0; i<200; i++ ) {
		if( (i % 3) == 0 ) { fFlags.set(i); }
	}
	for ( i=0; i<200; i++ ) {
		printf("%d",fFlags.test(i));
	}	
	exit(-5);
	return 0;
}

ESizeClass FloatStore::CheckSize( int len ) {
  if( len <= capacity()*kMinAllocation  ) return kM_TooSmall;
  else if( len <= capacity() ) return kM_OK;
  else if( len <= capacity()*kAllowedOverFlow ) return kM_Grow;
  else return kM_TooLarge;
}

FloatStore& FloatStore::GrabVector( int len, MemObject& mobj ) {
  int index =  mobj.MemoryIndex();
  if( len > capacity() ) {
    resize(len); 
    Finalize();
  }

  if( index == MemObject::kPermanentMemory )   SetObjInfo(kPermanent,True);
  else fFlags.set(index);

  fMemObjList.append(mobj);
  if( gDebug ) {
    sprintf(gMsgStr,"\nFS(%d): mobj(%d), Grab Vector( Index: %d, Length: %d, Permanent: %x )",
	    Index(), mobj.Index(), index, len, GetObjInfo(kPermanent) );
    gPrintLog();
  }
  return *this;
}

void FloatStore::Finalize() {
  for( Pix p = fMemObjList.first(); p; fMemObjList.next(p) ) {
    MemObject& mobj = (MemObject&) fMemObjList(p);
    mobj.Initialize();
  }
}

/*
*************************************************************************
*									*
* MemoryManager          					        *
*									*
*************************************************************************
*/

FloatStore& MemoryManager::GetVector( int size, MemObject& recipient, MemObject* donor ) {
  
  int index = recipient.MemoryIndex();

  if( (index != MemObject::kPermanentMemory) || donor ) {
    for( Pix p = first(); p; next(p) ) {
      FloatStore& fs = (FloatStore&) (*this)(p);
      int fs_avail = fs.CheckAvail( index );
      int fs_has_donor = fs.CheckSlot(donor,index);
#ifdef DEBUG
      if(gDebug>2){
				sprintf(gMsgStr," FS(%p,%p,%d,%d,%d) ",&fs,donor,index,fs_avail,fs_has_donor); 
				gPrintLog(); 
      }
#endif      
			if( ( (donor==NULL) && fs_avail ) || fs_has_donor  ) {
				switch ( fs.CheckSize( size ) ) {
				case kM_TooSmall:
					break;
				case kM_OK:
					return fs.GrabVector( size, recipient );
				case kM_Grow:
					return fs.GrabVector( size, recipient );
				case kM_TooLarge:
					break;
				}
      }
    }
    if( donor ) { gFatal( "Can't Find Memory donor: Check Frame configurations (probably need to declare a spatial frame somewhere)"); }
  }

  static int fcnt = 0;
  FloatStore* fs = new FloatStore(size);
  fs->SetIndex(fcnt++);
  append(*fs);
  return fs->GrabVector( size, recipient );
}

void MemoryManager::Finalize() {
  for( Pix p = first(); p; next(p) ) {
    FloatStore& fs = (FloatStore&) (*this)(p);
    fs.Finalize();
  }
}
