//----------------------------------------------------------------------------------------
//	PointRef.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __PointRef__
#define __PointRef__

#include "Array.h"
typedef class PointRef PointRef;

/*
*************************************************************************
*									*
* PointRef								*
*									*
*************************************************************************
*/

enum EPRType { kPR_Int, kPR_Float };
enum EPRInfo { kPRI_Type, kPRI_NDim, kPRI_OK, kPRI_New };

union Pcoord {
  float f;
  int i;
  Pcoord() { i=0; f = 0.0; }
  Pcoord( float f0 ) { f = f0; i=0; }
  Pcoord( int i0 ) { i=i0; f = 0.0; }
  inline Pcoord& operator= ( float f0 ) { f = f0; return *this; }
  inline Pcoord& operator= ( int i0 ) { i = i0; return *this; }
  inline operator int() const { return i; }
  inline operator float() const { return f; }
};


class RegionX {

  Region2 fR;

public:

  RegionX(Region2& r) : fR(r) {;}
  inline int inside(Pcoord* p){ return fR.inside((int)p[0],(int)p[1]); } 
  operator Region2() const { return fR; }
};

class PointRef  {

	Pcoord fC[4];
	byte fInfo[8];
	RegionX fRegion;
	
public:
	inline void SetInfo(EPRInfo index, byte val) { fInfo[index] = val; }
	inline byte GetInfo(EPRInfo index) const { return fInfo[index]; }
	inline const RegionX& Region() const { return fRegion; }
	inline int OK () const { return fInfo[kPRI_OK]; }

	PointRef(int i0, int i1, int i2, int i3, RegionX& r) : fRegion(r) {
		fC[0] = i0; fC[1] = i1; fC[2] = i2; fC[3] = i3; 
		fInfo[kPRI_Type] = kPR_Int; fInfo[kPRI_NDim] = 4; fInfo[kPRI_OK] = 1;
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(int i0, int i1, int i2, RegionX& r) : fRegion(r)  {
		fC[0] = i0; fC[1] = i1; fC[2] = i2; 
		fInfo[kPRI_Type] = kPR_Int; fInfo[kPRI_NDim] = 3; fInfo[kPRI_OK] = 1;	
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(int i0, int i1, RegionX& r) : fRegion(r)  {
		fC[0] = i0; fC[1] = i1; 
		fInfo[kPRI_Type] = kPR_Int; fInfo[kPRI_NDim] = 2; fInfo[kPRI_OK] = 1;	
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(int i0, int i1, Region2& r) : fRegion(r)  {
		fC[0] = i0; fC[1] = i1; 
		fInfo[kPRI_Type] = kPR_Int; fInfo[kPRI_NDim] = 2; fInfo[kPRI_OK] = 1;	
		if( !fRegion.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(int i0, RegionX& r) : fRegion(r)  {
		fC[0] = i0; 
		fInfo[kPRI_Type] = kPR_Int; fInfo[kPRI_NDim] = 1; fInfo[kPRI_OK] = 1;	
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(float f0, float f1, float f2, float f3, RegionX& r) : fRegion(r) {
		fC[0] = f0; fC[1] = f1; fC[2] = f2; fC[3] = f3; 
		fInfo[kPRI_Type] = kPR_Float; fInfo[kPRI_NDim] = 4; fInfo[kPRI_OK] = 1;	
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(float f0, float f1, float f2, RegionX& r) : fRegion(r) {
		fC[0] = f0; fC[1] = f1; fC[2] = f2; 
		fInfo[kPRI_Type] = kPR_Float; fInfo[kPRI_NDim] = 3; fInfo[kPRI_OK] = 1;	
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(float f0, float f1, RegionX& r) : fRegion(r) {
		fC[0] = f0; fC[1] = f1;
		fInfo[kPRI_Type] = kPR_Float; fInfo[kPRI_NDim] = 2; fInfo[kPRI_OK] = 1;	
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	PointRef(float f0, RegionX& r) : fRegion(r) {
		fC[0] = f0; 
		fInfo[kPRI_Type] = kPR_Float; fInfo[kPRI_NDim] = 1; fInfo[kPRI_OK] = 1;	
		if( !r.inside(fC) )  fInfo[kPRI_OK] = 0;
	}
	inline float Coord (const int i) { 
		switch(fInfo[0]) {
			case kPR_Int: return((float)((int)fC[i])); break; 
			case kPR_Float: return((float)fC[i]); break; 
		}
	}
	inline const Pcoord& operator () (const int i) const { 
	    return fC[i];
	}


};

#endif
