//-*-Mode: C++;-*-
#ifndef _TCell_h_
#define _TCell_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

#ifdef HAS_HDF
extern "C" {
#include "mfhdf.h"
}
#else
extern "C" {
#include "sme_types.h"
}
#endif

#include "TObjects.h"
#include "Environ.h"

typedef byte FlagIndex;
typedef class TLayer TLayer;
typedef class TCell TCell;
typedef class MultiGrid MultiGrid;
typedef class ActivationLayer ActivationLayer;
typedef TCell* TLink;
typedef TCell OrderedPoint;

class LinkLayer {
	
	TLink* _links;
	uint16 _nlinks;
	uint16 _nActivelinks;
	static int kLinkIncrement;
	static int _count_index;

	inline void realloc( int newsize ) {
			TLink* new_links = new TLink[newsize]; 
			memset( new_links, 0, newsize*sizeof(TLink) );
			if( _links ) {
				memcpy(new_links,_links,_nlinks*sizeof(TLink));
				delete[] _links;
			}
			_links = new_links; _nlinks = newsize;
	}
	
public:
	LinkLayer() { _nlinks = 0; _nActivelinks = 0; _links = NULL; }
	LinkLayer( int nLinks ) { _nlinks = 0; _nActivelinks = 0; _links = NULL; realloc( nLinks ); }
	
	inline int addLink( TCell* c ) {
		for( int i=0; i<_nActivelinks; i++ ) {
			if( _links[i] == NULL ) { _links[i] = c; return i; }
			if( _links[i] == c ) { return i; }
		}
		if( _nActivelinks >= _nlinks ) realloc( _nlinks + kLinkIncrement );
		_links[ _nActivelinks ] = c;
		return _nActivelinks++;
	}
	
	inline int addLinkFAS( TCell* c, int index ) { // add link to ( FAS = )first available slot starting at index.	
		for( int i=index; i<_nActivelinks; i++ ) {
			if( _links[i] == NULL ) { _links[i] = c; return i; }
			if( _links[i] == c ) { return i; }
		}
		if( index > _nActivelinks ) { _nActivelinks = index; }
		if( _nActivelinks >= _nlinks ) realloc( _nlinks + kLinkIncrement );
		_links[ _nActivelinks ] = c;
		return _nActivelinks++;
	}
  
	inline int addLink( TCell* c, int index ) {   // add link at slot index 
		if( index >= _nlinks ) realloc( index + kLinkIncrement );
		if( index >= _nActivelinks ) { _nActivelinks = index+1; }
		_links[ index ] = c;
		return index;
	}
	
	inline TLink Link( int index ) {
		if( index >= _nlinks ) return NULL;
		return _links[index];
	}

	inline TLink first() { return _links[_count_index=0]; }
	
	inline TLink next() {
		if( ++_count_index >= _nlinks ) return (TLink)0;
		return _links[_count_index];
	}
	
	inline int length() { return _nlinks; }	
	inline void clear() { 
		for( int i=0; i<_nlinks; i++ ) { _links[i] = 0; } 
		_nlinks = 0;  
	}	

};

class CellIndex {     
	uint32 _index;
	byte _flags;

	static FlagIndex f0;  
	static FlagIndex f1;
	static FlagIndex f2;
	static FlagIndex f3;
	static FlagIndex f4;
	static FlagIndex f5;
	static FlagIndex f6;
	static FlagIndex f7;
		
	inline void setFlag( FlagIndex fi, byte value ) { if(value) _flags |= fi; else _flags &= fi;  }
	inline byte flag( FlagIndex fi ) { return (_flags & fi); }

public:

	CellIndex() { _index = 0; _flags = 0; }
	
	inline void activate( int32 index ) {
		_index = index;
		setFlag(f0,1);
	}	
	inline byte active() { return flag(f0); }
		
	inline void deactivate() { setFlag(f0,0); }
	inline byte setActivatedAbove() { byte rv = flag(f1); setFlag(f1,1); return rv; }
	inline byte setActivatedBelow() { byte rv = flag(f2); setFlag(f2,1); return rv; }
	
	inline byte activated() { return flag(f0); }
	inline byte activatedAbove() { return flag(f1); }
	inline byte activatedBelow() { return flag(f2); }

	inline uint32 index() { return _index; }
		
};

//---- TCell -----------------------------------------------------------

typedef LinkLayer* LinkLayerPtr;

class TCell : public TOrderedObject {

friend class TLayer;

public:

		static enum EIndexIndex kNActivationLayers;
		static enum EIndexIndex kOwner;
		static enum EInfoIndex kNLinkLayers;
		static enum EInfoIndex kGhostIndex;
		static enum EInfoIndex kLayerIndex;
		static enum EInfoIndex kTmp;
	
private:

	TCell* _next;
	TCell* _parent;
	CellIndex* _activationLayers;
	LinkLayer** _neighborLinkLayers;
	LinkLayer* _childrenLinkLayer;
	float _cellsize;
	int32 _global_index;
	static MultiGrid* fMultiGrid;
	
	static int kActivationLevelIncrement;
	static int kNeighborLevelIncrement;
	
public:

    TCell( int index, byte layerIndex, int maxActivationLevels=0 );
    TCell( TCell* c );
    ~TCell();
    
		static inline void setMultiGrid( MultiGrid* m ) {
			if( fMultiGrid ) { if( m != fMultiGrid ) gFatal("Multiple MultiGrids not allowed."); }
			else { fMultiGrid = m; }
		}
		
		inline TCell* next() { return _next; }
		inline TCell* link(TCell* c) { return _next = c; }

		inline TCell* parent() { return _parent; }
		inline TCell* setParent(TCell* c) { return _parent = c; }
		
		void createActivationLevel( int activation_Level );
		
		inline LinkLayer* getNeighborLinkLayer( byte link_layer, uint16 nlinks=4, byte max_link_layer=0 ) {
			checkNeighborLinkLayers( MAX(link_layer,max_link_layer) );
			return ( _neighborLinkLayers[link_layer] ) ? _neighborLinkLayers[link_layer] : ( _neighborLinkLayers[link_layer] = new LinkLayer(nlinks) );
		}
		
		inline byte checkNeighborLinkLayers( byte link_level ) 	{
			if(  link_level >= GetObjInfo(kNLinkLayers) ) {
				LinkLayerPtr* new_layers = new LinkLayerPtr[ link_level+=kNeighborLevelIncrement ];
				memset( new_layers, 0, link_level*sizeof(LinkLayerPtr) );
				if( _neighborLinkLayers ) { 
					memcpy(new_layers,_neighborLinkLayers,GetObjInfo(kNLinkLayers)*sizeof(LinkLayerPtr));
					delete[] _neighborLinkLayers;
				}
				_neighborLinkLayers = new_layers;
				SetObjInfo(kNLinkLayers,link_level);			
			} else return 0;
			return 1;
		}

		inline LinkLayer* neighborLinkLayer( byte link_layer ) { return _neighborLinkLayers[link_layer]; }
		
		TCell* getNeighbor( int link_layer, int link_index );
		inline void setGlobalIndex( int32 index ) { _global_index = index; }
		inline int32 getGlobalIndex() { return _global_index; }
		
		inline LinkLayer* getChildLinkLayer( uint16 nlinks=0 ) { 
			return ( _childrenLinkLayer ) ? _childrenLinkLayer : ( _childrenLinkLayer = new LinkLayer(nlinks) );
		}
		inline LinkLayer* childLinkLayer() {  return _childrenLinkLayer; }
		
		inline int checkActivationLevel( int activation_Level ) {
			if( GetObjIndex( kNActivationLayers ) <= activation_Level ) { createActivationLevel( activation_Level ); return 1; }
			else return 0;
		}
		void mergeDataOverChildren( const float* data, int activationLevel, float& sum_value, int* icount=NULL, float* max_value=NULL, float* min_value=NULL);
		void computeCellsize();
		inline float cellsize() { return _cellsize; }
		
		void activate( ActivationLayer* layer );
		void finalizeActivation( int activation_Level, int32 memory_index );
		void activateParent( ActivationLayer* layer, int up_levels );
		void activateChildren( ActivationLayer* layer, int down_levels );
		inline void deactivate(int activation_Level ) { _activationLayers[activation_Level].deactivate(); }
		inline byte setActivatedAbove( int activation_level ) { return _activationLayers[activation_level].setActivatedAbove(); }
		inline void setActivatedBelow( int activation_level ) { _activationLayers[activation_level].setActivatedBelow(); }
		int setActiveAboveRecur( int activation_Level );
		int setActiveBelowRecur( int activation_Level );
				
		inline byte activated( int activation_level ) { return _activationLayers[activation_level].activated(); }
		inline byte activatedAbove( int activation_level ) { return _activationLayers[activation_level].activatedAbove(); }
		inline byte activatedBelow( int activation_level ) { return _activationLayers[activation_level].activatedBelow(); }
		inline int32 memoryIndex( int activation_level ) { return _activationLayers[activation_level].index(); }
		unsigned int operator() (int dim) const ;
		inline unsigned int row() const { return  operator() (0); }
 		inline unsigned int col() const { return  operator() (1); }

		inline void addChild( TCell* child ) {
				LinkLayer* ll = getChildLinkLayer();
				ll->addLink(child);
		}

		inline int addNeighbor( byte link_layer, TCell* neighbor, int link_index = -1 ) {
				LinkLayer* ll = getNeighborLinkLayer(link_layer);
				if(link_index<0) { return ll->addLink(neighbor); }
				else { return ll->addLink(neighbor,link_index); }
		}
		inline int addNeighborFAS( byte link_layer, TCell* neighbor, int link_index = -1 ) {   // FAS = first availalbe slot starting at link_index.
				LinkLayer* ll = getNeighborLinkLayer(link_layer);
				if(link_index<0) { return ll->addLink(neighbor); }
				else { return ll->addLinkFAS(neighbor,link_index); }
		}
};

#endif
