#ifndef __Timer__
#define __Timer__

#include <sys/time.h>
#include <sys/resource.h>
#include "Environ.h"

typedef struct rusage Usage;
typedef struct timeval TimeVal;
enum ET_PLoc { kT_Screen, kT_Log };
// extern int getrusage(...); 
/*
*************************************************************************
*									*
* Timer     					        *
*									*
*************************************************************************
*/

 
class Timer {

  Usage fUsage;
  TimeVal fUTime;
  TimeVal fSTime;
  int fSwaps;

public:
  inline Timer() {; }

  inline void StartUsage() { 
    getrusage(RUSAGE_SELF,&fUsage); 
    fUTime.tv_sec =  fUsage.ru_utime.tv_sec; 
    fUTime.tv_usec = fUsage.ru_utime.tv_usec; 
    fSTime.tv_sec =  fUsage.ru_stime.tv_sec; 
    fSTime.tv_usec = fUsage.ru_stime.tv_usec; 
    fSwaps = fUsage.ru_nswap;
  }

  inline void StartClock() {


     #include <time.h>
     
     clock_t start, end;
     double elapsed;
     
     start = clock();
     ... /* Do the work. */
     end = clock();
     elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;

   or call times function..

  }
  inline void PrintUsage( ET_PLoc where ) { 
    getrusage(RUSAGE_SELF,&fUsage);
    sprintf(gMsgStr,"Usage: User(%ld,%ld) Sys(%ld,%ld) Swaps: %d",
	    fUsage.ru_utime.tv_sec-fUTime.tv_sec, fUsage.ru_utime.tv_usec-fUTime.tv_usec,
	    fUsage.ru_stime.tv_sec-fSTime.tv_sec, fUsage.ru_stime.tv_usec-fSTime.tv_usec,
	    fUsage.ru_nswap-fSwaps );
    switch(where) {
    case kT_Screen:
      gPrintScreen();
      break;
    case kT_Log:
      gPrintLog();
      break;
    }
    fUTime.tv_sec =  fUsage.ru_utime.tv_sec; 
    fUTime.tv_usec = fUsage.ru_utime.tv_usec; 
    fSTime.tv_sec =  fUsage.ru_stime.tv_sec; 
    fSTime.tv_usec = fUsage.ru_stime.tv_usec; 
    fSwaps = fUsage.ru_nswap;
  }
  

};

#endif
