/**************************************************************************/
/*                         XGraph/XGraph.h    XGraph.h                   */
/**************************************************************************/

/* this implementes Xgraph, a simple X based graphics drawing class */

/**************************************************************************/

#ifndef XGRAPH_DEFINED
#define XGRAPH_DEFINED 1

#ifdef HAS_X

#include "Globals.h"
#include "Array.h"

class XAnim;
class TImage;
class Xgraph;

#define MAX_GRAPHS 10

class ColorParm {
 public:
  float fs;
  float fm;
  float fe;
  ColorParm() { fs=0; fm=0; fe=0; }
  void Set(float ifs, float ifm, float ife) { fs=ifs; fm=ifm; fe=ife; }
  unsigned short GetColor(int cIndex);
};

/**************************************************************************/

class Xgraph {
public:

  enum EImageType { kXAnim, kGraph, kSheet  };

    Xgraph(int aWidth = 640, int aHeight = 480, Bool isRoot = True );
    Xgraph(Display* aDisplay, Window aWindow, Bool isRoot = True ) : closeDisplay(FALSE)  { isRootNode=isRoot; setup(aDisplay, aWindow); }
    virtual ~Xgraph();
    
    int setForeground(char* color);
    int setForeground(int index);
    void rectangle(int xStart, int yStart, int width, int height, int isTemp=0);
    void filledRectangle(int xStart, int yStart, int width, int height, int isTemp=0);
    void line(int xStart, int yStart, int xEnd, int yEnd, int isTemp=0 );
    void circle(int xCenter, int yCenter, int radius);
    void filledCircle(int xCenter, int yCenter, int radius);
    void text( int xStart, int yStart, char* text, int isTemp=0 );
    void image( TImage* image, int xStart=0, int yStart=0, int width=0, int height=0, int isTemp=1 );
    void setImmediateUpdate(Bool val)	{ immediateUpdate = val; };
    void refresh();
    void flush(Bool block = FALSE);
    void block(char eChar);
    TImage* NewImage(EImageType type);
    void DisplayLegend(Window w, int xStart, int yStart, float fmin, float fmax );
    void CreateColors();
    void SetRedMap(float ifs, float ifm, float ife);
    void SetBlueMap(float ifs, float ifm, float ife);
    void SetGreenMap(float ifs, float ifm, float ife);
    void Clear();

    Window getWindow()		{ return(w); }
    Display* getDisplay()	{ return(display); }
    int getWidth()		{ return(width); }
    int getHeight()		{ return(height); }
    int operator!()		{ return(display == NULL); }
    int isValid()		{ return(display != NULL); }
    
    int yOffset;
    int xOffset[2]; 
    TImage* currentImage;
    int ngraphs;
    int graph_cnt[MAX_GRAPHS];
    unsigned long cpixel[256];

private:
    virtual int doXEvent(XEvent& event);
    void setup(Display* aDisplay, Window aWindow);
    int CreateLegendPixmap();
    Display* display;
    Window w;
    GC gc;
    Pixmap backup;
    Pixmap colorBar;
    unsigned int width;
    unsigned int height;
    unsigned long black;
    unsigned long white;
    unsigned long redpixel;
    unsigned long midpixel;
    unsigned long bluepixel;
    char breakChar;
    Colormap colormap; 
    Bool immediateUpdate;
    Bool closeDisplay;
    Bool isRootNode;
    int resetColors;
    ColorParm red;
    ColorParm blue;
    ColorParm green;
    
    int MaxImages;
    TImage **ImageList;
    int NImages;
};

/**************************************************************************/

class TImage {
public:
    TImage(Xgraph* aGraph);
    TImage(Display* aDisplay);
    virtual ~TImage();
    int isValid()			{ return(display != 0); }
    operator!()				{ return(display == 0); }
    unsigned int getHeight()		{ return(height); }
    unsigned int getWidth()		{ return(width); }
    void SetLocation(int ir, int ic)    { r0 = ir; c0 = ic; }
    Pixmap   getPixmap()		{ return(pixmap); }
    char AInfo[4];

    friend class Xgraph;
protected:
    virtual void doXEvent(XEvent& event) {;}
    virtual void putDisplay(Window w, int xStart=0, int yStart=0, int width=0, int height=0) {;}
    Display* display;
    GC gc;
    Pixmap pixmap;
    Pixmap shape;			// allows for transparent regions
    Window wind;
    Xgraph* xgraph;

    unsigned int height;
    unsigned int width;
    unsigned int c0;                  /* Coords of Origin of Image in Xgraph Window */
    unsigned int r0;
};


class XAnim : public TImage {
    friend class Xgraph;
public:
    XAnim( Xgraph* aGraph, int mag = 1 );
    virtual ~XAnim();
 
    int CreateNewImage( int width, int height, char* data, int mag = 1, int deepCopy=0 );
    int CreatePixmap( int width, int height, char* data );
    void SetImageData( char* data=NULL );
    void SetMapData (char* name );
	void Copy(Pixmap aPixmap, int aWidth, int aHeight, int xStart, int yStart);
    void Flush();
    void DrawRegion( Region2& r );
    void SetSize(int rows, int cols); 
 private:
    XImage* image;
    int mag;
    char* name;
    char* fData;
    virtual void doXEvent(XEvent& event);
    virtual void putDisplay(Window w, int xStart=-1, int yStart=-1, int width=0, int height=0);
    void DisplayLegend(Window w, int xStart, int yStart);
    void GetMinMax( int* minp, int* maxp );
    void ProcessButtonPress( int x, int y, int button );
    unsigned char GetValue(int x, int y, float *fval);
};

class TGraph : public TImage {
    friend class Xgraph;
public:
    TGraph( Xgraph* aGraph, int buffSize=100 );
    virtual ~TGraph();
 
    void AddPoint(float y);
    void AddPoint( float y, float t );
    void Flush(int isTemp=2);
    void FlushPoint(int isTemp=2);
    
    void SetData( float* data, int npoints );
    void SetCellLoc( int ix, int iy);
    void SetRange( float ymin, float ymax );
    void SetDomain( float xmin, float xmax, float dx=1.0 );
    void SetName(const char* name );
    void SetSize(int rows, int cols);
    void SetIndex( int index );
 private:
    char* name;
    float* data;
    int nPoints, iPoint;
    int fIndex0, fIndex1;
    int mSize;
    float dX;
    float Xmin;
    float Xmax;
    float Ymin;
    float Ymax;
    void putDisplay(Window w, int xStart=-1, int yStart=-1, int width=0, int height=0);
    virtual void doXEvent(XEvent& event);
    void putDisplay(int w, int xStart=-1, int yStart=-1, int width=0, int height=0){;}
    int GetValue( int x, float* value );
    int ScalePoint(float y);
    void Resize(float factor);
    void Rescale(float factor);  
    void DisplayGrid(int isTemp=2);
    void SetColor( );
    void ProcessButtonPress( int x, int y, int button );
};

#define MAX_S_COLS 25

class TSheet : public TImage {
    friend class Xgraph;
public:
    TSheet( Xgraph* aGraph);
    virtual ~TSheet();
 
    void SetSize(int rows, int cols);

    void Flush(int frows = -1, int isTemp=2 );
    void SetData( float* data, int rows, int cols );
    void SetDomain( float xmin=0.0, float dx=1.0 );
    void SetName(const char* name );
    int GetValue( int x, int y, float* value );

    int AddColumn(char* name);
    void SetRange(int nPoints, float dt);
    void FlushPoint(float value, int colIndex, int rowIndex, Bool doFlush=True);
    
 private:
    char* name[MAX_S_COLS];
    float* data;
    int cIndex;
    int rows;
    int cols;
    int mSize;
    float dX;
    float Xmin;
    int xsp, ysp;
    void ProcessButtonPress( int x, int y, int button );
    virtual void doXEvent(XEvent& event);
    void putDisplay(Window w, int xStart=-1, int yStart=-1, int width=0, int height=0);
};

typedef Xgraph XG;

#endif

#endif
