#!/bin/sh
#####################################################################
#
#		Configures SME3 dist
#
#####################################################################

# You may edit the following options to configure for your machine.

#alias -x make=gmake

CC=gcc
CXX=g++
#CC=cc
#CXX=CC
CFLAGS="-w"
OPTFLAGS="-O3"
DBGFLAGS="-g"

export CFLAGS
export OPTFLAGS
export DBGFLAGS
export CC
export CXX

ENABLE_DBG="no"
ENABLE_OPT="yes"

SME3_DIR=/usr/dev/sme/sme3
TARGET=/usr/dev/sme/
GRASS_INCLUDE=$GIS_BASE/src/include/
GRASS_LIB=$GIS_BASE/src/libes/LIB.sun5
MPI_VERSION=1.1
MPI_INCLUDE=/local/mpich/$MPI_VERSION/include
MPI_LIB=/local/mpich/$MPI_VERSION/lib/solaris/ch_p4
HDF_INCLUDE=/local/include
HDF_LIB=/local/lib
JDK_DIR=/local/Java/jdk1.2/
TCL_VERSION=8.0

cd $SME3_DIR
 
./configure --enable-mpi=no --enable-rpm=no --enable-network=yes --enable-hdf=no --enable-debug=$ENABLE_DBG --enable-opt=$ENABLE_OPT --enable-grass=no --with-mpi_inc_dir=$MPI_INCLUDE --with-mpi_lib_dir=$MPI_LIB --with-hdf_inc_dir=$HDF_INCLUDE --with-hdf_lib_dir=$HDF_LIB --with-grass_inc_dir=$GRASS_INCLUDE --with-grass_lib_dir=$GRASS_LIB --prefix=$TARGET --enable-tcl=yes --with-tcl_inc_dir=/hawk/include --with-tcl_lib_dir=/hawk/lib --with-tcl_version=$TCL_VERSION --enable-java=yes --with-jdk_dir=$JDK_DIR  


# The configure script should complete with the message "Configure completed successfully!".
# Check for error messages after completion.
# If configure is successful, install the SME using "make install".
# If you get lost, send email to: maxwell@cbl.umces.edu.








