#include <stdlib.h>
#include <stdio.h>
#include <utility.H>
#include <strings.H>
#include <dfit.H>

void usage()
{
  fprintf(stderr, "Usage: svp {-v | [-id <id>] <filename>}\n\n");
  fprintf(stderr, "     -v  print version and exit\n");
  fprintf(stderr, "     -id specify ID string\n\n");
}

int main (int argc, char* argv[])
{
  if (argc < 2)
    {
      usage();
      return -1;
    }

  TFilename f;
  TString id;

  for (int i = 1; i < argc; i++)
    {
      if (strcmp(argv[i], "-id") == 0)
	id = argv[++i];
      else if (strcmp(argv[i], "-v") == 0)
	{
	  printf ("svp %s\nCopyright F.Villa, MIIEE, UMD\n", SVP_VERSION);
	  exit(0);
	}
      else
	f= argv[i];
    }
  if (!fexist(f))
    {
      fprintf(stderr, "File %s not found\n", (const char*)f);
      return -1;
    }

  DFit fit(f, id);

  fit.compute();
  fit.report();

  return 0;
}
