#ifndef __VECTOR_H
#define __VECTOR_H

#ifndef __OBJECT_H
#include <object.H>
#endif

#ifndef __CLASSES_H
#include <classes.H>
#endif

// fPair: TObject to hold 2 floats (one timestamped value)

class fPair : public TObject
{
  float _t;
  float _v;

public:

  float time() { return _t; }
  float v() { return _v; }

  virtual word class_id() const { return CLASS_FPAIR; }
  fPair(float t, float v) { _t = t; _v = v; }
  fPair() {;}
  void set(float t, float v) { _t = t; _v = v; }
  virtual ~fPair() {;}
};

// Vector: simple timestamped vectors of bytes, integers, floats

class Vector : public TObject 
{

  unsigned long  _size;
  unsigned int   _dims;
  unsigned int   _dsize;

  float _time;

protected:

  virtual void alloc(long n) {;}
  virtual void destroy()     {;}

public:

  virtual word class_id() const { return CLASS_VECTOR; }
  void dsize(unsigned int d)    { _dsize = d;    }
  void time(float d)            { _time = d;     }
  void size(unsigned long d)    { _size = d;     }
  unsigned int dsize()    const { return _dsize; }
  long size()             const { return _size;  }
  float time()            const { return _time;  }

  Vector(int d, unsigned long n, float t = 0.0) 
  { _dims = d; _size = n; _time = t;}
  Vector(Vector& v) 
  { _dsize = v._dsize; _dims = v._dims; _time = v._time; _size = v._size; }
  virtual ~Vector() { destroy(); }
};

class bVector : public Vector
{
  byte* _data;
  
protected:
  
  virtual void alloc(long n) { _data = new byte[n];  }
  virtual void destroy()     { delete _data;        }
  
public:

  byte* data() { return _data; }
  byte  data(int x)        { return _data[x]; }
  byte  data(int x, int y, int xd) 
  { return _data[(unsigned)x*(unsigned)xd+(unsigned)y]; }

  virtual word class_id() const { return CLASS_BVECTOR; }
  bVector(int d, unsigned long n, float t = 0.0) : 
    Vector(d,n,t) { dsize(sizeof(byte)); alloc(size()); }
  bVector(bVector& v);
  virtual ~bVector() {;}
};

class iVector : public Vector
{
  short* _data;
  
protected:
  
  virtual void alloc(long n) { _data = new short[n]; }
  virtual void destroy()     { delete _data;        }
  
public:

  short* data() { return _data; }
  short  data(int x)        { return _data[x]; }
  short  data(int x, int y, int xd) 
  { return _data[(unsigned)x*(unsigned)xd+(unsigned)y]; }

  virtual word class_id() const { return CLASS_IVECTOR; }
  iVector(int d, unsigned long n, float t = 0.0) 
    : Vector(d,n,t) { dsize(sizeof(short)); alloc(size()); }
  iVector(iVector& v);
  
  virtual ~iVector() {;}
};

class lVector : public Vector
{
  long* _data;
  
protected:
  
  virtual void alloc(long n) { _data = new long[n]; }
  virtual void destroy()     { delete _data;        }
  
public:

  long* data()        { return _data; }
  long  data(int x)   { return _data[x]; }
  long  data(int x, int y, int xd) 
  { return _data[(unsigned)x*(unsigned)xd+(unsigned)y]; }

  virtual word class_id() const { return CLASS_LVECTOR; }
  lVector(int d, unsigned long n, float t = 0.0) 
    : Vector(d,n,t) { dsize(sizeof(long)); alloc (size()); }
  lVector(lVector& v);
  virtual ~lVector() {;}
};

class fVector : public Vector
{
  float* _data;
  
protected:
  
  virtual void alloc(long n) { _data = new float[n]; }
  virtual void destroy()     { delete _data;         }
  
public:

  float* data() { return _data; }
  float  data(int x)   { return _data[x]; }
  float  data(int x, int y, int xd) 
  { return _data[(unsigned)x*(unsigned)xd+(unsigned)y]; }

  virtual word class_id() const { return CLASS_FVECTOR; }
  fVector(int d, unsigned long n, float t = 0.0) 
    : Vector(d,n,t) { dsize(sizeof(float)); alloc(size()); }
  fVector(fVector& v);
  virtual ~fVector() {;}
};

#endif







