#include <stdlib.h>
#include <stdio.h>
#include <config.H>
#include <utility.H>
#include <scanner.H>

bool TConfig::_read_paragraph()
     // ritorna TRUE se il paragrafo c'era, FALSE altrimenti
{
  bool itwas = FALSE;
  _data.destroy();
  TScanner scan(_file);
  if (scan.paragraph(_paragraph))
    {
      // just position on next line
      if (_paragraph.find("__FILE__") != -1)
	return TRUE;
      
      itwas = TRUE;
      // populate array
      TString l, key, val;
      for (;;)
	{
	  l = scan.line();
	  if (l[0] == '#') continue;
	  if (l == "" || l[0] == '[') break;
	  int ind = l.find('=');
	  if (ind == -1) 
	    {
	      warning_box("Errore configurazione: file %s, vicino a riga %ud",
			  (const char*)_file, scan.linenum());
	      continue;
	    }
	  
	  key = l.left(ind);  key.trim();
	  val = l.mid(ind+1); val.trim();
	  // sostituzione abilitata
	  _data.add(key,val,TRUE);
	}
    }
  return itwas;
}

void TConfig::_write_paragraph(ofstream& out)
{
  TString cnf(32);

  if (!_imp_file.empty())
    {
      ifstream in(_imp_file);
      cnf << '[' << _paragraph << "__FILE__]";
      out << cnf << '\n';  
      
      while (!in.eof())
	{
	  in.getline(__tmp_string,sizeof(__tmp_string)-1);
	  out << __tmp_string << '\n';
	}
      out << "__FILE__EOF__\n";
      _imp_file = "";
    } 
  else 
    {
      _data.restart();            
      cnf << '[' << _paragraph << ']';
      out << cnf << '\n';  
      for (int i = 0; i < _data.items(); i++)
	{
	  THash_object* o = _data.get_hashobj();
	  out << o->key() << "\t= " << (TString&)(o->obj()) << '\n';
	}
      out << '\n';
    }
}


void TConfig::_write_file()
{
  ifstream in(_file);       
  TFilename temp;
  temp.temp("__tmp__.cnf");
  ofstream out(temp);
  
  TFixed_string l(__tmp_string, sizeof(__tmp_string)); 
  TString cnf(32);

  if (!_imp_file.empty())
    cnf << '[' << _paragraph << "__FILE__]";
  else 
    cnf << '[' << _paragraph << ']';

  bool skip = FALSE, done = FALSE;

  while (!in.eof())
    {
      in.getline(__tmp_string,sizeof(__tmp_string)-1);
      l.trim();
      
      if (cnf == l)
	{
	  // write paragraph and all variables
	  _write_paragraph(out);
	  skip = TRUE; done = TRUE;
	}
      else 
	{ 
      	  if (skip)  skip = l[0] != '[';
      	  if (!skip) out << l << '\n';
	}
    }
  // new paragraph
  if (!done) _write_paragraph(out);
  
  out.close(); in.close();
  TFilename bak(_file); bak.ext("bak");
  rename(_file,bak);
  fcopy(temp,_file);
  fremove(temp);
  _file = "";
}


void TConfig::_check_paragraph(const char* section)
{
 if (section != NULL && section != _paragraph)
    {
      if (_dirty) _write_file();
      _paragraph = section; 
      _dirty = FALSE;
      _read_paragraph();
    }
}

TString& TConfig::get(const char* var, const char* section, int index)
{
  // ritorna valore di variabile nella sezione corrente o in
  // quella specificata
  static TFixed_string s(__tmp_string, 256);
  TString vvar(var); if (index != -1) vvar << '(' << index << ')';
 
 _check_paragraph(section);

  if (_data.is_key(vvar)) 
    s = (TString&)_data[vvar];
  else s = "";

  return s;
}

long TConfig::get_long(const char* var, const char* section, int index)
{ 
  return atol(get(var,section,index)); 
}

bool TConfig::get_bool(const char* var, const char* section, int index)
{
  const TString& s = get(var, section, index).upper();
  return s != "" && (s == "X" || s == "ON" || s == "YES" ||
		     s == "OK" || s == "TRUE");
}


bool TConfig::set(const char* var, const char* value, const char* section, 
		  bool force, int index)
{
  // setta variabile nella sezione corrente o specificata
  // se force == TRUE crea la variabile se non esiste; altrimenti
  // da' errore; ritorna TRUE se la variabile c'era, FALSE diversamente

 _check_paragraph(section);
 TString vvar(var); if (index != -1) vvar << '(' << index << ')';

  bool itwas = _data.is_key(vvar);
 
  if (itwas && !force)
    warning_box("Tentativo di ridefinizione simbolo: %s", (const char*)vvar);
  else
    {
      _dirty = TRUE;
      _data.add(vvar, new TString(value), force);
    }
  return itwas;
}

bool TConfig::set(const char* var, long value, const char* section, 
		  bool force, int index)
{
  TString t; t << value;
  return set(var,t,section,force,index);
}

word TConfig::items(const char* var, const char* section)
{
  _check_paragraph(section);
  TString vvar(16); int cnt;
  for (cnt = 0; /* uncazzo */ ;cnt++)
    {
      vvar = var; vvar << '(' << cnt << ')';
      if (!_data.is_key(var))
	break;
    }
  return cnt;
}

bool TConfig::import_file(const char* file, const char* section)
{
  TString p(_paragraph); bool d = _dirty;
  _imp_file = file;
  _paragraph = section;
  _dirty = TRUE;
  _write_file();
  _paragraph = p; _dirty = d;
  return TRUE;
}

bool TConfig::export_file(const char* section, const char* file)
{
  ofstream out(file);
  if (out.bad()) 
    return FALSE;

  TString sec(section); sec << "__FILE__";
  if (_dirty) _write_file();

  TString l(256); 
  TScanner scan(_file);
  if (scan.paragraph(sec))
    {
      l = scan.line();
      while (l != "__FILE__EOF__" && !scan.eof())
	{
	  out << l << '\n';
	  l = scan.line('\n', FALSE);
	}
      out.close();
      return TRUE;
    }
  else return FALSE;
}


TConfig::TConfig(const char* filename, const char* paragraph) : 
  _paragraph(paragraph), _dirty(FALSE), _file(filename), _imp_file("")
                 
{
  if (!fexist(filename))
    {
      // create empty file
      FILE* fp = fopen(filename,"w");
      if (fp) fclose(fp);
    }
  _ispresent = _read_paragraph();
}

TConfig::~TConfig()
{
  // il distruttore riscrive il file con le modifiche se necessario 
  if (_dirty) _write_file();
}

