#ifndef __CONFIG_H
#define __CONFIG_H

#ifndef __ASSOC_H
#include <assoc.H>
#endif

#ifndef __STRINGS_H
#include <strings.H>
#endif

class ofstream;

class TConfig : public TObject
{
  TAssoc_array  _data;
  TFilename     _file;
  bool          _dirty, _ispresent;
  TString       _paragraph;
  TString       _imp_file;

  bool _read_paragraph();
  void _write_paragraph(ofstream&);
  void _write_file();
  void _check_paragraph(const char*);

 public:

  // ritorna valore di variabile nella sezione corrente o in
  // quella specificata; se non c'e' ritorna ""
  // passando index >=0 viene appeso al nome variabile per
  // implementare un mezzo cazzo di array
  TString& get(const char* var, const char* section = NULL, int index = -1);

  // questa ritorna 0 se non c'e', il che e' un po' sfigotto
  long get_long(const char* var, const char* section = NULL, int index = -1);
  
  // questa ritorna FALSE se non c'e', il che e' ancora piu' sfigotto
  bool get_bool(const char* var, const char* section = NULL, int index = -1);

  // setta variabile nella sezione corrente o specificata
  // se force == TRUE crea la sezione/variabile se non esiste; altrimenti
  // da' errore; ritorna TRUE se la sezione/var c'era, FALSE diversamente 
  // index come per get()
  bool set(const char* var, const char* value, const char* section = NULL, 
	   bool force = TRUE, int index = -1);
  bool set(const char* var, long value, const char* section = NULL, 
	   bool force = TRUE, int index = -1);

  // TRUE se il paragrafo corrente e' nuovo
  bool new_paragraph() { return !_ispresent; }

  // items ritorna quanti elementi dell'array nominato sono
  // presenti nella sezione indicata 
  // non si risponde di eventuali "buchi" causati da set() errate 
  word items(const char* var, const char* section);

  // importa un intero file in una sezione; non modifica
  // la sezione corrente
  bool import_file(const char* file, const char* section);
  // esporta una sezione-file in un file
  bool export_file(const char* section, const char* file);

  // il paragrafo iniziale e' il modulo corrente salvo diversa indicazione
  TConfig(const char* filename, const char* paragraph = NULL);
  // il distruttore riscrive il file con le modifiche se necessrio, 
  virtual ~TConfig();
};

#endif
