#ifndef __DFIT_H
#define __DFIT_H
#endif

// max number of test allowed
#define DFIT_MAXTESTS 24

#include <assoc.H>
#include <dfitm.H>
#include <fstream.h>

class VDesc;

class DFit : public TObject
{
  TString _id;
  TAssoc_array _vars;
  TArray _varnames;    // variable names in order of definition
  double _score;
  double _ok;
  TArray _outdefs;     // defined in dfitm.H

  int test_id(const char*);

public:
  
  // called to read config file in
  void read_config(const char* file);
  
  // called to fill in data at simulation end if no file read
  // is configured
  void set_data(const char* var, double* d, int ndata);
  
  // called to start the computation
  void compute();

  // global score for all variables considered
  double score() { return _score; }
  
  // score for a single variable with one or more methods
  double var_score(const char* varname, int method_id = MID_GLOBAL);

  // start report generator 
  virtual void report();

  // parse report string for variable (or main if v ==  NULL)
  virtual void report_object(const char* format, const char* f, 
			     VDesc* v = NULL);

  // define tag for new comparison method
  void add_method (const char* name, int method_id);
  
  // define to implement new comparison method
  virtual double compare_vars(int method_id, float* orig, float* cmp, 
			     int norig, int ncmp)
  { return 0.0; }

  // default just prints message and exits
  virtual void error(const char* message);

  DFit(const char* cfile, const char* id = "") : _ok(FALSE), _id(id)
  { read_config(cfile); }

  DFit() : _ok(FALSE), _id("")
  {}

  virtual ~DFit() { ; }
};

#ifdef USE_TCL

#ifndef __FEATOBJ_H
#include <featobj.H>
#endif

class tcl_dfit : public TFeatured_object
{
protected:

  virtual void do_method(methodID ID, int argc, char** argv,
			 int optc, char** optv);
  
  virtual int write(const char*);
  virtual int read (const char*);

public:

  tcl_dfit(int, char**, int, char**, char*);
  virtual ~tcl_dfit();
};

#endif
