#ifdef USE_TCL

#include <featobj.H>
#include <strings.H>

// method IDs

#define GET_FEATURE 101
#define SET_FEATURE 102
#define ADD_FEATURE 103
#define RMV_FEATURE 104
#define ZAP_FEATURE 105
#define NAM_FEATURE 106
#define FOJ_READ    107
#define FOJ_WRITE   108

void  TFeatured_object::set_feature(const char* feature, const char* val)
{
  if (preprocess_set_feature(feature,val))
    _features.add(feature, new TToken_string(val, ' '),TRUE);
}

void  TFeatured_object::append_feature(const char* feature, const char* val)
{
  TToken_string v(val, ' ');

  if (v.items() > 1) 
    {
      // it's a list: put braces
      v.insert("{", 0);
      v << "}";
    }

  if (preprocess_get_feature(feature))
    {
      if (!_features.is_key(feature))
	_features.add(feature, new TToken_string(v, ' '));
      else 
	{
	  TToken_string& t = (TToken_string&)_features[feature];
	  t.add(v);
	}
    }
}

void TFeatured_object::remove_feature(const char* feature)
{
  if (!_features.remove(feature))
    {
      // if not found, find 'array' variables with that name and
      // remove all of them
      _features.restart();
      THash_object* o; TString t(32);
      t << feature << '(';
      int l = t.len();
      while ((o = _features.get_hashobj()) != NULL)
	{
	  if (strncmp(o->key(), t, l) == 0)
	    _features.remove(o->key());
	}
    }
}

void TFeatured_object::get_names(const char* feature)
{
  // find 'array' variables with that name and
  // return list of names
  _features.restart();
  THash_object* o; TString t(32);
  t << feature << '(';
  int l = t.len();
  reset_result();
  
  while ((o = _features.get_hashobj()) != NULL)
    {
      char buf[80];
      if (strncmp(o->key(), t, l) == 0)
	{
	  strcpy(buf, (const char*)(o->key())+l);
	  buf[strlen(buf) - 1] = '\0';
	  add_result(buf);
	}
    }
}


const char* TFeatured_object::get_feature(const char* feature)
{
  if (preprocess_get_feature(feature))
    {
      if (_features.is_key(feature))
	return (const char*)(TToken_string&)(_features[feature]);
    }
  return "";
}

void TFeatured_object::invalid_method(const char* m, int argc, char** argv, 
				      int optc, char** opt)
{
  set_result(get_feature(m));
}


void TFeatured_object::do_method(methodID ID, int argc, char** argv, 
					 int optc, char** opt)
{
  int i;

  if (ID != ZAP_FEATURE && argc < 1)
    {
      error("need at least a feature name");
      return;
    }

  switch(ID)
    {
    case GET_FEATURE:
      set_result(get_feature(argv[0]));
      break;
    case SET_FEATURE:
      set_feature(argv[0], argc > 1 ? argv[1] : "");
      break;
    case NAM_FEATURE:
      get_names(argv[0]);
      break;
    case ADD_FEATURE:
      if (argc > 1)
	for (i = 1; i < argc; i++)
	  append_feature(argv[0], argv[i]);
      break;
    case RMV_FEATURE:
      remove_feature(argv[0]);
      break;
    case ZAP_FEATURE: 
      _features.destroy();
      break;
    case FOJ_READ: 
      set_result ("%d", read(argv[0]));
      break;
    case FOJ_WRITE: 
      set_result ("%d", write(argv[0]));
      break;
    }
}


TFeatured_object::TFeatured_object(int argc, char** argv, 
				   int optc, char** optv, char* name) :
  TclObject(argc, argv, optc, optv, name)
{

  TToken_string opt(32);
  TString nm(20);

  for(int i = 0; i < optc; i++)
    {
      opt = optv[i];
      nm  = opt.get();
      if (opt.items() > 1)
	set_feature(nm, opt.get());
    }

  add_method("get",     GET_FEATURE);
  add_method("set",     SET_FEATURE);
  add_method("lappend", ADD_FEATURE);
  add_method("unset",   RMV_FEATURE);
  add_method("names",   NAM_FEATURE);
  add_method("read",    FOJ_READ);
  add_method("write",   FOJ_WRITE);
}

#endif
