#ifndef __FEATOBJ_H
#define __FEATOBJ_H

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __TCLOBJ_H
#include <tclobj.H>
#endif

/* like TCLobj but with extensible var slots
 * each var added with set_var <varname> <val> can be retrieved 
 * with get_var OR simply using its name as a method
 * No 'invalid method' error is generated: invalid methods
 * return empty strings
 */

class TFeatured_object : public TclObject
{
  TAssoc_array _features;

  protected:

  virtual bool preprocess_get_feature(const char* f) 
    { return TRUE; }
  virtual bool preprocess_set_feature(const char* f, const char* v) 
    { return TRUE; }

  virtual void invalid_method(const char* m, int argc, char** argv, 
			      int optc, char** opt);

  virtual void do_method(methodID ID, int argc, char** argv, 
			 int optc, char** opt);
  
  // these are bound to predefined methods read and write
  virtual int write (const char* filename) { return 1; }
  virtual int read  (const char* filename) { return 1; }

public:

  void  append_feature(const char* feature, const char* val);
  void  set_feature(const char* feature, const char*  val);
  void  remove_feature(const char* feature);
  const char* get_feature(const char* feature);
  void  get_names(const char* feature);

  TFeatured_object(int argc, char** argv, int optc, char** optv, 
		   char* name); 
  virtual ~TFeatured_object() {}
};

#endif

