#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <strings.H>
#include "lex.H"

const int LF  = '\n';     // line feed
const int EOS = '\0';     // end of string

/*---------------------- Controllo per numeri -------------------------------*/
// lasciate pubbliche per eventuali usi esterni

bool TLex::is_integer (const char *s)
{
   int c, i = 0;
   if (s[0] == '-' || s[0] == '+') i++;
   while (c = s[i++])
      if (!(isdigit(c))) return FALSE;
   return TRUE;
}


bool TLex::is_float (const char *s)
{
   int c, i = 0, dotflag = 0, expflag = 0;
   if (s[0] == '-' || s[0] == '+') i++;
   while (c = s[i++])
      {
	if (c == 'e' || c == 'E')
	  {
	   if (expflag) return FALSE;
	   else {
	     expflag++; // no more exps allowed
	     dotflag++; // no more dots allowed
	     if (s[i+1] == '-' || s[i+1] == '-')
	       i++;
	     else if (!isdigit(s[i+1]))
	       return FALSE;
	   }
	   continue;
	  }
	if (c == '.')
         {
	   if (dotflag) return FALSE;
	   else dotflag++;
	   continue;
         }
      if (!(isdigit(c))) return FALSE;
      }
   return TRUE;
}

/*------------------------ check_newline ------------------------------------*/

void TLex::check_newline()
{
   int c;
   _yyline++;

   for (;;)
     {
       c = nextc();
       
       if (c == '\n' )
	 {
	   _yyline++;
	   continue;
	 }
       if (c != ' ' && c != '\t' )
	 {
	   pushc(c);
	   return;
	 }
     }
   
}


int TLex::nextc(bool ignn) 
{
  int c = _pushed ? _pushc : fgetc(_lexin);
  
  if (ignn && !feof(_lexin))
    {
      while (!isascii(c))
	{
	  c = fgetc(_lexin);
	  if (feof(_lexin))
	    break;
	}
    }
  if (feof(_lexin))
  {
    _eof = TRUE;
    return LEX_ENDFILE;
  }
  _pushed = FALSE;
  return c;
}

void TLex::pushc(int c)
{
  if (_pushed)
    error_box("porcabestia, l'hai gia' pushato questo %c", c);
  _pushc = c;
  _pushed = TRUE;
}
/*---------------------- Action routine: to be defined ----------------------*/

// le viene passato il valore di ritorno di LEX prima di ritornare e il nome
// del token che ha causato il match; yylex ritornera' il valore di when_found
// Per definire azioni particolari si ridefinisca questa funzione
// ATTENZIONE: deve gestire anche LEX_ENDFILE

int TLex::postprocess_token(int val, const char *token, int& alt)
{
   return val;
}


/*---------------------- Skip whitespace routine ----------------------------*/
// Aggiungere gestione errore

int TLex::skip_whitespace()
{
   int inside;

   int c = nextc();
   
   for (;;)
      {
      switch (c)
         {
         case '/':
	   c = nextc();
	   if (c != '*')
	     {
	       pushc(c);
	       return '/';
	     }
	   c = nextc();
	   inside = 1;
	   while (inside)
	     {
	       if (c == '*')
		 {
		   while (c == '*')
		     c = nextc();
		    if (c == '/')
		      {
			inside = 0;
			c = nextc();
		      }
		 }
	       else if ( c == '\n' )
		 {
		    _yyline++;
		    c = nextc();
                  }
	       else if (feof(_lexin))
		 // ERROR : commento non terminato
		 fatal_box("unterminated comment, line %d", _yyline);
	       else c = nextc();
	     }
	   break;
         case '\n':
	   check_newline();
         case ' ':
         case '\t':
         case '\f':
         case '\r':
	   c = nextc();
	   break;
         default:
	   if (feof(_lexin)) 
	     return LEX_ENDFILE;
	   else if (_ignore_nonprintable && !isascii(c))
	     c = nextc();
	   else
	     return c;
	   break;
         }
      }
}



/*-------------------------- Lexical analyzer -------------------------------*/

int TLex::yylex ()
{
  int i, ret = LEX_UNKNOWN;

  int c = skip_whitespace();

  if (c == LEX_ENDFILE || feof(_lexin)) 
    return LEX_ENDFILE;
  
  if (strchr(_trm,c) != NULL)  // terminatore
    {
      _yytxt2[0] = c;
      _yytxt2[1] = EOS;
      return c;
    }
  
  for (i = 0 ; ;)
    {
      _yytxt[i++] = c;
      c = nextc(_ignore_nonprintable);
      if (isspace(c) || strchr(_trm, c) != NULL) // check for termination
	{
	  pushc(c);
	  break;
	}
    }
  _yytxt[i] = '\0';
  
  if (is_integer(_yytxt))
    {
      _ival = atoi(_yytxt);
      _fval = (float)_ival;
      ret = LEX_INTEGER;
      goto found;
    }
  if (is_float(_yytxt))
    {
      _fval = atof(_yytxt);
      ret = LEX_FLOAT;
      goto found;
    }
  
  
  if (_kw)
    {
      // scan keyword definition array
      // binary search on sorted array
      for (i = 0; i < _kw->items(); i++)
	{
	  TToken_string& t = (TToken_string&)(*_kw)[i];
	  
	  /* printf ("scanning %s against %s: tikstr is %s\n", 
		  (const char*)_yytxt, (const char*)t.get(0),
		  (const char*)t); */
	  
	  if (t.get(0) >  _yytxt) break;
	  if (strcmp(t.get(0), _yytxt) == 0) // for speed
	    {
	      ret = t.get_int(1);
	      goto found;
	    }
	}
    }
  
  // controllo numero o identificatore
  if (isalpha(_yytxt[0]) || _yytxt[0] == '_')
    ret = LEX_IDENTIFIER;
  
found:
  
  return ret;
}


int TLex::token()
{
  _yyval = yylex();
  while((_yyval = postprocess_token(_yyval, _yytxt, _yyalt)) == LEX_IGNORE)
    _yyval = yylex();
  return _yyval;
}



TLex::TLex (const char* filename, const char* terminators, TArray* keywords) :
  _kw(keywords), _errflag(0), _yyline(0), _yyval(0), _ival(0), _fval(0.0),
  _eof(FALSE), _pushed(FALSE), _ignore_nonprintable(TRUE)
{
  strcpy(_trm, terminators);
  _yytxt[0] = _yytxt2[0] = '\0';
  _lexin = fopen(filename, "r");
  if (_lexin == NULL)
    fatal_box("TLex: error opening %s", filename);
}

TLex::~TLex () 
{
  if (_lexin != NULL) fclose(_lexin);
}


int TLexS::postprocess_token(int val, const char* tok, int& alt)
{
  if (val == '"') 
    {
    _sval = "";
    int c = nextc();
    while (c != '"') 
      {
	if (c == EOF)
	  {
	    fatal_box("TLex: end of file in string");
	  }
	else if (c == '\\')
	  {
	    c = nextc();
	    if (c == '\n')
	      continue;
	    else if (c == 'n')
	      _sval << '\n';
	    else if (c == 't')
	      _sval << '\t';
	    else if (c == 'r')
	      _sval << '\r';
	  }
	else
	  _sval << (char)c;
	c = nextc();
      }
    val = LEX_STRING;
    }
  return val;
}
