#ifdef USE_TCL
#ifdef USE_POSTGRES

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>
#include <utility.H>
extern "C" {
#include <ctype.h>
};


#ifdef strerror
#undef strerror
#endif

#include "postgres.H"
#include <libpq/libpq-fs.h>

#define M_PG_STATUS   1
#define M_PG_GETDATA  2
#define M_PG_NEW      3
#define M_PG_EXECCMD  4
#define M_PG_EXECFILE 5
#define M_PG_IMPFILE  6
#define M_PG_EXPFILE  7

#define PG_DEFHOST "localhost"
#define PG_DEFPORT "5432"

#ifndef BUFSIZE
#define BUFSIZE 2048
#endif

#undef DBG

int tcl_pg95::import_object(const char* file)
{
  char buf[BUFSIZE];
  int fd = open(file, O_RDONLY, 0666);
  if (fd < 0)
      return 0;

  int lobj = lo_creat(_conn, INV_READ|INV_WRITE|INV_ARCHIVE);

  if (lobj != 0)
    {
      int nb;
      int lfd = lo_open(_conn, lobj, INV_WRITE);
      while ((nb = ::read(fd, buf, BUFSIZE)) > 0)
	{
	  int tmp = lo_write(_conn, lfd, buf, nb);
	  if (tmp < nb) 
	    {
	      error("PG error writing large object");
	      break;
	    }
	}
      (void)lo_close(_conn, lfd);
    }
  (void)close(fd);

  return lobj;
}

int tcl_pg95::export_object(int oid, const char* file)
{
  char buf[BUFSIZE];

  int lfd = lo_open(_conn, oid, INV_READ);
  if (lfd < 0) return 0;

  int fd = open(file, O_CREAT|O_WRONLY, 0666);
  
  if (fd < 0)  return 0;
  
  int nb; int ret = 1;
  while ((nb = lo_read(_conn, lfd, buf, BUFSIZE)) > 0) 
    {
      int tmp = ::write(fd, buf, nb);
      if (tmp < nb)
	ret = 0;
    }
  (void)lo_close(_conn, lfd);
  (void)close(fd);	      
  return ret;
}

void tcl_pg95::submit_sql(const char* c)
{
#ifdef DBG
  printf ("DBG: submitting command: %s\n", c);
#endif
  PGresult* res = PQexec(_conn, (char*)c);
  if (res)
  { 
    PQclear(res);     
    _status = PQresultStatus(res) == PGRES_COMMAND_OK;
  }
  else _status = 0;
}

void tcl_pg95::import_file(int ac, char** av, int oc, char** ov)
{
  if (ac < 1) 
    error ("pg95db: usage: <obj> importFile <filename>");
  else 
    {
      PGresult* res = PQexec(_conn, "begin");
      PQclear(res);
      int i = import_object(av[0]);
      res = PQexec(_conn, "end");
      PQclear(res);
      set_result("%d", i);
    }
}

void tcl_pg95::export_file(int ac, char** av, int oc, char** ov)
{
  if (ac < 2) 
    error ("pg95db: usage: <obj> exportFile <oid> <filename>");
  else 
    {
      PGresult* res = PQexec(_conn, "begin");
      PQclear(res);
      int i = export_object(atoi(av[0]), av[1]);
      res = PQexec(_conn, "end");
      PQclear(res);
      set_result("%d", i);
    }
}

void tcl_pg95::exec_file(int ac, char** av, int oc, char** ov)
{
  TString cmd(512);
  if (ac < 1) 
    error ("pg95db: exec_file: filename expected");
    
  FILE* fp = fopen(av[0], "r");
  if (fp == NULL) {
    error ("pg95db: exec_file: file %s read error");
    _status = 0;
    return;
  }
  static char buf[128];
  while (!feof(fp)) {
    if (fgets(buf, 128, fp) == NULL)
      break;
    // chop newline
    buf[strlen(buf)-1] = '\0';
    // trim leading whitespace
    int i = 0;    
    while (isspace(buf[i]) && buf[i]) i++;
    // ignore comments and white lines
    if (buf[i] == '-' && buf[i+1] == '-')
      continue;
    if (buf[i] == '\0') continue;    
    cmd << buf;
    cmd.rtrim();
    if (cmd[cmd.len() - 1] == ';')
    {
      submit_sql((const char*)cmd);
      cmd = "";
      if (_status == 0)
        break;
    } 
  }
  fclose(fp);
}


void tcl_pg95::exec_sql(int ac, char** av, int oc, char**ov)
{
  if (ac < 1) 
    error("pg95db: exec_sql: no code to execute");
  else {
    char* p = av[0];
    while (isspace(*p)) p++;
    if (strncmp(p,"SELECT",6) == 0)
      submit_query((const char*)av[0]);
    else  
      submit_sql((const char*)av[0]); 
  }
}

void tcl_pg95::submit_query(const char* c)
{
#ifdef DBG
  printf ("DBG: submitting query: %s\n", c);
#endif
  PGresult* qr = PQexec(_conn, (char*)c);
  reset_result();
  
  if (qr && PQresultStatus(qr) == PGRES_TUPLES_OK)
  {
     TString res(80);
     for (int i = 0; i < PQntuples(qr); i++)
     {
       res = "{";
       for (int j = 0; j < PQnfields(qr); j++) {
         res << "{" << (const char*)PQgetvalue(qr, i, j) << "}";
         if (j < (PQnfields(qr) - 1)) res  << " ";
       }
       res << "}";
       add_result((const char*)res);
    }
  }
  if (qr) PQclear(qr);
}

tcl_pg95::tcl_pg95(int ac, char** av, int oc, char** ov, char* n) :
  TclObject(ac, av, oc, ov, n), _status(0), _host(PG_DEFHOST),
  _port(PG_DEFPORT), _conn(NULL), _new(0)
{
  bool cflag = 0;
  
  for (int i = 0; i < oc; i++)
  {
    TToken_string op(ov[i]);
    TString on(op.get());

    if (on == "create")
      cflag = 1;
    else if (on == "port")
      _port = op.get();
    else if (on == "host")
      _host = op.get();
  }
  
  if (ac < 1) 
    error("database name expected");
  else
  {
    _conn = PQsetdb(_host.empty() ? (char*)NULL : (char*)(const char*)_host,
                    _port.empty() ? (char*)NULL : (char*)(const char*)_port,
                    NULL, NULL, av[0]);
    _status = PQstatus(_conn) == CONNECTION_OK;
  }
  if (!_status && cflag)
  {
    PQfinish(_conn);
    _conn = PQsetdb(_host.empty() ? (char*)NULL : (char*)(const char*)_host,
                    _port.empty() ? (char*)NULL : (char*)(const char*)_port,
                    NULL, NULL, "template1");
    if ((_status = PQstatus(_conn)) == CONNECTION_OK)
    {
      printf("Creating DB %s\n", av[0]);
      PGresult* res =  
        PQexec(_conn, (char*)format("CREATE DATABASE %s;", av[0]));
      _status = (res && PQresultStatus(res) == PGRES_COMMAND_OK);
      if (res) PQclear(res);
      PQfinish(_conn);
      if (_status)
      {
        _conn = PQsetdb(_host.empty() ? (char*)NULL : (char*)(const char*)_host,
                        _port.empty() ? (char*)NULL : (char*)(const char*)_port,
                       NULL, NULL, av[0]);
        _status = PQstatus(_conn) == CONNECTION_OK;
        _new = 1;
      }
    } 
  }
    
  add_method("status",  M_PG_STATUS);
  add_method("isNew",   M_PG_NEW);
  add_method("getData", M_PG_GETDATA);
  add_method("execSql", M_PG_EXECCMD);
  add_method("execSqlFile", M_PG_EXECFILE);
  add_method("importFile", M_PG_IMPFILE);
  add_method("exportFile", M_PG_EXPFILE);
}

tcl_pg95::~tcl_pg95() 
{
  if (_conn) PQfinish(_conn);
}

void tcl_pg95::do_method(methodID ID, int argc, char** argv,
				  int optc, char** optv)
{
  switch (ID)
  {
  case M_PG_STATUS:
    set_result("%d",_status);
    break;
  case M_PG_NEW:
    set_result("%d",_new);
    break;
  case M_PG_EXECCMD:
    exec_sql(argc, argv, optc, optv);
    break;
  case M_PG_EXECFILE:
    exec_file(argc, argv, optc, optv);
    break;
  case M_PG_IMPFILE:
    import_file(argc, argv, optc, optv);
    break;
  case M_PG_EXPFILE:
    export_file(argc, argv, optc, optv);
    break;
  default:
    error ("Command not recognized");
    break;
  }
}


#endif
#endif
