#ifndef __PG_H
#define __PG_H

#ifndef __TCLOBJ_H
#include <tclobj.H>
#endif

extern "C" {
#include <libpq-fe.h>
};


class tcl_pg95 : public TclObject
{
  PGconn* _conn;
  TString _host;
  TString _port;
  int     _status;
  int     _new;
  
protected:

  virtual void do_method(methodID ID, int argc, char** argv,
                         int optc, char** opt);

  void submit_sql(const char*);    
  void submit_query(const char*);                        

  int import_object(const char* file);
  int export_object(int id, const char* file);
                         
public:

  void exec_sql   (int, char**, int, char**);
  void exec_file  (int, char**, int, char**);
  void import_file(int, char**, int, char**);
  void export_file(int, char**, int, char**);
  
  tcl_pg95(int, char**, int, char**, char*);
  virtual ~tcl_pg95();
};

#endif








