#include <ctype.h>
#include <stdlib.h>

#include <utility.H>
#include <scanner.H>

HIDDEN const char* strlwr (const char* str)
{
  char* s;
  for (s = __tmp_string; *str; s++, str++) *s = tolower(*str);
  *s = '\0';
  return __tmp_string;
}

inline bool string_start(char c)
{ return c == '"' || c == '\'' || c == '{' || c == '\''; }

inline char match(char c)
{ return (c == '{') ? '}' : c; }

TScanner::TScanner(const char* filename)
  : ifstream(filename), _token(128), _key(2), _pushed(FALSE), _line(0)
{
  if (!is_open()) 
    fatal_box("TScanner: can't open %s", filename);
}

const TString& TScanner::pop()
{
  if (!_pushed) do
    {
      _token.read_from((ifstream&) *this);
      if (_token[0] == '/' && _token[1] == '/')
	{
	  line();
	  _token.cut(0);
	}
    } while (_token.empty() && good());
  
  _pushed = FALSE;
  _token.upper();
  _key = _token.left(2);
  
  return _token;
}

TString& TScanner::line(char eol, bool ltrim)
{
  do
    {
      if (!_pushed) _token = "";
      getline(__tmp_string, sizeof(__tmp_string), eol);
      _line++;
      _token <<  __tmp_string;
      if (ltrim) _token.trim();
      else _token.rtrim();
    } while (_token.empty() && good());
  
  _pushed = FALSE;
  
  return _token;
}

const TString& TScanner::string()
{
  if (!_pushed)
    {
      char c;
      while (isspace(c = get()));
      if (string_start(c))
	{
	  getline(__tmp_string, sizeof(__tmp_string), match(c));
	  _token = __tmp_string;
	}
      else
	{
	  error_box("Stringa non trovata: riga ignorata");
	  _token.cut(0);
	}
    }
  
  _pushed = FALSE;
  return _token;
}

int TScanner::integer()
{
  int i = atoi(pop());
  if (i == 0 && !isdigit(_token[0])) push();
  return i;
}

double TScanner::number()
{
  double d = atof(pop());
  if (d == 0.0 && !isdigit(_token[0])) push();
  return d;
}


const TString& TScanner::operand()
{
  if (!_pushed)
    {
      char c;
      while (isspace(c = get()));
      putback(c);
      if (string_start(c))
	return string();
      else
	return pop();
    }
  
  _pushed = FALSE;
  return _token;
}

void TScanner::push(const char* s)
{
  CHECK(!_pushed, "You are pushing back two values to the scanner");
  
  if (s != NULL) _token = s;
  _pushed = TRUE;
}

bool TScanner::paragraph(const char* name)
{
  TString p(80);
  p << '[' << name << ']';
  
  seekg(0L);
  
  while (line().not_empty())
    if (token() == p) return TRUE;
  
  return FALSE;
}

