#ifndef __SCANNER_H
#define __SCANNER_H

#ifndef __FSTREAM_H
#include <fstream.h>
#endif

#ifndef __STRINGS_H
#include <strings.H>
#endif


// @C
class TScanner : public ifstream
{
// @DPRIV
  TString _token, _key;
  bool _pushed;
  word _line;

public:
// @FPUB
  TScanner(const char* filename);
  const TString& pop();
  const TString& key() const { return _key; }
  const TString& popkey() { pop(); return key(); }
  const TString& string();
  TString& line(char eol = '\n', bool ltrim = TRUE);
  const TString& equal() { return line('='); }
  int integer();
  double number();
  const TString& operand();
  bool paragraph(const char* name);

  bool ok() { return good(); }

  void push(const char* tok = NULL);
  const TString& token() const { return _token; }
  word linenum() { return _line; }
};


#endif // __SCANNER_H
