#ifndef __TCLOBJ_H
#define __TCLOBJ_H

#ifndef __OBJECT_H
#include <object.H>
#endif

#ifndef __ASSOC_H
#include <assoc.H>
#endif

#ifndef _TCL
extern "C" {
#include <tcl.h>
}
#endif

// objects receive NULL_METHOD when objname is invoked without args
#define NULL_METHOD -2

class TclObject;
typedef TclObject* (*TCLOBJ_CTOR)(int argc, char** argv, int optc, char** optv,
				  char* name);

// -----------------------------------------------------------
// user must create this one with an entry for each
// new class

extern struct TclClassDesc 
{
  const char* _name;
  TCLOBJ_CTOR _mkfunc;
} TclObjectTable[];

extern int  TclObj_Init(Tcl_Interp*);
extern void DeleteTempTclObjects();
extern bool UseIncrTcl;

// ------------------------------------------------------------

typedef short methodID;

class TclObject : public TObject
{
  friend class        tmp_obj;
  
  TString            _name;
  TToken_string      _result;
  TAssoc_array       _methods;
  int                _retval;
  bool               _error;
  int                _meth_cnt;
  char*              _class_name;
  bool               _expired;
  
protected:

  void     reset_result() { _error = FALSE; _result = ""; }
  int      set_result(const char* fmt = NULL, ...);
  int      add_result(const char* tk);
  int      add_result(double d);
  int      add_result(int n);
  int      add_result(long l);
  void     error(const char* fmt = NULL, ...);

  methodID add_method(const char* name, methodID);
  methodID method_id(const char* name);

  // user redefines this one and returns results here
  // through the above procs
  virtual void do_method(methodID ID, int argc, char** argv, 
			 int optc, char** opt) pure;

  // define this to catch 'invalid method' errors
  virtual void invalid_method(const char* m, int argc, char** argv, 
			      int optc, char** opt);

public:


  // hate to make this public but temp objects need to be destroyed from
  // outside, and it cannot be put into destructor
  void     destroy();
  void     set_class_name(char* n) { _class_name = n; }
  const char* class_name() const   { return _class_name; }

  // convert tcl object name into pointer to instance
  static TclObject* name2obj(const char*);

  const char* name() { return _name; }

  // TCL interface: only one interpreter per shell is supported (static)
  // sets result to result, returns error code or TCL_OK
  int execute(const char* code);
  // returns result, sets ret to error or TCL_OK, leaves result untouched
  const char* execute(const char* code, int& ret);
  // returns result, sets ret to error or TCL_OK, leaves result untouched
  const char* expr(const char* code, int& ret);
  // returns atoi() of result (left in Interp->result)
  int execute_with_ret(const char* code);
  // get value of global variable
  const char* get_global_var(const char*);
  // sets value of global variable
  void set_global_var(const char*, const char*);
  // called in method execution when the method is executed
  // by TCL proc (must be known to interpreter): proc is 
  // passed the name of the object and args - If ignres == TRUE
  // does not set the result string
  int invoke_tcl_method(const char* tclproc, int argc, char** argv, 
			bool ignres = FALSE);

  bool call_method (const char* meth, int argc, char** argv, 
		    int optc, char** optv); 

  void mark_for_deletion() { _expired = TRUE; }
  bool expired() const { return _expired; }
  TToken_string& result() { return _result; }
  
  bool is_error()        { return _error; }
  void set_error(bool b) { _error = b; }

  TclObject(int argc = 0, char** argv = NULL, int optc = 0, 
	    char** optv = NULL, char* name = NULL);

  virtual ~TclObject();
};

#endif

