#ifdef USE_TCL

#include "tclsock.H"
#include <stdlib.h>
#include <utility.H>

extern "C" {
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <unistd.h>

/* there are no prototypes for these on SunOS 4.1.x
extern int socket(int, int, int);
extern int bind(int, struct sockaddr*, int);
unsigned long inet_addr(char*);
extern int getsockname(int, struct sockaddr*, int*);
extern int gethostname(char*, int);
extern int listen(int, int);
extern int connect(int, struct sockaddr*, int);
*/
}

#define M_SK_ADD       1
#define M_SK_NSOCKETS  2
#define M_SK_TIMEOUT   4
#define M_SK_BUFSIZE   5

void tcl_socket::do_method(methodID ID, int ac, char** av, int oc, char** ov)
{
  switch (ID) 
  {
    case M_SK_ADD:
      add_socket(atoi(av[0]));
      break;
    case M_SK_NSOCKETS:
      set_result("%d", _nsocks);
      break;
    case M_SK_TIMEOUT:
      if (ac > 0)
        _timeout = atoi(av[1]);
      set_result("%d", _timeout);
      break; 
    case M_SK_BUFSIZE:
      if (ac > 0)
        _bufsize = atoi(av[1]);
      set_result("%d", _bufsize);
    default:
      error("tcl_socket: unknown method");
      break;
    }
}

void tcl_socket::add_socket(int port)
{
  // simply registers port for subsequent connections
  if (_nsocks == MAX_PORTS)
    error("tcl_socket: add_socket: maximum n. of ports exceeded");
  else
    _port[_nsocks++] = port;
}

int tcl_socket::connect(int rep)
{
  // create socket and connects to server of replication rep
  // returns socket descriptor or -1

  // tbi set options
  //  (*_sock[rep])->recvtimeout(_timeout);
  //  (*_sock[rep])->recvbufsz(_bufsize);
  // set sockaddr for connect()
  
  // printf ("connecting to port %d\n", _port[rep]);

  sockaddr_in sin;
  memset((char*)&sin, '\0', sizeof(sin));
  sin.sin_port = htons(_port[rep]);      
  if ((sin.sin_addr.s_addr = inet_addr((char*)(const char*)_host)) == -1) 
    {
      hostent* hp = gethostbyname((char*)(const char*)_host);
      if (hp != NULL) 
	{
	  memcpy(&(sin.sin_addr), hp->h_addr, hp->h_length);
	  sin.sin_family = hp->h_addrtype;
	}
    }
  else sin.sin_family = AF_INET;  
  int s = socket(sin.sin_family, SOCK_STREAM, 0);
  if (s < 0) return s;  
  // blocks until driver answers call
  if (::connect(s, (sockaddr*)&sin, sizeof(sin)) >= 0)
    return s;
  else return -1;
}

tcl_socket::tcl_socket(int ac, char** av, int oc, char** ov, char* n) :
  TclObject(ac,av,oc,ov,n), _host("localhost"), _nsocks(0), _timeout(2),
  _bufsize(4096)
{
  int port = 0;
  // parse arguments 
  for (int i = 0; i < oc; i++) 
  {
    TToken_string op(ov[i]);
    TString o1(32);
    o1 = op.get(0);
    
    if (o1 == "host")
      _host = op.get(1);
    else if (o1 == "timeout")
      _timeout = op.get_int(1);
    else if (o1 == "bufsize")
      _bufsize == op.get_int(1);
  }       
    
  if (_host.empty())  _host = "localhost";

  add_method("add", M_SK_ADD);
  add_method("nSockets", M_SK_NSOCKETS);
  add_method("timeout",   M_SK_TIMEOUT);
  add_method("bufsize",   M_SK_BUFSIZE);
}

tcl_socket::~tcl_socket() 
{
//  for (int i = 0; i < _nsocks; i++)
//  {
//    (*_sock[i])->close();
//    delete _sock[i];
//  }
}

#endif
