#ifndef __TCLSOCK_H
#define __TCLSOCK_H

#ifndef __TCLOBJ_H
#include <tclobj.H>
#endif

// maximum number of ports supported
#define MAX_PORTS 10

// only a TCL wrapper for a number of input internet socket
// so the interface will create them from TCL and pass them
// to variables which get data from the net; one socket for
// each replication of the data (one for each running driver)

class tcl_socket : public TclObject
{
  TString     _host;
  int         _port[MAX_PORTS];
  int         _nsocks;
  int         _timeout;
  int         _bufsize;
  
protected:

  virtual void do_method(methodID ID, int argc, char** argv,
                         int optc, char** opt);
public:

  void add_socket(int port);
  int  connect(int nrep = 0);
  unsigned bufsize() { return (unsigned)_bufsize; }
  
  tcl_socket(int, char**, int, char**, char*);
  virtual ~tcl_socket();
};

#endif
