#include "Erosion.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&Erosion_module::I());
	Erosion_module::I().Initialize();
	Erosion_module::I().SetMInfo(TModule::kisGlobal,True);
	EROSION_module::I().Initialize();
	XXXIMPORTS0_module::I().Initialize();
	Erosion_module::I().MakeConnections();
	EROSION_module::I().MakeConnections();
	XXXIMPORTS0_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class Erosion_module 
// ---------------------------------------------------------------------------
Erosion_module::Erosion_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
Erosion_module* Erosion_module::fInstance = NULL;
Erosion_module* Erosion_module::kNullModel = (Erosion_module*)0x1;
int Erosion_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int Erosion_module::InitVars() {
	
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int Erosion_module::Initialize() {
	InitVars();
	Erosion_module::I().AddSubModule(&EROSION_module::I());
	Erosion_module::I().AddSubModule(&XXXIMPORTS0_module::I());
	Model::I0().ModuleList().Alphabetize();
	return 1;
}

int Erosion_module::SetupEvents() {
	return 0;
}

int Erosion_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int Erosion_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int Erosion_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int Erosion_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int Erosion_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}

// ---------------------------------------------------------------------------
//                    Class EROSION_module 
// ---------------------------------------------------------------------------
EROSION_module::EROSION_module(char* name) :
	TIME("TIME"),
	DEPOSITED_SEDIMENT("DEPOSITED_SEDIMENT"),
	DEPOSITION("DEPOSITION"),
	SUSPENSION("SUSPENSION"),
	SUSPENDED_SEDIMENT("SUSPENDED_SEDIMENT"),
	WATER("WATER"),
	PRECIPITATION("PRECIPITATION"),
	INFILTRATION("INFILTRATION"),
	A("A"),
	B("B"),
	C("C"),
	D("D"),
	E("E"),
	ELEVMAP("ELEVMAP"),
	H("H"),
	HYDRO("HYDRO"),
	K("K"),
	LINKMAP("LINKMAP"),
	RUNOFF("RUNOFF"),
	SOILMAP("SOILMAP"),
	RAINFALL("RAINFALL"),
	TModule(name) {

}	
int EROSION_module::DEPOSITED_SEDIMENT_I0_exe() {
	float value;

	DEPOSITED_SEDIMENT.UpdateIntegrator(0);
	switch( DEPOSITED_SEDIMENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEPOSITED_SEDIMENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DEPOSITION.Value(p)-SUSPENSION.Value(p) );
			DEPOSITED_SEDIMENT.Update( p, value, dT() );
		}
		DEPOSITED_SEDIMENT.GrabMemory();
		if( DEPOSITED_SEDIMENT.GetF(FLinkEdges) ) { DEPOSITED_SEDIMENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DEPOSITION.Value()-SUSPENSION.Value() );
			DEPOSITED_SEDIMENT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int EROSION_module::DEPOSITED_SEDIMENT_i1_exe() {
	float value;

	DEPOSITED_SEDIMENT.UpdateIntegrator(1);
	switch( DEPOSITED_SEDIMENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEPOSITED_SEDIMENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			DEPOSITED_SEDIMENT.InitValue( p, value );
		}
		DEPOSITED_SEDIMENT.GrabMemory();
		if( DEPOSITED_SEDIMENT.GetF(FLinkEdges) ) { DEPOSITED_SEDIMENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			DEPOSITED_SEDIMENT.InitValue( value );
	  } break;
	}
	return 0;
}

int EROSION_module::DEPOSITION_u2_exe() {
	float value;

	switch( DEPOSITION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DEPOSITION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( K.Value(p)*SUSPENDED_SEDIMENT.Value(p) );
			DEPOSITION.Update( p, value );
		}
		DEPOSITION.GrabMemory();
		if( DEPOSITION.GetF(FICFlux) ) DEPOSITION.Cov().Set(0.0); 
		if( DEPOSITION.GetF(FLinkEdges) ) { DEPOSITION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( K.Value()*SUSPENDED_SEDIMENT.Value() );
			DEPOSITION.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::SUSPENSION_u3_exe() {
	float value;

	switch( SUSPENSION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SUSPENSION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( RUNOFF.Value(p) <  D.Value(p) ) ) ? ( ((float)0) ) : (  ( ( ( RUNOFF.Value(p) <  E.Value(p) ) ) ? ( ( ( ( C.Value(p)*RUNOFF.Value(p) )/( E.Value(p)-D.Value(p) ) )-( ( C.Value(p)*D.Value(p) )/( E.Value(p)-D.Value(p) ) ) ) ) : ( C.Value(p) ) )  ) ) ;
			SUSPENSION.Update( p, value );
		}
		SUSPENSION.GrabMemory();
		if( SUSPENSION.GetF(FICFlux) ) SUSPENSION.Cov().Set(0.0); 
		if( SUSPENSION.GetF(FLinkEdges) ) { SUSPENSION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( RUNOFF.Value() <  D.Value() ) ) ? ( ((float)0) ) : (  ( ( ( RUNOFF.Value() <  E.Value() ) ) ? ( ( ( ( C.Value()*RUNOFF.Value() )/( E.Value()-D.Value() ) )-( ( C.Value()*D.Value() )/( E.Value()-D.Value() ) ) ) ) : ( C.Value() ) )  ) ) ;
			SUSPENSION.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::SUSPENDED_SEDIMENT_I4_exe() {
	float value;

	SUSPENDED_SEDIMENT.UpdateIntegrator(0);
	switch( SUSPENDED_SEDIMENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SUSPENDED_SEDIMENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SUSPENSION.Value(p)-DEPOSITION.Value(p) );
			SUSPENDED_SEDIMENT.Update( p, value, dT() );
		}
		SUSPENDED_SEDIMENT.GrabMemory();
		if( SUSPENDED_SEDIMENT.GetF(FLinkEdges) ) { SUSPENDED_SEDIMENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SUSPENSION.Value()-DEPOSITION.Value() );
			SUSPENDED_SEDIMENT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int EROSION_module::SUSPENDED_SEDIMENT_i5_exe() {
	float value;

	SUSPENDED_SEDIMENT.UpdateIntegrator(1);
	switch( SUSPENDED_SEDIMENT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SUSPENDED_SEDIMENT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			SUSPENDED_SEDIMENT.InitValue( p, value );
		}
		SUSPENDED_SEDIMENT.GrabMemory();
		if( SUSPENDED_SEDIMENT.GetF(FLinkEdges) ) { SUSPENDED_SEDIMENT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			SUSPENDED_SEDIMENT.InitValue( value );
	  } break;
	}
	return 0;
}

int EROSION_module::WATER_I6_exe() {
	float value;

	WATER.UpdateIntegrator(0);
	switch( WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PRECIPITATION.Value(p)-INFILTRATION.Value(p) );
			WATER.Update( p, value, dT() );
		}
		WATER.GrabMemory();
		if( WATER.GetF(FLinkEdges) ) { WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PRECIPITATION.Value()-INFILTRATION.Value() );
			WATER.Update( value, dT() );
	  } break;
	}
	return 0;
}

int EROSION_module::WATER_i7_exe() {
	float value;

	WATER.UpdateIntegrator(1);
	switch( WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SOILMAP.Value(p) == ((float)1) ) ) ? ( ((float)3000) ) : ( ((float)1) ) ) ;
			WATER.InitValue( p, value );
		}
		WATER.GrabMemory();
		if( WATER.GetF(FLinkEdges) ) { WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SOILMAP.Value() == ((float)1) ) ) ? ( ((float)3000) ) : ( ((float)1) ) ) ;
			WATER.InitValue( value );
	  } break;
	}
	return 0;
}

int EROSION_module::WATER_vE23_exe() {
	float value;

			 SWTransport1(WATER, HYDRO, RUNOFF, SUSPENDED_SEDIMENT);
	WATER.UpdateReserve();
	return 0;
}

int EROSION_module::PRECIPITATION_u8_exe() {
	float value;

	switch( PRECIPITATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PRECIPITATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  RAINFALL.Value(p);
			PRECIPITATION.Update( p, value );
		}
		PRECIPITATION.GrabMemory();
		if( PRECIPITATION.GetF(FICFlux) ) PRECIPITATION.Cov().Set(0.0); 
		if( PRECIPITATION.GetF(FLinkEdges) ) { PRECIPITATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  RAINFALL.Value();
			PRECIPITATION.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::INFILTRATION_u9_exe() {
	float value;

	switch( INFILTRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = INFILTRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SOILMAP.Value(p) == ((float)1) ) ) ? ( ((float)0) ) : (  ( ( ( SOILMAP.Value(p) == ((float)31) ) ) ? ( SL::Min(( WATER.Value(p)/dT() ), ((float)1)) ) : (  ( ( ( SOILMAP.Value(p) == ((float)11) ) ) ? ( SL::Min(( WATER.Value(p)/dT() ), ((float)20)) ) : ( SL::Min(( WATER.Value(p)/dT() ), ((float)100)) ) )  ) )  ) ) ;
			INFILTRATION.Update( p, value );
		}
		INFILTRATION.GrabMemory();
		if( INFILTRATION.GetF(FICFlux) ) INFILTRATION.Cov().Set(0.0); 
		if( INFILTRATION.GetF(FLinkEdges) ) { INFILTRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SOILMAP.Value() == ((float)1) ) ) ? ( ((float)0) ) : (  ( ( ( SOILMAP.Value() == ((float)31) ) ) ? ( SL::Min(( WATER.Value()/dT() ), ((float)1)) ) : (  ( ( ( SOILMAP.Value() == ((float)11) ) ) ? ( SL::Min(( WATER.Value()/dT() ), ((float)20)) ) : ( SL::Min(( WATER.Value()/dT() ), ((float)100)) ) )  ) )  ) ) ;
			INFILTRATION.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::A_u10_exe() {
	float value;

	switch( A.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = A.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  2;
			A.Update( p, A.ParameterValue(value,p) );
		}
		A.GrabMemory();
		if( A.GetF(FLinkEdges) ) { A.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  2;
			A.Update( A.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EROSION_module::B_u11_exe() {
	float value;

	switch( B.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = B.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  10;
			B.Update( p, B.ParameterValue(value,p) );
		}
		B.GrabMemory();
		if( B.GetF(FLinkEdges) ) { B.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  10;
			B.Update( B.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EROSION_module::C_u12_exe() {
	float value;

	switch( C.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = C.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			C.Update( p, C.ParameterValue(value,p) );
		}
		C.GrabMemory();
		if( C.GetF(FLinkEdges) ) { C.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			C.Update( C.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EROSION_module::D_u13_exe() {
	float value;

	switch( D.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = D.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  2;
			D.Update( p, D.ParameterValue(value,p) );
		}
		D.GrabMemory();
		if( D.GetF(FLinkEdges) ) { D.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  2;
			D.Update( D.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EROSION_module::E_u14_exe() {
	float value;

	switch( E.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = E.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  20;
			E.Update( p, E.ParameterValue(value,p) );
		}
		E.GrabMemory();
		if( E.GetF(FLinkEdges) ) { E.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  20;
			E.Update( E.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EROSION_module::ELEVMAP_u15_exe() {
	float value;

	switch( ELEVMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ELEVMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			ELEVMAP.Update( p, value );
		}
		ELEVMAP.GrabMemory();
		if( ELEVMAP.GetF(FLinkEdges) ) { ELEVMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			ELEVMAP.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::H_u16_exe() {
	float value;

	switch( H.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  4000;
			H.Update( p, H.ParameterValue(value,p) );
		}
		H.GrabMemory();
		if( H.GetF(FLinkEdges) ) { H.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  4000;
			H.Update( H.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EROSION_module::HYDRO_u17_exe() {
	float value;

	switch( HYDRO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HYDRO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			HYDRO.Update( p, value );
		}
		HYDRO.GrabMemory();
		if( HYDRO.GetF(FLinkEdges) ) { HYDRO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			HYDRO.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::K_u18_exe() {
	float value;

	switch( K.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = K.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.200000;
			K.Update( p, K.ParameterValue(value,p) );
		}
		K.GrabMemory();
		if( K.GetF(FLinkEdges) ) { K.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.200000;
			K.Update( K.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EROSION_module::LINKMAP_u19_exe() {
	float value;

	switch( LINKMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LINKMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			LINKMAP.Update( p, value );
		}
		LINKMAP.GrabMemory();
		if( LINKMAP.GetF(FLinkEdges) ) { LINKMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			LINKMAP.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::RUNOFF_u20_exe() {
	float value;

	switch( RUNOFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RUNOFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SOILMAP.Value(p) == ((float)1) ) ) ? ( SL::Max(((float)0), ( WATER.Value(p)-H.Value(p) )) ) : ( (  ( ( ( WATER.Value(p) <  A.Value(p) ) ) ? ( ((float)0) ) : (  ( ( ( WATER.Value(p) <  B.Value(p) ) ) ? ( ( ( B.Value(p)*( WATER.Value(p)-A.Value(p) ) )/( B.Value(p)-A.Value(p) ) ) ) : ( WATER.Value(p) ) )  ) ) /dT() ) ) ) ;
			RUNOFF.Update( p, value );
		}
		RUNOFF.GrabMemory();
		if( RUNOFF.GetF(FLinkEdges) ) { RUNOFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SOILMAP.Value() == ((float)1) ) ) ? ( SL::Max(((float)0), ( WATER.Value()-H.Value() )) ) : ( (  ( ( ( WATER.Value() <  A.Value() ) ) ? ( ((float)0) ) : (  ( ( ( WATER.Value() <  B.Value() ) ) ? ( ( ( B.Value()*( WATER.Value()-A.Value() ) )/( B.Value()-A.Value() ) ) ) : ( WATER.Value() ) )  ) ) /dT() ) ) ) ;
			RUNOFF.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::SOILMAP_u21_exe() {
	float value;

	switch( SOILMAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOILMAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)31);
			SOILMAP.Update( p, value );
		}
		SOILMAP.GrabMemory();
		if( SOILMAP.GetF(FLinkEdges) ) { SOILMAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)31);
			SOILMAP.Update( value );
	  } break;
	}
	return 0;
}

int EROSION_module::RAINFALL_u22_exe() {
	float value;

	switch( RAINFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RAINFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph0(TIME.Value());
			RAINFALL.Update( p, value );
		}
		RAINFALL.GrabMemory();
		if( RAINFALL.GetF(FLinkEdges) ) { RAINFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph0(TIME.Value());
			RAINFALL.Update( value );
	  } break;
	}
	return 0;
}

EROSION_module* EROSION_module::fInstance = NULL;
EROSION_module* EROSION_module::kNullModel = (EROSION_module*)0x1;
int EROSION_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int EROSION_module::InitVars() {
	
	TIME.SSInit(this);
	DEPOSITED_SEDIMENT.SSInit(this);
	DEPOSITION.SSInit(this);
	DEPOSITION.SetOrigin(&SUSPENDED_SEDIMENT);
	DEPOSITION.SetDestination(&DEPOSITED_SEDIMENT);
	SUSPENSION.SSInit(this);
	SUSPENSION.SetOrigin(&DEPOSITED_SEDIMENT);
	SUSPENSION.SetDestination(&SUSPENDED_SEDIMENT);
	SUSPENDED_SEDIMENT.SSInit(this);
	SUSPENDED_SEDIMENT.SetLinkEdges();
	WATER.SSInit(this);
	WATER.SetLinkEdges();
	PRECIPITATION.SSInit(this);
	PRECIPITATION.SetDestination(&WATER);
	INFILTRATION.SSInit(this);
	INFILTRATION.SetOrigin(&WATER);
	A.SSInit(this);
	B.SSInit(this);
	C.SSInit(this);
	D.SSInit(this);
	E.SSInit(this);
	ELEVMAP.SSInit(this);
	H.SSInit(this);
	HYDRO.SSInit(this);
	HYDRO.SetLinkEdges();
	K.SSInit(this);
	LINKMAP.SSInit(this);
	RUNOFF.SSInit(this);
	RUNOFF.SetLinkEdges();
	SOILMAP.SSInit(this);
	RAINFALL.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int EROSION_module::SetupEvents() {
	TExecuteCommand* I0 = (TExecuteCommand*) DEPOSITED_SEDIMENT.GetCommand("I0",TCommand::kIntegrate,TCommand::kCode);
	I0->SetExecutable(&DEPOSITED_SEDIMENT_I0_exe_g);
	I0->Code() = "I0 <- ( DEPOSITION-SUSPENSION )";
	I0->AddDependency(DEPOSITION);
	I0->AddDependency(SUSPENSION);
	I0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i1 = (TExecuteCommand*) DEPOSITED_SEDIMENT.GetCommand("i1",TCommand::kInit,TCommand::kCode);
	i1->SetExecutable(&DEPOSITED_SEDIMENT_i1_exe_g);
	i1->Code() = "i1 <- ((float)500)";
	i1->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u2 = (TExecuteCommand*) DEPOSITION.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&DEPOSITION_u2_exe_g);
	u2->Code() = "u2 <- ( K*SUSPENDED_SEDIMENT )";
	if( SUSPENDED_SEDIMENT.GetF(FisClamped) ) { u2->AddDependency(SUSPENDED_SEDIMENT); }
	u2->AddDependency(K);
	u2->AddDependency(SUSPENDED_SEDIMENT);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) SUSPENSION.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&SUSPENSION_u3_exe_g);
	u3->Code() = "u3 <-  ( ( ( RUNOFF <  D ) ) ? ( ((float)0) ) : (  ( ( ( RUNOFF <  E ) ) ? ( ( ( ( C*RUNOFF )/( E-D ) )-( ( C*D )/( E-D ) ) ) ) : ( C ) )  ) ) ";
	if( DEPOSITED_SEDIMENT.GetF(FisClamped) ) { u3->AddDependency(DEPOSITED_SEDIMENT); }
	u3->AddDependency(RUNOFF);
	u3->AddDependency(D);
	u3->AddDependency(E);
	u3->AddDependency(C);
	u3->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I4 = (TExecuteCommand*) SUSPENDED_SEDIMENT.GetCommand("I4",TCommand::kIntegrate,TCommand::kCode);
	I4->SetExecutable(&SUSPENDED_SEDIMENT_I4_exe_g);
	I4->Code() = "I4 <- ( SUSPENSION-DEPOSITION )";
	I4->AddDependency(SUSPENSION);
	I4->AddDependency(DEPOSITION);
	I4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i5 = (TExecuteCommand*) SUSPENDED_SEDIMENT.GetCommand("i5",TCommand::kInit,TCommand::kCode);
	i5->SetExecutable(&SUSPENDED_SEDIMENT_i5_exe_g);
	i5->Code() = "i5 <- ((float)0)";
	i5->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* I6 = (TExecuteCommand*) WATER.GetCommand("I6",TCommand::kIntegrate,TCommand::kCode);
	I6->SetExecutable(&WATER_I6_exe_g);
	I6->Code() = "I6 <- ( PRECIPITATION-INFILTRATION )";
	I6->AddDependency(PRECIPITATION);
	I6->AddDependency(INFILTRATION);
	I6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i7 = (TExecuteCommand*) WATER.GetCommand("i7",TCommand::kInit,TCommand::kCode);
	i7->SetExecutable(&WATER_i7_exe_g);
	i7->Code() = "i7 <-  ( ( ( SOILMAP == ((float)1) ) ) ? ( ((float)3000) ) : ( ((float)1) ) ) ";
	i7->AddDependency(SOILMAP);
	i7->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE23 = (TExecuteCommand*) WATER.GetCommand("vE23",TCommand::kFunction,TCommand::kCode);
	vE23->SetExecutable(&WATER_vE23_exe_g);
	vE23->Code() = "vE23 <- Function";
	vE23->GetFunction() = 'P';
	vE23->AddDependency(WATER);
	vE23->AddDependency(HYDRO);
	vE23->AddDependency(RUNOFF);
	vE23->AddDependency(SUSPENDED_SEDIMENT);
	vE23->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u8 = (TExecuteCommand*) PRECIPITATION.GetCommand("u8",TCommand::kUpdate,TCommand::kCode);
	u8->SetExecutable(&PRECIPITATION_u8_exe_g);
	u8->Code() = "u8 <- RAINFALL";
	u8->AddDependency(RAINFALL);
	u8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u9 = (TExecuteCommand*) INFILTRATION.GetCommand("u9",TCommand::kUpdate,TCommand::kCode);
	u9->SetExecutable(&INFILTRATION_u9_exe_g);
	u9->Code() = "u9 <-  ( ( ( SOILMAP == ((float)1) ) ) ? ( ((float)0) ) : (  ( ( ( SOILMAP == ((float)31) ) ) ? ( SL::Min(( WATER/dT() ), ((float)1)) ) : (  ( ( ( SOILMAP == ((float)11) ) ) ? ( SL::Min(( WATER/dT() ), ((float)20)) ) : ( SL::Min(( WATER/dT() ), ((float)100)) ) )  ) )  ) ) ";
	if( WATER.GetF(FisClamped) ) { u9->AddDependency(WATER); }
	u9->AddDependency(SOILMAP);
	u9->AddDependency(WATER);
	u9->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u10 = (TExecuteCommand*) A.GetCommand("u10",TCommand::kUpdate,TCommand::kCode);
	u10->SetExecutable(&A_u10_exe_g);
	u10->Code() = "u10 <- 2";
	u10->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u11 = (TExecuteCommand*) B.GetCommand("u11",TCommand::kUpdate,TCommand::kCode);
	u11->SetExecutable(&B_u11_exe_g);
	u11->Code() = "u11 <- 10";
	u11->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u12 = (TExecuteCommand*) C.GetCommand("u12",TCommand::kUpdate,TCommand::kCode);
	u12->SetExecutable(&C_u12_exe_g);
	u12->Code() = "u12 <- 1";
	u12->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u13 = (TExecuteCommand*) D.GetCommand("u13",TCommand::kUpdate,TCommand::kCode);
	u13->SetExecutable(&D_u13_exe_g);
	u13->Code() = "u13 <- 2";
	u13->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u14 = (TExecuteCommand*) E.GetCommand("u14",TCommand::kUpdate,TCommand::kCode);
	u14->SetExecutable(&E_u14_exe_g);
	u14->Code() = "u14 <- 20";
	u14->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u15 = (TExecuteCommand*) ELEVMAP.GetCommand("u15",TCommand::kUpdate,TCommand::kCode);
	u15->SetExecutable(&ELEVMAP_u15_exe_g);
	u15->Code() = "u15 <- ((float)1)";
	u15->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u16 = (TExecuteCommand*) H.GetCommand("u16",TCommand::kUpdate,TCommand::kCode);
	u16->SetExecutable(&H_u16_exe_g);
	u16->Code() = "u16 <- 4000";
	u16->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u17 = (TExecuteCommand*) HYDRO.GetCommand("u17",TCommand::kUpdate,TCommand::kCode);
	u17->SetExecutable(&HYDRO_u17_exe_g);
	u17->Code() = "u17 <- ((float)1)";
	u17->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u18 = (TExecuteCommand*) K.GetCommand("u18",TCommand::kUpdate,TCommand::kCode);
	u18->SetExecutable(&K_u18_exe_g);
	u18->Code() = "u18 <- 0.200000";
	u18->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u19 = (TExecuteCommand*) LINKMAP.GetCommand("u19",TCommand::kUpdate,TCommand::kCode);
	u19->SetExecutable(&LINKMAP_u19_exe_g);
	u19->Code() = "u19 <- ((float)1)";
	u19->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u20 = (TExecuteCommand*) RUNOFF.GetCommand("u20",TCommand::kUpdate,TCommand::kCode);
	u20->SetExecutable(&RUNOFF_u20_exe_g);
	u20->Code() = "u20 <-  ( ( ( SOILMAP == ((float)1) ) ) ? ( SL::Max(((float)0), ( WATER-H )) ) : ( (  ( ( ( WATER <  A ) ) ? ( ((float)0) ) : (  ( ( ( WATER <  B ) ) ? ( ( ( B*( WATER-A ) )/( B-A ) ) ) : ( WATER ) )  ) ) /dT() ) ) ) ";
	u20->AddDependency(SOILMAP);
	u20->AddDependency(WATER);
	u20->AddDependency(H);
	u20->AddDependency(A);
	u20->AddDependency(B);
	u20->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u21 = (TExecuteCommand*) SOILMAP.GetCommand("u21",TCommand::kUpdate,TCommand::kCode);
	u21->SetExecutable(&SOILMAP_u21_exe_g);
	u21->Code() = "u21 <- ((float)31)";
	u21->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u22 = (TExecuteCommand*) RAINFALL.GetCommand("u22",TCommand::kUpdate,TCommand::kCode);
	u22->SetExecutable(&RAINFALL_u22_exe_g);
	u22->Code() = "u22 <- Graph0(TIME)";
	u22->AddDependency(TIME);
	u22->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int EROSION_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int EROSION_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int EROSION_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int EROSION_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS0_module 
// ---------------------------------------------------------------------------
XXXIMPORTS0_module::XXXIMPORTS0_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
XXXIMPORTS0_module* XXXIMPORTS0_module::fInstance = NULL;
XXXIMPORTS0_module* XXXIMPORTS0_module::kNullModel = (XXXIMPORTS0_module*)0x1;
int XXXIMPORTS0_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int XXXIMPORTS0_module::InitVars() {
	
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int XXXIMPORTS0_module::SetupEvents() {
	return 0;
}

int XXXIMPORTS0_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int XXXIMPORTS0_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int XXXIMPORTS0_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int XXXIMPORTS0_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}
