#ifndef __ModelEqns__
#define __ModelEqns__

#include "SpaceSim.h"
#include "SWater1.h"

// ---------------------------------------------------------------------------
//                    Class Erosion_module 
// ---------------------------------------------------------------------------

int kA__Wildcard = -99;

class Erosion_module : public TModule {
protected:

	Erosion_module(char* name);

public:

	TTime TIME;
protected:

	static Erosion_module* fInstance;
	static Erosion_module* kNullModel;
public:
	inline static Erosion_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new Erosion_module("Erosion_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (Erosion_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize();
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit();
};


// ---------------------------------------------------------------------------
//                    Class EROSION_module 
// ---------------------------------------------------------------------------

class EROSION_module : public TModule {
protected:

	EROSION_module(char* name);

public:

	TTime TIME;
	CStateVariable DEPOSITED_SEDIMENT;
	CFluxVariable DEPOSITION;
	CFluxVariable SUSPENSION;
	CStateVariable SUSPENDED_SEDIMENT;
	CStateVariable WATER;
	CFluxVariable PRECIPITATION;
	CFluxVariable INFILTRATION;
	CAuxVariable A;
	CAuxVariable B;
	CAuxVariable C;
	CAuxVariable D;
	CAuxVariable E;
	CAuxVariable ELEVMAP;
	CAuxVariable H;
	CAuxVariable HYDRO;
	CAuxVariable K;
	CAuxVariable LINKMAP;
	CAuxVariable RUNOFF;
	CAuxVariable SOILMAP;
	CAuxVariable RAINFALL;
protected:

	int DEPOSITED_SEDIMENT_I0_exe();
	friend int DEPOSITED_SEDIMENT_I0_exe_g( Variable* v );
	int DEPOSITED_SEDIMENT_i1_exe();
	friend int DEPOSITED_SEDIMENT_i1_exe_g( Variable* v );
	int DEPOSITION_u2_exe();
	friend int DEPOSITION_u2_exe_g( Variable* v );
	int SUSPENSION_u3_exe();
	friend int SUSPENSION_u3_exe_g( Variable* v );
	int SUSPENDED_SEDIMENT_I4_exe();
	friend int SUSPENDED_SEDIMENT_I4_exe_g( Variable* v );
	int SUSPENDED_SEDIMENT_i5_exe();
	friend int SUSPENDED_SEDIMENT_i5_exe_g( Variable* v );
	int WATER_I6_exe();
	friend int WATER_I6_exe_g( Variable* v );
	int WATER_i7_exe();
	friend int WATER_i7_exe_g( Variable* v );
	int WATER_vE23_exe();
	friend int WATER_vE23_exe_g( Variable* v );
	int PRECIPITATION_u8_exe();
	friend int PRECIPITATION_u8_exe_g( Variable* v );
	int INFILTRATION_u9_exe();
	friend int INFILTRATION_u9_exe_g( Variable* v );
	int A_u10_exe();
	friend int A_u10_exe_g( Variable* v );
	int B_u11_exe();
	friend int B_u11_exe_g( Variable* v );
	int C_u12_exe();
	friend int C_u12_exe_g( Variable* v );
	int D_u13_exe();
	friend int D_u13_exe_g( Variable* v );
	int E_u14_exe();
	friend int E_u14_exe_g( Variable* v );
	int ELEVMAP_u15_exe();
	friend int ELEVMAP_u15_exe_g( Variable* v );
	int H_u16_exe();
	friend int H_u16_exe_g( Variable* v );
	int HYDRO_u17_exe();
	friend int HYDRO_u17_exe_g( Variable* v );
	int K_u18_exe();
	friend int K_u18_exe_g( Variable* v );
	int LINKMAP_u19_exe();
	friend int LINKMAP_u19_exe_g( Variable* v );
	int RUNOFF_u20_exe();
	friend int RUNOFF_u20_exe_g( Variable* v );
	int SOILMAP_u21_exe();
	friend int SOILMAP_u21_exe_g( Variable* v );
	int RAINFALL_u22_exe();
	friend int RAINFALL_u22_exe_g( Variable* v );
	static EROSION_module* fInstance;
	static EROSION_module* kNullModel;
public:
	inline static EROSION_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new EROSION_module("EROSION_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (EROSION_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph0(double x) { 
		static double g[365][2] = {
			{ 0.0000E+00, 4.550000E+00},{ 1.0000E+00, -6.370000E+00},{ 2.0100E+00, -6.370000E+00},{ 3.0100E+00, -6.370000E+00},
			{ 4.0100E+00, -6.370000E+00},{ 5.0100E+00, -6.370000E+00},{ 6.0200E+00, -6.220000E+00},{ 7.0200E+00, -6.370000E+00},
			{ 8.0200E+00, -6.370000E+00},{ 9.0200E+00, -6.370000E+00},{ 1.0000E+01, -6.370000E+00},{ 1.1000E+01, -1.330000E+00},
			{ 1.2000E+01, -5.780000E+00},{ 1.3000E+01, 3.310000E+01},{ 1.4000E+01, -6.370000E+00},{ 1.5000E+01, -6.370000E+00},
			{ 1.6000E+01, -6.370000E+00},{ 1.7000E+01, -6.370000E+00},{ 1.8000E+01, -5.570000E+00},{ 1.9100E+01, -6.340000E+00},
			{ 2.0100E+01, 8.810000E+00},{ 2.1100E+01, -6.120000E+00},{ 2.2100E+01, -6.370000E+00},{ 2.3100E+01, -6.370000E+00},
			{ 2.4100E+01, -6.370000E+00},{ 2.5100E+01, -6.370000E+00},{ 2.6100E+01, -6.370000E+00},{ 2.7100E+01, 5.100000E+01},
			{ 2.8100E+01, 4.550000E+01},{ 2.9100E+01, 9.830000E+00},{ 3.0100E+01, -5.470000E+00},{ 3.1100E+01, -3.860000E+00},
			{ 3.2100E+01, -4.560000E+00},{ 3.3100E+01, -3.530000E-01},{ 3.4100E+01, -5.020000E+00},{ 3.5100E+01, -5.470000E+00},
			{ 3.6100E+01, -5.160000E+00},{ 3.7100E+01, -5.470000E+00},{ 3.8100E+01, -1.050000E+00},{ 3.9100E+01, -4.280000E+00},
			{ 4.0100E+01, -3.010000E+00},{ 4.1100E+01, -5.470000E+00},{ 4.2100E+01, -5.470000E+00},{ 4.3100E+01, -5.460000E+00},
			{ 4.4100E+01, -5.470000E+00},{ 4.5100E+01, -5.470000E+00},{ 4.6100E+01, -5.470000E+00},{ 4.7100E+01, -4.410000E+00},
			{ 4.8100E+01, -5.470000E+00},{ 4.9100E+01, -5.470000E+00},{ 5.0100E+01, 3.520000E+00},{ 5.1100E+01, -4.820000E+00},
			{ 5.2100E+01, 2.690000E+01},{ 5.3100E+01, 1.420000E+01},{ 5.4100E+01, 2.850000E+00},{ 5.5200E+01, -7.150000E-01},
			{ 5.6200E+01, 4.270000E+01},{ 5.7200E+01, -5.470000E+00},{ 5.8200E+01, -3.470000E+00},{ 5.9200E+01, -2.630000E+00},
			{ 6.0200E+01, -4.990000E+00},{ 6.1200E+01, -4.990000E+00},{ 6.2200E+01, -4.990000E+00},{ 6.3200E+01, -4.990000E+00},
			{ 6.4200E+01, 2.960000E+00},{ 6.5200E+01, -4.990000E+00},{ 6.6200E+01, 2.410000E+00},{ 6.7200E+01, -4.990000E+00},
			{ 6.8200E+01, -4.990000E+00},{ 6.9200E+01, 5.450000E+00},{ 7.0200E+01, -4.990000E+00},{ 7.1200E+01, -4.990000E+00},
			{ 7.2200E+01, -4.990000E+00},{ 7.3200E+01, 2.700000E+01},{ 7.4200E+01, -4.980000E+00},{ 7.5200E+01, -4.980000E+00},
			{ 7.6200E+01, -4.340000E+00},{ 7.7200E+01, -4.990000E+00},{ 7.8200E+01, -4.990000E+00},{ 7.9200E+01, 1.930000E+01},
			{ 8.0200E+01, 1.850000E+01},{ 8.1200E+01, -3.850000E+00},{ 8.2200E+01, -4.990000E+00},{ 8.3200E+01, -4.990000E+00},
			{ 8.4200E+01, -4.990000E+00},{ 8.5200E+01, -4.990000E+00},{ 8.6200E+01, -4.980000E+00},{ 8.7200E+01, -4.670000E+00},
			{ 8.8200E+01, 3.280000E+01},{ 8.9200E+01, -3.690000E+00},{ 9.0200E+01, -3.690000E+00},{ 9.1300E+01, -3.690000E+00},
			{ 9.2300E+01, -3.690000E+00},{ 9.3300E+01, -3.690000E+00},{ 9.4300E+01, -3.690000E+00},{ 9.5300E+01, -3.690000E+00},
			{ 9.6300E+01, -3.690000E+00},{ 9.7300E+01, 3.100000E-02},{ 9.8300E+01, -3.690000E+00},{ 9.9300E+01, -3.050000E+00},
			{ 1.0000E+02, -3.690000E+00},{ 1.0100E+02, -3.690000E+00},{ 1.0200E+02, -3.690000E+00},{ 1.0300E+02, 9.280000E-01},
			{ 1.0400E+02, -3.690000E+00},{ 1.0500E+02, 4.170000E+00},{ 1.0600E+02, -2.640000E+00},{ 1.0700E+02, -2.100000E+00},
			{ 1.0800E+02, 2.030000E+00},{ 1.0900E+02, 1.280000E+01},{ 1.1000E+02, 4.230000E+00},{ 1.1100E+02, -8.070000E-01},
			{ 1.1200E+02, -3.650000E+00},{ 1.1300E+02, -3.690000E+00},{ 1.1400E+02, -3.690000E+00},{ 1.1500E+02, -3.690000E+00},
			{ 1.1600E+02, -3.690000E+00},{ 1.1700E+02, -3.690000E+00},{ 1.1800E+02, -3.690000E+00},{ 1.1900E+02, -2.460000E+00},
			{ 1.2000E+02, -2.460000E+00},{ 1.2100E+02, -2.460000E+00},{ 1.2200E+02, -2.460000E+00},{ 1.2300E+02, -2.460000E+00},
			{ 1.2400E+02, -2.460000E+00},{ 1.2500E+02, -2.460000E+00},{ 1.2600E+02, -2.460000E+00},{ 1.2700E+02, -2.460000E+00},
			{ 1.2800E+02, -2.460000E+00},{ 1.2900E+02, -2.460000E+00},{ 1.3000E+02, -2.460000E+00},{ 1.3100E+02, -2.460000E+00},
			{ 1.3200E+02, -2.460000E+00},{ 1.3300E+02, -2.200000E+00},{ 1.3400E+02, -2.460000E+00},{ 1.3500E+02, -2.460000E+00},
			{ 1.3600E+02, 5.980000E-01},{ 1.3700E+02, -2.460000E+00},{ 1.3800E+02, -2.460000E+00},{ 1.3900E+02, -2.460000E+00},
			{ 1.4000E+02, -2.460000E+00},{ 1.4100E+02, -2.460000E+00},{ 1.4200E+02, -2.460000E+00},{ 1.4300E+02, -2.460000E+00},
			{ 1.4400E+02, -2.460000E+00},{ 1.4500E+02, -2.460000E+00},{ 1.4600E+02, -2.460000E+00},{ 1.4700E+02, -2.460000E+00},
			{ 1.4800E+02, -2.460000E+00},{ 1.4900E+02, 1.170000E-01},{ 1.5000E+02, 2.210000E+00},{ 1.5100E+02, -2.170000E+00},
			{ 1.5200E+02, -2.170000E+00},{ 1.5300E+02, -2.170000E+00},{ 1.5400E+02, -2.170000E+00},{ 1.5500E+02, -2.170000E+00},
			{ 1.5600E+02, -2.170000E+00},{ 1.5700E+02, -2.170000E+00},{ 1.5800E+02, -2.170000E+00},{ 1.5900E+02, -5.550000E-01},
			{ 1.6000E+02, -2.020000E+00},{ 1.6100E+02, -2.170000E+00},{ 1.6200E+02, -2.170000E+00},{ 1.6300E+02, -2.170000E+00},
			{ 1.6400E+02, -2.170000E+00},{ 1.6500E+02, -2.170000E+00},{ 1.6600E+02, -2.170000E+00},{ 1.6700E+02, -2.170000E+00},
			{ 1.6800E+02, -2.170000E+00},{ 1.6900E+02, -2.170000E+00},{ 1.7000E+02, -2.170000E+00},{ 1.7100E+02, -2.170000E+00},
			{ 1.7200E+02, 1.020000E+01},{ 1.7300E+02, -2.170000E+00},{ 1.7400E+02, -2.170000E+00},{ 1.7500E+02, -2.170000E+00},
			{ 1.7600E+02, -2.170000E+00},{ 1.7700E+02, -2.170000E+00},{ 1.7800E+02, -2.170000E+00},{ 1.7900E+02, -2.170000E+00},
			{ 1.8000E+02, -2.160000E+00},{ 1.8100E+02, -2.160000E+00},{ 1.8200E+02, -2.160000E+00},{ 1.8400E+02, -2.160000E+00},
			{ 1.8500E+02, -2.160000E+00},{ 1.8600E+02, -2.160000E+00},{ 1.8700E+02, -2.160000E+00},{ 1.8800E+02, -1.590000E+00},
			{ 1.8900E+02, 5.470000E+00},{ 1.9000E+02, -1.330000E+00},{ 1.9100E+02, -2.160000E+00},{ 1.9200E+02, -2.160000E+00},
			{ 1.9300E+02, -2.160000E+00},{ 1.9400E+02, -2.160000E+00},{ 1.9500E+02, -2.160000E+00},{ 1.9600E+02, -2.160000E+00},
			{ 1.9700E+02, -2.160000E+00},{ 1.9800E+02, -2.160000E+00},{ 1.9900E+02, 1.040000E+00},{ 2.0000E+02, 1.410000E+00},
			{ 2.0100E+02, -2.160000E+00},{ 2.0200E+02, -2.160000E+00},{ 2.0300E+02, -2.160000E+00},{ 2.0400E+02, -2.160000E+00},
			{ 2.0500E+02, -2.160000E+00},{ 2.0600E+02, -2.160000E+00},{ 2.0700E+02, -2.160000E+00},{ 2.0800E+02, -2.160000E+00},
			{ 2.0900E+02, -2.160000E+00},{ 2.1000E+02, -2.160000E+00},{ 2.1100E+02, -2.150000E+00},{ 2.1200E+02, -2.760000E+00},
			{ 2.1300E+02, -2.760000E+00},{ 2.1400E+02, -2.760000E+00},{ 2.1500E+02, -2.760000E+00},{ 2.1600E+02, -2.760000E+00},
			{ 2.1700E+02, -2.760000E+00},{ 2.1800E+02, -2.760000E+00},{ 2.1900E+02, -2.760000E+00},{ 2.2000E+02, -2.750000E+00},
			{ 2.2100E+02, 2.910000E+00},{ 2.2200E+02, -2.760000E+00},{ 2.2300E+02, -6.780000E-01},{ 2.2400E+02, -2.260000E+00},
			{ 2.2500E+02, -2.760000E+00},{ 2.2600E+02, -2.760000E+00},{ 2.2700E+02, -2.760000E+00},{ 2.2800E+02, -2.760000E+00},
			{ 2.2900E+02, -2.760000E+00},{ 2.3000E+02, -2.760000E+00},{ 2.3100E+02, -2.760000E+00},{ 2.3200E+02, -2.760000E+00},
			{ 2.3300E+02, -2.760000E+00},{ 2.3400E+02, -2.750000E+00},{ 2.3500E+02, 1.280000E+00},{ 2.3600E+02, -2.760000E+00},
			{ 2.3700E+02, -2.760000E+00},{ 2.3800E+02, -2.760000E+00},{ 2.3900E+02, -2.760000E+00},{ 2.4000E+02, -2.760000E+00},
			{ 2.4100E+02, -2.760000E+00},{ 2.4200E+02, -2.760000E+00},{ 2.4300E+02, -3.780000E+00},{ 2.4400E+02, -3.780000E+00},
			{ 2.4500E+02, -3.780000E+00},{ 2.4600E+02, -3.780000E+00},{ 2.4700E+02, -3.780000E+00},{ 2.4800E+02, -3.780000E+00},
			{ 2.4900E+02, -3.780000E+00},{ 2.5000E+02, -3.780000E+00},{ 2.5100E+02, -3.780000E+00},{ 2.5200E+02, -1.620000E+00},
			{ 2.5300E+02, -3.780000E+00},{ 2.5400E+02, -3.780000E+00},{ 2.5500E+02, -3.780000E+00},{ 2.5600E+02, -3.780000E+00},
			{ 2.5700E+02, -3.780000E+00},{ 2.5800E+02, 4.170000E+00},{ 2.5900E+02, -3.780000E+00},{ 2.6000E+02, -3.780000E+00},
			{ 2.6100E+02, -3.780000E+00},{ 2.6200E+02, -3.780000E+00},{ 2.6300E+02, -3.770000E+00},{ 2.6400E+02, 2.310000E+00},
			{ 2.6500E+02, 2.790000E+00},{ 2.6600E+02, -3.780000E+00},{ 2.6700E+02, -9.480000E-01},{ 2.6800E+02, -3.780000E+00},
			{ 2.6900E+02, -1.790000E+00},{ 2.7000E+02, 1.250000E+01},{ 2.7100E+02, -3.530000E+00},{ 2.7200E+02, -3.780000E+00},
			{ 2.7300E+02, -4.860000E+00},{ 2.7400E+02, -4.860000E+00},{ 2.7500E+02, -4.860000E+00},{ 2.7600E+02, -4.860000E+00},
			{ 2.7700E+02, -4.860000E+00},{ 2.7800E+02, -4.860000E+00},{ 2.7900E+02, -4.860000E+00},{ 2.8000E+02, -4.860000E+00},
			{ 2.8100E+02, -4.860000E+00},{ 2.8200E+02, -4.860000E+00},{ 2.8300E+02, -4.860000E+00},{ 2.8400E+02, 8.300000E+00},
			{ 2.8500E+02, 1.250000E+01},{ 2.8600E+02, -4.860000E+00},{ 2.8700E+02, -4.860000E+00},{ 2.8800E+02, -4.860000E+00},
			{ 2.8900E+02, -4.860000E+00},{ 2.9000E+02, -4.860000E+00},{ 2.9100E+02, -4.860000E+00},{ 2.9200E+02, -4.860000E+00},
			{ 2.9300E+02, 7.460000E+00},{ 2.9400E+02, -4.860000E+00},{ 2.9500E+02, 3.470000E+00},{ 2.9600E+02, 4.070000E+01},
			{ 2.9700E+02, -1.080000E+00},{ 2.9800E+02, 6.780000E+01},{ 2.9900E+02, -4.860000E+00},{ 3.0000E+02, -4.860000E+00},
			{ 3.0100E+02, -4.860000E+00},{ 3.0200E+02, 1.530000E+01},{ 3.0300E+02, -4.860000E+00},{ 3.0400E+02, -5.900000E+00},
			{ 3.0500E+02, -5.900000E+00},{ 3.0600E+02, -5.900000E+00},{ 3.0700E+02, -4.390000E+00},{ 3.0800E+02, -4.660000E+00},
			{ 3.0900E+02, -5.900000E+00},{ 3.1000E+02, 8.690000E+00},{ 3.1100E+02, -5.600000E+00},{ 3.1200E+02, 6.570000E+01},
			{ 3.1300E+02, -5.570000E+00},{ 3.1400E+02, -5.900000E+00},{ 3.1500E+02, -2.930000E+00},{ 3.1600E+02, -4.720000E+00},
			{ 3.1700E+02, -5.900000E+00},{ 3.1800E+02, 8.630000E-01},{ 3.1900E+02, 5.460000E-01},{ 3.2000E+02, -5.900000E+00},
			{ 3.2100E+02, 2.000000E-03},{ 3.2200E+02, -5.530000E-01},{ 3.2300E+02, -5.900000E+00},{ 3.2400E+02, 8.130000E+00},
			{ 3.2500E+02, -5.880000E+00},{ 3.2600E+02, 6.430000E+00},{ 3.2700E+02, -3.540000E+00},{ 3.2800E+02, -5.900000E+00},
			{ 3.2900E+02, -5.900000E+00},{ 3.3000E+02, 8.680000E+00},{ 3.3100E+02, -5.900000E+00},{ 3.3200E+02, -5.900000E+00},
			{ 3.3300E+02, -4.780000E+00},{ 3.3400E+02, -2.980000E+00},{ 3.3500E+02, -5.640000E+00},{ 3.3600E+02, -5.380000E+00},
			{ 3.3700E+02, 7.240000E+00},{ 3.3800E+02, 1.550000E+01},{ 3.3900E+02, -6.520000E+00},{ 3.4000E+02, 5.310000E+01},
			{ 3.4100E+02, 1.070000E+02},{ 3.4200E+02, 3.170000E+01},{ 3.4300E+02, 8.280000E+01},{ 3.4400E+02, -6.410000E+00},
			{ 3.4500E+02, -6.550000E+00},{ 3.4600E+02, -6.550000E+00},{ 3.4700E+02, -6.550000E+00},{ 3.4800E+02, -6.550000E+00},
			{ 3.4900E+02, -5.660000E+00},{ 3.5000E+02, -5.290000E+00},{ 3.5100E+02, -6.550000E+00},{ 3.5200E+02, -6.550000E+00},
			{ 3.5300E+02, -6.550000E+00},{ 3.5400E+02, -5.920000E+00},{ 3.5500E+02, -4.570000E+00},{ 3.5600E+02, 1.630000E+01},
			{ 3.5700E+02, 5.140000E+01},{ 3.5800E+02, -6.420000E+00},{ 3.5900E+02, -5.910000E+00},{ 3.6000E+02, -6.260000E+00},
			{ 3.6100E+02, 6.720000E+00},{ 3.6200E+02, 2.840000E+01},{ 3.6300E+02, 1.400000E+01},{ 3.6400E+02, -6.300000E+00},
			{ 3.6500E+02, -5.970000E+00}, };
		return SL::Graph( 0, x, 364, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DEPOSITED_SEDIMENT_I0_exe_g(Variable* obj) { return EROSION_module::I().DEPOSITED_SEDIMENT_I0_exe(); }
int DEPOSITED_SEDIMENT_i1_exe_g(Variable* obj) { return EROSION_module::I().DEPOSITED_SEDIMENT_i1_exe(); }
int DEPOSITION_u2_exe_g(Variable* obj) { return EROSION_module::I().DEPOSITION_u2_exe(); }
int SUSPENSION_u3_exe_g(Variable* obj) { return EROSION_module::I().SUSPENSION_u3_exe(); }
int SUSPENDED_SEDIMENT_I4_exe_g(Variable* obj) { return EROSION_module::I().SUSPENDED_SEDIMENT_I4_exe(); }
int SUSPENDED_SEDIMENT_i5_exe_g(Variable* obj) { return EROSION_module::I().SUSPENDED_SEDIMENT_i5_exe(); }
int WATER_I6_exe_g(Variable* obj) { return EROSION_module::I().WATER_I6_exe(); }
int WATER_i7_exe_g(Variable* obj) { return EROSION_module::I().WATER_i7_exe(); }
int WATER_vE23_exe_g(Variable* obj) { return EROSION_module::I().WATER_vE23_exe(); }
int PRECIPITATION_u8_exe_g(Variable* obj) { return EROSION_module::I().PRECIPITATION_u8_exe(); }
int INFILTRATION_u9_exe_g(Variable* obj) { return EROSION_module::I().INFILTRATION_u9_exe(); }
int A_u10_exe_g(Variable* obj) { return EROSION_module::I().A_u10_exe(); }
int B_u11_exe_g(Variable* obj) { return EROSION_module::I().B_u11_exe(); }
int C_u12_exe_g(Variable* obj) { return EROSION_module::I().C_u12_exe(); }
int D_u13_exe_g(Variable* obj) { return EROSION_module::I().D_u13_exe(); }
int E_u14_exe_g(Variable* obj) { return EROSION_module::I().E_u14_exe(); }
int ELEVMAP_u15_exe_g(Variable* obj) { return EROSION_module::I().ELEVMAP_u15_exe(); }
int H_u16_exe_g(Variable* obj) { return EROSION_module::I().H_u16_exe(); }
int HYDRO_u17_exe_g(Variable* obj) { return EROSION_module::I().HYDRO_u17_exe(); }
int K_u18_exe_g(Variable* obj) { return EROSION_module::I().K_u18_exe(); }
int LINKMAP_u19_exe_g(Variable* obj) { return EROSION_module::I().LINKMAP_u19_exe(); }
int RUNOFF_u20_exe_g(Variable* obj) { return EROSION_module::I().RUNOFF_u20_exe(); }
int SOILMAP_u21_exe_g(Variable* obj) { return EROSION_module::I().SOILMAP_u21_exe(); }
int RAINFALL_u22_exe_g(Variable* obj) { return EROSION_module::I().RAINFALL_u22_exe(); }
// ---------------------------------------------------------------------------
//                    Class XXXIMPORTS0_module 
// ---------------------------------------------------------------------------

class XXXIMPORTS0_module : public TModule {
protected:

	XXXIMPORTS0_module(char* name);

public:

	TTime TIME;
protected:

	static XXXIMPORTS0_module* fInstance;
	static XXXIMPORTS0_module* kNullModel;
public:
	inline static XXXIMPORTS0_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new XXXIMPORTS0_module("XXXIMPORTS0_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (XXXIMPORTS0_module&) *fInstance;
	}

	virtual int InitVars();
	virtual int InitArrays();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};



#endif
