/* multiple utilities for I/O etc of ELM */
#include "../Driver_Sources/globals.h" 

float *plot_array, gTS;
int gNPtTs;
char mapFileName[300];
int PListIndex=0;
int total_memory=0;
int TR(int i, int j, int index);

ViewParm *read_output_parms(void); /*jan99 */
static 	ViewParm *readOutlist(int size); /*jan99 */
static	int     readViewParms(FILE *vpFileName, int size, ViewParm **ppview); /*jan99 */

#if NeedFunctionPrototypes
int readViewParmsOLD(char* filename, int size); /*jan99*/
int isFloat (char *target_str) ;
int isInteger (char *target_str) ;
void print_point(ViewParm *vp, void* Map, char Mtype, char* mName, int tIndex, int vpindex) ;
#else
int readViewParmsOLD(); /*jan99*/
int isFloat ();
int isInteger ();
void print_point();
#endif

#if NeedFunctionPrototypes

int iclip ( int x0, int min, int max );
int check_for (char *s0, char *s1, int start, int  cs, int rp);

#else

int iclip ( );
int check_for ();

#endif


#if NeedFunctionPrototypes
VOIDP nalloc( unsigned mem_size, char var_name[50] )
#else
     VOIDP nalloc( mem_size, var_name )
     unsigned mem_size;
     char var_name[50];
#endif
{
  VOIDP rp;
  
  if(mem_size == 0) return(NULL);	
  rp = (VOIDP) malloc( mem_size );
  total_memory += mem_size;
  fasync(stderr);
  if( rp == NULL ) { fprintf(stderr,"Sorry, out of memory(%d): %s\n",mem_size,var_name); Exit(0); }
  fmulti(stderr);
  return(rp);
}	

#if NeedFunctionPrototypes
void link_edges(VOIDP Map, unsigned char Mtype) 
#else
     void link_edges(Map,Mtype)
     VOIDP Map; unsigned char Mtype;
#endif
{
  switch(Mtype) {
  case 'f' :	
    exchange_borders((byte*)Map,sizeof(float)); break;
  case 'd' : case 'i' :	
    exchange_borders((byte*)Map,sizeof(int)); break;
  case 'c' :	
    exchange_borders((byte*)Map,sizeof(UCHAR)); break;
  }	
}

char* name_from_path(name)
char* name;
{
  char* namePtr; int i, slen;
  char dirCh;
  
  namePtr = name;
  if(H_OPSYS==UNIX) dirCh = '/';
  else dirCh = ':';
  slen = strlen(name);
  
  for(i=0; i<slen; i++) {
  	if( name[slen-i-1] == dirCh ) { namePtr = name+slen-i; break; }
  }
  return namePtr;  
}

#if NeedFunctionPrototypes
void quick_look(void * Map, char *name, unsigned char Mtype, int xc, int yc, int range, unsigned char format)
#else
     void quick_look( Map, name, Mtype, xc, yc, range, format )
     void * Map;
     unsigned char name[50], Mtype;
     int xc, yc, range;
	 byte format;
#endif
{
  int ymin, ymax, xmin, xmax, x, y, N0, N1;
  char* namePtr;

  if (!on_this_proc(xc,yc)) return;
  x = xc - lcl_start[0] + 1;
  y = yc - lcl_start[1] + 1;
  xmin = x - range;
  xmax = x + range + 1;
  ymin = y - range;
  ymax = y + range + 1;
  xmax = iclip( xmax, 0, s0+2);
  xmin = iclip( xmin, 0, s0+2);
  ymax = iclip( ymax, 0, s1+2);
  ymin = iclip( ymin, 0, s1+2);
  N0 = xmax-xmin;
  N1 = ymax-ymin;
  namePtr = name_from_path(name);
  if (debug >3) {sprintf(msgStr,"Window to Map %s, s=%d, proc0 = %d, proc1 = %d; Corners(gbl): (%d,%d) (%d,%d)\n",namePtr,range,recpnum[0],recpnum[1],xc-range,yc-range,xc+range+1,yc+range+1);
  writeWindow(Map,namePtr,msgStr,xmin,ymin,N0,N1,istep,Mtype,format);
  }
  
}

/*jan99*/
ViewParm *
read_output_parms() {
    return readOutlist(332);
} 
/* now 332, was  ELM 323, fau 305 */


/*jan99*/
static ViewParm *
readOutlist(int size)
{
  int i, j, Npt;
  ViewParm* vp;
  FILE   *cnfgFile;
  
  if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/RunParms/Model.outList",ModelPath,ProjName);
  else sprintf(mapFileName,"%s%s:RunParms:Model.outList",ModelPath,ProjName);
  cnfgFile = fopen(mapFileName, "r");
  if (cnfgFile == NULL) {
      sprintf(msgStr, "Error, can't open file %s", mapFileName);
      WriteMsg(msgStr, 1); exit(-1);}
  
  Npt = readViewParms(cnfgFile,size, &vp);
  fclose(cnfgFile);
  return vp;

}

#if NeedFunctionPrototypes
void readOutlistOLD(int size)
#else
void readOutlistOLD(size)
int size;
#endif
{
  int i, j, Npt;
  ViewParm* vp;
  
  if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/RunParms/Model.outList",ModelPath,ProjName);
  else sprintf(mapFileName,"%s%s:RunParms:Model.outList",ModelPath,ProjName);
  
  Npt = readViewParmsOLD(mapFileName,size);
  for(i=0; i<Npt; i++) {
    vp = view+i;
    if(debug ) { 
		sprintf(msgStr,"\n%d: step: %d %s Npts: %d type: %c size: %d  ",i,vp->step,vp->fileName, vp->nPoints, vp->mapType, getPrecision(vp) ); 
		WriteMsg(msgStr,1); 
	}
    if( getFlag(vp,ISARRAY) ) {
      if(debug ) { 
			for(j=0; j<(vp->nPoints); j++) { sprintf(msgStr," [ type: %c loc:(%d,%d,%d) ]",vp->points[j].type,vp->points[j].x,vp->points[j].y,vp->points[j].y); WriteMsg(msgStr,1); }
      }
    }
  }
}

#if NeedFunctionPrototypes
void make_more_points(ViewParm *vp, int ptIncr)
#else
void make_more_points(vp,ptIncr)
ViewParm *vp;
int ptIncr;
#endif
{
	Point3D *new_pts;
	int i;
	
	new_pts = (Point3D *) malloc( (vp->maxPoints+ptIncr) * sizeof(Point3D) );
	for(i=0; i < vp->maxPoints; i++) {
		new_pts[i].x = vp->points[i].x;
		new_pts[i].y = vp->points[i].y;
		new_pts[i].z = vp->points[i].z;
		new_pts[i].type = vp->points[i].type;
	}
	if( vp->points != NULL ) { free((char*)vp->points); }
	vp->points = new_pts;
	vp->maxPoints += ptIncr;
	if(debug) {
		sprintf(msgStr,"Made %d more points for %s for %d total points",ptIncr,vp->fileName,vp->maxPoints); 
		WriteMsg(msgStr,1);
	}
}
	

static int 	
readViewParms(FILE *vpFile, int size, ViewParm **ppview)
{
  char test;
  char cmd;
  int index=0, ix, iy, iz, go=1, i, nArgs, precision, format=0, Ocmd;
  float x,y;
  ViewParm *vp, *view;

    format = init_config_file(vpFile, '#', '*', '@', '~');
    view = (ViewParm *)nalloc(size * sizeof(ViewParm), "view");
    *ppview = view;
  
    for (i = 0; i < size; i++) {
        
	vp = view+i;
	vp->scale.s = 1.0;
        vp->scale.o = 0.0;
	vp->step = 0;
        Ocmd=0;
	vp->nPoints = 0;
	vp->points = NULL;
	vp->maxPoints = 0;
	vp->mapType = 'N';
	precision = 1;
	setPrecision(vp,precision);
  }

  while(1) {
		index = parse_packet(vpFile, &nArgs, &test);/*fix*/
		if( index == -1)  break; 
		if( index == -3)  break; 
		if(index >= size) { fprintf(stderr,"\n Read index Error in configuration: index out of range: %d ", index); break; }
		if( index == -2) break;
		else {
			vp = view+index;
			strncpy(vp->fileName,gCArg[0],23);
                        vp->fileName[23]='\0';
			if( test == '*' ) setFlag(vp,ISARRAY,1); 
			else if (test == '@') setFlag(vp,ISARRAY,0);
			else { sprintf(msgStr," %s: Syntax Error in configuration, test char = %c ",gCArg[0],test); usrErr(msgStr); break; }
                        if(debug) { 
				sprintf(msgStr,"\nReading Output Config for %s: Nargs = %d, CMD0 = %c index = %d",gCArg[0],nArgs,gCArg[1][0],index);	
				WriteMsg(msgStr,1);  
			}				
			cmd = gCArg[1][0]; 
			switch (cmd) {	
				case 'O':
					if( isInteger(gCArg[2])  ) { ix = atoi(gCArg[2]);  }
					else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);	
					if(debug) { sprintf(msgStr,"\n%s Output Config: O(%d)",gCArg[0],ix);	WriteMsg(msgStr,1); }				
					vp->step = ix; Ocmd=1;
				break;
				case 'A':
					if( isInteger(gCArg[2]) && nArgs > 2 ) { ix = atoi(gCArg[2]);  }
					else  { fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);  WriteMsg(msgStr,1); }	
					if(debug) { sprintf(msgStr,"\n%s Output Config: A()",gCArg[0]); WriteMsg(msgStr,1); }					
					vp->mapType = 'H';
					if( Ocmd == 0 ) vp->step = 1;
				break;
			     case 'G':
					 if ( nArgs > 2 )  { if( isInteger(gCArg[2])  ) { vp->mapType = atoi(gCArg[2]); } else { vp->mapType =gCArg[2][0]; } }
					 if ( nArgs > 3 ) if( isInteger(gCArg[3])  ) { precision = atoi(gCArg[3]); }
					 if ( nArgs > 4 ) strcpy(vp->fileName,gCArg[4]);
					 if( precision > 1 && precision < 5 ) setPrecision(vp,precision);
					 if( Ocmd == 0 ) vp->step = 1;
				break;
			     case 'B':
					 if( isFloat(gCArg[2]) && isFloat(gCArg[3])  && nArgs > 3 ) { vp->bounds.Vmax = atof(gCArg[2]); vp->bounds.Vmin = atof(gCArg[3]); }
					 if(debug) { sprintf(msgStr,"\n%s Output Config: G(%.1f,%.1f)",vp->bounds.Vmax,vp->bounds.Vmin); WriteMsg(msgStr,1); } 
				break;
				case 'P':
					if( isInteger(gCArg[2]) &&  isInteger(gCArg[3]) && nArgs > 3 )  { 	
						if( (i = (++(vp->nPoints)-1)) >= (vp->maxPoints)) make_more_points(vp,7);
						ix = atoi(gCArg[2]); iy = atoi(gCArg[3]);  
					}
					else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
					if(debug) { sprintf(msgStr,"\n%s Output Config: P(%d,%d), index = %d",gCArg[0],ix,iy,i); 
							WriteMsg(msgStr,1);  
					}				
					vp->points[i].x = ix; 
					vp->points[i].y = iy;
					vp->points[i].type = 'p';
				break;
				case 'W':
					if( isInteger(gCArg[2]) &&  isInteger(gCArg[3]) &&  isInteger(gCArg[4]) && nArgs > 4 ) {
						if( (i = (++(vp->nPoints)-1)) >= (vp->maxPoints)) make_more_points(vp,7);
						ix = atoi(gCArg[2]); iy = atoi(gCArg[3]); iz = atoi(gCArg[4]);  
					}
					else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
					if( nArgs > 5 )  vp->points[i].format = gCArg[5][0];
					vp->points[i].type = 'w';
					vp->points[i].x = ix;  	
					vp->points[i].y = iy;  	
					vp->points[i].z = iz;
					if(debug) { sprintf(msgStr,"\n%s Output Config: W(%d,%d,%d,%c), index = %d",gCArg[0],ix,iy,iz,vp->points[i].format,i);	WriteMsg(msgStr,1);  }				
					if( Ocmd == 0 ) vp->step = 1;
				break;
				case 'S': case 'C':
					if( gCArg[1][1] == 'm' || gCArg[1][0] == 'C' ) {     
						 if( isInteger(gCArg[2]) &&  isInteger(gCArg[3]) &&  isInteger(gCArg[4]) && nArgs > 5 ) {
							if( (i = (++(vp->nPoints)-1)) >= (vp->maxPoints)) make_more_points(vp,7);
							ix = atoi(gCArg[2]); iy = atoi(gCArg[3]); iz = atoi(gCArg[4]); 
							vp->points[i].type =  gCArg[5][0];
						 }
						 else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
						 vp->points[i].x = ix;  	
						 vp->points[i].y = iy;  	
						 vp->points[i].z = iz;
						 if(debug) { sprintf(msgStr,"\n%s Output Config: Sm(%d,%d,%d,%c), index = %d",gCArg[0],ix,iy,iz,gCArg[4][0],i); WriteMsg(msgStr,1); }				
						 if( Ocmd == 0 ) vp->step = 1;	
					} else {								
						if( nArgs > 2 ) {
							if( isFloat(gCArg[2]) ) { x = atof(gCArg[2]); }
							else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
						}
						if( nArgs > 3 ) {
							if( isFloat(gCArg[3]) ) { y = atof(gCArg[3]); }
							else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
						}
						if(debug) { sprintf(msgStr,"\n%s Output Config: S(%f,%f)",gCArg[0],x,y); WriteMsg(msgStr,1); }				
						vp->scale.s = x; 
						vp->scale.o = y;
					}
				break;
			}
		}
	}
  return size;
}


#if NeedFunctionPrototypes	
int readViewParmsOLD(char* filename, int size)
#else
int readViewParmsOLD(filename,size)
char* filename; int size;
#endif
{
  char test;
  char cmd;
  int index=0, ix, iy, iz, go=1, i, nArgs, precision, format=0, Ocmd;
  float x,y;
  ViewParm *vp;

  format = init_config_fileOLD(filename, '#', '*', '@', '~' ); /*open file in here */
  if( size < 0 ) { fprintf(stderr,"OutList Size Read Error."); exit(0); }
  if(view == NULL) view = (ViewParm*) malloc(size*sizeof(ViewParm));
  viewSize = size;
  
  for(index=0; index<viewSize; index++)  {
	vp = view+index;
	vp->scale.s = 1.0;  vp->scale.o = 0.0;
	vp->step = 0; Ocmd=0;
	vp->nPoints = 0;
	vp->points = NULL;
	vp->maxPoints = 0;
	vp->mapType = 'N';
	precision = 1;
	setPrecision(vp,precision);
  }

  while(1) {
		index = parse_packetOLD( &nArgs, &test );
		if(debug) { 
			if(index>0) { sprintf(msgStr,"\nGot packet: %s, nargs: %d, test: %c, index: %d\n",gCArg[0],nArgs,test,index); WriteMsg(msgStr,1); } 
			else  { sprintf(msgStr,"\nGot packet: index: %d\n",index); WriteMsg(msgStr,1); } 
		}
		if( index == -1)  break; 
		if( index == -3)  break; 
		if(index >= size) { fprintf(stderr,"\n Read index Error in configuration: index out of range: %d ", index); break; }
		if( index == -2) break;
		else {
			vp = view+index;
			strncpy(vp->fileName,gCArg[0],23); vp->fileName[23]='\0';
			if( test == '*' ) setFlag(vp,ISARRAY,1); 
			else if (test == '@') setFlag(vp,ISARRAY,0);
			else { sprintf(msgStr," %s: Syntax Error in configuration, test char = %c ",gCArg[0],test); usrErr(msgStr); break; }
                        if(debug) { 
				sprintf(msgStr,"\nReading Output Config for %s: Nargs = %d, CMD0 = %c index = %d",gCArg[0],nArgs,gCArg[1][0],index);	
				WriteMsg(msgStr,1);  
			}				
			cmd = gCArg[1][0]; 
			switch (cmd) {	
				case 'O':
					if( isInteger(gCArg[2])  ) { ix = atoi(gCArg[2]);  }
					else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);	
					if(debug) { sprintf(msgStr,"\n%s Output Config: O(%d)",gCArg[0],ix);	WriteMsg(msgStr,1); }				
					vp->step = ix; Ocmd=1;
				break;
				case 'A':
					if( isInteger(gCArg[2]) && nArgs > 2 ) { ix = atoi(gCArg[2]);  }
					else  { fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);  WriteMsg(msgStr,1); }	
					if(debug) { sprintf(msgStr,"\n%s Output Config: A()",gCArg[0]); WriteMsg(msgStr,1); }					
					vp->mapType = 'H';
					if( Ocmd == 0 ) vp->step = 1;
				break;
			     case 'G':
					 if ( nArgs > 2 )  { if( isInteger(gCArg[2])  ) { vp->mapType = atoi(gCArg[2]); } else { vp->mapType =gCArg[2][0]; } }
					 if ( nArgs > 3 ) if( isInteger(gCArg[3])  ) { precision = atoi(gCArg[3]); }
					 if ( nArgs > 4 ) strcpy(vp->fileName,gCArg[4]);
					 if( precision > 1 && precision < 5 ) setPrecision(vp,precision);
					 if( Ocmd == 0 ) vp->step = 1;
				break;
			     case 'B':
					 if( isFloat(gCArg[2]) && isFloat(gCArg[3])  && nArgs > 3 ) { vp->bounds.Vmax = atof(gCArg[2]); vp->bounds.Vmin = atof(gCArg[3]); }
					 if(debug) { sprintf(msgStr,"\n%s Output Config: G(%.1f,%.1f)",vp->bounds.Vmax,vp->bounds.Vmin); WriteMsg(msgStr,1); } 
				break;
				case 'P':
					if( isInteger(gCArg[2]) &&  isInteger(gCArg[3]) && nArgs > 3 )  { 	
						if( (i = (++(vp->nPoints)-1)) >= (vp->maxPoints)) make_more_points(vp,7);
						ix = atoi(gCArg[2]); iy = atoi(gCArg[3]);  
					}
					else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
					if(debug) { sprintf(msgStr,"\n%s Output Config: P(%d,%d), index = %d",gCArg[0],ix,iy,i); 
							WriteMsg(msgStr,1);  
					}				
					vp->points[i].x = ix; 
					vp->points[i].y = iy;
					vp->points[i].type = 'p';
				break;
				case 'W':
					if( isInteger(gCArg[2]) &&  isInteger(gCArg[3]) &&  isInteger(gCArg[4]) && nArgs > 4 ) {
						if( (i = (++(vp->nPoints)-1)) >= (vp->maxPoints)) make_more_points(vp,7);
						ix = atoi(gCArg[2]); iy = atoi(gCArg[3]); iz = atoi(gCArg[4]);  
					}
					else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
					if( nArgs > 5 )  vp->points[i].format = gCArg[5][0];
					vp->points[i].type = 'w';
					vp->points[i].x = ix;  	
					vp->points[i].y = iy;  	
					vp->points[i].z = iz;
					if(debug) { sprintf(msgStr,"\n%s Output Config: W(%d,%d,%d,%c), index = %d",gCArg[0],ix,iy,iz,vp->points[i].format,i);	WriteMsg(msgStr,1);  }				
					if( Ocmd == 0 ) vp->step = 1;
				break;
				case 'S': case 'C':
					if( gCArg[1][1] == 'm' || gCArg[1][0] == 'C' ) {     
						 if( isInteger(gCArg[2]) &&  isInteger(gCArg[3]) &&  isInteger(gCArg[4]) && nArgs > 5 ) {
							if( (i = (++(vp->nPoints)-1)) >= (vp->maxPoints)) make_more_points(vp,7);
							ix = atoi(gCArg[2]); iy = atoi(gCArg[3]); iz = atoi(gCArg[4]); 
							vp->points[i].type =  gCArg[5][0];
						 }
						 else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
						 vp->points[i].x = ix;  	
						 vp->points[i].y = iy;  	
						 vp->points[i].z = iz;
						 if(debug) { sprintf(msgStr,"\n%s Output Config: Sm(%d,%d,%d,%c), index = %d",gCArg[0],ix,iy,iz,gCArg[4][0],i); WriteMsg(msgStr,1); }				
						 if( Ocmd == 0 ) vp->step = 1;	
					} else {								
						if( nArgs > 2 ) {
							if( isFloat(gCArg[2]) ) { x = atof(gCArg[2]); }
							else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
						}
						if( nArgs > 3 ) {
							if( isFloat(gCArg[3]) ) { y = atof(gCArg[3]); }
							else  fprintf(stderr," %s: Syntax Error in configuration ",gCArg[0]);
						}
						if(debug) { sprintf(msgStr,"\n%s Output Config: S(%f,%f)",gCArg[0],x,y); WriteMsg(msgStr,1); }				
						vp->scale.s = x; 
						vp->scale.o = y;
					}
				break;
			}
		}
	}
  return size;
}

#if NeedFunctionPrototypes
void calc_maxmin(ViewParm *vp, void* Map, char Mtype, char* mName, int step) 
#else
     void calc_maxmin(vp, Map, Mtype, mName, step) 
     void* Map;
     ViewParm *vp;
     char Mtype; char* mName;
     int step;
#endif
     
{
  int ix, iy,  type = 12, cnt=0;
  float vout[4], ftmp, fmax = -1000, fmin = 1000;
  
  switch(Mtype) {
  case 'f' :	
    for(ix=1; ix<=s0; ix++) 
      for(iy=1; iy<=s1; iy++) {
	if( ON_MAP[T(ix,iy)] ) {
	  if( (ftmp = ((float*)Map)[T(ix,iy)]) > fmax ) {
	    fmax = ftmp; 
	  }
	  if( ftmp < fmin ) fmin = ftmp;
	}
      }
    break;
  case 'i' :	case 'd' :	
    for(ix=1; ix<=s0; ix++) 
      for(iy=1; iy<=s1; iy++) {
	if( ON_MAP[T(ix,iy)] ) {
	  if( ftmp = ((int*)Map)[T(ix,iy)] > fmax ) fmax = ftmp;
	  if( ftmp < fmin ) fmin = ftmp;
	}
      }
    break;
  case 'c' :	
    for(ix=1; ix<=s0; ix++) 
      for(iy=1; iy<=s1; iy++) {
	if( ON_MAP[T(ix,iy)] ) {
	  if( ftmp = (float)((unsigned char*)Map)[T(ix,iy)] > fmax ) fmax = ftmp;
	  if( ftmp < fmin ) fmin = ftmp;
	}
      } 
    break;
  }
  if(step==0) {
    vp->gScale.Vmax = fmax;
    vp->gScale.Vmin = fmin;
  } else {
    if( fmax > vp->gScale.Vmax ) vp->gScale.Vmax = fmax;
    if( fmin < vp->gScale.Vmin ) vp->gScale.Vmin = fmin;
  }
  vout[0] = fmax; vout[1] = vp->gScale.Vmax; vout[2] = fmin; vout[3] = vp->gScale.Vmin;
  Combine(vout,mName,4,kMAXMIN,step);
}

void setup_platform() {
 
/*     usrErr("Setting up platfrom");  */
  exparam(&env);
/*   usrErr("Done exparam"); */
  procnum = env.procnum;
  exgridsplit(env.nprocs, 2, nprocs);
  if( exgridinit(2, nprocs) < 0) { usrErr("Failed to Setup Grid"); exit(0); }
/*   usrErr("Done exgridinit"); */
  exgridcoord(procnum, recpnum);
}

void setup_grid() {
  
  exgridsize(procnum,gbl_size,lcl_size,lcl_start);
  
  s0 = lcl_size[0];
  s1 = lcl_size[1];
  
  gridSize = (s0+2)*(s1+2);
  
  sprintf(msgStr,"\nGRID DATA::[ gsize: (%d, %d), lstart: (%d, %d), lend: (%d, %d), lsize: (%d, %d) ]\n",
	  gbl_size[0], gbl_size[1], lcl_start[0], 
	  lcl_start[1], lcl_start[0]+lcl_size[0]-1, 
	  lcl_start[1]+lcl_size[1]-1, lcl_size[0], lcl_size[1] );
  WriteMsg(msgStr,ALLPROCS);  
  sprintf(msgStr,"\nVP DATA:: size: (%d), Variable sizes: float: %d, int: %d, long: %d,  double: %d\n", 
	    sizeof(ViewParm), sizeof(float),sizeof(int) ,sizeof(long) ,sizeof(double)   );
  WriteMsg(msgStr,1);

  
  gTempSize = gridSize*8;
  gTemp = (UCHAR*) nalloc(gTempSize,"gTemp");  
}

#if NeedFunctionPrototypes
int iclip ( int x0, int min, int max )
#else
     int iclip ( x0, min, max ) 
     int x0, min, max;
#endif
{
  int rv;
  rv = ( x0 > max) ?  max : x0;
  rv = ( rv < min) ?  min : rv;
  return rv;
}
#if NeedFunctionPrototypes
void write_output(
		   int 				index,
		   ViewParm 		*vp,
		   void* 			Map,
		   char 	        *filename,
		   char 	        Mtype,
		   int 				step)
#else
void write_output(index,vp,Map,filename,Mtype,step)
		   int 				index;
		   ViewParm 		*vp;
		   char 	        *filename;
		   void* 			Map;
		   char 	        Mtype;
		   int 				step;
#endif
{
	int i; Point3D point;

        calcdate( Jdate, mo, da, yr, hr, mi, se); /* get the calendar date info from the julian date */
        
        if(vp->mapType != 'N' ) {
			write_map_file(filename,Map,Mtype,index,vp->scale.s,vp->scale.o,getPrecision(vp),vp->mapType,mo,da,yr);
			if (debug > 3) calc_maxmin(vp,Map,Mtype,filename,step);
	}
	for(i=0; i< (vp->nPoints); i++ ) {
		point = vp->points[i];
	    if (debug > 3) { sprintf(msgStr,"\nwriting Out: %s(%d): %c(), index = %d, step=%d\n", filename, i, point.type, index, step ); 
            WriteMsg(msgStr,1); 
            }
            
		switch( point.type ) {	
                    case 'm': case 'M': calc_maxmin( vp,Map,Mtype,filename,step); break;	
                    case 'w': quick_look( Map, filename, Mtype, point.x, point.y, point.z, point.format ); break;
                    case 'a': case 's': case 'A': case 'S': print_loc_ave( &point, Map, Mtype, filename, step ); break;
                    case 'p': print_point( vp, Map, Mtype, filename, step, i ); break;
		}
	}
}
						
#if NeedFunctionPrototypes
int write_map_file(
		   char 	        *filename,
		   VOIDP 			Map,
		   char 	        Mtype,
		   int 				index,
		   float 			scale_value,
		   float 			offset_value,
		   int 				bSize, 
		   unsigned char    type,
                   int *mo, int *da, int *yr)
#else
     int write_map_file(filename, Map, Mtype, index, scale_value, offset_value, bSize, type, mo, da,yr)
     char 	        *filename;
     VOIDP 			Map;
     char 	        Mtype;
     int 			index;
     float 			scale_value;
     float 			offset_value;
     int 			bSize;
	 unsigned char  type;
     int *mo, *da, *yr;
#endif
{	
  int i, j, pathType=0;
  char /* ftype[7] */ftype[10], gSize;
  float ftmp; 
  SLONG itmp, imax, imin;
  UCHAR *mPtr;
  char s_mo[3], s_da[3];
  
/* below provide increasing integer, non-date, appendage to filenames */
/*   ftype[0] = '0' + (index / 100); */
/*   ftype[1] = '0' + ((index%100) / 10); */
/*   ftype[2] = '0' + (index % 10); */
 /*  ftype[8] = '\0'; */

/* jan99 we now put the date (yyyymmdd) as the appendage to the root filename*/
  if (mo[0]<10) sprintf(s_mo,"0%d", mo[0]);
  else sprintf(s_mo,"%d", mo[0]);
  if (da[0]<10) sprintf(s_da,"0%d", da[0]);
  else sprintf(s_da,"%d", da[0]);
  sprintf (ftype,"%d%s%s\0",yr[0],&s_mo,&s_da);
  
  if( HDF && type=='H' ) sprintf(ftype,".hdf");
   
  gSize = gridSize*bSize + 1;
  if( gSize > gTempSize ) { 
    if(gTempSize) free((char*)gTemp); 
    gTemp = (UCHAR*) nalloc( gSize, "gTemp" );	
    gTempSize = gSize; 
  }
  
  if( H_OPSYS == UNIX ){ if( check_for (filename, "/", 0, CASE, END ) >= 0 ) { if( filename[0] != '/' ) pathType = 1; else pathType = 2; }}
  else { if( check_for (filename, ":", 0, CASE, END ) >= 0 ) { if( filename[0] == ':' ) pathType = 1; else pathType = 2; }}
  
  if(type=='H') {                         /* HDF format */
    switch(pathType) {
    case 0:	/* No Path */
      if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Output/Animation/%s%s\0",OutputPath,ProjName,filename,ftype);
      else sprintf(mapFileName,"%s%s:Output:Animation:%s%s\0",OutputPath,ProjName,filename,ftype);
      break;
    case 1:	/* Relative Path */
      if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Output/Animation/%s%s\0",OutputPath,ProjName,filename,ftype);
      else sprintf(mapFileName,"%s%s:Output:Animation:%s%s\0",OutputPath,ProjName,filename,ftype);
      break;
    case 2:	/* Full Path */
      sprintf(mapFileName,"%s.hdf\0",filename);
      break;
    }
  }
  else if(type=='M') {	
    switch(pathType) {                   /* Map II Format */
    case 0:								/* No Path */
      if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Output/Maps/%s%s\0",OutputPath,ProjName,filename,ftype);
      else sprintf(mapFileName,"%s%s:Output:Maps:%s%s\0",OutputPath,ProjName,filename,ftype);
      break;
    case 1:	/* Relative Path */
      if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Output/Maps/%s%s\0",OutputPath,ProjName,filename,ftype);
      else sprintf(mapFileName,"%s%s:Output:Maps:%s%s\0",OutputPath,ProjName,filename,ftype);
      break;
    case 2:	/* Full Path */
      sprintf(mapFileName,"%s%s\0",filename,ftype);
      break;
    }
  }
  else {
  	bSize = 1;
    switch(pathType) {                   /* Binary Format */
    case 0:								/* No Path */
      if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Output/Animation%d/%s%s\0",OutputPath,ProjName,type,filename,ftype);
      else sprintf(mapFileName,"%s%s:Output:Animation%d:%s%s\0",OutputPath,ProjName,type,filename,ftype);
      break;
    case 1:	/* Relative Path */
      if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/DriverOutput/Animation%d/%s%s\0",OutputPath,ProjName,type,filename,ftype);
      else sprintf(mapFileName,"%s%s:Output:Animation%d:%s%s\0",OutputPath,ProjName,type,filename,ftype);
      break;
    case 2:	/* Full Path */
      sprintf(mapFileName,"%s%s\0",filename,ftype);
      break;
    }
  }
  
  bSize = (bSize < 1) ? 1 : bSize;
  bSize = (bSize > 4) ? 4 : bSize;
  if( Mtype == 'c' ) bSize = 1;
  if(bSize == 1) { imax = 255; imin = 0; }
  else if(bSize == 2) { imax = 255*128; imin = -imax; }
  else if(bSize == 3) { imax = 256*256*128; imin = -imax; }
  mPtr = gTemp;
  
  if  ( debug >3) {  sprintf(msgStr,"\n\nWriting Map %s: scale_value = %f, offset_value = %f, index = %d, filename = %s, type = %c, bSize = %d, pathType = %d, type = %d\n",
			   filename,scale_value,offset_value,index,mapFileName,Mtype,bSize,pathType,type);   WriteMsg(msgStr,1); }
  
  for (i=0; i<s0; i++) {
    for (j=0; j<s1; j++) {
      if( ON_MAP[T(i+1,j+1)] ) {
	switch(Mtype) {
	case 'f' :    			
	  ftmp = ((( (float*) Map)[T(i+1,j+1)] - offset_value) / scale_value); 
	  itmp = (int) ftmp;
	  itmp = (itmp > imax-1) ? imax-1 : itmp;
	  itmp = (itmp < imin) ? imin : itmp;
	  break;
	case 'd' : case 'i' :  	
	  ftmp = ((( (int*) Map)[T(i+1,j+1)] - offset_value) / scale_value); 
	  itmp = (int) ftmp;
	  itmp = (itmp > imax-1) ? imax-1 : itmp;
	  itmp = (itmp < imin) ? imin : itmp;
	  break;
	case 'c' : 				
	  itmp = ((unsigned char*) Map)[T(i+1,j+1)];
	  itmp = (itmp > imax-1) ? imax-1 : itmp;
	  itmp = (itmp < imin) ? imin : itmp;
	  break;
	}
      }
      else  itmp = imax;
      
      enc_Nb(&mPtr,itmp,bSize);
    }
  }	
  writeMap(mapFileName,gTemp,bSize,type,index);
  if(debug) quick_look(Map, filename, Mtype, dbgPt.x, dbgPt.y, 2,'E');
  return(0);
}

#if NeedFunctionPrototypes
int read_map_file(
		  char 	                *filename,
		  VOIDP 		Map,
		  unsigned char 	Mtype,
		  float 		scale_value,
		  float 		offset_value)
#else
     int read_map_file(filename, Map, Mtype, scale_value, offset_value)
     char 	        *filename;
     VOIDP 		Map;
     unsigned char 	Mtype;
     float 		scale_value;
     float 		offset_value;
#endif
{
  int i, j, k0, size;
  unsigned temp;
  UCHAR *tmpPtr, Dsize;
  
  size = gridSize*4 +1;
  if( size > gTempSize ) { 
    if(gTemp) free((char*)gTemp); 
    gTemp = (UCHAR*)nalloc( size, "gTemp" );	
    gTempSize = size; 
  }
  
  if(debug>2) { sprintf(msgStr,"Reading %s\n",filename);  usrErr(msgStr); WriteMsg(msgStr,1); } 
  if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Data/%s",ModelPath,ProjName,filename);
  else sprintf(mapFileName,"%s%s:Data:%s",ModelPath,ProjName,filename);
  
  Dsize = readMap(mapFileName,gTemp);
  
  if(debug) { sprintf(msgStr,"name = %s, proc = %d, scale_value = %f, offset_value = %f, size = %x\n ",filename,procnum,scale_value,offset_value,Dsize);  WriteMsg(msgStr,1); } 
  for (i=1; i<=s0; i++) {
    for (j=1; j<=s1; j++) {
      k0 = Dsize*((i-1)*lcl_size[1] + (j-1));
      tmpPtr = gTemp+k0;
      switch(Dsize) {
      case 1: temp = gTemp[k0]; break;
      case 2: temp = gTemp[k0]*256 + gTemp[k0+1]; break;
      case 3: temp = gTemp[k0]*65536 + gTemp[k0+1]*256 + gTemp[k0+2]; break;
      case 4: temp = gTemp[k0]*16777216 + gTemp[k0+1]*65536 + gTemp[k0+2]*256 + gTemp[k0+3]; break;
      default: fprintf(stderr,"ERROR, illegal size: %x\n",Dsize); temp = 0;
      }						
      switch (Mtype) {
      case 'f' :
	((float*)Map)[T(i,j)] = scale_value*((float)temp)+offset_value; 
	break;
      case 'd' : case 'i' :
	((int*)Map)[T(i,j)] = (int)  scale_value*((float)temp)+offset_value; 
	break;
      case 'c' :
	((unsigned char*)Map)[T(i,j)] = (int)  scale_value*(unsigned char) temp; 
	break;
      }
    }
  }
  if(debug) quick_look(Map, filename, Mtype, dbgPt.x, dbgPt.y, 2,'E');
  link_edges(Map,Mtype);
  fflush(stderr);
  return Dsize;
}

#if NeedFunctionPrototypes
float*    read_timeseries_file(int iFormat, char* filename, float* fValue, int index, int* NPt, float* TStep)
#else
     float* read_timeseries_file(iFormat,filename,fValue,index,NPt,TStep)
     int iFormat;
     char *filename;
     float *TStep;
     int *NPt,index;
     float* fValue;
#endif
{
  float *value;
  if(fValue) free((char*)fValue);
  if(Lprocnum==1) { sprintf(msgStr,"\nReading Timeseries file: %s, index %d",filename,index); usrErr(msgStr); WriteMsg(msgStr,1); }
  if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Data/%s",ModelPath,ProjName,filename);
  else sprintf(mapFileName,"%s%s:Data:%s",ModelPath,ProjName,filename);
  value = readSeries(mapFileName,iFormat,index,NPt,TStep);
  return value;
}


#if NeedFunctionPrototypes
void PTS_SetFields (PTSeries* thisStruct, int ix, int iy, int index, int format, int col)
#else
     void PTS_SetFields (thisStruct, ix, iy, index, format, col)
     PTSeries* thisStruct; int ix; int iy; int format, index, col;
#endif
{
  float ptstep = 1.0, *value; /*jan99 changed name from tstep to ptstep (not a prob, but had same name as global hydro DT of tstep)*/
  int n0;
  
  thisStruct->fX = ix;
  thisStruct->fY = iy;
  if(thisStruct->fValue) free((char*)thisStruct->fValue); 

/* sept98, used revised readSeries fcn thisStruct->fValue = readSeries(mapFileName,format,index,&n0,&ptstep);*/
  thisStruct->fValue = readSeriesCol(mapFileName,format,index,&n0,&ptstep,col);
  
  gNPtTs = thisStruct->fNpt = n0;
  gTS = thisStruct->fTS = ptstep;
  value = thisStruct->fValue;
  if  ( debug>2 ) {  sprintf(msgStr,"\nPTS_SetFields: TSVals: %f %f %f, TS: %f, NPt: %d \n",value[0],value[1],value[2],ptstep,n0);  WriteMsg(msgStr,1); }
}

#if NeedFunctionPrototypes
float* get_DBase_parm2(
     char *filename,
     int i0, int i1, int index)
#else
float* get_DBase_parm2(filename,i0, i1, index)
     char *filename;
     int i0, i1, index;
#endif
{
  float* dArray;
  
  sprintf(mapFileName,"Reading dBase: %s",filename);
  usrErr(mapFileName); 
  if(debug) { sprintf(msgStr,"%s\n",mapFileName); WriteMsg(msgStr,1); }
  if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Data/%s",ModelPath,ProjName,filename);
  else sprintf(mapFileName,"%s%s:data:%s",ModelPath,ProjName,filename);
  dArray = read_hdp2(mapFileName, i0, i1, index, 2);
  return dArray;
}

#if NeedFunctionPrototypes
float* get_DBase_parm(
     char *filename,
     int i0, int i1, int index)
#else
float* get_DBase_parm(filename,i0, i1, index)
     char *filename;
     int i0, i1, index;
#endif
{
  float* dArray;
  
  if (debug>2) {  sprintf(mapFileName,"Reading dBase: %s",filename);
  usrErr(mapFileName);  } 
  if(debug) { sprintf(msgStr,"%s\n",mapFileName); WriteMsg(msgStr,1); }
  if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Data/%s",ModelPath,ProjName,filename);
  else sprintf(mapFileName,"%s%s:data:%s",ModelPath,ProjName,filename);
  dArray = read_hdp2(mapFileName, i0, i1, index, 1);
  return dArray;
}





void set_env_vars( ) {
  
  FILE *infile;
  char filename[100], ch;
  static long start;
  int i, maxLen =200;
  
  if (H_OPSYS == UNIX ) { 
 
    /*OutputPath = getenv("OutputPath"); */
    ModelPath = getenv("ModelPath"); 
    ProjName = getenv("ProjName");
    DriverPath = getenv("DriverPath");
    sprintf(msgStr,"Project Name = %s",ProjName); usrErr(msgStr);
/*    sprintf(msgStr,"Output Path = %s",OutputPath); usrErr(msgStr); */ /*jan99*/
    sprintf(msgStr,"Model Path = %s",ModelPath); usrErr(msgStr); /*nov98*/
    /* sprintf(msgStr,"Driver Path = %s",DriverPath); usrErr(msgStr); */
  }
  else {
    ModelPath = (char*) malloc(maxLen);
    ProjName = (char*) malloc(maxLen);
    DriverPath = (char*) malloc(maxLen);
    if(DriverPath == NULL) { fprintf(stderr,"Can't allocate memory in set_env_vars"); Exit(0); }
    if(Lprocnum == 1) {
        
	  sprintf(filename,"Driver.config");
	  infile = fopen(filename,"r");
      start = ftell(infile);
      
      usrErr("Setting Environment Variables."); 
      scan_forward(infile,"ModelPath ="); i=0;
      skip_white(infile);
      while((ch=fgetc(infile)) != '\n') {
	if(i>=maxLen) { 
	  fprintf(stderr,"Error, model path too long: %s\n",ModelPath); Exit(0); }
	ModelPath[i++] = ch;
      }
      while( ModelPath[i-1]==' ' ) i--;
      ModelPath[i] = '\0';
      
      clearerr(infile); 
      fseek(infile, start, SEEK_SET);
      scan_forward(infile,"ProjName ="); i=0;
      skip_white(infile);
      while((ch=fgetc(infile)) != '\n') {
	if(i>=maxLen) { 
	  fprintf(stderr,"Error, project path too long: %s\n",ProjName); Exit(0); }
	ProjName[i++] = ch;
      }	
      while( ProjName[i-1]==' ' ) i--;
      ProjName[i] = '\0';
      
      clearerr(infile); fseek(infile, start, SEEK_SET); 
      scan_forward(infile,"DriverPath ="); i=0;
      skip_white(infile);
      while((ch=fgetc(infile)) != '\n') {
	if(i>=maxLen) { 
	  fprintf(stderr,"Error, driver path too long: %s\n",DriverPath); Exit(0); }
	DriverPath[i++] = ch;
      }	
      while( DriverPath[i-1]==' ' ) i--;
      DriverPath[i] = '\0';
      fclose(infile);
    }
    broadcastMsg( (byte*) ModelPath );
    broadcastMsg( (byte*) ProjName );
    broadcastMsg( (byte*) DriverPath );
  }
}


void read_model_parameters() {
  
  char filename[120];
  int test;
  FILE *infile;
  
  if(H_OPSYS==UNIX) sprintf(filename,"%s/%s/Data/GlobalParms",ModelPath,ProjName);
  else  sprintf(filename,"%s%s:Data:GlobalParms",ModelPath,ProjName,filename);
  
  infile = fopen(filename,"r");
  if(infile==NULL) { fprintf(stderr,"Error, can't open file %s",filename); Exit(0); }
  sprintf(msgStr,"Getting Parms from file %s\n.",filename); WriteMsg(msgStr,1); 
  test = ReadParms(infile);
  if(test<=0) { fprintf(stderr,"\n*** Parameter Read Error in %s; see driver debug file ***", filename); Exit(0); }
  fclose(infile);
}

#if NeedFunctionPrototypes
void set_boundary(VOIDP Map, unsigned char Mtype,float bv) 
#else
     void set_boundary(Map, Mtype, bv) 
     VOIDP Map; unsigned char Mtype; float bv;
#endif
{
  int size, i0, i1;
  
  switch(Mtype) {
  case 'f' :	
    size = sizeof(float);
    if(recpnum[1]==0) for(i0=0; i0<=s0+1; i0++) ((float*)Map)[T(i0,0)] = bv;
    if(recpnum[0]==0) for(i1=0; i1<=s1+1; i1++) ((float*)Map)[T(0,i1)] = bv;
    if(recpnum[1]==(nprocs[1]-1)) for(i0=0; i0<=s0+1; i0++) ((float*)Map)[T(i0,s1+1)] = bv;
    if(recpnum[0]==(nprocs[0]-1)) for(i1=0; i1<=s1+1; i1++) ((float*)Map)[T(s0+1,i1)] = bv;
    break;
  case 'i' :	case 'd' :	
    size = sizeof(int);
    if(recpnum[1]==0) for(i0=0; i0<=s0+1; i0++) ((int*)Map)[T(i0,0)] = (int) bv;
    if(recpnum[0]==0) for(i1=0; i1<=s1+1; i1++) ((int*)Map)[T(0,i1)] = (int) bv;
    if(recpnum[1]==(nprocs[1]-1)) for(i0=0; i0<=s0+1; i0++) ((int*)Map)[T(i0,s1+1)] = (int) bv;
    if(recpnum[0]==(nprocs[0]-1)) for(i1=0; i1<=s1+1; i1++) ((int*)Map)[T(s0+1,i1)] = (int) bv;
    break;
  case 'c' :	
    size = sizeof(unsigned char);
    if(recpnum[1]==0) for(i0=0; i0<=s0+1; i0++) ((unsigned char*)Map)[T(i0,0)] = (unsigned char) '\0' + (int) bv;
    if(recpnum[0]==0) for(i1=0; i1<=s1+1; i1++) ((unsigned char*)Map)[T(0,i1)] = (unsigned char) '\0' + (int) bv;
    if(recpnum[1]==(nprocs[1]-1)) for(i0=0; i0<=s0+1; i0++) ((unsigned char*)Map)[T(i0,s1+1)] = (unsigned char) '\0' + (int) bv;
    if(recpnum[0]==(nprocs[0]-1)) for(i1=0; i1<=s1+1; i1++) ((unsigned char*)Map)[T(s0+1,i1)] = (unsigned char) '\0' + (int) bv;
    break;
  }
}
/*****************************************************************************/

#if NeedFunctionPrototypes
double z(int x, int y)
#else
     double z(x, y)
     int x; int y;
#endif
{
  return( (double) plot_array[T(x+1,y+1)] );
}

/**************************************************************/


#if NeedFunctionPrototypes
void smooth (float* Map,int Ns)
#else
     void smooth  (Map, Ns)
     float* Map; int Ns;
#endif
{
  int i, j, k,  im;
  float *temp, tm[8];
  
  sprintf(msgStr,"Smooth map, Ns = %d\n",Ns); WriteMsg(msgStr,1);
  temp = (float*) malloc(sizeof(float)*(s0+2)*(s1+2));
  if(temp==NULL) { fprintf(stderr,"Error, out of memory"); Exit(1); }
  fsingl(stderr);
  for(k=1; k<=Ns; k++) {
    for(i=1; i<=s0; i++) { 
      for(j=1; j<=s1; j++) {
	if(HAB[T(i,j)]) {
	  tm[0] = (HAB[T(i+1,j+1)]) ? Map[T(i+1,j+1)] : Map[T(i,j)];
	  tm[1] = (HAB[T(i-1,j+1)]) ? Map[T(i-1,j+1)] : Map[T(i,j)];
	  tm[2] = (HAB[T(i+1,j-1)]) ? Map[T(i+1,j-1)] : Map[T(i,j)];
	  tm[3] = (HAB[T(i-1,j-1)]) ? Map[T(i-1,j-1)] : Map[T(i,j)];
	  tm[4] = (HAB[T(i+1,j)]) ? Map[T(i+1,j)] : Map[T(i,j)];
	  tm[5] = (HAB[T(i-1,j)]) ? Map[T(i-1,j)] : Map[T(i,j)];
	  tm[6] = (HAB[T(i,j+1)]) ? Map[T(i,j+1)] : Map[T(i,j)];
	  tm[7] = (HAB[T(i,j-1)]) ? Map[T(i,j-1)] : Map[T(i,j)];
	  temp[T(i,j)] = Map[T(i,j)]/9;
	  for(im=0; im<8; im++) temp[T(i,j)] += tm[im]/ 9;
	}
	else temp[T(i,j)] = 0.0;
      }
    }
    for(i=1; i<=s0; i++) 
      for(j=1; j<=s1; j++) 
	if(HAB[T(i,j)]) Map[T(i,j)] = temp[T(i,j)];
    link_edges(Map,'f');
  }
  free((char*)temp);
}

/********************************************************* FUNCTION COMMENTED OUT
#if NeedFunctionPrototypes
void print_point_list(ViewParm *vp, void* Map, char Mtype, char* mName, int tIndex) 
#else
     void print_point_list(vp, Map, Mtype, mName, tIndex) 
     ViewParm *vp;
     void* Map;
     char Mtype, *mName; 
     int tIndex;
#endif
{
  Point3D *pt;
  int i, x, y;
  
  if(tIndex==0) { vp->PLindex = PListIndex; pSeries[PListIndex].Length=0; }
  else PListIndex = vp->PLindex; 
  for(i=0; (i<vp->nPoints && i<MAX_PTSERIES); i++) {
    pt = vp->points + i;
    x = pt->x - lcl_start[0];
    y = pt->y - lcl_start[1];
    if(  (x >= 0) && (x < s0)  &&  (y >= 0) && (y < s1)  ) {
      if(tIndex==0) { 			
	if( PListIndex >= MAX_PTSERIES ) fatal("Too many Point series.");
	else if( pSeries[PListIndex].data == NULL ) pSeries[PListIndex].data = (float*) malloc( (N_iter*sizeof(float)/vp->step)+2 );
	if( pSeries[PListIndex].data == NULL ) usrErr("out of Memory for Spatial Timeseries.");
	pSeries[PListIndex].Loc.x = pt->x;
	pSeries[PListIndex].Loc.y = pt->y;
	strcpy(pSeries[PListIndex].name,mName);
      }
      switch(Mtype) {
      case 'f' :  pSeries[PListIndex].data[ pSeries[PListIndex].Length++ ] = ((float*)Map)[T(x+1,y+1)];			
	Case 'i' :	pSeries[PListIndex].data[ pSeries[PListIndex].Length++ ] = ((int*)Map)[T(x+1,y+1)];
	Case 'c' :  pSeries[PListIndex].data[ pSeries[PListIndex].Length++ ] = ((unsigned char*)Map)[T(x+1,y+1)];
      }
      PListIndex++;
    }
  }
}
**************************************************************/

#if NeedFunctionPrototypes
void print_point(ViewParm *vp, void* Map, char Mtype, char* mName, int tIndex, int vpindex) 
#else
     void print_point(vp, Map, Mtype, mName, tIndex, vpindex) 
     ViewParm *vp;
     void* Map;
     char Mtype, *mName; 
     int tIndex;
	 int vpindex;
     
#endif
{
  	int x, y;
	Point3D *pt;
        char Cdate[12];
        
  
	pt = vp->points + vpindex;
    x = pt->x - lcl_start[0];
    y = pt->y - lcl_start[1];
    if(  (x >= 0) && (x < s0)  &&  (y >= 0) && (y < s1)  ) {
      if(tIndex==0) { pt->z = PListIndex; pSeries[PListIndex].Length=0; }
      else PListIndex = pt->z; 
      if(tIndex==0) { 			
		if( PListIndex >= MAX_PTSERIES ) fatal("Too many Point series.");
		else if( pSeries[PListIndex].data == NULL ) pSeries[PListIndex].data = (float*) malloc( (N_iter*sizeof(float)/vp->step)+2 );
                if( pSeries[PListIndex].data == NULL ) usrErr("out of Memory for Spatial Timeseries.");
		pSeries[PListIndex].Loc.x = pt->x;
		pSeries[PListIndex].Loc.y = pt->y;
		pSeries[PListIndex].outstep = vp->step; /* added jan99 */
		strcpy(pSeries[PListIndex].name,mName);
		if(debug ) { 
			sprintf(msgStr,"\nSetup Pointlist %d for %s(%d), step=%d, point=(%d,%d)\n", PListIndex, mName, vpindex, vp->step, x, y ); 
			WriteMsg(msgStr,ALLPROCS); 
		}
      }
      switch(Mtype) {
		  case 'f' :  pSeries[PListIndex].data[ pSeries[PListIndex].Length++ ] = ((float*)Map)[T(x+1,y+1)];			
		  Case 'i' :	pSeries[PListIndex].data[ pSeries[PListIndex].Length++ ] = ((int*)Map)[T(x+1,y+1)];
		  Case 'c' :  pSeries[PListIndex].data[ pSeries[PListIndex].Length++ ] = ((unsigned char*)Map)[T(x+1,y+1)];
      }
	  if(debug >2) { /*jan99*/
		  sprintf(msgStr,"\nWriting Point %d for %s(%d), point=(%d,%d), value = %f, index = %d\n", 
							PListIndex, mName, vpindex, x, y, ((float*)Map)[T(x+1,y+1)], pSeries[PListIndex].Length-1 ); 
		  WriteMsg(msgStr,ALLPROCS); 
	  }
      PListIndex++;
    }
}

#if NeedFunctionPrototypes
void writeWindow(
		 void* fValue,
		 char* vName,
		 char* desc,
		 int x0, int y0, int N0, int N1, int index,
		 UCHAR Mtype,
		 UCHAR format)
#else
void writeWindow(fValue,vName,desc,x0,y0,N0,N1, index, Mtype, format)
     void* fValue;
     char* desc;
     char* vName;
     int x0, y0, N0, N1,index;
     UCHAR Mtype, format;
#endif
{
  int mSize, size;
  char ctemp[200];
  
  switch(Mtype) {
  case 'f': case 'L': case 'E':		size = sizeof(float); break;
  case 'd': case 'i':	                size = sizeof(int);  break;
  case 'c':				size = sizeof(char); break;
  }
  if( (mSize=size*N0*N1) > gTempSize ) {
    if(gTemp != NULL) free((char*)gTemp);
    gTemp = (UCHAR*)malloc(gTempSize=mSize);
  }
  
  Copy(((UCHAR*)fValue)+T(x0,y0)*size,gTemp,N1*size,N0,(s1+2)*size,N1*size);
  sprintf(ctemp,"(%d)WIND: %s",index,vName);
  writeSeries(gTemp,ctemp,desc,N0,N1,Mtype,format);
}

/**************************************************************/

#if NeedFunctionPrototypes
int skip_white(FILE *infile)
#else
int skip_white(infile)
     FILE *infile;
#endif
{
  int ch;
  
  while( isspace(ch=fgetc(infile)) ) {;}
  if(ch==EOF) return 0;
  ungetc(ch,infile);
  return 1;		
}  

#if NeedFunctionPrototypes
VOID print_bytes(
     FILE* outfile,
     void* value,
     char* label)
#else
VOID print_bytes(outfile,value,label)
     FILE* outfile;
     void* value;
     char* label;
#endif
{
  UCHAR *chPtr = (UCHAR*)value;
  fprintf(outfile,"{%s: (%x %x %x %x) }",label,chPtr[0],chPtr[1],chPtr[2],chPtr[3]);	
}

/****************************************************************************/
#if NeedFunctionPrototypes
void read_map_dep_parm (char filename[50],float *tvar,int Npt)
#else
     void read_map_dep_parm (filename,tvar,Npt)
     char filename[50];
     float *tvar;
     int Npt;
#endif
{
  int index, count=0, test, go=1;
  FILE *cfile;
  char dfilename[150];
  
  if(H_OPSYS==UNIX) sprintf(dfilename,"%s/%s/%s",ModelPath,ProjName,filename);
  else sprintf(dfilename,"%s%s:%s",ModelPath,ProjName,filename);
  if(UserInteraction) fprintf(stderr,"\nReading file %s:\n",dfilename); 
  cfile = fopen(dfilename,"r");
  if(cfile==NULL) {fprintf(stderr,"\nERROR: Unable to open data file %s\n",dfilename); fflush(stderr); Exit(1); } 
  skip_white(cfile);
  
  while(++count) {
    fscanf(cfile,"%d",&index); skip_white(cfile);
    if( index >= Npt ) {fprintf(stderr,"Data Read Error, Not enough memory for %s\n",filename); fflush(stdout);}
    test = fscanf(cfile,"%f",&tvar[index]);
    if(test==0 || test==EOF) {fprintf(stderr,"Data Read Error\n"); fflush(stdout);}
    if(skip_white(cfile)==0) {
      fprintf(stderr,"\n%d points read\n",count); fflush(stdout); 
      return;
    }
  }
  fflush(stdout);
  fclose(cfile); 
}

/********************************************************************/
#if NeedFunctionPrototypes
int scan_forward ( FILE *infile, char *tstring) 
#else
     int scan_forward ( infile, tstring)
     FILE *infile;
     unsigned char *tstring;
#endif
{
  int sLen, i, cnt=0;
  char Input_string[100], test;
  
  sLen = strlen(tstring);
  while( ( test = fgetc(infile) ) != EOF ) {
    for(i=0; i<(sLen-1); i++) 
	Input_string[i] = Input_string[i+1];
    Input_string[sLen-1] = test;
    Input_string[sLen] = '\0';
    if(++cnt >= sLen) {
      test =  strcmp(Input_string,tstring);
      if( test == 0 ) return 1;
    }
  }
  return(-1);
}

/**********************************************************************/
#if NeedFunctionPrototypes
void read_map_dims(char *filename )
#else
     void read_map_dims( filename )
     char *filename; 
#endif
{
  FILE *file;
  
  if (debug>3) { sprintf(msgStr,"Getting map dims: %s",filename); usrErr(msgStr);} /*nov98*/
  if(Lprocnum == 1) {
    if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Data/%s",ModelPath,ProjName,filename);
    else sprintf(mapFileName,"%s%s:data:%s",ModelPath,ProjName,filename);
    file = fopen(mapFileName,"r");
    if(file==NULL) { 
      fprintf(stderr,"Unable to open map header file %s.\n",mapFileName); 
      fflush(stderr); 
      Exit(0);
    }
    scan_forward(file,"ROWS=");
    fscanf(file,"%d",&gbl_size[0]);
    sprintf(msgStr,"rows = %d\n",gbl_size[0]); WriteMsg(msgStr,1);
    scan_forward(file,"COLUMNS=");
    fscanf(file,"%d",&gbl_size[1]);
    sprintf(msgStr,"cols = %d\n",gbl_size[1]); WriteMsg(msgStr,1);
    fclose(file);
  }
  broadcastInt(gbl_size);
  broadcastInt(gbl_size+1);
  s0 = gbl_size[0];
  s1 = gbl_size[1];
}

/*******************************************************************************/

#if NeedFunctionPrototypes
void init_pvar(VOIDP Map, UCHAR* mask, unsigned char Mtype,float iv) 
#else
     void init_pvar(Map,mask,Mtype,iv)
     UCHAR* mask;
     VOIDP  Map;
     unsigned char Mtype;
     float iv;
#endif
{
  int i0, i1;
  
  switch(Mtype) {
  case 'b' :	/* added double (b) for (non-map) basin array budget calcs */
    for(i0=0; i0<=numBasn; i0++) {
	((double*)Map)[i0] = iv;
      }
    break;
  case 'l' :	/* added double (l == letter "ell" ) for map arrays */
    for(i0=0; i0<=s0+1; i0++) 
      for(i1=0; i1<=s1+1; i1++) {
	if(mask==NULL) ((double*)Map)[T(i0,i1)] = iv;
	else if ( mask[T(i0,i1)] == 0 ) ((double*)Map)[T(i0,i1)] = 0;
	else ((double*)Map)[T(i0,i1)] = iv;
      }
    break;
  case 'f' :	
    for(i0=0; i0<=s0+1; i0++) 
      for(i1=0; i1<=s1+1; i1++) {
	if(mask==NULL) ((float*)Map)[T(i0,i1)] = iv;
	else if ( mask[T(i0,i1)] == 0 ) ((float*)Map)[T(i0,i1)] = 0;
	else ((float*)Map)[T(i0,i1)] = iv;
      }
    break;
  case 'i' :	case 'd' :	
    for(i0=0; i0<=s0+1; i0++) 
      for(i1=0; i1<=s1+1; i1++) {
	if(mask==NULL) ((int*)Map)[T(i0,i1)] = (int)iv;
	else if ( mask[T(i0,i1)] == 0 ) ((int*)Map)[T(i0,i1)] = 0;
	else ((int*)Map)[T(i0,i1)] = (int)iv;
      }
    break;
  case 'c' :	
    for(i0=0; i0<=s0+1; i0++) 
      for(i1=0; i1<=s1+1; i1++) {
	if(mask==NULL) ((unsigned char*)Map)[T(i0,i1)] = (unsigned char) '\0' + (int) iv;
	else if ( mask[T(i0,i1)] == 0 ) ((unsigned char*)Map)[T(i0,i1)] = '\0';
	else ((unsigned char*)Map)[T(i0,i1)] = (unsigned char) '\0' + (int) iv;
      } 
    break;
  }
}

#if NeedFunctionPrototypes
int Poisson(float mu) 
#else
     int Poisson(mu)
     float mu;
#endif
{
  int ix;
  float f0, r, Lp = 1, xf = 1, p=0;
  
  p = f0 = Exp(-mu);
  r = SMDRAND(0.0,1.0);
  
  for( ix=0; ix<500; ix++) {
    if( r < p ) return ix;
    Lp *= mu;
    if(ix>0) xf *= ix;
    p += (Lp*f0)/xf;
  }
  return ix;    
}

/* removed river stuff aug18/98 */
/***************************************************************************/
#if NeedFunctionPrototypes
int TR(int i, int j, int index) 
#else
     int TR(i, j, index) 
     int i;
     int j;
     int index;
#endif
{
  int rv=0;	
  switch(index) {
  case SE: if( j==s1+1 || i==s0+1 )  	{ rv = -1; break; } else { rv = T(i+1,j+1); break;}
  case SS: if( i==s0+1 )  		{ rv = -1; break; } else { rv = T(i+1,j); break; }
  case SW: if( j==0 || i==s0+1 ) 	{ rv = -1; break; } else { rv = T(i+1,j-1); break;}
  case WW: if( j==0) 			{ rv = -1; break; } else { rv = T(i,j-1); break;}
  case NW: if( i==0  || j==0 ) 		{ rv = -1; break; } else { rv = T(i-1,j-1); break;}
  case NN: if( i==0) 			{ rv = -1; break; } else { rv = T(i-1,j); break;}
  case NE: if( i==0 || j==s1+1) 	{ rv = -1; break; } else { rv = T(i-1,j+1); break;}
  case EE: if( j==s1+1) 		{ rv = -1; break; } else { rv = T(i,j+1); break;}
  }
  return rv;
}

/*removed CalcRiverMap aug18/98 */
/***************************************************************************/

#if NeedFunctionPrototypes
void print_loc_ave(Point3D *vt, void* Map, char Mtype, char* mName, int tIndex) 
#else
     void print_loc_ave(vt,  Map, Mtype, mName, tIndex) 
     Point3D *vt;
     void* Map;
     char Mtype; char* mName; int tIndex;
#endif
     
{
  int ix, iy, x, y, x0, y0, range, xmax, ymax, xmin, ymin, type = 11;
  float vout[4];
  double sum = 0, normCoef = 0;
  
  if(Mtype != 'f') { fprintf(stderr,"Warning: Wrong type in Loc Ave: %s(%c)\n",mName,Mtype); return; }	
  x0 = vt->x;
  y0 = vt->y;
  range = vt->z;
  x = x0 - lcl_start[0]; 
  y = y0 - lcl_start[1];
  xmin = x - range;
  xmax = x + range;
  ymin = y - range;
  ymax = y + range;
  xmax = (xmax > (s0)) ? (s0) : xmax;
  xmin = (xmin <  0  ) ?   0  : xmin;
  ymax = (ymax > (s1)) ? (s1) : ymax;
  ymin = (ymin <  0  ) ?   0  : ymin;
  
  for(ix=xmin; ix<xmax; ix++)  {
    for(iy=ymin; iy<ymax; iy++) { 
      if( ON_MAP[T(ix+1,iy+1)] ) sum += ((float*)Map)[T(ix+1,iy+1)];			
      normCoef += 1.0;
    }
  }
  
  vout[0] = sum; vout[1] = normCoef;
  
  switch (vt->type) {
     case 's' :  Combine(vout,mName,1,kSUM,tIndex); break;
     case 'a' :  Combine(vout,mName,2,kAVE,tIndex); break;
     case 'A' :  Combine(vout,mName,2,kAVECUM,tIndex); break;
     case 'S' :  Combine(vout,mName,1,kSUMCUM,tIndex); break;
  }  
}

/**********************************************************************/
#if NeedFunctionPrototypes
void PTS_Free(PTSeries* thisStruct) 
#else
     void PTS_Free(thisStruct) 
     PTSeries* thisStruct;
#endif
{
  if(thisStruct->fValue) free((char*)thisStruct->fValue);
}


/**********************************************************************/
#if NeedFunctionPrototypes
void PTS_CopyFields (PTSeries* thisStruct, PTSeries pV) 
#else
     void PTS_CopyFields (thisStruct, pV) 
     PTSeries* thisStruct; PTSeries pV;
#endif
{
  thisStruct->fX = pV.fX;
  thisStruct->fY = pV.fY;
  thisStruct->fValue = pV.fValue;
}

/**********************************************************************/
#if NeedFunctionPrototypes
void RP_SetFields (RPoint* thisStruct, int ix, int iy, float r, float value) 
#else
     void RP_SetFields (thisStruct, ix, iy, r, value) 
     RPoint* thisStruct; int ix; int iy; float r; float value;
#endif
{
  thisStruct->fX = ix;
  thisStruct->fY = iy;
  thisStruct->fr = r;
  thisStruct->fValue = value;	
}

/**********************************************************************/
#if NeedFunctionPrototypes
void RP_CopyFields (RPoint* thisStruct, RPoint* that) 
#else
     void RP_CopyFields (thisStruct, that) 
     RPoint* thisStruct; RPoint* that;
#endif
{
  thisStruct->fX = that->fX;
  thisStruct->fY = that->fY;
  thisStruct->fr = that->fr;
  thisStruct->fValue = that->fValue;
}

/**********************************************************************/

#if NeedFunctionPrototypes
void RP_SwapFields (RPoint* thisStruct, RPoint* that) 
#else
     void RP_SwapFields (thisStruct, that) 
     RPoint* thisStruct; RPoint* that;
#endif
{
  RPoint temp;
  RP_CopyFields (&temp, thisStruct);
  RP_CopyFields (thisStruct, that);
  RP_CopyFields (that, &temp);
}

/**********************************************************************/

#if NeedFunctionPrototypes
PTSeriesList* PTSL_Init(int nSlots, int format) 
#else
     PTSeriesList* PTSL_Init(nSlots, format) 
     int nSlots; int format;
#endif
{
  int i;
  PTSeriesList* thisStruct;
  thisStruct = (PTSeriesList*) malloc(sizeof(PTSeriesList));
  thisStruct->fList = (PTSeries*) malloc(sizeof(PTSeries)*nSlots);
  for(i=0; i<nSlots; i++) thisStruct->fList[i].fValue = NULL;
  thisStruct->fNSlots = nSlots;
  thisStruct->fNSlotsUsed = 0;
  thisStruct->fNptTS = 0;
  thisStruct->fFormat = format;
  return(thisStruct);
}

/**********************************************************************/

#if NeedFunctionPrototypes
RPointList * RPL_Init(int nPoints) 
#else
     RPointList * RPL_Init(nPoints) 
     int nPoints;
#endif
{
  RPointList *thisStruct;
  thisStruct = (RPointList*) malloc(sizeof(RPointList));
  thisStruct->fList = (RPoint*) malloc(sizeof(RPoint)*nPoints);
  thisStruct->fNPt = nPoints;
  thisStruct->fNPtUsed = 0;
  return thisStruct;
}

/**********************************************************************/

#if NeedFunctionPrototypes
void RPL_AddrPoint(RPointList *thisStruct, int x, int y, float r, float value) 
#else
     void RPL_AddrPoint( thisStruct, x, y, r, value) 
     RPointList *thisStruct; int x; int y; float r; float value; 
#endif
{
  RPoint* pointListtemp;
  int i, newPoints;
  
  if( thisStruct->fNPtUsed >= thisStruct->fNPt ) {
    newPoints = 20;
    thisStruct->fNPt += newPoints;
    pointListtemp = (RPoint*) malloc(sizeof(RPoint)*(thisStruct->fNPt));
    for(i=0; i<thisStruct->fNPtUsed; i++) {
      RP_CopyFields(pointListtemp+i,thisStruct->fList+i);
    }
    if( thisStruct->fList != NULL ) free((char*)thisStruct->fList);
    thisStruct->fList = pointListtemp;
  }
  
  RP_SetFields( thisStruct->fList + thisStruct->fNPtUsed, x, y, r, value);
  thisStruct->fNPtUsed++;
}

/**********************************************************************/

#if NeedFunctionPrototypes
void RPL_Sort(RPointList *thisStruct)
#else
     void RPL_Sort(thisStruct) 
     RPointList *thisStruct;
#endif
{
  int i, go=1;
  
  while(go) {
    go = 0;
    for(i=1; i<thisStruct->fNPtUsed; i++) if(thisStruct->fList[i-1].fr > thisStruct->fList[i].fr) {
      RP_SwapFields (thisStruct->fList+i-1, thisStruct->fList+i);
      go = 1;
    }
  }		
}

/**********************************************************************/
/* sept 98: added the col arg to PTS_SetFields call, did not change PTS_CopyFields or anything else */

#if NeedFunctionPrototypes
void PTSL_AddpTSeries(PTSeriesList* thisStruct, int x, int y, int index, int seriesNum, int col ) 
#else
     void PTSL_AddpTSeries(thisStruct, x, y, index, seriesNum, col) 
     PTSeriesList* thisStruct; int x; int y; int index, seriesNum, col;
#endif
{
  PTSeries* valListtemp;
  int i, newSlots;
  
  if( seriesNum >= thisStruct->fNSlots ) {
    newSlots = Max(20,thisStruct->fNSlots*0.2);
    thisStruct->fNSlots += newSlots;
    valListtemp = (PTSeries*) malloc(sizeof(PTSeries)*(thisStruct->fNSlots));
    for(i=0; i<thisStruct->fNSlotsUsed; i++) {
      valListtemp[i].fNpt = thisStruct->fNptTS;
      PTS_CopyFields(valListtemp+i,thisStruct->fList[i]);
    }
    for(i=thisStruct->fNSlotsUsed; i<thisStruct->fNSlots; i++) valListtemp[i].fValue = NULL;
    if( thisStruct->fList != NULL ) free((char*)thisStruct->fList);
    thisStruct->fList = valListtemp;
  }
  
  PTS_SetFields( thisStruct->fList + seriesNum, x, y, index, thisStruct->fFormat, col );
  thisStruct->fNSlotsUsed = seriesNum;
}

/**********************************************************************/

#if NeedFunctionPrototypes
void PTSL_Free(PTSeriesList* thisStruct) 
#else
     void PTSL_Free(thisStruct) 
     PTSeriesList* thisStruct;
#endif
{
  int i;
  if(thisStruct == NULL) return;
  for(i=0; i<thisStruct->fNSlotsUsed; i++) PTS_Free( thisStruct->fList +i );
  if( thisStruct->fList != NULL ) free((char*)thisStruct->fList);
  free((char*)thisStruct);
  thisStruct = NULL;
}

/**********************************************************************/

#if NeedFunctionPrototypes
void RPL_Free(RPointList* thisStruct) 
#else
     void RPL_Free(thisStruct) 
     RPointList* thisStruct;
#endif
{
  if(thisStruct == NULL) return;
   if( thisStruct->fList != NULL ) free((char*)thisStruct->fList);
  free((char*)thisStruct);
  thisStruct = NULL;
}

/**********************************************************************/

#if NeedFunctionPrototypes
float PTSL_GetInterpolatedValue0(PTSeriesList* thisStruct, int x, int y, int step)  
#else
     float PTSL_GetInterpolatedValue0( thisStruct, x, y, step)  
     PTSeriesList* thisStruct; int x; int y; int step;
#endif
{
  int i,  dx, dy, my_debug;
  PTSeries pV;
  float  wpow;
  float weight, InterpValue=0.0, distance=0.0; /* was double jan99*/
  int r;
  
  wpow = beta1; /* beta1 is read from Driver.parm */

/*   if(debug>2) { */
/*   	if( x == dbgPt.x && y == dbgPt.y ) my_debug = 1; */
/*   	else my_debug = 0; */
/*   } */
  
  for(i=0; i<thisStruct->fNSlotsUsed; i++) {
    pV = thisStruct->fList[i];
    dx = (pV.fX-(x+lcl_start[0]));
    dy = (pV.fY-(y+lcl_start[1]));
    r = (dx*dx + dy*dy);
    if( r == 0 ) return pV.fValue[step];
    weight = (wpow == 1.0) ? (1.0)/r : 1.0/(r*r);
        /* the pow() and double was incredibly slow (signif slowed simualtion), so removed it
           and gave the choice of only inverse distance or inverse distance**2 weighting */
    /* weight = (wpow == 1.0) ? ( (double)1.0)/r : pow(r,-wpow) ; */
    InterpValue += pV.fValue[step]*weight;
    distance += weight;
  }
  if (distance > 0) InterpValue /= distance;
  else InterpValue = (thisStruct->fList[0]).fValue[step];
  return (float) InterpValue;
}

/**********************************************************************/
#if NeedFunctionPrototypes
float PTSL_GetInterpolatedValue1(PTSeriesList* thisStruct, int x, int y, int step)  
#else
     float PTSL_GetInterpolatedValue1( thisStruct, x, y, step)  
     PTSeriesList* thisStruct; int x; int y; int step;
#endif
{
  int i,  dx, dy;
  PTSeries pV;
  RPointList *pList;
  float  wpow;
  double weight, InterpValue=0.0, distance=0.0;
  long r;
  
  pList = RPL_Init( 20 );
  wpow = beta1;/* beta1 is read from Driver.parm */
  for(i=0; i<thisStruct->fNSlotsUsed; i++) {
    pV = thisStruct->fList[i];
    dx = (pV.fX-x);
    dy = (pV.fY-y);
    r = dx*dx + dy*dy;
    if( r == 0 ) return pV.fValue[step];
    RPL_AddrPoint(pList, dx, dy, r, pV.fValue[step]);
    weight = (wpow == 1.0) ? ((double)1.0)/r : pow(r,-wpow);
    InterpValue += pV.fValue[step]*weight;
    distance += weight;
  }
  RPL_Sort(pList);
  RPL_Free(pList);
  return (float) InterpValue;
}

/**********************************************************************/

#if NeedFunctionPrototypes
void PTSL_ReadLists( PTSeriesList* thisStruct,  char *ptsFileName, int index, float* timeStep, int* nPtTS, int col ) 
#else
     void PTSL_ReadLists( thisStruct,  ptsFileName, index, timeStep, nPtTS, col ) 
     PTSeriesList* thisStruct; char *ptsFileName; int index; int* nPtTS, col;
     float* timeStep;
#endif
{
  char pathname[150], infilename[60], ss[201], ret = '\n';
  FILE* cfile;
  int ix, iy, tst, sCnt=0;
  
  if( Lprocnum == 1 ) {
    if(H_OPSYS==UNIX) sprintf(mapFileName,"%s/%s/Data/%s.pts",ModelPath,ProjName,ptsFileName);
    else sprintf(mapFileName,"%s%s:Data:%s.pts",ModelPath,ProjName,ptsFileName); 
    cfile = fopen(mapFileName,"r");
    if(cfile==NULL) {fprintf(stdout,"\nERROR: Unable to open timeseries file %s\n",mapFileName); Exit(1); }
    else { sprintf(msgStr,"\nReading file %s\n",mapFileName); WriteMsg(msgStr,1); } 
    if (debug > 2) {sprintf(msgStr,"Reading %s timeseries, column %d",mapFileName, col); usrErr(msgStr);}
    
  
/* sept98: modified usrErr message to , */
        /* removed fscanf(cfile,"Data Directory = %s",pathname); */
    fgets(ss,200,cfile); /* skip header line */
  }
  while(1) {
    if( Lprocnum == 1 ) {
      tst = fscanf(cfile,"%d",&ix);
      if( tst > 0  ) {
	fscanf(cfile,"%d",&iy); 
	tst = fscanf(cfile,"%s",infilename); 
/* sept98:   modified data path */
	sprintf(mapFileName,"%s/%s/Data/%s",ModelPath,ProjName,infilename);
      }
    }
    broadcastInt(&tst); 
    if(tst<1) break;
    broadcastInt(&ix); 
    broadcastInt(&iy); 
    PTSL_AddpTSeries(thisStruct, ix, iy, index, sCnt, col);
    sCnt++;
  }
  if( Lprocnum == 1 ) fclose(cfile);  
  *nPtTS = gNPtTs;
  *timeStep = gTS;
  
} 

/**********************************************************************/


#if NeedFunctionPrototypes
void PTSL_CreatePointMap(PTSeriesList* pList,void* Map, unsigned char Mtype,int step, float scale)
#else
     void PTSL_CreatePointMap( pList, Map, Mtype, step, scale)
     PTSeriesList* pList; void* Map; unsigned char Mtype; int step; float scale;
#endif
{
  int i0, i1;
  
  switch(Mtype) {
  case 'f' :	
    for(i0=0; i0<=s0+1; i0++) 
      for(i1=0; i1<=s1+1; i1++) 
	((float*)Map)[T(i0,i1)] = (ON_MAP[T(i0,i1)]) ? PTSL_GetInterpolatedValue0(pList,i0,i1,step)*scale : 0.0 /*was this value (jan99) -0.012 */; 
    break;
  case 'i' :	case 'd' :	
    for(i0=0; i0<=s0+1; i0++) 
      for(i1=0; i1<=s1+1; i1++) 
	((int*)Map)[T(i0,i1)] = (int)  ( (ON_MAP[T(i0,i1)]) ? PTSL_GetInterpolatedValue0(pList,i0,i1,step)*scale : 0 );
    break;
  case 'c' :	
    for(i0=0; i0<=s0+1; i0++) 
      for(i1=0; i1<=s1+1; i1++) 
	((unsigned char*)Map)[T(i0,i1)] = (unsigned char) '\0' + (int)  ( (ON_MAP[T(i0,i1)]) ? PTSL_GetInterpolatedValue0(pList,i0,i1,step)*scale : 0 );
    break;
  }
}


/*****************************************************************************/

/************************************************************************/
/*																		*/
/*	Routine:	dec_1b, dec_2b, dec_4b									*/
/*																		*/
/*	Read a one, two, or four byte signed value from the specified		*/
/*	buffer and return the resulting value.  The buffer pointer is		*/
/*	advanced past the data which was read.								*/
/*																		*/
/*	Parameters:															*/
/*		"sptr"	A pointer to pointer to UCHAR (the buffer).				*/
/*																		*/
/*	Returns:	The resulting value.									*/
/*																		*/
/************************************************************************/

int
  dec_1b(sptr)
UCHAR			**sptr;
{
  return ((int) *(*sptr)++);
}

int
  dec_2b(sptr)
UCHAR			**sptr;
{
  int			rval;
  
  rval = *(*sptr)++;
  rval |= (*(*sptr)++ << 8);
  return (rval);
}

SLONG
  dec_4b(sptr)
UCHAR			**sptr;
{
  SLONG			rval;
  
  rval = (SLONG) *(*sptr)++;
  rval |= (((SLONG) *(*sptr)++) << 8);
  rval |= (((SLONG) *(*sptr)++) << 16);
  rval |= (((SLONG) *(*sptr)++) << 24);
  return (rval);
}


/************************************************************************/
/*									*/
/*	Routine:	enc_str, enc_strN						*/
/*									*/
/*	Place a "\0" terminated string into the specified buffer and	*/
/*	advance the buffer pointer past the placed object.		*/
/*									*/
/*	Parameters:							*/
/*		"sptr"	A pointer to pointer to UCHAR (the buffer).	*/
/*		"s"	The string to place in the buffer.		*/
/*		 "N"  Max number of characters.							*/
/*	Returns:	None.						*/
/*									*/
/************************************************************************/

VOID
  enc_str(sptr,s)
UCHAR			**sptr;
register STRING		s;
{
  register STRING		cptr;
  
  for(cptr = (STRING) *sptr; *s != '\0';) *cptr++ = *s++;
  *cptr++ = '\0';
  *sptr = (UCHAR *) cptr;
}

VOID
  enc_strN(sptr,s,N)
UCHAR			**sptr;
register STRING		s;
int N;
{
  register STRING		cptr;
  register int i=0;
  
  for(cptr = (STRING) *sptr; *s != '\0';) { *cptr++ = *s++; if(i++ == N-1) break; }
  *cptr++ = '\0';
  *sptr = (UCHAR *) cptr;
}

/************************************************************************/
/*									*/
/*	Routine:	enc_2b, enc_4b					*/
/*									*/
/*	Place a two or four byte signed value into the specified buffer	*/
/*	and advance the buffer pointer past the placed object.		*/
/*									*/
/*	Parameters:							*/
/*		"sptr"	A pointer to pointer to UCHAR (the buffer).	*/
/*		"value"	The value to place in the buffer.		*/
/*									*/
/*	Returns:	None.						*/
/*									*/
/************************************************************************/

VOID
  enc_Nb1(sptr,value,bytes)
UCHAR		**sptr;
SLONG		value;
int         bytes;
{
  switch(bytes) {
  case 1:
    *(*sptr)++ = value;
    break;
  case 2:
    *(*sptr)++ = value;
    *(*sptr)++ = (value >> 8);
    break;
  case 3:
    *(*sptr)++ = value;
    *(*sptr)++ = (value >>= 8);
    *(*sptr)++ = (value >> 8);
    break;
  case 4:
    *(*sptr)++ = value;
    *(*sptr)++ = (value >>= 8);
    *(*sptr)++ = (value >>= 8);
    *(*sptr)++ = (value >> 8);
    break;
  }
}

VOID
  enc_Nb(sptr,value,bytes)
UCHAR		**sptr;
SLONG		value;
int         bytes;
{
  UCHAR tmp[4];
  switch(bytes) {
  case 1:
    *(*sptr)++ = value;
    break;
  case 2:
    *(*sptr)++ = (value >> 8);
    *(*sptr)++ = value;
    break;
  case 3:
    tmp[0] = value;
    tmp[1] = (value >>= 8);
    tmp[2] = (value >> 8);
    *(*sptr)++ = tmp[2];
    *(*sptr)++ = tmp[1];
    *(*sptr)++ = tmp[0];
    break;
  case 4:
    tmp[0] = value;
    tmp[1] = (value >>= 8);
    tmp[2] = (value >>= 8);
    tmp[3] = (value >> 8);
    *(*sptr)++ = tmp[3];
    *(*sptr)++ = tmp[2];
    *(*sptr)++ = tmp[1];
    *(*sptr)++ = tmp[0];
    break;
  }
}

VOID
  enc_2b(sptr,value)
UCHAR			**sptr;
int			value;
{
  *(*sptr)++ = value;
  *(*sptr)++ = (value >> 8);
}

VOID
  enc_3b(sptr,value)
UCHAR			**sptr;
int			value;
{
  *(*sptr)++ = value;
  *(*sptr)++ = (value >>= 8);
  *(*sptr)++ = (value >> 8);
}

VOID
  enc_4b(sptr,value)
UCHAR			**sptr;
SLONG			value;
{
  *(*sptr)++ = value;
  *(*sptr)++ = (value >>= 8);
  *(*sptr)++ = (value >>= 8);
  *(*sptr)++ = (value >> 8);
}

VOID swap_bytes(value)
     void* value;
{
  register UCHAR ch;
  register UCHAR *vPtr = (UCHAR*)value;
  ch = vPtr[0];
  vPtr[0] = vPtr[3];
  vPtr[3] = ch;
  ch = vPtr[1];
  vPtr[1] = vPtr[2];
  vPtr[2] = ch;
}

VOID swap_bytesN(value,size)
     void* value;
     int size;
{
  register UCHAR ch;
  register int i,j;
  register UCHAR *vPtr = (UCHAR*)value;
  for(i=0; i<size; i++) {
    j = i*4;
    ch = vPtr[j];
    vPtr[j] = vPtr[j+3];
    vPtr[j+3] = ch;
    ch = vPtr[j+1];
    vPtr[j+1] = vPtr[j+2];
    vPtr[j+2] = ch;
  }
}

#if NeedFunctionPrototypes
void fatal(char *msg) 
#else
void fatal(msg) 
char *msg;
#endif
{
  printf("%s",msg);
  fflush(stdout);
  Exit(9);
}

#if NeedFunctionPrototypes
void setFlag(ViewParm* vp, UINT mask, int value )
#else
void setFlag(vp, mask, value )
ViewParm* vp; UINT mask; int value;
#endif
 { 
  if(value) vp->flags |= mask; else vp->flags &= ~mask;
}

#if NeedFunctionPrototypes
int getFlag(ViewParm* vp, UINT mask) 
#else
int getFlag(vp, mask) 
ViewParm* vp; UINT mask; 
#endif
{ 
  if( vp->flags & mask ) return 1; else return 0;
}

#if NeedFunctionPrototypes
void setPrecision(ViewParm* vp, int value )
#else
void setPrecision(vp, value )
ViewParm* vp; int value;
#endif
{
  if(value/3) vp->flags |= PMASK2; else vp->flags &= ~PMASK2;
  if((value-1)%2) vp->flags |= PMASK1; else vp->flags &= ~PMASK1;
}

#if NeedFunctionPrototypes
int getPrecision(ViewParm* vp)
#else
int getPrecision(vp)
ViewParm* vp;
#endif
 { 
  int rv = 1;
  if(vp->flags & PMASK2) rv +=2;
  if(vp->flags & PMASK1) rv +=1;
  return rv;
}

#if NeedFunctionPrototypes
int check_for (char *s0, char *s1, int start, int  cs, int rp)
#else
int check_for (s0,s1,start,cs,rp)
char *s0; char *s1; int start; int  cs; int rp;
#endif
{
  /*  Check for occurrences of string s1 in string s0 	*/
  /*  after position start. Return -1 if not found.  		*/
  /* if cs = CASE -> case sensitive, cs = NOCASE, not case sens. 	*/
  /* if rp = BEG -> return position of beginning of s1, 	*/
  /* 			otherwise return position of (next char following the) end of s1 		*/
  int i, j=0, k=-1, Len1 = strlen(s1), Len0 = strlen(s0);
  char t1, t2;
  
  while(k<0) {
    k=0;
    for(i=start; i< Len0; ++i) { 
      t1 = s0[i];
      t2 = s1[j];
      if(cs==NOCASE) { t1 = tolower(t1); t2 = tolower(t2); }   
      if (t1 == t2)  j++;
      else {j=0; k=0;}
      if(j==Len1) { k=1; break; }
    }
  }
  if(k<=0) 		return(-1);
  else if(rp==BEG) 	return(i-Len1+1);
  else      		return(i+1);
}

float
Normal(mean, sd)
	float mean, sd ;
{
    int table_loc ;
    double rand_num ;
    float sign ;
    float interval = .1 ;
    int n_interval = 40 ;
    float high, low ;
    float return_val = 0.0;

    sign = SMDRAND(0.0, 1.0) ;
    sign = (sign < .5 ? -1 : 1) ;
    rand_num = SMDRAND(.5, 1.0);
    low = gRTable[0] ;
    for (table_loc=1; table_loc<n_interval; table_loc++)
    {
        high = gRTable[table_loc] ;
        if (high > rand_num + .5)
        {
            return_val = mean + sd * (sign  * interval * (table_loc - 1 +
                                                          (rand_num+.5-low)/(high-low))) ;
            return(return_val) ;
        }
        low = high ;
    }
    return(return_val) ;
}

int isInteger (char *target_str) {

	int i=-1,first_num=0;
	char ch;

	while( (ch=target_str[++i]) != '\0' ) { 
			if( isdigit(ch) ) first_num=1;
			if( (ch=='-' || ch=='+') && first_num ) return(0);  
			if( !( isspace(ch) || isdigit(ch) || ch=='-' || ch=='+') ) return(0);  
	}
	return(1);	  	
}

int isFloat (char *target_str) {

	int i=-1,first_num=0;
	char ch;

	while( (ch=target_str[++i]) != '\0' ) { 
			if( isdigit(ch) ) first_num=1;
			if( (ch=='-' || ch=='+') && first_num ) return(0);  
			if( !( isspace(ch) || isdigit(ch) || ch=='-' || ch=='+' || ch=='.' || toupper(ch) == 'E') ) return(0);  
	}
	return(1);	  	
}

/* returns Julian date */
/* no longer used jan99 - replaced by julian date/calendar system */
#if NeedFunctionPrototypes
int Jdate_calc ( char yyyy[5],char mm[3],char dd[3] ) 
#else
int Jdate_calc (yyyy, mm, dd)
char yyyy[5], mm[3], dd[3];
#endif

{
    int yr,mo,da;
    
/* the Jdate calc comes from Kochan 1994, Programming in ANSI C, valid for dates
    from Jan 1, 1901 onward (subtracted 694404 from that formula to make 01/01/1901
    equal to julian day 0) */
    yr = atoi(yyyy);
    mo = atoi(mm);
    da = atoi(dd);

    Jdate = (1461 * (( mo <= 2) ? (yr - 1) : yr) / 4
             + 153 * ((mo <= 2) ? (mo + 13) : (mo +1)) / 5 + da)-694404;
    return (Jdate);
}





/* The two functions for going to/from julianDay/CalendarDate
   were (unmodified) from HSM's /vol/hsm/src/libs/xmgr_julday/ directory.
*/

/*
 * return the Julian day + hms as a real number
 */

/*
** Takes a date, and returns a Julian day. A Julian day is the number of
** days since some base date  (in the very distant past).
** Handy for getting date of x number of days after a given Julian date
** (use jdate to get that from the Gregorian date).
** Author: Robert G. Tantzen, translator: Nat Howard
** Translated from the algol original in Collected Algorithms of CACM
** (This and jdate are algorithm 199).
*/
double julday(int mon, int day, int year, int h, int mi, double se)
{
    long m = mon, d = day, y = year;
    long c, ya, j;
    double seconds = h * 3600.0 + mi * 60 + se;

    if (m > 2)
	m -= 3;
    else {
	m += 9;
	--y;
    }
    c = y / 100L;
    ya = y - (100L * c);
    j = (146097L * c) / 4L + (1461L * ya) / 4L + (153L * m + 2L) / 5L + d + 1721119L; 
    if (seconds < 12 * 3600.0) {
	j--;
	seconds += 12.0 * 3600.0;
    } else {
	seconds = seconds - 12.0 * 3600.0;
    }
    return (j + (seconds / 3600.0) / 24.0);
}

/* Julian date converter. Takes a julian date (the number of days since
** some distant epoch or other), and returns an int pointer to static space.
** ip[0] = month;
** ip[1] = day of month;
** ip[2] = year (actual year, like 1977, not 77 unless it was  77 a.d.);
** ip[3] = day of week (0->Sunday to 6->Saturday)
** These are Gregorian.
** Copied from Algorithm 199 in Collected algorithms of the CACM
** Author: Robert G. Tantzen, Translator: Nat Howard
*/
void calcdate(double jd, int *m, int *d, int *y, int *h, int *mi, double *sec)
{
    static int ret[4];

    long j = jd;
    double tmp, frac = jd - j;

    if (frac >= 0.5) {
	frac = frac - 0.5;
	j++;
    } else {
	frac = frac + 0.5;
    }

    ret[3] = (j + 1L) % 7L;
    j -= 1721119L;
    *y  = (4L * j - 1L) / 146097L;
    j = 4L * j - 1L - 146097L * *y;
    *d  = j / 4L; 
    j = (4L * *d + 3L) / 1461L;
    *d = 4L * *d + 3L - 1461L * j; 
    *d = (*d + 4L) / 4L;
    *m = (5L * *d - 3L) / 153L;
    *d = 5L * *d - 3 - 153L * *m; 
    *d = (*d + 5L) / 5L; 
    *y = 100L * *y + j;
    if (*m < 10)
	*m += 3;
    else {
	*m -= 9;
	*y += 1;
    }
    tmp = 3600.0 * (frac * 24.0);
    *h = (int) (tmp / 3600.0);
    tmp = tmp - *h * 3600.0;
    *mi = (int) (tmp / 60.0);
    *sec = tmp - *mi * 60.0;
}

int dayofweek(double j)
{
    j += 0.5;
    return (int) (j + 1) % 7;
}

/*******************************************************/


