/****************
* Generic Driver for ELM *
*****************


This is the code which drives the unit model on
the chosen platform.
Succession and the horizontal flows (incl. water management) are called 
from the UnitMod.c.  See that source for ELM info.

added date information (initial date, Julian dates etc.)
aug-nov98 - added more runtime parms, modified console output to user 
jan99 added OutputPath, modified the method of generating output  
*/

#include "globals.h"

int plus_x, plus_y, minus_x, minus_y;
int lcl_size[2], lcl_start[2], gridSize;
struct nodenv env;
void setup_transputers();

/* SME Simulation and IO Parameters   *******************************/
FILE *binfile;
float TIME, dt=1,  max_level;
SeriesParm pSeries[MAX_PTSERIES];
ViewParm *view = NULL;
Point2D dbgPt;
int void_value, out_step, viz_step, N_iter, color_map, istep=-1, nArg; /*removed fNs aug18/98 */
int  NSector, iSector[MAX_SECTOR];
int s0, s1, gbl_size[2], seed, debug, gSLen[MAX_NHAB], viewSize=0;
int procnum, Lprocnum, nprocs[2], nproc, recpnum[2], tramType, tramNum[2];
float  base_flux_rate, alpha1, alpha2, alpha3;
float beta1, beta2, beta3;
char *ModelPath, *OutputPath, outpath[120], *ProjName, *DriverPath;  /*jan99*/

/* For model-specific calcs etc. */
float CELL_SIZE;
char modelName[20], modelVers[10];    /* this is the ELM/CALM/etc name, version number (string such as v.2.1) */
int CALMrun = 0, ELMrun=0; /* these take the ELM or CALM name and indicate which one is running */
int ESP=0; /* this flag indicates whether the ELM's Everglades Settling of Phosphorus Module is running */
int PosAn=0; /* this flag indicates whether we're running in Position Analysis mode */
int hyd_iter; /* max number of horiz iterations per whole-model time step (dt) */
/* time step for horiz surface, groundwater, and canal iterations (dt/hyd_iter, dt/hyd_iter/2.0) */
float sfstep, gwstep, canstep; 
float avgIntvl; /* day (not iteration) interval for recurring averages etc */
char initDateRead[15], Re_initDateRead[15]; 
int yr_in, mo_in, da_in, hr_in=0, mi_in=0, se_in=0; /* initial calendar and time info */
int mo_R_in, da_R_in; /* re-initialization month and day */
int yr[2], mo[2], da[2], hr[2], mi[2];  /* global,  year, month, day, hour, minutes */
int yr_end[2], mo_end[2], da_end[2];  /* ending year, month, day */
double se[2];  /* global, seconds (only due to using an algorithm with such detail) */

double Jdate, Jdate_init, Jdate_end; /* Julian days since "a few epochs ago", and Jdays on sim start/end */
int numday; /* number of days of simulation (incl. start day) */
float celWid,sq_celWid; /* cell width, square root of cell width, used in number of hydro calcs jan99*/
int WatMgmt; 
int HabSwitch; 
char SimAlt[20], SimModif[20]; /* simulation scenario/alterative, and scenario modifier */
char *run_start_date, *run_start_time; /* start date/time of simulation */

time_t dat0, *tp, tEnd, tTotElap;
const time_t  *tStart;


char msgStr[MAX_MSG_SIZE];
UCHAR* gTemp = NULL;  
int gTempSize = 0;
int gOutStart, gOutEnd;
int gAnimateIndex = 0;
float gRTable[] =
	{.5000,.5398,.5793,.6179,.6554,.6915,.7257,.7580,.7881,.8159,
	 .8413,.8643,.8849,.9032,.9192,.9332,.9452,.9554,.9641,.9713,
	 .9773,.9821,.9861,.9893,.9918,.9938,.9953,.9965,.9974,.9981,
	 .9987,.9990,.9993,.9995,.9997,.9998,.9998,.9999,.9999,1.00} ;

void get_parmf(); 
void open_run_files();
void open_out_files();
void setup();

int main(argc, argv)
int argc;
char *argv[];
{
    int i, increm, iw=0, iw1=0, irun=0, go=1; 
    ViewParm  *view;	 	/* jan99 */
    char ic;
    char *testgarb;
    struct tm *now;
    
    local_setup(argc, argv);	


/*      dat0=time(tp); */
/*       tStart = time(tp);  */
/*      now = localtime(tStart); */
     
/*     testgarb=ctime(tStart) ; */
/*    fprintf("%s",testgarb ); */
    
     /*timbeg_(); */
    run_start_date = __DATE__ ;
    run_start_time = __TIME__ ; 
   

    setup();    
    usrErr("Allocating Memory.");
    alloc_memory();

    usrErr0("Reading GlobalParms; ");
    read_model_parameters();


    usrErr("Reading spatial data...");
    init_vars(1);
    usrErr("Done getting spatial data.");

    while(go) {
        sync_processors();

        go = 0; /* just here to halt re-execution of model (while(go) ) */

        usrErr("Reading Model.outList");
            /* read_output_parmsOLD(); */  
        view = read_output_parms();   /* jan99*/
        
        open_out_files(++irun); /* now Driver1.out is opened for writing general messages
                                 (warnings, errors, and data depending on debug level) */

        usrErr0("Initializing model...");
        init_vars(0);
        usrErr("Done.");

        usrErr0("Dynamic ecological modules:\n\t");
        for (i=0; i<NSector; i++) {sprintf(msgStr, "%d, ", iSector[i]);usrErr0(msgStr);}
                
        if (PosAn)  {
            sprintf(msgStr, "\n\t***running %2d/%2d Position Analysis*** ",mo_R_in,da_R_in); usrErr0(msgStr);
            PosAn=2; /* now that we've initialized the run, increment the PosAn flag to indicate that */
        }
        if (ESP)  usrErr0("\n\t***running ESP*** ");
        if (WatMgmt)  usrErr0("\n\twith spatial water managment 'on' ");
        else usrErr0("\n\twith spatial water managment 'off' ");
        if (HabSwitch)  usrErr("and succession 'on'.");
        else usrErr("and succession 'off'.");
                
        sprintf(msgStr,"\n*** Running simulation from %d/%d/%d to %d/%d/%d ***",
               yr_in,mo_in,da_in, yr_end[0],mo_end[0],da_end[0] ); usrErr(msgStr);
/***************/
            /* temporal loop for driving model */
        for(istep=0; istep<N_iter; istep++) {
            TIME = istep*dt;
            Jdate = Jdate_init+TIME; /*  increment the julian day counter */
            calcdate( Jdate, mo, da, yr, hr, mi, se); /* get the calendar date info from the julian date */

            if (PosAn)
                if ( (mo[0] == mo_R_in) && (da[0] == da_R_in) ) {
                    usrErr0("Re-initializing.  Reading spatial data...");
                    init_vars(1); /* UnitMod.c - read in the spatial data initial conditions */
                    usrErr0("Initializing model...");
                    init_vars(0); /* UnitMod.c - re-initialize the variables */
                    usrErr("Done re-initializing.");
                }
            
            if(Lprocnum==1)
                if(debug >2) {
                    sprintf(msgStr,"---------------------------------------Iteration = %d\n",istep);
                    WriteMsg(msgStr,1); usrErr(msgStr); 
                }
                else
                {  /* sprintf(msgStr,"\r%d:   ",istep);  usrErr0(msgStr); */

                    sprintf(msgStr,"\r%d/%2d/%2d:   ",yr[0],mo[0],da[0] ); usrErr0(msgStr); /* calendar date */

                }

                        
            for(i=0; i<NSector; i++) { /* call eco/hydro modules */
                if(Lprocnum==1)
                    if(debug >2) {
                    sprintf(msgStr,"Running cell dyn %d of %d\n",iSector[i],NSector); WriteMsg(msgStr,1); usrErr(msgStr); 
                }

                call_cell_dyn(iSector[i],istep);
            }
			
            if( (istep >= gOutStart && istep < gOutEnd) || istep == 0 ) {
                if(Lprocnum==1)  
                    if(debug >2) {
                        usrErr(""); /* carriage return following hydstep iterations */
                        sprintf(msgStr,"(%d)Generating Output",procnum); WriteMsg(msgStr,1); usrErr(msgStr); 
                    }
                gen_output(istep, view);  /* gen_outputOLD(istep); */
            }
            
            if (FMOD(TIME,180) == 0 ) { /* send to disk every half-year (in case of program halt) */
                if (istep == 0) open_point_lists(pSeries,MAX_PTSERIES); /* open point timeseries files */
                send_point_lists2(pSeries,MAX_PTSERIES); /* second format, multiple files, columns */
                /* send_point_lists(pSeries,MAX_PTSERIES);  original format, single column */
            }
        }
/***************/
        send_point_lists2(pSeries,MAX_PTSERIES); /* second format, multiple files, columns */
        /* send_point_lists(pSeries,MAX_PTSERIES);  original format, single column */
    
      /*   timend_(); */
/* print time stamp of simulation start to Driver1.out debug file */
            sprintf(msgStr,"Simulation started on %s, %s",run_start_date, run_start_time); WriteMsg(msgStr,1);
    

    }
    

return 0;
}

/*****************************************************************************/

void setup()
{
  int i;
  for(i=0; i<MAX_PTSERIES; i++)  pSeries[i].data = NULL;
  setup_platform();
  set_env_vars();
 /* open_out_files(0); call this after reading the output path in get_parmf */
  get_parmf(); 
  get_map_dims();
  setup_grid();
  local_init();
}

/****************************************************************************/


void get_parmf () {

    int i=0, stop=0;
    unsigned char ch;
    FILE *infile;
    char filename[120], ss[120]; 
    
    if(Lprocnum==1) {
        if (H_OPSYS == UNIX )
            sprintf(filename,"%s/%s/RunParms/Driver.parm",ModelPath,ProjName);
        else
            sprintf(filename,"%s%s:RunParms:Driver.parm",ModelPath,ProjName);
        infile = fopen(filename,"r");
        if(infile==NULL) { fprintf(stderr,"Error, can't open file %s",filename); Exit(0); }
    }

     
    fgets(ss,120,infile);
    sscanf(ss,"%s",&outpath);    
    OutputPath = &outpath; /* path for all output */
    open_out_files(0); /*jan99*/
    sprintf(msgStr, "Output Path = %s", OutputPath); usrErr(msgStr); WriteMsg(msgStr,1);

        /* start date  */
    fgets(ss,120,infile);
    sscanf(ss,"%s",&initDateRead); /* read in as yyyy/mm/dd format */

    if(Lprocnum==1) { sprintf(msgStr,"initDateRead=%s\n",&initDateRead); WriteMsg(msgStr,1); } 
    sscanf(initDateRead, "%4d/%2d/%2d,",&yr_in,&mo_in,&da_in); /* starting date of sim */

        /* julian day, returns a double (args = mon, day, yr, hrs,min,secs) */
    Jdate_init = julday(mo_in, da_in, yr_in, hr_in, mi_in, se_in); 

        /* re-initialization date  */
    fgets(ss,120,infile);
    sscanf(ss,"%s",&Re_initDateRead); /* read in as mm/dd format */

    if(Lprocnum==1) { sprintf(msgStr,"Re_initDateRead=%s\n",&Re_initDateRead); WriteMsg(msgStr,1); } 
    sscanf(Re_initDateRead, "%2d/%2d,",&mo_R_in,&da_R_in); /* re-initialize month/day */

    if (mo_R_in>0) PosAn=1; /* in position analysis mode, we re-initialize every year on same month/day */

    fgets(ss,120,infile);
    sscanf(ss,"%s",&modelName);    
    sprintf(msgStr, "Model Name= %s", modelName); usrErr(msgStr); WriteMsg(msgStr,1);

    if (strcmp(modelName,"ELM") == 0) {
        ELMrun = 1;
    }
    else if (strcmp(modelName,"CALM") == 0) {
        CALMrun = 1;
    }
    else { sprintf (msgStr,"Sorry - the %s model has not been configured for canal basins!\nPlease define the model's canal basins in WatMgmt.c.\n",
                    modelName); exit (-1);}

    getString(infile,"Model version=",modelVers); /* model version number (eg., v.2.1) */
    if(Lprocnum==1) { sprintf(msgStr,"Model version=%s\n",&modelVers); WriteMsg(msgStr,1); } 

    getFloat(infile,"CellArea=",&CELL_SIZE);
    if(Lprocnum==1) { sprintf(msgStr,"CellArea=%f\n",CELL_SIZE); WriteMsg(msgStr,1); } 
    celWid = sqrt(CELL_SIZE); /* cell width, used in number of hydro calcs */
    sq_celWid = sqrt(celWid); /* square root of cell width, used in number of hydro calcs */

    getInt(infile,"N_iter=",&N_iter);
    if(Lprocnum==1) { sprintf(msgStr,"N_iter=%d\n",N_iter); WriteMsg(msgStr,1); } 

    getFloat(infile,"avgIntvl=",&avgIntvl);
    if(Lprocnum==1) { sprintf(msgStr,"avgIntvl=%f\n",avgIntvl); WriteMsg(msgStr,1); } 

    getFloat(infile,"flux_parms=",&alpha1);
    getFloat(infile,NULL,&alpha2);
    getFloat(infile,NULL,&alpha3);
    if(Lprocnum==1) { sprintf(msgStr,"flux parms=\t(%f,%f,%f)\n",(double)alpha1,(double)alpha2,(double)alpha3); WriteMsg(msgStr,1); } 
    getFloat(infile,"global_parms=",&beta1);
    getFloat(infile,NULL,&beta2);
    getFloat(infile,NULL,&beta3);
    if(Lprocnum==1) { sprintf(msgStr,"global parms=\t(%f,%f,%f)\n",(double)beta1,(double)beta2,(double)beta3); WriteMsg(msgStr,1); } 
    getInt(infile,"color_map=",&color_map);
    getInt(infile,"seed=",&seed);
    if(Lprocnum==1) { sprintf(msgStr,"seed=%d\n",seed); WriteMsg(msgStr,1); } 
    getFloat(infile,"dt=",&dt);
    if(Lprocnum==1) { sprintf(msgStr,"dt=%f\n",(double)dt); WriteMsg(msgStr,1); } 
    getInt(infile,"hyd_iter=",&hyd_iter); 
    if(Lprocnum==1) { sprintf(msgStr,"hyd_iter=%d\n",hyd_iter); WriteMsg(msgStr,1); } 
        /* overland cell-cell flow is at smallest time step,
           others called every other hyd_iter
           and thus have double the time step */
    sfstep = dt/hyd_iter; /* time step for cell-cell overland flows */
    gwstep = dt/(hyd_iter/2); /* time step for cell-cell ground water flows */
        /* canal run every step*/
    canstep = dt/(hyd_iter/* /2 */ ); /* time step for canal flows */

    Jdate_end = (Jdate_init + N_iter * dt)-1; /* ending Julian day */
    numday = Jdate_end - Jdate_init + 1; /* number of days of simulation */

    calcdate( Jdate_end, mo_end, da_end, yr_end, hr, mi, se); /* get the ending calendar date info from the julian date */
    if(Lprocnum==1) { sprintf(msgStr,"ending date=%d/%d/%d\n",yr_end[0],mo_end[0],da_end[0]); WriteMsg(msgStr,1); } 
 

    getInt(infile,"debug=",&debug);
    if(Lprocnum==1) { sprintf(msgStr,"debug=%d\n",debug); WriteMsg(msgStr,1); } 
    getInt(infile,"debug_point=",&dbgPt.x);
    getInt(infile,NULL,&dbgPt.y);
    if(Lprocnum==1) { sprintf(msgStr,"debug point= (%d,%d)\n",dbgPt.x,dbgPt.y); WriteMsg(msgStr,1); } 
    getFloat(infile,"base_flux_rate=",&base_flux_rate);
    if(Lprocnum==1) { sprintf(msgStr,"flux_rate=%f\n",(double)base_flux_rate); WriteMsg(msgStr,1); } 
    getInt(infile,"Output(Start,End)=",&gOutStart); getInt(infile,NULL,&gOutEnd); 
    if(Lprocnum==1) { sprintf(msgStr,"Output Start,End= %d,%d\n",gOutStart,gOutEnd); WriteMsg(msgStr,1); } 
    getInt(infile,"HabSwitch=",&HabSwitch); /* flag to turn on habitat switching */
    if(Lprocnum==1) { sprintf(msgStr,"HabSwitch=%d\n",HabSwitch); WriteMsg(msgStr,1); } 
    getInt(infile,"WatMgmt=",&WatMgmt); /* flag to turn on canal/water management */
    if(Lprocnum==1) { sprintf(msgStr,"WatMgmt=%d\n",WatMgmt); WriteMsg(msgStr,1); } 
    getString(infile,"Scenario=",SimAlt); /* simulation's scenario/alternative */
    if(Lprocnum==1) { sprintf(msgStr,"SimAlt=%s\n",&SimAlt); WriteMsg(msgStr,1); } 
    getString(infile,"Scenario modifier=",SimModif); /* simulation's scenario/alternative & modifier */
    if(Lprocnum==1) { sprintf(msgStr,"SimModif=%s\n",&SimModif); WriteMsg(msgStr,1); } 

    if(Lprocnum == 1) {
  	/* skip_white(infile); jan98 */
  	scan_forward(infile,"Sectors="); i=0; stop=0;
        while(1) {
	    skip_white(infile);
            ch=fgetc(infile);
            if( isdigit(ch) ) ungetc(ch,infile);
            else {
                switch (ch) {
                    case ';':  NSector = i; stop=1; break;
                    case ',':  skip_white(infile); break;
                    /* case EOF:  fprintf(stderr,"Read Error in get_parmf sector\n"); Exit(0); */ /*jan99*/   
                }
            }
            if(stop) break;
            else fscanf(infile,"%d",&iSector[i++]);
                /* sector 13 is the Everglades Settling of Phosphorus (ESP) model - this sets the ESP flag*/
            if (iSector[i-1] == 13) ESP=1;
            
	}
	fclose(infile);  
    }
    broadcastInt(&NSector);
    if(Lprocnum==1) { sprintf(msgStr,"\n(%d) NSector = %d: Sectors=",procnum,NSector); WriteMsg(msgStr,1); } 
    for(i=0; i<NSector; i++) {
  	broadcastInt(&iSector[i]);
	if(Lprocnum==1) { sprintf(msgStr,"(%d:%d)",i,iSector[i]); WriteMsg(msgStr,1); }  
    }
    for(i=0; i<MAX_PTSERIES; i++) if(pSeries[i].data) { free((char*)pSeries[i].data);  pSeries[i].data = NULL; }
}
/****************************************************************************/



