/*  
global header for ELM
*/

#include <ctype.h> 
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "custom.h"
#include "tools.h"

#define ABS(x) (((x)>=0) ? (x) : -(x))
#define Abs(x) fabs((double)x)
#define Cos(x) cos((double)x)
#define Sin(x) sin((double)x)
#define Tan(x) tan((double)x)
#define Atan(x) atan((double)x)
#define Arctan(x) atan((double)x)
#define CELLSIZE CELL_SIZE
#define Exp(x) exp((double)x)
#define Logn(x) log((double)x) 
#define Mod(x,y) FMOD(x,y)
#define Max(x,y) (((x)>(y))?(x):(y))
#define Min(x,y) (((y)>(x))?(x):(y))
#define Int(x) ((int)(x))
#define Sqrt(x) pow((double)x,0.5)
#define DT dt
#define T(x,y) ((int)((x)*(s1+2)+(y)))
#define ramp(x) (((x)>0)?(x):0)
#define sgn(x) (((x)>=0) ? 1.0 : -1.0)
#define sig(x) (((x)>=0) ? 1.0 : 0.0)
#define getQuadNum(x,y) (sig(x)+2*sig(y))
#define Nramp(x) (((x)<0) ? -(x) : 0)
#define MAX_NHAB 255
#define MAX_NSTEP  200
#define MAX_SECTOR  30
#define MAX_PTSERIES  400  
#define MAX_TS_FILES  50  /* max # files (=variables) for writing point time series */
#define MAX_MSG_SIZE 1200
#define PI 3.1415927
#define Pi 3.1415927
#define pi 3.1415927
#define EOL '\n'
#define Case break;case
#define NE 2
#define EE 3
#define SE 4
#define SS 5
#define SW 6
#define WW 7
#define NW 8
#define NN 9
#define True 1
#define False 0
#define XC(ix) (((float)(recpnum[0]*s0 + ix))/(s0*nprocs[0]+1))
#define YC(iy) (((float)(recpnum[1]*s1 + iy))/(s1*nprocs[1]+1))
#define RAN pranf()
#define	MAXINT		32767		/* (2**15)-1, max positive int */

typedef	int		BOOL;
typedef	FILE		*STREAM;
typedef	char		*STRING;
typedef	unsigned char	UCHAR;
typedef	unsigned int	UINT;
typedef	unsigned short	USHORT;
typedef	long		SLONG;
typedef	unsigned long	ULONG;
#define	MAXULONG	((unsigned long) 0xFFFFFFFFL)	/* (2**32)-1 */

#define	DEBUG		FALSE		/* UNUSED - TRUE enabled debug code */
#define	FOREVER		for(;;)
#define	UNUSED		0
#define	VOID		void		/* Unused return value */
#define POUND           ((UCHAR)0x23)

typedef struct pTSeries {
	int fX;
	int fY;
	int fNpt;
	float fTS;
	float *fValue;
} PTSeries;

typedef struct pTSeriesList {
	PTSeries* fList;
	int fNSlots;
	int fNSlotsUsed;
	int fNptTS;
	int fFormat;
	int fIndex;
} PTSeriesList;

typedef struct rPoint {
	float fr;
	int fX;
	int fY;
	float falpha;
	float fValue;
} RPoint;

typedef struct rPointList {
	RPoint* fList;
	int fNPt;
	int fNPtUsed;
} RPointList;

/*******************************************************
  the following structure is created by Tung in order to
  shorten the repeated code of initialization and generation of output
 *******************************************************
  */
typedef struct {
	float **pfvar;
	char  *pname;
	char  ctype;
} outVar_struct;

/* new basin definition structure used in BudgStats, Fluxes, WatMgmnt */
struct basnDef **basn_list;
struct basnDef
{
    char basnTxt[8];
    int IR[20]; /* max of 20 indicator regions within a hydrologic basin */
    int numIR; /* number of indicator regions in this hydrologic basin */
    int FLok[30];   /* hydrologic basins with which the current basin may have overland flow */
    int numFLok;    /* number of FLok basins attached to this one */
    int parent;  /* ID if this is a main (parent) hydro basin */
    int family;   /* the family name (parent basin & IRegion children) of hydrologic basin */
    double cm_conv; /* convert volume water data to cm across region */
    double mgm2_conv; /* convert mass data to mg/m2 across region */    
} basins;

extern int plus_x, plus_y, minus_x;
extern int  minus_y;
extern int gbl_size[2], lcl_size[2]; 
extern int lcl_start[2];
extern struct nodenv env;
extern int gridSize, nArg;
extern char  msgStr[MAX_MSG_SIZE];
extern UCHAR* gTemp;  
extern int gTempSize, gAnimateIndex;
extern unsigned char *HAB;
extern int total_memory;

#ifdef SMP
extern unsigned char *ON_MAP;
#else 
extern int *ON_MAP;
#endif


extern int gOutStart, gOutEnd;
extern float gRTable[];

/* Flux Parameters  *********************************************/

extern float base_flux_rate, alpha1;   	
extern float alpha2, alpha3;

/*  Simulation and IO Parameters  *******************************/

extern float TIME, dt;

extern SeriesParm pSeries[MAX_PTSERIES];
extern ViewParm *view;
extern Point2D dbgPt;
extern int  debug, seed;
extern FILE *infile, *binfile, *outfile;
extern int istep, viz_step, out_step, N_iter, viewSize; /* removed fNs & void_value aug18/98 */
extern char *ModelPath, *OutputPath, outpath[120], *ProjName, *DriverPath;
extern int s0, s1, gbl_size[2], gSLen[MAX_NHAB];
extern int nprocs[2], recpnum[2];
extern int procnum, Lprocnum, tramType, tramNum[2];
extern float beta1, beta2, beta3;
extern char mapFileName[300];
extern float CELL_SIZE; 
extern float celWid,sq_celWid; /* cell width, square root of cell width, used in number of hydro calcs jan99*/


/*additions*/
extern int *BCondFlow; /* flow constraints map for boundary flows */
extern int hyd_iter; /* max number of horiz iterations per whole-model time step (dt) */
/* time step for horiz surface, groundwater, and canal iterations (dt/hyd_iter, dt/hyd_iter/2.0) */
extern float sfstep, gwstep, canstep; 
extern float avgIntvl; /* day (not iteration) interval for recurring averages etc */
extern char SimAlt[20], SimModif[20], modelName[20], modelVers[10]; /*simulation alternative/scenario, scenario modifier, model name & version */
extern int CALMrun, ELMrun; /* these take the ELM or CALM name and indicate which one is running */
extern int ESP; /* this flag indicates whether the ELM's Everglades Settling of Phosphorus Module is running */
extern int PosAn; /* this flag indicates whether we're running in Position Analysis mode */
extern char initDateRead[15]; 
extern double Jdate, Jdate_init, Jdate_end; /* julian dates for current and begin/end time */
extern int  numday; /* number of days in simulation, calc'd from Jdates */
extern int yr[2], mo[2], da[2], hr[2], mi[2];  /* global,  year, month, day, hour, minutes */
extern double se[2];  /* global, seconds (only due to using an algorithm with such detail) */

extern float DetentZ; /* detention depth (m) == min water depth in cell for sfwater fluxing, also used for gwater fluxing */
extern float MinCheck; /* a small threshold number, generally used to check that depths do not exceed this threshold
                          in terms of going negative or above capacity; units often in meters */
extern int *basn, numBasn; /* hydro basins map, and number of basins */
extern int WatMgmt; /* flag read from driver.parm to turn on canal function */
extern int HabSwitch; /* flag read from driver.parm to turn on habitat switching */
/* added Nov13/98*/

/* for system-wide mass balance check */
extern double *TOT_VOL_CAN; /* total canal volume, units = m^3 */
extern double *VOL_IN_STR, *VOL_IN_OVL, *VOL_IN_SPG, *VOL_IN_GW; /* basin-based, horiz inputs to canal and cells, units = m^3 */
extern double *VOL_OUT_STR, *VOL_OUT_OVL, *VOL_OUT_SPG, *VOL_OUT_GW; /* basin-based, horiz outputs from canal and cells, units = m^3 */

extern double *TOT_P_CAN; /* total canal P, units = kg */
extern double *P_IN_STR, *P_IN_OVL, *P_IN_SPG, *P_IN_GW; /* basin-based, horiz inputs to canal and cells, units = kg */
extern double *P_OUT_STR, *P_OUT_OVL, *P_OUT_SPG, *P_OUT_GW; /* basin-based, horiz outputs from canal and cells, units = kg */

extern double *TOT_S_CAN; /* total canal S, units = kg */
extern double *S_IN_STR, *S_IN_OVL, *S_IN_SPG, *S_IN_GW; /* basin-based, horiz inputs to canal and cells, units = kg */
extern double *S_OUT_STR, *S_OUT_OVL, *S_OUT_SPG, *S_OUT_GW; /* basin-based, horiz outputs from canal and cells, units = kg */

/************************************ Functions Defined in Driver_Utilities.c  */

/** Functions Defined in Driver_Utilities.c  *********************************/

#if NeedFunctionPrototypes

VOIDP nalloc( unsigned mem_size, char var_name[50] );
void fatal(char *msg);
void setFlag(ViewParm* vp, UINT mask, int value );
int getFlag(ViewParm* vp, UINT mask); 
void setPrecision(ViewParm* vp, int value );
int getPrecision(ViewParm* vp);
void   link_edges(void *Map, unsigned char Mtype);
void PTS_Init(struct pTSeries* thisStr);
void PTS_Free(struct pTSeries* thisStr);
void PTS_SetFields (struct pTSeries* thisStr, int ix, int iy, int index, int format, int col); /* add arg, sept98*/
void PTS_CopyFields (struct pTSeries* thisStr, PTSeries pV);
PTSeriesList* PTSL_Init(int nSlots, int format);
void PTSL_AddpTSeries(struct pTSeriesList* thisStr, int x, int y, int index, int seriesNum, int col );/* add arg, sept98*/
void PTSL_Free(struct pTSeriesList* thisStr);
float PTSL_GetInterpolatedValue(struct pTSeriesList* thisStr, int x, int y, int step);
void PTSL_ReadLists( PTSeriesList* thisStr,  char *ptsFileName, int index, float* timeStep, int* nPtTS, int col );/* add arg, sept98*/
void PTSL_CreatePointMap(PTSeriesList* pList,void* Map, unsigned char Mtype,int step, float scale);
void print_point_list(ViewParm *vp, void* Map, char Mtype, char* mName, int tIndex) ;
void print_loc_ave(Point3D *vt, void* Map, char Mtype, char* mName, int tIndex);
void   set_boundary(void *Map, unsigned char Mtype, float bv);
void   init_pvar(void *Map, UCHAR* mask, unsigned char Mtype,float iv);
void   Cplot(VOIDP Map, unsigned char Mtype, float Vmax, float Vmin);
int    write_map_file(char *filename, VOIDP Map, char Mtype, int index, float scale, float offset, int precision, unsigned char type, int *mo, int *da, int *yr);
int    read_map_file(	char 	*filename,
						VOIDP			Map,
						unsigned char	Mtype,
						float			scale_val,
						float			offset_val );
int    read_ts_map_file(	char 	*filename,
						VOIDP			Map,
						unsigned char	Mtype,
						float			scale_val,
						float			offset_val,
						int index );
float*    read_timeseries_file(int iFormat, char* filename, float* value, int index, int* NPt, float* TStep);
/* ELM added three (Pump0,1,2) types of read time series (OUTDATED 4/98)*/
float*    read_Pump0_ts_file(int iFormat, char* filename, float* value, int index, int* NPt, float* TStep);
float*    read_Pump1_ts_file(int iFormat, char* filename, float* value, int index, int* NPt, float* TStep);
float*    read_Pump2_ts_file(int iFormat, char* filename, float* value, int index, int* NPt, float* TStep);

void   quick_look( void *Map, char *name, unsigned char Mtype, int i0, int j0, int range, unsigned char format );
void   smooth (float* Map,int Ns);
float  pranf();
void   pranset(int seed);
int    skip_white(FILE *infile);
int    scan_forward ( FILE *infile, char tstring[50]) ;
void   read_map_dims(char* filename );
void 	read_model_parameters();
int dec_1b(UCHAR **sptr);
int dec_2b(UCHAR **sptr);
SLONG dec_4b(UCHAR **sptr);
VOID enc_2b(UCHAR **sptr, int	value);
VOID enc_4b(UCHAR **sptr, SLONG	value);
VOID enc_Nb(UCHAR **sptr, SLONG	value, int bytes);
VOID enc_str(UCHAR **sptr, register STRING	s);
VOID enc_strN(UCHAR **sptr, register STRING	s, int N);
void setup_grid();
void setup_platform();
void readOutlistOLD(int size); /*jan99 */
VOID print_bytes(FILE* outfile,void* value,char* label);
VOID swap_bytes(void* value);
VOID swap_bytesN(void* value,int size);
void print_msg ( char *msg );
void fatal(char *msg);
void calc_maxmin(ViewParm *vp, void* Map, char Mtype, char* mName, int step); 
void writeWindow(void* fValue, char* vName, char* label, int x0, int y0, int N0, int N1, int index, UCHAR Mtype, unsigned char format );
float* get_DBase_parm2( char *filename, int i0, int i1, int index );
float* get_DBase_parm( char *filename, int i0, int i1, int index );
void write_output( int 	index, ViewParm *vp, void* Map, char* filename, char Mtype, int	step);

double julday(int mon, int day, int year, int h, int mi, double se);
void calcdate(double jd, int *m, int *d, int *y, int *h, int *mi, double *sec);
int dayofweek(double j);


#else 

VOIDP nalloc( );
void fatal();
void setFlag( );
int getFlag(); 
void setPrecision();
int getPrecision();
void PTS_Init();
void PTS_Free();
void PTS_SetFields ();
void PTS_CopyFields ();
PTSeriesList* PTSL_Init();
void PTSL_AddpTSeries();
void PTSL_Free();
float PTSL_GetInterpolatedValue();
void PTSL_ReadLists();
void PTSL_CreatePointMap();
void   link_edges();
void   set_boundary();
void   init_pvar();
void   Cplot();
int    write_map_file();
int    read_map_file();
int    read_ts_map_file();
float* read_timeseries_file();
/* ELM added three (Pump0,1,2) types of read time series (OUTDATED 4/98)*/
float*    read_Pump0_ts_file();
float*    read_Pump1_ts_file();
float*    read_Pump2_ts_file();

void   quick_look( );
void   smooth ();
float  pranf();
void   pranset();
int    round();
int    skip_white();
int    scan_forward () ;
void   read_map_dims();
void set_async_mode(); 
void read_model_parameters();
void print_loc_ave();
int dec_1b();
int dec_2b();
SLONG dec_4b();
float dec_float();
VOID enc_2b();
VOID enc_4b();
VOID enc_Nb();
VOID enc_float();
VOID enc_str();
VOID enc_strN();
void setup_grid();
void setup_platform();
void readOutlistOLD(); /*jan99 */
VOID print_bytes();
VOID swap_bytes();
VOID swap_bytesN();
void print_msg ();
float* get_DBase_parm2();
float* get_DBase_parm();
void fatal() ;
void calc_maxmin();
void writeWindow();
float* get_DBase_parm2(  );
float* get_DBase_parm(  );
void write_output( );

double julday( );
void calcdate( );
int dayofweek( );

#endif /* NeedFunctionPrototypes */

/****************************************  Functions Defined in Fluxes.c  */

#if NeedFunctionPrototypes

void Flux_GWater (int it, float *SatWat, float *Unsat, float *SfWat,
                  float *DOMdepth, float *rate, float *poros, float *sp_yield, float *elev,
                  double *gwSTUF1, double *gwSTUF2, double *gwSTUF3,
                  double *swSTUF1, double *swSTUF2, double *swSTUF3 );
void Flux_GWcells( int i0, int i1, int j0, int j1,
                    float *SatWat, float *Unsat, float *SfWat, 
                    float *rate, float *poros, float *sp_yield, float *elev,
                    double *gwSTUF1, double *gwSTUF2, double *gwSTUF3,
                    double *swSTUF1, double *swSTUF2, double *swSTUF3);


void Flux_SWater (int it, float *SURFACE_WAT,float *SED_ELEV,float *HYD_MANNINGS_N,
                  double *STUF1, double *STUF2, double *STUF3, float HDmax);
float Flux_SWcells(int i0,int i1,int j0,int j1, float *SWater,
                   float *Elevation,float *MC, float HDmax);
void Flux_SWstuff (int i0,int i1,int j0,int j1, float Flux,
                   float *SURFACE_WAT, double *STUF1, double *STUF2, double *STUF3);


#else

void Flux_GWater ()
float Flux_GWcells();

void Flux_SWater ();
float Flux_SWcells();
void Flux_SWstuff ();


#endif  /* NeedFunctionPrototypes */


/**********************************   */

#if NeedFunctionPrototypes

void alloc_memory ();
void init_vars ( int firstI ); 
void get_map_dims();
int ReadParms(FILE* inFile);
int call_cell_dyn (int sector, int step);
void link_maps ();
void gen_outputOLD (int step); /*jan99 */
void gen_output(int step, ViewParm *view); /*jan99 */
void  set_env_vars();
void read_output_parmsOLD(); /*jan99 */

#else

void alloc_memory ();
void init_vars (); 
void get_map_dims();
int ReadParms();
void link_maps ();
int call_cell_dyn ();
void gen_outputOLD (); /*jan99 */
void gen_output(); /*jan99 */
void set_env_vars();
void read_output_parmsOLD(); /*jan99 */


#endif

/*************************/
