
#define	ISARRAY		0x8000		/* TRUE/ is Array	*/
#define	OUTMAP		0x4000		/* TRUE/ output variable as Map.*/
#define	ANIMAT		0x2000		/* TRUE/ 	*/
#define	TEMP1		0x1000		/* TRUE/ 	*/
#define	TEMP2		0x0800		/* TRUE/ 	*/
#define	TEMP3		0x0400		/* TRUE/ 	*/
#define	PMASK2		0x0200		/* TRUE/ 	*/
#define	PMASK1		0x0100		/* TRUE/ 	*/

#define	CASE 0
#define	NOCASE 1
#define	BEG 0
#define	END 1

#define kMAX 0
#define kMIN 1
#define kMAXMIN 2
#define kSUM 3
#define kAVE 4
#define kSUMCUM 5
#define kAVECUM 6

#define kCArgDepth 	10
#define kCArgWidth 	50
extern char gCArg[kCArgDepth][kCArgWidth];

typedef struct point3D { 
    int x; 
    int y; 
    int z;
    unsigned char type;    
    unsigned char format;    
} Point3D;

typedef struct point2D { 
	int x; 
	int y; 
} Point2D; 

typedef unsigned char byte;

typedef struct scale1 { 
	float s; 
	float o;  
} Scale1; 

typedef struct scale2 { 
	float Vmin; 
	float Vmax;  
} Scale2; 

typedef struct viewParm {
	Scale1 scale;
	Scale2 gScale;
	Scale2 bounds;
    Point3D *points;	
	unsigned char nPoints;
	unsigned char maxPoints;
	int step;
	unsigned char mapType;    
	unsigned int flags;
	char fileName[24];
} ViewParm;

typedef struct seriesParm {
	float* data;
	Point2D Loc;
	char name[24];
	int Length;
	int outstep; /* added jan99 */
	int laststep; /* added jan99 */
} SeriesParm;

#if PLATFORM != EXPRESS
typedef struct nodenv {
	int procnum;		/* Processor number of calling program */
	int nprocs;			/* Number of nodes in this processor group */
	int groupid;		/* Group identifier for this processor group */
	int taskid;			/* Identifies particular task on a node */
} nodenv;
#endif   

#if NeedFunctionPrototypes

void Copy(void *src, void *dst, int w, int n, int sw, int dw);
float SMDRAND( float  fminVal, float fmaxVal );
void writeMap(char* filename, void* data, int bSize, unsigned char type, int index);
byte  readMap(char* filename, void* data);
float* readSeries(char *filename, int format, int index, int* Npt, float* TStep );
/* sept98 added a modified readSeries fcn to read multiple columns */
float* readSeriesCol(char *filename, int format, int index, int* Npt, float* TStep, int col );

float* read_hdp2( char* filename, int loc0, int loc1, int index, int order );
void send_point_lists(SeriesParm *pSeries, int nSeries);
void send_point_lists2(SeriesParm *pSeries, int nSeries); /* multi-column, multi-file format jan99 */
void open_point_lists(SeriesParm *pSeries, int nSeries); /* multi-column, multi-file format jan99 */
void writeSeries(void* fValue, char* label, char* desc, int N0, int N1, byte Mtype, byte format );
void WriteMsg(char* msg, int procIndex);
void Exit(int code);
void Combine(float* fValue, char* label, int nComp, int cType, int step);
int on_this_proc(int x, int y);
void exchange_borders(byte* map, int size);
void usrErr (char* dString);
void broadcastMsg(byte*  msgPtr );
void broadcastInt(int* iValPtr);
void broadcastChar( byte*  cPtr );
void sync_processors();
void broadcastData( void*  dataPtr, int *dataSize );
void broadcastFloat(void* dataPtr);
void getInt(FILE* inFile, char* lString, int* iValPtr );
void getChar(FILE* inFile, char* lString, char* cValPtr );
void getString(FILE* inFile, char* lString, char* inString );
void getFloat( FILE* inFile, char* lString, float* fValPtr );
void local_setup(int  argc, char* argv[]);
void open_out_files(int index);
void alloc_local_memory();
float FMOD( float x, float y);
void local_init();
/*jan99*/
int init_config_fileOLD(char* filename, char term1, char term2, char term3, char term4);
int init_config_file(FILE *vpFile, char term1, char term2, char term3, char term4);
int parse_packetOLD( int* nArgs, char* test); 
int parse_packet(FILE *vpFile, int* nArgs, char* test); 

#if PLATFORM != EXPRESS
void exparam(struct nodenv* envInfo);
int	exgridinit(int dim, int *nprocs);
void exgridsplit(int nprocs, int ndim, int nprocs2[2]);
void exgridcoord(int pnum, int rnum[2]); 
void exgridsize(int pnum, int gsize[2], int lsize[2], int lstart[2] );
void set_async_mode(FILE* file); 
void fmulti(FILE* file); 
void fsingl(FILE* file); 
void fasync(FILE* file); 
void Cplot(VOIDP Map, unsigned char Mtype, float max_value, float min_value); 
#endif /* EXPRESS Functions */

#else

float SMDRAND() ;
void writeMap();
byte  readMap();
float* readSeries();
/* sept98 added a modified readSeries fcn to read multiple columns */
float* readSeriesCol();

float* read_hdp2();
void send_point_lists();
void send_point_lists2(); /* multi-column, multi-file format jan99 */
void open_point_lists(); /* multi-column, multi-file format jan99 */
void writeSeries();
void WriteMsg();
void Exit();
void exchange_borders();
int on_this_proc();
void usrErr (); 
void broadcastMsg();
void broadcastInt( );
void broadcastChar( );
void sync_processors();
void broadcastData( );
void broadcastFloat();
void getInt( );
void getChar( );
void getString();
void getFloat( );
void local_setup();
void open_out_files();
void alloc_local_memory();
void Combine();
float FMOD();
void local_init();
int init_config_file();
int init_config_fileOLD();
int parse_packet();
int parse_packetOLD();

#if PLATFORM != EXPRESS
void Cplot(); 
void exparam();
void exgridsplit();   
int	exgridinit();
void exgridcoord();
void exgridsize();
void set_async_mode( ); 
void fmulti( ); 
void fsingl( ); 
void fasync( ); 
#endif /* EXPRESS Functions */

#endif
