#include "Success.h"

#define CELL_EQ(x) if ( !(F_Cell[x]%100) ) F_Cell[x]


/*************************************************************************************/
/*								Ignite a fire in a cell								 */
/*
float Fire_Init ( char* filename )
{


  return 0.0;

}
*/
/************************************************************************************/
/*				  		Propagates the fire over the landscape						*/

float Fire_flux (float *F_Travel, int *F_Cell, int i0, int i1)
{ float CELL_D = sqrt ( CELLSIZE );

	/* the cells in F_Cell are marked by integers 0,1,...,9 depending upon 		*/
	/* where the fire enters the cell: 1 - if struck by lightning in the center	*/
	/*		2 - came to the center of cell border from North					*/
	/*		3 - came to the center of cell border from West 					*/
	/*		4 - came to the center of cell border from South					*/
	/*		5 - came to the center of cell border from East						*/
	/*		6 - came to upper left corner										*/
	/*		7 - came to upper right corner					8	4	9			*/
	/*		8 - came to lower right corner					3	1	5			*/
	/*		9 - came to lower left corner					7	2	6			*/

  switch ( F_Cell[T(i0,i1)] )
  {
  	case 0: return 1;
  	/*  CELL_EQ(x) is defined above as (if ( !F_Cell[x] ) F_Cell[x]) */
  	case 1: /* center of cell hit */
  			if ( F_Travel[T(i0,i1)] < CELL_D/2. ) return 1;
   			CELL_EQ( T(i0+1,i1) ) = 12;
 			CELL_EQ( T(i0,i1-1) ) = 3;
  			CELL_EQ( T(i0-1,i1) ) = 4;
  			CELL_EQ( T(i0,i1+1) ) = 15;
  			if ( F_Travel[T(i0,i1)] < CELL_D*0.707 ) return 1; /* sqrt(2)/2 */
  			CELL_EQ( T(i0-1,i1-1) ) = 8;
  			CELL_EQ( T(i0-1,i1+1) ) = 9;
  			CELL_EQ( T(i0+1,i1-1) ) = 17;
  			CELL_EQ( T(i0+1,i1+1) ) = 16;
  			break;
  			
  	case 2: if ( F_Travel[T(i0,i1)] < CELL_D/2. ) return 1;
  			CELL_EQ( T(i0,i1-1) ) = 7;
  			CELL_EQ( T(i0-1,i1-1) ) = 8;
  			CELL_EQ( T(i0-1,i1+1) ) = 9;
  			CELL_EQ( T(i0,i1+1) ) = 16;
  			if ( F_Travel[T(i0,i1)] > CELL_D ) CELL_EQ( T(i0+1,i1) ) = 12;
  			if ( F_Travel[T(i0,i1)] < CELL_D*1.1181) return 1; /* = sqrt(5)/2 */
  			CELL_EQ( T(i0+1,i1-1) ) = 17;
  			CELL_EQ( T(i0+1,i1+1) ) = 16;
  			break;
  			
  	case 4: if ( F_Travel[T(i0,i1)] < CELL_D/2. ) return 1;
  			CELL_EQ( T(i0,i1-1) ) = 8;
  			CELL_EQ( T(i0+1,i1-1) ) = 17;
  			CELL_EQ( T(i0+1,i1+1) ) = 16;
  			CELL_EQ( T(i0,i1+1) ) = 19;
  			if ( F_Travel[T(i0,i1)] > CELL_D ) CELL_EQ( T(i0-1,i1) ) = 4;
  			if ( F_Travel[T(i0,i1)] < CELL_D*1.1181) return 1; /* = sqrt(5)/2 */
  			CELL_EQ( T(i0-1,i1-1) ) = 8;
  			CELL_EQ( T(i0-1,i1+1) ) = 9;
  			break;
  			
  	case 3: if ( F_Travel[T(i0,i1)] < CELL_D/2. ) return 1;
  			CELL_EQ( T(i0-1,i1) ) = 8;
  			CELL_EQ( T(i0-1,i1+1) ) = 9;
  			CELL_EQ( T(i0+1,i1) ) = 17;
  			CELL_EQ( T(i0+1,i1+1) ) = 16;
  			if ( F_Travel[T(i0,i1)] > CELL_D ) CELL_EQ( T(i0,i1-1) ) = 3;
  			if ( F_Travel[T(i0,i1)] < CELL_D*1.1181) return 1; /* = sqrt(5)/2 */
  			CELL_EQ( T(i0-1,i1-1) ) = 8;
  			CELL_EQ( T(i0+1,i1-1) ) = 17;
  			break;
  			
  	case 5: if ( F_Travel[T(i0,i1)] < CELL_D/2.) return 1;
  			CELL_EQ( T(i0-1,i1-1) ) = 8;
  			CELL_EQ( T(i0-1,i1) ) = 9;
  			CELL_EQ( T(i0+1,i1-1) ) = 17;
  			CELL_EQ( T(i0+1,i1) ) = 16;
  			if ( F_Travel[T(i0,i1)] > CELL_D ) CELL_EQ( T(i0,i1+1) ) = 15;
  			if ( F_Travel[T(i0,i1)] < CELL_D*1.1181) return 1; /* = sqrt(5)/2 */
  			CELL_EQ( T(i0-1,i1+1) ) = 9;
  			CELL_EQ( T(i0+1,i1+1) ) = 16;
  			break;
  			
  	case 6: if ( F_Travel[T(i0,i1)] < CELL_D ) return 1;
  			CELL_EQ( T(i0-1,i1+1) ) = 9;
  			CELL_EQ( T(i0,i1+1) ) = 16;
   			CELL_EQ( T(i0+1,i1) ) = 16;
 			CELL_EQ( T(i0+1,i1-1) ) = 17;
  			if ( F_Travel[T(i0,i1)] > CELL_D*1.414 ) CELL_EQ( T(i0+1,i1+1) ) = 16;
													 /* = sqrt(2) */
  			break;
  			
  	case 7: if ( F_Travel[T(i0,i1)] < CELL_D ) return 1;
  			CELL_EQ( T(i0-1,i1-1) ) = 8;
  			CELL_EQ( T(i0,i1-1) ) = 7;
   			CELL_EQ( T(i0+1,i1) ) = 17;
 			CELL_EQ( T(i0+1,i1+1) ) = 16;
  			if ( F_Travel[T(i0,i1)] > CELL_D*1.414 ) CELL_EQ( T(i0+1,i1-1) ) = 17;
													 /* = sqrt(2) */
  			break;
  			
  	case 8: if ( F_Travel[T(i0,i1)] < CELL_D ) return 1;
  			CELL_EQ( T(i0,i1-1) ) = 8;
  			CELL_EQ( T(i0+1,i1-1) ) = 17;
   			CELL_EQ( T(i0-1,i1) ) = 8;
 			CELL_EQ( T(i0-1,i1+1) ) = 9;
  			if ( F_Travel[T(i0,i1)] > CELL_D*1.414 ) CELL_EQ( T(i0-1,i1-1) ) = 8;
													 /* = sqrt(2) */
  			break;
  			
  	case 9: if ( F_Travel[T(i0,i1)] < CELL_D ) return 1;
  			CELL_EQ( T(i0-1,i1-1) ) = 8;
  			CELL_EQ( T(i0-1,i1) ) = 9;
   			CELL_EQ( T(i0,i1+1) ) = 19;
 			CELL_EQ( T(i0+1,i1+1) ) = 16;
  			if ( F_Travel[T(i0,i1)] > CELL_D*1.414 ) CELL_EQ( T(i0-1,i1+1) ) = 9;
													 /* = sqrt(2) */
  			break;
  }	
  return 1;
}	          

/********************************************************************************************/
