#include "Success.h"

#define H_SW_PERIOD 366
#define MAX_SW 99
#define AV_PER 7  			/* period of averaging - should be <100 */
#define SW_TIME_TH_W 4
#define SW_TIME_TH_N 4

unsigned long *HabHist;		/* maximum is 4294967296 */
int Hab_num;

struct HabData
 {
 float Lhi;		/* upper parameter value for the habitat */
 float Llo;		/* lower parameter value for the habitat */
 float Pin;		/* for how long do you need to stay within suitable values */
 				/* to switch to this habitat type */
 }; 

struct Habitat
 {
 struct HabData Water; 
 struct HabData Nutrient;
 float	PFin;	/* for how long do you need to stay without a fire */
 				/* to switch to this habitat type */
 };

struct Habitat Habi[MAX_NHAB];

void F_Hab_Init ( char *filename );

unsigned char 
F_Hab_Sw (int ix, int iy, float *Water, float *Nutrient, int *Fire, unsigned char *HAB);

unsigned char 
F_Hab_SwA (int ix, int iy, float *Water, float *Nutrient, int *Fire, unsigned char *HAB);

/*void InHab ( float Water, int *StateW, float Nutrient, int *StateN );*/
int InHab ( float Var, struct HabData Params );

void alloc_hab_hist( void );


/********************************************************************************************/
/*					Reads the information about habitats from file HabData					*/
void
F_Hab_Init ( char *filename )

{
  int i = 0, h;
  char s[250];

  Hab_num = 0;

  if(H_OPSYS==UNIX) 
   		sprintf( mapFileName, "%s/%s/Data/%s", ModelPath, ProjName, filename );
  else sprintf( mapFileName, "%s%s:Data:%s", ModelPath, ProjName, filename );
  
/* Open file with Habitat structure */
   if ( ( HsFile = fopen( mapFileName, "r" ) ) ==  NULL )
    {
       usrErr( "Can't open succession parms file! " ) ;
       exit(-1) ;
    }

   fgets(s,249,HsFile); fgets(s,249,HsFile); /* skip 2 header lines */
   
/* Read habitat descriptors until none left */
   while ( (h = fscanf( HsFile, "%s %f %f %f %f %f %f %f",
            s, &Habi[Hab_num].Water.Llo, &Habi[Hab_num].Water.Lhi, &Habi[Hab_num].Water.Pin,
            &Habi[Hab_num].Nutrient.Llo, &Habi[Hab_num].Nutrient.Lhi, &Habi[Hab_num].Nutrient.Pin,
            &Habi[Hab_num].PFin)) > 0 && h!= EOF && h == 8) 
   { if (h != 8) { usrErr ( "Wrong habitat switching data format." );
                   exit(-1);
                 }
   
   Hab_num++;
   }

   fclose (HsFile);

   sprintf (msgStr, "\tHabitat switching data read OK for %d habitats", Hab_num ); usrErr(msgStr); WriteMsg(msgStr,1);
   
   alloc_hab_hist( );

   return; 
}

/********************************************************************************************
Returns the number of the habitat to switch to, based on the yearly length of
the period of favorable conditions.
*/

unsigned char 
F_Hab_Sw (int ix, int iy, float *Water, float *Nutrient, int *Fire, unsigned char *HAB)

{
 int i;
 float HabW[MAX_NHAB], HabN[MAX_NHAB];
 int cell =  T(ix,iy);
 int hab = HAB[cell];	/* current habitat in the cell */
 
 /* define the fire history */
 if ( !(Fire[cell]%100) ) Fire[cell] += 100;

 for ( i = 0; i < Hab_num; i++ )  
	{
	 /* HabHist stores the water history in the last 5 positions and the nutrient
 		history in the first 5 positions */
	 HabW[i] = (HabHist[cell*Hab_num +i]%10000)/10000.;
	 HabN[i] = (HabHist[cell*Hab_num +i]/10000)/10000.;
     /* to keep the HabHist arrays int, the code uses a modified value 
        for tracing history: the number of days in actual state is weighted
        by the H_SW_PERIOD (365) and the result is then *10000 to make it
        integer */
	 if (TIME > H_SW_PERIOD) 
 		{ HabW[i] -= HabW[i]/H_SW_PERIOD/H_SW_PERIOD;
 		  HabN[i] -= HabN[i]/H_SW_PERIOD/H_SW_PERIOD;
 		}
 	 /* while I'm adding 1 for each additional day in this state, I'm
 	    subtracting 1/H_SW_PERIOD, which is the probability of being
 	    in that state during the last H_SW_PERIOD days. This is to avoid
 	    keeping track of all the history */
 	 if ( InHab (Water[cell], Habi[i].Water) ) HabW[i] += 1./H_SW_PERIOD;
 	 if ( InHab (Nutrient[cell]*1.0e6, Habi[i].Nutrient) ) HabN[i] += 1./H_SW_PERIOD;

 	 HabHist[cell*Hab_num +i] = (int)(HabN[i]*10000)*10000 + HabW[i]*10000;
 	} 
   
 /* check that the historical conditions for switching hold */
 for ( i = 0; i < Hab_num; i++ )  
 /* to keep the HabHist arrays int, the code uses a modified value 
    for tracing history: the number of days in actual state is weighted
    by the H_SW_PERIOD (365) and the result is then *10000 to make it integer */
	if ( HabW[i] >= Habi[i].Water.Pin*10000./H_SW_PERIOD &&
						 HabN[i] >= Habi[i].Nutrient.Pin*10000./H_SW_PERIOD) 
		{ HabHist[cell*Hab_num +i] = 0;
		  return (i+1);
		}
		
 return hab;	
}

/*******************************************************************************************
Returns the number of habitat to switch to based on the length of the weekly
(or other) averaged period of favorable conditions.
In this case the period of habitat favorable conditions is calculated as the number of
weeks (or other time intervals) during which the habitat conditions matched the
specified for a period longer than the given one - SW_TIME_TH. The switching occurs as soon
as the number of such successfull weeks exceeds the time specified in Pin
*/

unsigned char 
F_Hab_SwA (int ix, int iy, float *Water, float *Nutrient, int *Fire, unsigned char *HAB)
{
 int StateW, StateN, i;
 int HabW[MAX_NHAB], HabN[MAX_NHAB], DW, DN;
 int cell =  T(ix,iy);
 int hab = HAB[cell];	/* current habitat in the cell */
 
 /* define the habitat type that matches the existing water conditions */
 
 for ( i = 0; i < Hab_num; i++ )
 /* HabHist is an array of integers : nnNssS, where nn are the two digits for the number of
 	weeks being in the nutrient favorable conditions, N the number of days in those conditions 
 	during the current week; similarly ss are the two digits for the number of weeks in the
 	water level favorable conditions and S is the number of days during the current week in
 	that state. The switching occurs when both of these histories exceed the habitat specific 
 	periods  Pin.
 */
	{
	 DW = HabHist[cell*Hab_num +i]%10;
	 HabW[i] = (HabHist[cell*Hab_num +i]/10)%100;
	 DN = (HabHist[cell*Hab_num +i]/1000)%10;
	 HabN[i] = HabHist[cell*Hab_num +i]/10000;
	 
 	 if ((int)TIME%AV_PER == 0)
 	   { /* when the averaging time elapses, if #favorable days exceeds a threshold (4 for 7 day avg period now), increment the period (weeks now) history */
 	 	if (DW > SW_TIME_TH_W) HabHist[cell*Hab_num +i] = HabHist[cell*Hab_num +i] - DW + 100;
 	 	else HabHist[cell*Hab_num +i] = 0;
 	 	if (DN > SW_TIME_TH_N) HabHist[cell*Hab_num +i] = HabHist[cell*Hab_num +i] - DN*1000 + 10000;
 	 	else HabHist[cell*Hab_num +i] = 0;
	   }	

 /* check what habitat type the existing conditions match */  /* increment the day# if conditions are favorable */
  	 if ( InHab (Water[cell], Habi[i].Water) )  HabHist[cell*Hab_num + i]++;
 	 if ( InHab (Nutrient[cell]*1.0e6, Habi[i].Nutrient) )  
 	 		HabHist[cell*Hab_num + i] = HabHist[cell*Hab_num + i] + 1000;
 	} 
   
 /* check that the historical conditions for switching hold */
 for ( i = 0; i < Hab_num; i++ )  
	if ( HabW[i] >= Habi[i].Water.Pin && HabN[i] >= Habi[i].Nutrient.Pin ) 
		{ HabHist[cell*Hab_num +i] = 0;
		  return (i+1); /* returns new hab */
		}
		
 return hab;	
}

/********************************************************************************************/
void alloc_hab_hist( void )
{
  HabHist = (unsigned long *) nalloc(sizeof(unsigned long)*(s0+2)*(s1+2)*(Hab_num),"HabHist");
  init_pvar(HabHist,NULL,'i',0);
}

/********************************************************************************************/
/*			Defines the type of current habitat basing on the variable value				*/

/*void InHab ( float Water, int *StateW, float Nutrient, int *StateN )

{
 int i;
 
 for ( i = 0; i < Hab_num; i++ )
 	{ if ( (Water <= Habi[i].Water.Lhi || Habi[i].Water.Lhi >= MAX_SW) 
 				&& Water >= Habi[i].Water.Llo ) 
 	  *StateW = (i+1);
 	  if ( (Nutrient <= Habi[i].Nutrient.Lhi || Habi[i].Nutrient.Lhi >= MAX_SW) 
 	  			&& Nutrient >= Habi[i].Nutrient.Llo ) 
 	  *StateN = (i+1);
	}
 return;
}

*/
/********************************************************************************************/
/*			Defines the type of current habitat basing on the variable value				*/


int InHab ( float Var, struct HabData Params )

{
  if ( (Var <= Params.Lhi || Params.Lhi >= MAX_SW) && Var >= Params.Llo ) 
 	  return 1;
  else return 0;
}
