#include "../Driver_Sources/globals.h"

#define GEM 0

#define TAB '\t'
#define STEP(x) ( ((x)>=0) ? 1.0 : 0.0 )
#define CH_LINE 2		/* the row in ON_MAP designated to place GEM canal quasi-cells*/
#define MAX_H_STRUCT 180	/* maximal number of structures that have historical or SFWMM data input */

FILE *ChanInFile, *File; 
FILE *CanalOutFile;
FILE *CanalOutFile_P;
/* FILE *CanalOutFile_N; */
FILE *CanalOutFile_S;

FILE *WstructOutFile;
FILE *WstructOutFile_P;
/* FILE *WstructOutFile_N; */
FILE *WstructOutFile_S;

FILE *DebugFile; 

struct Data2 Hist_data[MAX_H_STRUCT]; 
				/* pointer to array of pointers for the water control structure time series */

int num_chan; 			/* number of channels */
int num_struct_hist, numTPser;	/*number of structures driven by historical & # structs with hist TP data */
struct Chan **Chan_list;

struct Structure *struct_first;
struct Structure *structs;


struct Data2
 {
     char S_nam[20];       /* SFWMM control structure name (also in the struct structure ) */
     char file[20];
     float *arrayPump;
     float *arrayP;
     float *arrayN;
     float *arrayS;
     int aggID; /* the SFWMM structure ID of the aggregated flow (e.g., S10's ID stored with S10A-D) */
     int aggCnt; /* the # of dissaggregated structures contained in an aggregated SFWMM (e.g., S10 will have 3) */
     int flag;
};

struct Chan_reach
 {
 float x0,y0,x1,y1;     /* UTM coordinates of beginning and end of channel reach */
 struct Chan_reach *next_reach; /* pointer to next canal reach */
 };  

struct Chan 		    /* defines a single canal */
{
    int number;            /* number of canal */
    int levee;         	/* 1 -levee on the left, -1 -levee on the right, 
                           2 - levees on both sides, 0 - no levees */
    int roil;				/* number of cells to interact to the left */
    int roir;				/* and to the right */
    float depth;		    /* canal reach (not water) depth */
    float width;			/* Channel width */
    float cond;			/* Seepage coefficient for the canal */
    double N;				/* nitrogen mass in canal (kg) */
    double P;				/* phosphorus mass in canal (kg) */
    double S;				/* salt mass in canal (kg) */
    double N_con;			/* nitrogen concentration in canal (mg/L = g/m3) */
    double P_con;			/* phosphorus concentration in canal (mg/L = g/m3) */
    double S_con;			/* salt concentration in canal (mg/L = g/m3) */
    float wat_depth;			/* water depth in canal */

    float ic_N_con;			/* initial nitrogen concentration in canal (mg/L = g/m3) */
    float ic_P_con;			/* initial phosphorus concentration in canal (mg/L = g/m3) */
    float ic_depth;			/* initial water depth in canal */

    float length;			/* length of canal */
    float area;			/* area of canal */
    float elev_start;			/* land elevation at starting point of canal */
    float elev_end;			/* land elevation at ending point of canal */
    float elev_drop;			/* (positive) land elevation drop between start&end points of canal */
    float minVol;			/* minimum volume allowed in canal */
    float seg_len;			/* avg length of cell along reach segment */
    float SW_flow_coef;	/* overland flow coef modified by calib parm (not incl. manning's n) */
    float SPG_flow_coef;	/* seepage coef modified by calib parm */
    int   num_of_cells;    /* number of interacting cell patterns (pairs in this case) */
    int   basin;    		/* water basin to which the canal belongs */
    int parent;          /* ID if this is a main (parent) hydro basin */
    int family;          /* the family name (parent basin & IRegion children) of hydrologic basin */
    double sumHistOut;	        /* sum of all historical/SFWMM flows (corrected for excess demand) from a reach during an iteration */
    double sumHistIn;	        /* sum of all historical/SFWMM flows (corrected for excess demand) to a reach during an iteration */
    double sumRuleOut;	        /* sum of all rule-based flows from a reach during an iteration */
    double sumRuleIn;	        /* sum of all rule-based flows to a reach during an iteration */
    struct Chan_reach *reaches; /* pointer to list of canal reaches */
    struct Cells *cells;  		 /* pointer to the list of adjacent cells */
    struct Chan *next_in_list;  /* points to the next canal in list */
};
  
struct Cells			/* defines the cells adjacent to a canal */
 {
 int x;					/* coordinates of the cell */
 int y;
 int ind;				/* cell index - could be 1 for left cells and -1 for right cells */
 float length;			/* length of canal associated with this cell */
 struct Cells *next_cell;	/* next pair of cells adjacent to the canal */  
 };
 
struct Schedule
 {
 int num_point; 		/* number of points in graph */
 struct Points *graph_points;
 };
 
struct Points
 {
 float time;
 float value;
 }; 

struct Structure		/* defines the water control structure attributes */
 { 
 int flag;                      /* historical/SFWMM data flag, that switches off recalculation of flows */
 int histID;                      /* historical/SFWMM structure ID */
 int aggID;                      /* ID of SFWMM structure that holds aggregated data for current structure  */
 char S_nam[20];                /*  structure name */
 int str_cell_i;
 int str_cell_j;		/* coordinates of the WC structure's cell  */
 int canal_fr;		        /* number of canal upstream */
 int canal_to;                  /* number of canal downstream */
 int cell_i_fr;
 int cell_j_fr;		        /* coordinates of the cell upstream next to the structure */
 int cell_i_to;
 int cell_j_to;			/* coordinates of the cell downstream next to the structure */
 float HW_stage;		/* targeted waterhead in canal or cell upstream (+/-) */
 float TW_stage;		/* targeted waterhead in canal or cell downstream (+/-) */
 /* (+/-) means that there is a plus if waterhead should be > targeted and a minus otherwise */
 struct Schedule *HW_graph;	/* pointer to array of data if HW stage is to be a graph */
 struct Schedule *TW_graph;	/* pointer to array of data if TW stage is to be a graph */
 int cell_i_HW;
 int cell_j_HW;			/* coordinates of the cell upstream that may influence the operation */
 int cell_i_TW;
 int cell_j_TW;			/* coordinates of the cell downstream that may influence the operation */
 float w_coef;			/* wier coefficient (=0 for virtual structure) */
 double flow;			/* flow through structure */
 int TPser;                    /* flag to indicate use of concentration that is: -1=calc'd, 0= constant, 1=time series  */
 int TNser;                    /* flag to indicate use of concentration that is: -1=calc'd, 0= constant, 1=time series  */
 int TSser;                    /* flag to indicate use of concentration that is: -1=calc'd, 0= constant, 1=time series  */
 float TP;                      /* historical TP concentration, constant value across time */
 float TN;                      /* historical TN concentration, constant value across time */
 float TS;                      /* historical TS (salt) concentration, constant value across time */
 double conc_P;			/* Phos conc in flow through structure */
 double conc_N;			/* Nit conc in flow through structure */
 double conc_S;			/* Salt conc in flow through structure */
 double SumFlow;			/* sum of flow through structure over the summary interval */
 double Sum_P;			/* sum (conc_P*flow) in flow through structure over the summary interval */
 double Sum_N;			/* sum (conc_N*flow) in flow through structure over the summary interval */
 double Sum_S;			/* sum (conc_S*flow) in flow through structure over the summary interval */
 int multiOut;     	/* flag to indicate a structure has been processed as multiple outflow from one reach */
 struct Structure *next_in_list;   /* points to the next structure in list */
 };



#if NeedFunctionPrototypes

struct Chan *ReadChanStruct ( char* filename, float BASE_DATUM );
struct Cells *MarkCell 
( int x, int y, int index, float length, struct Cells *cell, int ch_number, int levee, int xm, int ym, int c_num, int *marked );
struct Schedule *Read_schedule ( char *s_name, char *filename );

void CanalReInit();
void Canal_Network_Init (float baseDatum, float *elev ); /*parall*/
void Run_Canal_Network ( float *SWH, float *ElevMap, float *MC, float *GWV, float *poros, float *GWcond, 
                         double *NA, double *PA, double *SA, double *GNA, double *GPA, double *GSA,
                         float *Unsat, float *sp_yield);  /* may99 last 2 were wrong order */
void ReadStructures ( char* name );
void Channel_configure (  float *ElevMap, struct Chan *channel_first );/* parall */
void FluxChannel ( int chan_n, float *SWH, float *ElevMap, float *MC, float *GWH, float *poros, 
                   float *GWcond, double *NA, double *PA, double *SA, double *GNA, double *GPA, double *GSA,
                   float *Unsat, float *sp_yield);      
void Flows_in_Structures ( float *SWH, float *Elev, float *MC, double *NA, double *PA, double *SA ); /*jun99 added MC */
float f_Manning ( float delta, float SWater, float SW_coef );
float f_Ground ( float dh, float height, float GW_coef, float l_Length );
float *InitializeMap( char *In, float *Array );
char *Scip( char *s, char SYM );
int Round (float x);
int Wrdcmp ( char *s, char *t );
float GetGraph ( struct Schedule *graph, float x );
float feet2mx ( double feet );
float feet2my ( double feet );
float UTM2kmx ( double UTM );
float UTM2kmy ( double UTM );

#else 

struct Chan *ReadChanStruct ( );
struct Cells *MarkCell ( );
struct Schedule *Read_schedule (  );
void CanalReInit();
void Canal_Network_Init ( );
void Run_Canal_Network ( );     
void ReadStructures ( );
void Channel_configure ( );
void FluxChannel ( );     
void Flows_in_Structures ( );
float f_Manning ( );
float f_Ground ( );
float * InitializeMap( );
int Wrdcmp ( );
float GetGraph ( );
char *Scip( );
int Round ( );
float feet2mx ( );
float feet2my ( );
float UTM2kmx ( );
float UTM2kmy ( );

#endif
 
/*****************************/
