/* sept98, added modified readSeries fctn to read from multiple columns (remember Tools.h) 
jan99 added OutputPath 
*/

#include "globals.h"

#if HDF 
#include "hdf.h" 
#endif 

#define	MAXCOMBOS		30		/* Maximum # of current combos */

#define HDF_VERIFY(a) if(ret == FAIL) { printf("*** UNEXPECTED RETURN from %s is %d\n", a, (int)ret); }

struct	combo_table			/* Global per-stream structure	*/
	{
	int			step;	/* Current step	*/
	int			type;	/* Combo type */
	char			name[25];	/* File name */
	UCHAR		free;     /* free slot */
	int			ocnt;	/* # of times currently open	*/
	float          fvalue[10];
};
UINT	max_combos_open;			/* Max "open" map streams	*/
struct	combo_table	ctable[MAXCOMBOS];	/* Combination table	*/
char gSectorChar = '';
char gHabChar = '';
char gPairChar = '';
char gStart, gCnfg;
FILE* dFile, *outfile=NULL, *cnfgFile=NULL;
char gCArg[kCArgDepth][kCArgWidth];
int gVPindex = -1;
char cTemp[200], gTerm[4];
int find_char ( FILE *infile, char tchar); 
int find_spec_char ( FILE *infile); 
int find_graph_char ( FILE *infile); 
int get_number( FILE *infile );
int goto_index ( FILE *infile, char tchar, int index); 
float get_Nth_parm( FILE *infile, int pIndex, int* end );
void goto_Nth_parm( FILE *infile, int pIndex ) ;
float* get_hdep_parm( char* filename, int sIndex, int pIndex ); 
float* get_hdp2( char* filename, int sIndex, int pIndex, int index);

char *OutputPath; /* jan99 */
int cell_pts[MAX_TS_FILES], numPtFil; /* (clumsy use of) counters for point time series output */

#if NeedFunctionPrototypes
float SMDRAND( float  fminVal, float fmaxVal )
#else
float SMDRAND( fminVal, fmaxVal) 
float fminVal, fmaxVal;
#endif
{ 
  float rv, tmp;
  tmp = rand();
  rv = fminVal + (fmaxVal-fminVal)*(tmp/RAND_MAX); 
  return(rv);
} 

VOID  write_header(mapFileName,size)
char* mapFileName;
int size;
{
	FILE* header;
	fprintf(dFile,"Writing Header: filen = %s\n",mapFileName); fflush(dFile);
	header = fopen(mapFileName,"w");
	if(header==NULL) { fprintf(stderr,"Can't open header file: %s\n",mapFileName); fflush(stderr); exit(-1); }
	fprintf(header,"FILETYPE=INTERCHANGE\nROWS=%d\nCOLUMNS=%d\nCELLSIZE=1", gbl_size[0], gbl_size[1]);
	fprintf(header,"\nUNITS=KM\nFORMAT=BIN\nSIZE=%d\nLOCATION=%s.bin\n",size,mapFileName);
	fclose(header);
	strcat(mapFileName,".bin");
}

int  read_header( mapFileName )
char* mapFileName;
{
	FILE* file;
	int rows, cols, i, Dsize=1, test, offset;
	char ch, dirCh;
        long int start;
	
	file = fopen(mapFileName,"r");
	if(file==NULL) { fprintf(stderr,"Unable to open header file %s.\n",mapFileName); 
		fflush(stderr); exit(0);}
	else { fprintf(dFile,"Successfully opened header file %s.\n",mapFileName);  fflush(dFile); } 
	scan_forward(file,"ROWS=");
	fscanf(file,"%d",&rows);
	fprintf(dFile,"rows = %d\n",rows);
	scan_forward(file,"COLUMNS=");
	fscanf(file,"%d",&cols);
	fprintf(dFile,"cols = %d\n",cols); fflush(dFile);
	if( !( rows == gbl_size[0] && cols == gbl_size[1] ) ) { 
		fprintf(stderr,"Error, Wrong map size: %s: (%d,%d) : (%d,%d)\n",mapFileName,rows,gbl_size[0],cols,gbl_size[1]); }
	start = ftell(file);
	test = scan_forward(file,"\nSIZE=");
	if(test < 1) { clearerr(file); fseek(file, start, SEEK_SET); }
	else {	fscanf(file,"%d",&Dsize);
			fprintf(dFile,"size = %d\n",Dsize);
			if( Dsize < 1 || Dsize > 4 ) {  fprintf(stderr,"Error, Illegal map size: %s  (%d)\n",mapFileName,Dsize); exit(0); }
	}
	test = scan_forward(file,"LOCATION="); i=1;
        if (H_OPSYS == UNIX ) dirCh = '/'; else dirCh = ':';
	offset = strlen(mapFileName); 
	while( mapFileName[--offset] != dirCh ) if( offset == -1 ) break;
	while( ( ch=fgetc(file) ) != '' ) mapFileName[ offset + (i++) ] = ch;
	mapFileName[ offset + i ] = '\0';
	if(debug) { fprintf(dFile,"\nLOCATION = %s\n",mapFileName);  fflush(dFile); }
	fclose(file);
	return Dsize;
}

#if NeedFunctionPrototypes
void writeMap(char* filename, void* data, int bSize, unsigned char type, int index)
#else
void writeMap(filename,data,bSize,type,index)
char* filename; void* data; int bSize, index;
unsigned char type;
#endif
{
  int gsize, istat;
  FILE* bFile; 
  if(type=='M') write_header(filename,bSize);
  if (type == 'H') {
#if HDF
    if(index==0) { istat = DFR8putimage(filename,(char*)data,s1,s0,0); }
    else { istat = DFR8addimage(filename,(char*)data,s1,s0,0); }
    if(istat != 0) printf("\nerror writing HDF file: %s\n",filename);
#endif
  } else {
    if( ( bFile = fopen(filename,"wb") ) == NULL ) { fprintf(stderr,"Can't Open Mapfile: %s",filename); exit(0); }
    gsize = gbl_size[0]*gbl_size[1]*bSize;
    fwrite( (char*)data, gsize, 1, bFile );
    fclose(bFile);
  }
}

byte readMap(filename,data)
char* filename; void* data;
{
  int gsize, nbytes; byte bsize;
  FILE* bFile;
  bsize = read_header(filename);
  if( ( bFile = fopen(filename,"rb") ) == NULL ) { fprintf(stderr,"Can't Open Mapfile: %s",filename); exit(0); }
  gsize = gbl_size[0]*gbl_size[1];
  nbytes = fread( (char*)data, (int)bsize, gsize, bFile );
  if(debug) { fprintf(dFile," %d of %d items Read for %s, size = %x bytes ",nbytes,gsize,filename,bsize); }
  fclose(bFile);
  return bsize;
}

#if NeedFunctionPrototypes
float* readSeries(char *filename, int format, int index, int* Npt, float* TStep )
#else
float* readSeries( filename, format, index, Npt, TStep )
char *filename;
int format;
int index;
int* Npt;
float* TStep;
#endif
{
    int line = 1, cread=1, itest, month = 0, jday=0, j, sLen = 372;
    FILE *cfile;
    char  ctest, cmark[373], ret = '\n', fnum[20];
    unsigned char cmove[373], cmv=0;
    char tfilename[200];
    float  *tvar, last_var[13];

    sprintf(tfilename,"%s%d.ts",filename,index);
    fprintf(dFile,"\nReading file %s, index = %d\n",tfilename,index); fflush(dFile);
    cfile = fopen(tfilename,"r");
    if(cfile==NULL) {  
 	if( index > 0 ) {  fprintf(stdout,"\nWARNING: Unable to open timeseries file %s, using %s0.ts\n",tfilename,filename); return 0; } 
	else { fprintf(stdout,"\nERROR: Unable to open timeseries file %s\n",tfilename); exit(-1); } 
    }
    for(j=0; j<13; j++) last_var[j] = 0.0;

    switch (format) {

	case 1:
            tvar = (float*) nalloc( 380*sizeof(float), "timeseries temp" );
            sprintf(cmark,"Annual%c",ret);
            itest = scan_forward(cfile,cmark);
            fprintf(stderr,"Reading file %s, status = %d\n",filename,itest); fflush(stderr);
            if(itest==-1)  exit(-1);
            while( (ctest=fgetc(cfile)) == '-' || isspace(ctest) ) ;
            while(1) {			
                if(cread) { ctest=fgetc(cfile); }
                cread=1;
                if(ctest == '\n') 
                    if(line<31) { 
                        fscanf(cfile,"\t%d",&itest); 
                        line = itest; 
                        month = 0;
                        if(debug>1) fprintf(dFile,"\n"); 
                    } 
                    else break;
                else if( ctest == '\t' || ctest == ' ' )  { 
                    month++; 
                    while( (ctest=fgetc(cfile)) == ' ' || ctest == '\t' ) {;} 
                    cread=0; 
                }
                else if (ctest == '*') { 
                    tvar[ jday ] = -1; 
                    cmark[ jday ] = '*'; 
                    while( (ctest=fgetc(cfile)) == '*' ) {;}
                    cread=0; 
                    if(debug>1) { fprintf(dFile,"(%d,%f,%c) ",jday,tvar[ jday ],cmark[ jday ]); fflush(dFile); }
                }
                else if (ctest == 'T') { 
                    tvar[ jday ] = 0.0; 
                    cmark[ jday ] = 'T'; 
                    while( isalpha( ctest=fgetc(cfile) ) ) {;}
                    cread=0; 
                    if(debug>1) { fprintf(dFile,"(%d,%f,%c)",jday,tvar[ jday ],cmark[ jday ]); fflush(dFile); }
                }
                else if (ctest == '-') { 
                    if( (ctest=fgetc(cfile)) == '-' ) {
                        tvar[ jday ] = last_var[month]; 
                        cmark[ jday ] = '1'; 
                        while( (ctest=fgetc(cfile)) == '-' ) {;}
                        cread=0; 
                        if(debug>1) { fprintf(dFile,"(%d,%f,%c) ",jday,tvar[ jday ],cmark[ jday ]); fflush(dFile); }
                    }
                    else {
                        while( ctest == ' ' ) ctest=fgetc(cfile);
                        if(isdigit(ctest) ) {
                            fnum[0] = '-';
                            fnum[j=1] = ctest;
                            while ( isdigit( ctest=fgetc(cfile) ) || ctest == '.' ) 
                                fnum[++j] = ctest;
                            cread=0;
                            fnum[++j] = '\0';
                            last_var[month] = tvar[ jday ] = (float) atof(fnum); 
                            cmark[ jday ] = '1'; 
                            if(debug>1) { fprintf(dFile,"(%d,%f,%c)",jday,tvar[ jday ],cmark[ jday ]); fflush(dFile); }
                            if( isalpha(ctest) ) cread=1;
                        }
                        else { printf("Format error in TS File %s%d, day = %d, month = %d\n",filename,index,jday,month); exit(0); } 
                    }
                }
                else if( isdigit(ctest) ) {
                    fnum[j=0] = ctest;
                    while ( isdigit( ctest=fgetc(cfile) ) || ctest == '.' ) 
                        fnum[++j] = ctest;
                    cread=0;
                    fnum[++j] = '\0';
                    last_var[month] = tvar[ jday ] = (float) atof(fnum); 
                    cmark[ jday ] = '1'; 
                    if(debug>1) { fprintf(dFile,"(%d,%f,%c)",jday,tvar[ jday ],cmark[ jday ]); fflush(dFile); }
                    if( isalpha(ctest) ) cread=1;
                }	
                if(month<=12) jday = 31*(month-1) +line - 1 ;
                else jday = sLen;
            }
		 
            for(jday=0; jday<sLen; jday++) {
                if( cmark[jday] == '*') cmv++;
                cmove[jday] = cmv;
            }
            for(jday=0; jday<sLen; jday++) 
                if( cmark[ jday ] != '*') tvar[ jday - cmove[jday] ]  =  tvar[ jday  ];
		   
            if(debug>1) for(jday=0; jday<10; jday++) { fprintf(dFile,"(%d,%f), ",jday,tvar[ jday ]); }
            tvar[ sLen = 365 ] = 1.0;
            break;
	case 2:
            itest = scan_forward(cfile,"@>"); if(debug>1) fprintf(dFile,"@>%d ",itest);
            fprintf(stderr,"Reading file %s, status = %d\n",filename,itest); fflush(stdout);
            if(itest==-1)  exit(-1); scan_forward(cfile,"=");
            fscanf(cfile,"%f",TStep);if(debug>1) fprintf(dFile,"@>%d ",itest); 
            itest = scan_forward(cfile,"@>"); if(debug>1) fprintf(dFile,"@>%d ",itest); 
            if(itest==-1)  exit(-1); scan_forward(cfile,"=");
            fscanf(cfile,"%d",&sLen);
            itest = scan_forward(cfile,"@>"); if(debug>1) fprintf(dFile,"@>%d ",itest);
            if(itest==-1)  exit(-1);
            fprintf(dFile,"Data: (%d %f) \n",sLen,*TStep); 
            tvar = (float*) nalloc( (sLen+2)*sizeof(float), "timeseries temp" );
            for (line = 0; line<sLen; line++) {
                itest = scan_forward(cfile,">"); if(debug>1) fprintf(dFile,"%d> ",itest);
                if(itest==-1) { sLen = line; break; } 
                itest = fscanf(cfile,"%f",&(tvar[ line ]));
                if(itest<1) { tvar[line] = 0.0; }
                if(debug>1) fprintf(dFile,"line = %d: %f (%d)\n",line,tvar[ line ],itest);
            }
            tvar[ sLen ] = *TStep;	
            break;
	default:
            fprintf(stderr,"ERROR: unknown format in read_timeseries: %d\n",format); exit(0);
    }
    fprintf(dFile,"\nDone Reading file %s\n",tfilename); fflush(dFile);
    fflush(stdout);
    fclose(cfile);
    *Npt = sLen;
    return tvar;
}

#if NeedFunctionPrototypes /* sept98, added modified readSeries fctn to read from multiple columns */

float* readSeriesCol(char *filename, int format, int index, int* Npt, float* TStep, int col )
#else
float* readSeriesCol( filename, format, index, Npt, TStep, col )
char *filename;
int format;
int index;
int* Npt; 
float* TStep;
int col;
#endif

{
    int line = 0, cread=1, itest, j, sLen = 372 ;
    FILE *cfile;
    char  ctest, cmark[373], ret = '\n';
    unsigned char cmove[373], cmv=0;
    char tfilename[200], date_read[20],ss[200];
    int yyyy,mm, dd;
    double Jdate_read; /*jan99*/
    float  *tvar, *nullvar, first[10];

    sprintf(tfilename,"%s%d.ts",filename,index);
    if(debug>4) fprintf(dFile,"\nReading file %s, col %d, index = %d\n",tfilename,col,index); fflush(dFile);
    cfile = fopen(tfilename,"r"); 
    if(cfile==NULL) {  
 	if( index > 0 ) {  fprintf(stdout,"\nWARNING: Unable to open timeseries file %s, using %s0.ts\n",tfilename,filename); return 0; } 
	else { fprintf(stdout,"\nERROR: Unable to open timeseries file %s\n",tfilename); exit(-1); } 
    }

    if (format != 2) { fprintf(stderr,"ERROR: only using floats in read_timeseries: %d\n",format); exit(0); }
    
           sLen = Jdate_end-Jdate_init+1; /* global, read/determined in genericDriver */
            tvar = (float*) nalloc( (sLen+2)*sizeof(float), "timeseries temp" );
            scan_forward(cfile,"{END COMMENT}\n");
            fgets(ss,200,cfile); /* skip  the header line */
            
            do {
                fscanf(cfile, "%d %d %d %f %f %f %f", &yyyy,&mm,&dd,&first[1],&first[2],&first[3],&first[4] ); 
        /*jan99 julian day, returns a double (args = mon, day, yr, hrs,min,secs) */
                Jdate_read = julday(mm, dd, yyyy, 0, 0, 0); 
                if (Jdate_read > Jdate_init) {printf (" \n***Error\nInit date in %s file > simulation start date.\n",tfilename); exit (-1);}
                if feof(cfile) {printf (" \n***Error\nNon-matching starting date for %s meteorological time series\n",tfilename); exit (-1);}
            } while (Jdate_read < Jdate_init);
            
            tvar[0] = first[col]; /* have now read the first data record, assign to array */
            if(debug>4) fprintf(dFile,"%d %d %d %f\n",yyyy,mm,dd,tvar[0]);
            for (line = 1; line<sLen; line++) {
            
            /* each case for reading a different column */
                switch (col) {
                    case 1:
                        itest = fscanf(cfile,"%d %d %d %f %f %f %f",&yyyy,&mm,&dd, &(tvar[ line ]),&nullvar, &nullvar, &nullvar);
                        break;
                    case 2:
                        itest = fscanf(cfile,"%d %d %d %f %f %f %f",&yyyy,&mm,&dd,&nullvar, &(tvar[ line ]), &nullvar, &nullvar);
                        break;
                    case 3:
                        itest = fscanf(cfile,"%d %d %d %f %f %f %f",&yyyy,&mm,&dd,&nullvar, &nullvar, &(tvar[ line ]), &nullvar);
                        break;
                    case 4:
                        itest = fscanf(cfile,"%d %d %d %f %f %f %f",&yyyy,&mm,&dd,&nullvar, &nullvar, &nullvar, &(tvar[ line ]));
                        break;
                    default:
                        printf ("\nError in interpolation time series data.\n"); 
                        exit(-1);
                        break;
                } /* end switch */

                if(debug>4) fprintf(dFile,"%d %d %d %f\n",yyyy,mm,dd,tvar[ line ]);
                if feof(cfile) {printf (" \n***Error\nExceeded number of records for %s meteorological time series\n",tfilename); exit (-1);}
            }
            tvar[ sLen ] = *TStep;
 
    if(debug>4) { fprintf(dFile,"\nDone Reading file %s\n",tfilename); fflush(dFile); }
    
    fflush(stdout);
    fclose(cfile);
    *Npt = sLen;
    return tvar;
}



float* get_hdep_parm( char* filename, int sIndex, int pIndex ) 
{
	int hIndex, end=0;
	FILE* infile;
	float* fTmp;

	fTmp = (float*) malloc( MAX_NHAB * sizeof(float) );
	fTmp[0] = 0.0;
	fprintf(dFile,"\nReading file %s\n",filename); 
	infile = fopen(filename,"r");
	if(infile==NULL) {fprintf(stdout,"\nERROR: Unable to open dBase file %s\n",filename); exit(-1); }
	
	for( hIndex = 1; hIndex < MAX_NHAB; hIndex++) {
	
		goto_index (infile, gHabChar, hIndex); 
		goto_index (infile, gSectorChar, sIndex);
		fTmp[hIndex] = get_Nth_parm( infile, pIndex, &end );
		if(end) break;
	}
	fclose(infile);
	return fTmp; 
}

float* read_hdp2( filename, sIndex, pIndex, index, order )
char* filename; int sIndex, pIndex,  index, order ;
{
  if(order==2) return get_hdp2( filename, sIndex, pIndex, index);
  else if (order == 1) return get_hdep_parm( filename, sIndex, pIndex );
  else { printf("Illegal order in read_hdp2: %d\n",order); exit(0); }
  return NULL;
}

float* get_hdp2( filename, sIndex, pIndex, index)
char* filename; int sIndex, pIndex,  index;
{
	int test, cnt=0, i, j, iparm, imax, first = 1, mss;
	int hIndex, graphSize, *indexTmp, *itmp, n0=0, n1, seriesSize=0; 
	float  *fTemp, fparm, *graphTmp, *fGraph;
	FILE *infile;
	
	graphSize = 100;
	graphTmp = (float*)malloc(graphSize*sizeof(float));
	fGraph = (float*)malloc(graphSize*sizeof(float));
	indexTmp = (int*)malloc(graphSize*sizeof(int));

	fprintf(dFile,"\nReading file %s\n",filename); 
	infile = fopen(filename,"r");
	if(infile==NULL) {fprintf(stdout,"\nERROR: Unable to open dBase file %s\n",filename); Exit(-1); }
	
	for( hIndex = 1; hIndex < MAX_NHAB; hIndex++) {
	   rewind(infile);	
	   if( goto_index (infile, gHabChar, hIndex) ) { 
	   	  fprintf(dFile,"}\ngot graph : (Hab = %d)\n{ ",hIndex);
		  goto_index (infile, gSectorChar, sIndex);
		  goto_Nth_parm( infile, pIndex ); imax = 0;	
		  while(1) {
			test = fscanf(infile,"%d",&iparm);
			if( test == 1 ) {
				fprintf(dFile,"%d ",iparm);
				if(cnt >= graphSize) {
					free((char*)graphTmp);
					itmp = indexTmp; 
					graphSize = cnt + 20;
					graphTmp = (float*)malloc(graphSize*sizeof(float));
					indexTmp = (int*)malloc(graphSize*sizeof(int));
					for(i=0; i<cnt; i++) indexTmp[i] = itmp[i];
					free((char*)itmp);
				}
				indexTmp[cnt++] = iparm;
				if( iparm > imax ) imax = iparm;
			}
			else { usrErr("read error in get graph."); Exit(-1); }
			test = find_graph_char(infile);
			if (test == 1) {
				if(first) { n1 = imax+1; first = 0; }
				else if ( imax > n1 ) { usrErr("DBase Read Error, Unequal graph sizes"); Exit(0); }
				if ( (hIndex+1) > n0 ) n0 = (hIndex+1);
				if( n0*n1 > graphSize ) {					
					fTemp = fGraph; 
					mss = graphSize;
					graphSize = (n0+5)*n1*sizeof(float);
					fGraph = (float*)malloc(graphSize);
					for(i=0; i<mss; i++) ((UCHAR*)fGraph)[i] = ((UCHAR*)fTemp)[i];
					free((char*)fTemp);
				}
				for (j=0; j<n1; j++) ((float*)fGraph)[hIndex*n1 + j] = -1;
				cnt = 0;
				break; 
			}
			else if(test == -1) break;
		  }
		  while(1) {
			test = fscanf(infile,"%f",&fparm);
			if( test == 1 ) {
				fprintf(dFile,"%.2f ",fparm);
				graphTmp[cnt++] = fparm;
			}
			else { usrErr("read error in get graph"); Exit(0); }
			test = find_graph_char(infile);
			if(test == 2) { ; }
			else if (test == 1) { 
				for (j=0; j<cnt; j++) ((float*)fGraph)[ hIndex*n1 +indexTmp[j] ] = graphTmp[j];
				cnt = 0;
				break;
			}
			else break;
		  }
	   }
	}
	gSLen[index] = n1;
	free((char*)graphTmp);
	free((char*)indexTmp);
	fclose(infile);
	return (float*)fGraph;
} 

/* single-column format original */
void send_point_lists(SeriesParm *pSeries, int nSeries)
{
  FILE *oFile;
  int i, j, ix, iy;

  if(H_OPSYS == UNIX) sprintf(msgStr,"%s%s/Output/PointTimeSeries",OutputPath,ProjName);
  else sprintf(msgStr,"%s%s:Output:PointTimeSeries",OutputPath,ProjName);
  oFile = fopen(msgStr,"w");
  if(oFile == NULL) { fprintf(stderr,"Error, unable to open %s file.",msgStr); return; }
  
  for(i=0; i<nSeries; i++) {
    if( pSeries[i].data == NULL ) return;
    ix = pSeries[i].Loc.x;
    iy = pSeries[i].Loc.y;
    fprintf(oFile,"\n%s: (%d,%d)------------------------\n",pSeries[i].name,ix,iy);	
    for (j=0; j<pSeries[i].Length; j++) {
        fprintf(oFile,"%d\t%f\n",j,pSeries[i].data[j]); fflush(oFile); /* added fflush for ELM */
        
    }
  }
  fclose(oFile);
}

/* multi-column, multi-file format - see note below in open_point_lists, jan99 */
void send_point_lists2(SeriesParm *pSeries, int nSeries)
{
  FILE *oFile;
  int i=0, ii, j, ix, iy, k= 0, last_pt;
  double Jdate_pt;
  
      /* k = file/variable counter; i = indiv cellLoc time series counter */
  for (k = 0; k <= numPtFil; k++) { /* loop over the number of point ts files */
      if(H_OPSYS == UNIX) sprintf(msgStr,"%s%s/Output/PtSer/%s.pts",OutputPath,ProjName,pSeries[i].name);
      else sprintf(msgStr,"%s%s:Output:PtSer:%s.pts",OutputPath,ProjName,pSeries[i].name);
      oFile = fopen(msgStr,"a");
      if(oFile == NULL) { fprintf(stderr,"Error, unable to open %s file.",msgStr); return; }

      for(j=pSeries[i].laststep; j<pSeries[i].Length; j++ ) { /*temporal loop */
          Jdate_pt = Jdate_init+j*pSeries[i].outstep;
          calcdate( Jdate_pt, mo, da, yr, hr, mi, se); /* get the calendar date info from the julian date */
          fprintf(oFile,"\n%d/%d/%d\t",yr[0],mo[0],da[0] ); /* calendar date in col 1 */

          last_pt = i+cell_pts[k]; /* # of last cellLoc point of the current variable's file */
          for (ii=i; ii<last_pt; ii++) {/* loop over number of point locations per file */
              fprintf(oFile,"%f\t",pSeries[ii].data[j]);
          }
      }
      fclose (oFile); 
      pSeries[i].laststep = j; /* remember the last temporal outstep for this file */
      i += cell_pts[k];     /* increment the indiv cellLoc time series counter */ 
  }
  return;
}


/* open files and print headers for multi-column, multi-file format jan99 */
/* the user can define, for any variable in the model,one or more cell (point)
   locations for which point time series data are written.  There can be
   ca. 10-50 point TS each for both total_head and surface water P conc that need to
   be output for calib/verif comparison to observed data.  Other variables such
   as elevation may also want to be printed with some point data at diff outsteps.
   Thus, we make a separate file for each variable (unknown until user chooses)
   that has multiple columns for multiple points (unknown until user chooses). A
   structure should/could be set up for this, but to maintain minimal changes
   between the parallel and serial versions, for now we just maintain the
   original data structure and use some counters below to keep track of
   diff files and numbers of columns (also allowing different output steps as
   chosen by the user). (The original code printed all variables
   in one column in one file). */

void open_point_lists(SeriesParm *pSeries, int nSeries)
{
  FILE *oFile;
  int i, j, ix, iy, k= 0 ;

  for (i=0; i<nSeries; i++) {
      if( pSeries[i].data == NULL ) {fclose (oFile); return;}
      if (strcmp(pSeries[i].name,pSeries[i-1].name) != 0) {
              /* numPtFil== increment counter of number of variables/files used for output */
          if (i>0) { numPtFil++; fclose (oFile); }
          
          if(H_OPSYS == UNIX) sprintf(msgStr,"%s%s/Output/PtSer/%s.pts",OutputPath,ProjName,pSeries[i].name);
          else sprintf(msgStr,"%s%s:Output:PtSer:%s.pts",OutputPath,ProjName,pSeries[i].name);
          oFile = fopen(msgStr,"w");
          if(oFile == NULL) { fprintf(stderr,"Error, unable to open %s file.",msgStr); return; }
          fprintf (oFile, "%s %s %s %s scenario: \nDate\t", &modelName, &modelVers, &SimAlt, &SimModif);
          
      }

      ix = pSeries[i].Loc.x;
      iy = pSeries[i].Loc.y;
      fprintf(oFile,"%s:(%d,%d)\t",pSeries[i].name,ix,iy);
      cell_pts[numPtFil]++; /* count the number of cell point locs per variable/file */
      
  }
}

#if NeedFunctionPrototypes
void Copy(void *src, void *dst, int w, int n, int sw, int dw)
#else
void Copy( src, dst, w, n, sw, dw) 
void *src; void *dst; int w; int n; int sw; int dw;
#endif
{
	int i;
	for(i=0; i<n; i++) memcpy( ((UCHAR*)dst)+i*dw, ((UCHAR*)src)+i*sw, w );
}

#if NeedFunctionPrototypes
void writeSeries(void* fValue, char* label, char* desc, int N0, int N1, byte Mtype, byte format )
#else  
void writeSeries(fValue,label,desc,N0,N1,Mtype,format)
int N0,N1;
char* label;
char* desc;
void* fValue;
UCHAR Mtype;
UCHAR format;
#endif
{
  int ix, iy; 
  static unsigned char first_write = 1;
  long int  ret, dimsizes[2];
  unsigned short int refnum;
  if(format == 'H') {
  
#if HDF	  
	  dimsizes[0] = N0;
	  dimsizes[1] = N1;
	  sprintf(cTemp,"%s%s:Output:Windows.hdf",OutputPath,ProjName);
	  DFSDclear();
	  
	  switch(Mtype) {
		 case 'f': 
		    DFSDsetNT(DFNT_FLOAT32);  break;
		 case 'L': 
		    DFSDsetNT(DFNT_FLOAT32);  break;
		 case 'E': 
		    DFSDsetNT(DFNT_FLOAT32);  break;
		 case 'd': case 'i': 
		    DFSDsetNT(DFNT_INT32);  break;
		 case 'c': 
		    DFSDsetNT(DFNT_UINT8);  break;
	  }
	  if(first_write) {
	  	ret = DFSDputdata(cTemp,2,dimsizes,fValue);
		first_write = 0;
	  } else {
	  	ret = DFSDadddata(cTemp,2,dimsizes,fValue);
	  }
	  HDF_VERIFY("DFSDadddata");
	  refnum = DFSDlastref();
	  ret = DFANputlabel(cTemp,DFTAG_SDG,refnum,label);
	  HDF_VERIFY("DFANputlabel");
	  ret = DFANputdesc(cTemp,DFTAG_SDG,refnum,desc,strlen(desc));
	  HDF_VERIFY("DFANputdesc");
#endif
  }
  else {
    fprintf(outfile,"\n_________%s\n",label);	
    fprintf(outfile,"%s\n",desc);	
    for (ix=0; ix<N0; ix++) {
      fprintf(outfile,"\n");
      for (iy=0; iy<N1; iy++) {
        switch(Mtype) {
          case 'f': 
      	 	if(format=='L') 		fprintf(outfile,"%f ",*(((float*)fValue)+iy+ix*N1)); 
      		else if(format=='E')  	fprintf(outfile,"%.3E ",*(((float*)fValue)+iy+ix*N1)); 
			else 				fprintf(outfile,"%.3f ",*(((float*)fValue)+iy+ix*N1));
			break;
      	case 'd': case 'i': 
			fprintf(outfile,"%d ",*(((int*)fValue)+iy+ix*N1)); 
			break;
      	case 'c': 
			fprintf(outfile,"%x ",*(((UCHAR*)fValue)+iy+ix*N1)); 
			break;
        }
      }
    }  
  }
}

int getCombineIndex(name,step,type,last)
char* name;
int step, type, *last;
{
	int count, index = -1;
	*last = 0;
	
	for(count = 0; count < max_combos_open; count++) {
	
		if( ctable[count].free )	{			/* Determine if the slot is in use. */
			if(index == -1) index = count;		/* Nope, keep track of first free global stream table slot. */ 
			if(debug) { fprintf(dFile,"cnt = %d, index = %d, free combo stream\n",count,index); fflush(dFile); }
		}
		else if( strncmp(name,ctable[count].name,25) == 0 && ctable[count].type == type ) {
		    *last = 1; 
		    if(debug) { 
		      fprintf(dFile,"\n(%s)combo cnt = %d, step = %d, type = %d\n",
			      name,count,step,type); 
		      	fflush(dFile); 
		    }
		    return count;
		}
	}
	if( index == -1 ) { 
		index = max_combos_open; 
		if( ++max_combos_open > MAXCOMBOS) { sprintf(msgStr,"Out of combo slots: %s, step=%d, type=%d\n",name,step,type);  usrErr(msgStr); return -1; }
	}
	if(debug) { fprintf(dFile,"\n(%s)index = %d, step=%d, setup combo\n",name,index,step); fflush(dFile); }
	strncpy(ctable[index].name,name,25);
	ctable[index].step = step;
	ctable[index].type = type;
	ctable[index].free = 0;
	*last = -1;
	return index;
}

void Combine(float* fValue, char* label, int nComp, int cType, int step)
{
	int print, cIndex, i, cum;
	static int type = 11;
	char tmpStr[50];
	if( ++type > 99) type = 11;

	cum = ((cType == kAVECUM) || (cType == kSUMCUM)) ? 1 : 0;	
	if(cum) { cIndex = getCombineIndex(label,step,cType,&print); }
	
	switch(cType) {
		case kMAXMIN: 
			sprintf(msgStr,"\nMAXMIN(%d) for %s:",step,label); 
			for(i=0; i<nComp; i++) { sprintf(tmpStr," %f",fValue[i]); strcat(msgStr,tmpStr); }
			WriteMsg(msgStr,1);
		break;
		case kMAX:
			sprintf(msgStr,"\nMAX(%d) for %s:",step,label); 
			for(i=0; i<nComp; i++) { sprintf(tmpStr," %f",fValue[i]); strcat(msgStr,tmpStr); }
			WriteMsg(msgStr,1);
		break;
		case kMIN:
			sprintf(msgStr,"\nMIN(%d) for %s:",step,label); 
			for(i=0; i<nComp; i++) { sprintf(tmpStr," %f",fValue[i]); strcat(msgStr,tmpStr); }
			WriteMsg(msgStr,1);
		break;
		case kSUM:
			sprintf(msgStr,"\nSUM(%d) for %s:",step,label); 
			for(i=0; i<nComp; i++) { sprintf(tmpStr," %f",fValue[i]); strcat(msgStr,tmpStr); }
			WriteMsg(msgStr,1);
		break;
		case kAVE:
			sprintf(msgStr,"\nAVE(%d) for %s:",step,label); 
			for(i=0; i<nComp; i+=2) { sprintf(tmpStr," %f",fValue[i]/fValue[i+1]); strcat(msgStr,tmpStr); }
			WriteMsg(msgStr,1);
		break;
		case kSUMCUM:
			if( print == -1) {
				for(i=0; i<nComp; i++) ctable[cIndex].fvalue[i] = fValue[i]; 
			
			} else {
				for(i=0; i<nComp; i++) ctable[cIndex].fvalue[i] += fValue[i]; 
			}
			if(print==1) { 				
				sprintf(msgStr,"\nSUMCUM(%d) for %s:",step,label); 
				for(i=0; i<nComp; i++) { sprintf(tmpStr," %f",ctable[cIndex].fvalue[i]); strcat(msgStr,tmpStr); }
				WriteMsg(msgStr,1);
			}
		break;
		case kAVECUM:
			if( print == -1) {
				for(i=0; i<nComp; i++) ctable[cIndex].fvalue[i] = fValue[i]; 
			
			} else {
				for(i=0; i<nComp; i++) ctable[cIndex].fvalue[i] += fValue[i]; 
			}
			if(print==1) { 				
				sprintf(msgStr,"\nAVECUM(%d) for %s:",step,label); 
				for(i=0; i<nComp; i+=2) { sprintf(tmpStr," %f",ctable[cIndex].fvalue[i]/ctable[cIndex].fvalue[i+1]); strcat(msgStr,tmpStr); }
				WriteMsg(msgStr,1);
			}
		break;
	}
}	
	


void WriteMsg(msg,wh)
char* msg;
int wh;
{
  wh = 1;
  if(outfile) fprintf(outfile,"%s\n",msg); 
  else fprintf(stdout,"%s\n",msg); 
  fflush(stdout);
}

void exparam(envInfo) 
struct nodenv* envInfo;
{	
	envInfo->procnum = 1;
	envInfo->nprocs = 1;
	envInfo->groupid = 0;
	envInfo->taskid = 0;
 
}

int  exgridinit(dim, nprocs) 		/*  For EXPRESS Compatibility  */	
int dim, *nprocs;
{ return 0;}

void exgridsplit(nprocs, ndim, nprocs2)  
int nprocs, ndim, nprocs2[2];
{
  nprocs2[0] = 1;
  nprocs2[1] = 1;
}

void exgridcoord(pnum, rnum) 
int pnum, rnum[2];
{
    tramNum[0] = rnum[0] = 0;
    tramNum[1] = rnum[1] = 0;
}

void exgridsize(pnum,gsize,lsize,lstart)
int pnum, gsize[2], lsize[2], lstart[2];
{
	int rem[2], i, j;
	for( i=0; i<2; i++ ) {
		lsize[i] = gsize[i]/nprocs[i];
		rem[i] = gsize[i] - lsize[i]*nprocs[i];
		if(recpnum[i]<rem[i]) lsize[i]++;
		for(j=0; j<recpnum[i]; j++) if( j<rem[i] && recpnum[i] >= rem[i] ) lstart[i] += (lsize[i]+1); else lstart[i] += lsize[i];
	}
}

void set_async_mode(file) 
FILE* file;
{ return;}

void fmulti(file) 
FILE* file;
{ return;}

void fsingl(file) 
FILE* file;
{ return;}

void fasync(file) 
FILE* file;
{ return;}


void usrErr (char* dString) 
{
   fprintf(stderr,"%s\n", dString); fflush(stderr); 
}

void usrErr0 (char* dString) /*jan99*/
{
   fprintf(stderr,"%s", dString); fflush(stderr); 
}

void Exit(code)
int code;
{ exit(code); }

void exchange_borders(UCHAR* map, int size) {
return;
}

int on_this_proc(x,y)
	int x, y;
{ return 1; }

#if NeedFunctionPrototypes
void Cplot(VOIDP Map, unsigned char Mtype, float max_value, float min_value) 
#else
void Cplot(Map, Mtype, max_value, min_value) 
VOIDP Map; unsigned char Mtype; float max_value; float min_value;
#endif
 {
}

void broadcastMsg( msgPtr )
UCHAR* msgPtr;
{}

void broadcastInt( iValPtr )
int* iValPtr;
{}

void broadcastChar( cPtr )
UCHAR* cPtr;
{}

void broadcastData( dataPtr, dataSize )
void* dataPtr;
int *dataSize;
{}

void sync_processors() {
  return;
}

void broadcastFloat(dataPtr)
void* dataPtr;
{}

void getInt(inFile, lString, iValPtr )
FILE* inFile;
int* iValPtr;
char* lString;
{
	int test;
	UCHAR iEx=0;
	if(lString)  scan_forward(inFile,lString);
	test = fscanf(inFile,"%d",iValPtr);
	if(test != 1) {
		 fprintf(stderr,"Read Error (%d):",test);
		 if(lString) fprintf(stderr,"%s\n",lString);
		 *iValPtr = 0;
		 iEx = 1;
	}
	if (iEx) exit(0);
}

void getChar(inFile, lString, cValPtr )
FILE* inFile;
char* cValPtr;
char* lString;
{
	int test;
	UCHAR iEx=0;
	if(lString)  scan_forward(inFile,lString);
	test = fscanf(inFile,"%c",cValPtr);
	if(test != 1) {
		fprintf(stderr,"Read Error (%d):",test);
		if(lString) fprintf(stderr,"%s\n",lString);
		iEx = 1; 
		*cValPtr = '\0';
	}
	if (iEx) exit(0);
}

void getString(inFile, lString, inString )
FILE* inFile;
char *lString, *inString;
{
	int test;
	UCHAR iEx=0;
	if(lString)  scan_forward(inFile,lString);
	test = fscanf(inFile,"%s",inString);
	if(test != 1) {
		fprintf(stderr,"Read Error (%d):",test);
		if(lString) fprintf(stderr,"%s\n",lString);
		iEx = 1; 
	}
	if (iEx) exit(0);
}

void getFloat(inFile, lString, fValPtr )
FILE* inFile;
float* fValPtr;
char* lString;
{
	int test, fSize;
	UCHAR iEx=0;
	if(lString)  scan_forward(inFile,lString);
	test = fscanf(inFile,"%f",fValPtr);
	if(test != 1) {
		fprintf(stderr,"Read Error (%d):",test);
		if(lString) fprintf(stderr,"%s\n",lString);
		*fValPtr = 0.0;
		iEx = 1;
	}
	if (iEx) exit(0);
}

void local_setup(argc, argv)
int argc;
char *argv[]; 
{
	int i;
	nprocs[0] = 1;
	nprocs[1] = 1;
	tramType =  0;
	procnum = 1;
	recpnum[0] = 0;
	recpnum[1] = 0;
	Lprocnum = 1;
	max_combos_open = 0;	
	for(i = 0; i < MAXCOMBOS; i++) {
		ctable[i].ocnt = 0;
		ctable[i].free = 1;
	}
	dFile = fopen("Driver.debug","w");
	if( dFile == NULL) { usrErr("Can't open Driver.debug file."); Exit(0); }
	srand(seed);
	fprintf(dFile," RAND_MAX = %d\n",(int)RAND_MAX);
}


    

void open_out_files(index)
int index;
{
  char filename[120];
  
  if (H_OPSYS == UNIX ) 
    sprintf(filename,"%s/%s/Output/Debug/Driver%x.out",OutputPath,ProjName,(UCHAR)index);
  else
    sprintf(filename,"%s%s:Output:Driver%x.out",OutputPath,ProjName,(UCHAR)index);

  outfile = fopen(filename,"w");
  if(outfile == NULL) { 
  	fprintf(stderr,"Error, unable to open %s file.\n",filename);
  	fprintf(stderr,"OutputPath: %s\n",OutputPath);  
  	fprintf(stderr,"Project: %s\n",ProjName);  
  	exit(0); 
  }

}

int init_config_file(FILE *vpFile, char term1, char term2, char term3, char term4)
{
  char test;
  int format,size=-1;

  gTerm[0] = term1;
  gTerm[1] = term2;  
  gTerm[2] = term3;  
  gTerm[3] = term4;  
  skip_white(vpFile);
  test = fgetc(vpFile);
  if(test == gTerm[0])
      fscanf(vpFile,"%d",&format);
  else
      format = -1;
  return format;
}


#if NeedFunctionPrototypes
int init_config_fileOLD(char* filename, char term1, char term2, char term3, char term4)
#else
int init_config_fileOLD(filename, term1, term2, term3, term4 )
char *filename, term1, term2, term3, term4; 
#endif
{
  char test; int format, size=-1;
  cnfgFile = fopen(filename,"r");
  if(cnfgFile==NULL) { fprintf(stderr,"Error, can't open file %s",filename); exit(0); }
  gTerm[0] = term1;
  gTerm[1] = term2;  
  gTerm[2] = term3;  
  gTerm[3] = term4;  
  skip_white(cnfgFile);
  test = fgetc(cnfgFile);
  if(test == gTerm[0])  fscanf(cnfgFile,"%d",&format);
  else return -1;
  return format;
}

/*jan99*/
int skip_cnfg_space(FILE *vpFile, char* tch)
{
	char ch; int rv = 1;
	ch = *tch;
	while( isspace(ch) ) { 
		if( (ch=fgetc(vpFile)) == EOF || ch == gTerm[3] || ch == '\0' ) {
			fclose(vpFile); cnfgFile = NULL; return -3; 
		}
	}
	*tch = ch;
	return rv;
}

int skip_cnfg_spaceOLD(char* tch)
{
	char ch; int rv = 1;
	ch = *tch;
	while( isspace(ch) ) { 
		if( (ch=fgetc(cnfgFile)) == EOF || ch == gTerm[3] || ch == '\0' ) {
			fclose(cnfgFile); cnfgFile = NULL; return -3; 
		}
	}
	*tch = ch;
	return rv;
}

int parse_packet( FILE *vpFile, int* nArgs, char* test) 
{
    static	int     gVPindex = -1;
    static	char    gCnfg;
    
	char ch = ' ', eChar = ' '; 
	int btype=0, argc=2, go=1, i=0, j=0, new_name = 0;

	if(vpFile == NULL) return -3;
	while (1) {
		if ( skip_cnfg_space(vpFile, &ch) < 0) return -3; j=0;
		if( ch == gTerm[1] || ch == gTerm[2] ) {
		    gCnfg = ch; ch = ' ';
			if ( skip_cnfg_space(vpFile, &ch) < 0 ) return -3;
			while ( !isspace(ch) ) { cTemp[j++] = ch; ch=fgetc(vpFile); }
			cTemp[j++] = '\0'; new_name = 1;
			gVPindex++;
		}
		else break;
	}
	strcpy(gCArg[0],cTemp);
	*test = gCnfg;
	while ( isalnum( ch ) ) { gCArg[1][i++]=ch; ch=fgetc(vpFile); }
	gCArg[1][i]='\0'; i=0;
	while( 1 ) {
		if( ch == '(' ) { eChar = ')'; break;} 
		else if( ch == '[' ) { eChar = ']'; break;} 
		else if( ch == '{' ) { eChar = '}'; break;} 
		else if( !isspace(ch) ) { return -3;}
		ch=fgetc(vpFile);
	}
	while (go) {
		while( ch=fgetc(vpFile) ) {
			if( ch == ',' ) { argc++; break; }
			if( ch == ')' ||  ch == '}' ||  ch == ']')  { 
				if( ch == eChar ) {  argc++; go=0; break;} 
				else { printf( "\nWarning: Syntax error in parse_config, var: %s\n",gCArg[0]); return -2; } 
			}
			gCArg[argc][i++]=ch;
			if( i==(kCArgWidth-1) ) break;
		}
		if(i==0) { printf( "\nWarning: Syntax error in parse_config, var: %s\n",gCArg[0]); return -2; } 
		else { gCArg[argc-1][i]='\0'; i=0; }
		if(argc == kCArgDepth) { 
			while( ch != eChar ) ch=fgetc(vpFile);  
			go = 0; 
		}
	}
	*nArgs = argc;
	if(argc==0) { printf( "\nWarning: Syntax error in parse_config, var: %s\n",gCArg[0]); return -2; }
	else return gVPindex;		
} 


int parse_packetOLD( int* nArgs, char* test) 
{
	char ch = ' ', eChar = ' '; 
	int btype=0, argc=2, go=1, i=0, j=0, new_name = 0;

	if(cnfgFile == NULL) return -3;
	while (1) {
		if ( skip_cnfg_spaceOLD(&ch) < 0) return -3; j=0;
		if( ch == gTerm[1] || ch == gTerm[2] ) {
		    gCnfg = ch; ch = ' ';
			if ( skip_cnfg_spaceOLD(&ch) < 0 ) return -3;
			while ( !isspace(ch) ) { cTemp[j++] = ch; ch=fgetc(cnfgFile); }
			cTemp[j++] = '\0'; new_name = 1;
			gVPindex++;
		}
		else break;
	}
	strcpy(gCArg[0],cTemp);
	*test = gCnfg;
	while ( isalnum( ch ) ) { gCArg[1][i++]=ch; ch=fgetc(cnfgFile); }
	gCArg[1][i]='\0'; i=0;
	while( 1 ) {
		if( ch == '(' ) { eChar = ')'; break;} 
		else if( ch == '[' ) { eChar = ']'; break;} 
		else if( ch == '{' ) { eChar = '}'; break;} 
		else if( !isspace(ch) ) { return -3;}
		ch=fgetc(cnfgFile);
	}
	while (go) {
		while( ch=fgetc(cnfgFile) ) {
			if( ch == ',' ) { argc++; break; }
			if( ch == ')' ||  ch == '}' ||  ch == ']')  { 
				if( ch == eChar ) {  argc++; go=0; break;} 
				else { printf( "\nWarning: Syntax error in parse_config, var: %s\n",gCArg[0]); return -2; } 
			}
			gCArg[argc][i++]=ch;
			if( i==(kCArgWidth-1) ) break;
		}
		if(i==0) { printf( "\nWarning: Syntax error in parse_config, var: %s\n",gCArg[0]); return -2; } 
		else { gCArg[argc-1][i]='\0'; i=0; }
		if(argc == kCArgDepth) { 
			while( ch != eChar ) ch=fgetc(cnfgFile);  
			go = 0; 
		}
	}
	*nArgs = argc;
	if(argc==0) { printf( "\nWarning: Syntax error in parse_config, var: %s\n",gCArg[0]); return -2; }
	else return gVPindex;		
} 

 
 int find_char ( FILE *infile, char tchar) 
{
	char test = '1', cchar = '#';
	int in_c=0;
		
	while( test != EOF ) {
		test = fgetc(infile);
		if( test == tchar && in_c==0 ) { return 1; }
		if( test == cchar ) in_c=1;
		if( test == '\n' )  in_c=0;
	}		
	return(0);
}

int find_spec_char ( FILE *infile) 
{
	char test = '1', cchar = '#';
	int in_c=0;
		
	while( ( test = fgetc(infile) ) != EOF) {
		if(in_c==0) {
			if( test == gHabChar ) return 1;
			if( test == gSectorChar ) return 2;
			if( test == gPairChar ) return 3;
		}
		if( test == cchar ) in_c=1;
		if( test == '\n' )  in_c=0;
	}		
	return(0);
}

int find_graph_char ( FILE *infile) 
{
	char test;		
	while( ( test = fgetc(infile) ) != EOF ) if( test != ' ' ) {
		if( test == '\t' ) return 1;
		if( test == '' ) return 2;
		else return -1;
	}		
	return(0);
}

int get_number( FILE *infile ) {
	char ch;
	int rv;
	
	ch = fgetc(infile);
	if( !isdigit( ch ) ) return(-1);
	rv = ch - '0';
	
	while( isdigit( ch = fgetc(infile) ) ) 
		rv = rv*10 + ( ch - '0' );
		
	return rv;
}

int goto_index ( FILE *infile, char tchar, int index) 
{
	int rv=1, current_index=-1, itest;

	while(current_index != index) {	
		itest = find_char (infile, tchar);
		if(itest <= 0) return 0;
		current_index = get_number(infile);
		if(current_index < 0) fatal("Bad number format in dBase");
	}
	return 1;
}

float get_Nth_parm( FILE *infile, int pIndex, int* end ) 
{
	int i=1, itest=1;
	float rv; char ch;
	
	while ( (i++ < pIndex) && itest > 0 ) { itest = find_char ( infile, '\t' ); }
	if( itest == 0 ) { *end = 1; return(0.0); }
	
	itest = fscanf(infile,"%f",&rv);
	if(itest==1) { if(debug) { sprintf(msgStr,"got parm: %f\n",rv); fflush(dFile); WriteMsg(msgStr,1); }}
	else if ( (ch = fgetc(infile)) == EOF ) { *end = 1; return(0.0); }
	else {
		sprintf(msgStr,"Read Error in dBase(%d)\n REad Dump:\n",itest); WriteMsg(msgStr,1);
		for(i=0; i<12; i++) { 
			ch = fgetc(infile);
			if(ch==EOF) { sprintf(msgStr,"\nAt EOF\n"); WriteMsg(msgStr,1); break; }
			else fputc(ch,dFile);
		}
		exit(0);
	}
	*end = 0;
	return(rv);
}

void goto_Nth_parm( FILE *infile, int pIndex ) 
{
	int i=1;
	while ( i++ < pIndex ) find_char ( infile, '\t' );
}



float FMOD( float x, float y) {
  return (float)fmod((double)x, (double)y);
}

void local_init() {;}
