/* Statistical summaries */

/* basin/Indicator_Region budgets and mass balance checks,
   cell-specific averages
   basin-specific averages
*/
/* may99 modified init_pvar fcn for basin double and map double precision */

#include "UnitMod.h"


int *numCells, numBasn; /* array of number of cells in basins, number of basins */

/* water budget/mass check */
double *SUMSF, *SUMGW, *SUMUW, *RAIN, *EVAP, *TRANSP, *RCHG; 
double *TOT_VOL, *TOT_VOL_OLD, *VOL_IN, *VOL_OUT, *TOT_VOL_ERR, *VOL_ERR_PER_INFL,
    *TOT_VOL_CUM_ERR, *TOT_VOL_AVG_ERR;
double *VOL_IN_SUM, *VOL_OUT_SUM, *VOL_IN_AVG, *VOL_OUT_AVG; 

/* P budget/mass check for all storage fractions */
double *P_CELL, *P_RAIN; /* RECHARGE IS always 0, BUT NEED TO ADD THAT OUTFLOW for non-zero flux */
double *P, *P_OLD, *P_IN, *P_OUT, *P_ERR, *P_ERR_CUM;
double *P_IN_SUM, *P_OUT_SUM, *P_IN_AVG, *P_OUT_AVG; 

/* P budget/mass check for live storage fractions */
double *P_LIVE_CELL, *P_MAC, *P_Calg, *P_NCalg;
double *Calg_GPP, *NCalg_GPP, *Calg_mort, *NCalg_mort, *mac_mort, *mac_NPP;
double *P_LIVE, *P_LIVE_OLD, *P_LIVE_IN, *P_LIVE_OUT, *P_LIVE_ERR, *P_LIVE_ERR_CUM;
double *P_LIVE_IN_SUM, *P_LIVE_OUT_SUM, *P_LIVE_IN_AVG, *P_LIVE_OUT_AVG; 

/* P budget/mass check for dead (in soil, plants, NOT including water-borne) storage fractions */
double *P_DEAD_CELL;
double *dop_macIn, *dop_stdIn, *dop_sorbIn, *dop_decomp, *dop_desorb,
    *floc_decomp, *floc_In;
double *stdet_in, *stdet_out;
double *P_DEAD, *P_DEAD_OLD, *P_DEAD_IN, *P_DEAD_OUT, *P_DEAD_ERR, *P_DEAD_ERR_CUM;
double *P_DEAD_IN_SUM, *P_DEAD_OUT_SUM, *P_DEAD_IN_AVG, *P_DEAD_OUT_AVG; 

/* P budget/mass check for water-borne storage fractions */
double *P_WAT_CELL;
double *wat_sfMiner, *wat_sedMiner, *wat_sfUpt, *wat_sedUpt, *P_settl;
double *P_WAT, *P_WAT_OLD, *P_WAT_IN, *P_WAT_OUT, *P_WAT_ERR, *P_WAT_ERR_CUM;
double *P_WAT_IN_SUM, *P_WAT_OUT_SUM, *P_WAT_IN_AVG, *P_WAT_OUT_AVG; 

/* S budget/mass check */
double *TOT_S_CELL; /* RECHARGE IS always 0, BUT NEED TO ADD THAT OUTFLOW for non-zero flux */
double *TOT_S, *TOT_S_OLD, *S_IN, *S_OUT, *TOT_S_ERR, *S_ERR_CUM;
double *S_IN_SUM, *S_OUT_SUM, *S_IN_AVG, *S_OUT_AVG; 

/* average (& hydroperiod) variables */
double *DepthAvg, *UnsatAvg, *TPsf_avg, *TPpore_avg, *TPsoil_avg, *NCperi_avg, *Cperi_avg, *Mac_avg;

float *HydPerAnn, *SfWatAvg, *UnsatZavg, *UnsatMoistAvg, *TotHeadAvg, *RainAvg,
    *ETAvg, *EvapAvg, *TranspAvg;
float *TPSfWatAvg, *TPSfUptAvg, *TPSfMinAvg, *TP_settlAvg, *TPSedWatAvg, *TPSedUptAvg,
    *TPSedMinAvg, *TPSorbAvg, *TPtoVOLAvg, *TPtoSOILAvg;
float *SaltSfAvg, *SaltSedAvg;
float *Floc_fr_phBioAvg, *DOM_fr_stdetAvg;
float *PeriLiteCFAvg, *PeriAvg,
    *NC_PeriAvg, *NC_Peri_nppAvg, *NC_Peri_mortAvg, *NC_PeriNutCFAvg, *NC_PeriRespAvg,
    *C_PeriAvg, *C_Peri_nppAvg, *C_Peri_mortAvg, *C_PeriNutCFAvg, *C_PeriRespAvg,
    *NC_Peri_PCAvg, *C_Peri_PCAvg;    
float *Mac_totBioAvg, *Mac_nphBioAvg, *Mac_phBioAvg, *Mac_nppAvg, *Mac_nphMortAvg,
    *Mac_phMortAvg, *LAI_effAvg, *Manning_nAvg, *MacNutCfAvg, *MacWatCfAvg,
    *mac_nph_PCAvg, *mac_ph_PCAvg;
float *Std_detrAvg;

void cellAvg();
void budgSum();
void DatePrnt();
void budgFinal(int ibas);
void budgReset(int ibas);


/*******
main calling function for budget and summary stats
******/
void stats(step)
 int step;
/* always called last during a time step */
/* use basin-specific arrays for budget */
/* basin 0 is the entire system */	
/* debug switch must be >0 to turn on budget calcs in the horiz flux modules */

/* we also calculate cell-specific and basin/IRegion- specific means in this module */

{
    int ix, iy, x, y, cellLoc, ibas, ii; 
    
    struct basnDef *basins;

        /* calcs for global averages (each cell in entire map array) */
    cellAvg();
        /* generate summations for basin (and IRegion) budgets - also doing means within basins/IRegions here */
    budgSum();
    

/*############*/				
/* now calc the budget/mass balance info and print out results at the avgIntvl interval time */
    if ( !(FMOD(TIME, avgIntvl)) )  {
        if (TIME/avgIntvl>1) DatePrnt(); /* print date stamp on current output record */
        
        for (ibas = numBasn; ibas >= 0; ibas--) {
            basins = basn_list[ibas];

            for (ii=0; ii<basins->numIR; ii++) { 
/* get the (non-budget) mean values for cells within indicator regions */
                DepthAvg[ibas] +=  DepthAvg[basins->IR[ii]];
                UnsatAvg[ibas] +=  UnsatAvg[basins->IR[ii]];
                TPsf_avg[ibas] +=  TPsf_avg[basins->IR[ii]];
                TPpore_avg[ibas] +=  TPpore_avg[basins->IR[ii]];
                TPsoil_avg[ibas] +=  TPsoil_avg[basins->IR[ii]];
                NCperi_avg[ibas] +=  NCperi_avg[basins->IR[ii]];
                Cperi_avg[ibas] +=  Cperi_avg[basins->IR[ii]];
                Mac_avg[ibas] +=  Mac_avg[basins->IR[ii]];
                
                    /* sum up all the I/O to indicator regions within a hydrologic basin
                       (the horizontal flows are treated within the flow calcs) */
                    /* flows */
                RAIN[ibas]+=RAIN[basins->IR[ii]];  EVAP[ibas]+=EVAP[basins->IR[ii]];
                TRANSP[ibas]+=TRANSP[basins->IR[ii]]; RCHG[ibas]+=RCHG[basins->IR[ii]];

                VOL_IN_STR[ibas]+=VOL_IN_STR[basins->IR[ii]]; VOL_OUT_STR[ibas]+=VOL_OUT_STR[basins->IR[ii]];
                S_IN_STR[ibas]+=S_IN_STR[basins->IR[ii]]; S_OUT_STR[ibas]+=S_OUT_STR[basins->IR[ii]];
                P_IN_STR[ibas]+=P_IN_STR[basins->IR[ii]];P_OUT_STR[ibas]+=P_OUT_STR[basins->IR[ii]];

                P_RAIN[ibas]+=P_RAIN[basins->IR[ii]];
                Calg_GPP[ibas]+=Calg_GPP[basins->IR[ii]];  NCalg_GPP[ibas]+=NCalg_GPP[basins->IR[ii]];
                Calg_mort[ibas]+=Calg_mort[basins->IR[ii]]; NCalg_mort[ibas]+=NCalg_mort[basins->IR[ii]];
                mac_NPP[ibas]+=mac_NPP[basins->IR[ii]]; mac_mort[ibas]+=mac_mort[basins->IR[ii]]; 
                dop_macIn[ibas]+=dop_macIn[basins->IR[ii]]; 
                dop_sorbIn[ibas]+=dop_sorbIn[basins->IR[ii]];
                floc_decomp[ibas]+=floc_decomp[basins->IR[ii]]; 
                floc_In[ibas]+=floc_In[basins->IR[ii]];
                stdet_in[ibas]+=stdet_in[basins->IR[ii]]; P_settl[ibas]+=P_settl[basins->IR[ii]]; 
                dop_decomp[ibas]+=dop_decomp[basins->IR[ii]]; dop_desorb[ibas]+=dop_desorb[basins->IR[ii]]; 
                wat_sfMiner[ibas]+=wat_sfMiner[basins->IR[ii]]; wat_sedMiner[ibas]+=wat_sedMiner[basins->IR[ii]];
                wat_sfUpt[ibas]+=wat_sfUpt[basins->IR[ii]];  wat_sedUpt[ibas]+=wat_sedUpt[basins->IR[ii]];

                    /* stocks */
                SUMSF[ibas]+=SUMSF[basins->IR[ii]];  SUMUW[ibas]+=SUMUW[basins->IR[ii]];
                SUMGW[ibas]+=SUMGW[basins->IR[ii]];  TOT_VOL_CAN[ibas]+=TOT_VOL_CAN[basins->IR[ii]];

                TOT_S_CELL[ibas]+=TOT_S_CELL[basins->IR[ii]];  TOT_S_CAN[ibas]+=TOT_S_CAN[basins->IR[ii]];
                
                P_CELL[ibas]+=P_CELL[basins->IR[ii]];  TOT_P_CAN[ibas]+=TOT_P_CAN[basins->IR[ii]];
                P_LIVE_CELL[ibas]+=P_LIVE_CELL[basins->IR[ii]];  
                P_DEAD_CELL[ibas]+=P_DEAD_CELL[basins->IR[ii]];  
                P_WAT_CELL[ibas]+=P_WAT_CELL[basins->IR[ii]];  

            } /* end of IR summation */
            
                /*  inputs  */
            VOL_IN[ibas] = RAIN[ibas] + VOL_IN_STR[ibas] + VOL_IN_OVL[ibas] + VOL_IN_SPG[ibas] + VOL_IN_GW[ibas]; 
            VOL_IN_SUM[ibas] += VOL_IN[ibas];
            S_IN[ibas] = S_IN_STR[ibas] + S_IN_OVL[ibas] + S_IN_SPG[ibas] + S_IN_GW[ibas]; 
            S_IN_SUM[ibas] += S_IN[ibas];
            P_IN[ibas] = P_RAIN[ibas] + P_IN_STR[ibas] + P_IN_OVL[ibas] + P_IN_SPG[ibas] + P_IN_GW[ibas]; 
            P_IN_SUM[ibas] += P_IN[ibas];
            

                /*  outputs */
            VOL_OUT[ibas] = EVAP[ibas] + TRANSP[ibas] + RCHG[ibas] + VOL_OUT_STR[ibas] + VOL_OUT_OVL[ibas] + VOL_OUT_SPG[ibas] + VOL_OUT_GW[ibas]; 
            VOL_OUT_SUM[ibas] += VOL_OUT[ibas];
            S_OUT[ibas] = S_OUT_STR[ibas] + S_OUT_OVL[ibas] + S_OUT_SPG[ibas] + S_OUT_GW[ibas]; 
            S_OUT_SUM[ibas] += S_OUT[ibas];
            P_OUT[ibas] = P_OUT_STR[ibas] + P_OUT_OVL[ibas] + P_OUT_SPG[ibas] + P_OUT_GW[ibas]; 
            if (ESP) P_OUT[ibas] += P_settl[ibas]; /* only if running ESP with settling losses from system */
            P_OUT_SUM[ibas] += P_OUT[ibas];
            

                /* actual new volume/mass = sum of the current storages */
            TOT_VOL[ibas] = SUMSF[ibas] + SUMUW[ibas] + SUMGW[ibas] + TOT_VOL_CAN[ibas]; 
            TOT_S[ibas] = TOT_S_CELL[ibas] + TOT_S_CAN[ibas]; 
            P[ibas] = P_CELL[ibas] + TOT_P_CAN[ibas]; 
            
            if (!ESP) { /* do same for diff P fractions when running full model */
                    /*  inputs  */
                P_LIVE_IN[ibas] = Calg_GPP[ibas] + NCalg_GPP[ibas] + mac_NPP[ibas];
                P_LIVE_IN_SUM[ibas] += P_LIVE_IN[ibas];
                P_DEAD_IN[ibas] = dop_macIn[ibas]  + dop_sorbIn[ibas] + stdet_in[ibas] + P_settl[ibas] + floc_In[ibas];
                P_DEAD_IN_SUM[ibas] += P_DEAD_IN[ibas];
                P_WAT_IN[ibas] =  P_RAIN[ibas] + wat_sfMiner[ibas] + wat_sedMiner[ibas] + dop_desorb[ibas] 
                    + P_IN_STR[ibas] + P_IN_OVL[ibas] + P_IN_SPG[ibas] + P_IN_GW[ibas] ;
                P_WAT_IN_SUM[ibas] += P_WAT_IN[ibas] ;
                    /*  outputs */
                P_LIVE_OUT[ibas] =  Calg_mort[ibas] + NCalg_mort[ibas] + mac_mort[ibas];
                P_LIVE_OUT_SUM[ibas] += P_LIVE_OUT[ibas];
                P_DEAD_OUT[ibas] = dop_decomp[ibas] + dop_desorb[ibas] + floc_decomp[ibas];
                P_DEAD_OUT_SUM[ibas] += P_DEAD_OUT[ibas];
                P_WAT_OUT[ibas] = wat_sfUpt[ibas] + wat_sedUpt[ibas] + dop_sorbIn[ibas] + P_settl[ibas]
                    + P_OUT_STR[ibas] + P_OUT_OVL[ibas] + P_OUT_SPG[ibas] + P_OUT_GW[ibas] ;
                P_WAT_OUT_SUM[ibas] += P_WAT_OUT[ibas];
                    /* actual new volume/mass = sum of the current storages */
                P_LIVE[ibas] = P_LIVE_CELL[ibas]; 
                P_DEAD[ibas] = P_DEAD_CELL[ibas]; 
                P_WAT[ibas] = P_WAT_CELL[ibas] + TOT_P_CAN[ibas]; 
            }
           
                /* now calc the errors, print the data */
                /* skip the first calculation time, need to accumulate a past value for the budget calcs */
            if (TIME/avgIntvl>1)
                budgFinal(ibas);
        }

        budgReset(ibas);

    } /* end of all budget calcs/output at avgIntvl time */

} /* end of stats */



/*******
set up the subasin indicator linkages
******/
void basinInit()
{
    int ix,iy,cellLoc,ibas;
    int ii, jj, basnID;
    int basnCnt=-1; /* the whole system basin in the basinIR file is not considered part of this count of the number of basins/IRs */
    char ss[222], *line, modnam[20], boundIR[3];

    struct basnDef *basins ;
    
    sprintf( mapFileName, "%s/%s/Data/basinIR", ModelPath, ProjName );
/* Open file with canals data */
    if ( ( basInFile = fopen( mapFileName, "r" ) ) ==  NULL )
    {
        sprintf( msgStr,"Can't open %s basin definition input file! ",mapFileName ) ; usrErr(msgStr);
        exit(-1) ;
    }

    fgets( ss, 220, basInFile );fgets( ss, 220, basInFile ); /* skip 2 header lines */
    fgets( ss, 220, basInFile ); sscanf( ss,"%s", &modnam); 
    if (strcmp(modnam,modelName) != 0) {
        sprintf(msgStr, "The model name (%s) found in the %s file doesn't match the one (%s) you asked for in Driver.parm!",
                modnam, mapFileName, modelName); usrErr(msgStr);
        exit(-1);
    }
        /* Allocate memory for first basin */
    if ( (basins = (struct basnDef *) malloc( (size_t) sizeof( struct basnDef ))) == NULL ) {
        printf( "Failed to allocate memory for first basin (%s)\n ", basins->basnTxt ) ;
        exit( -2 ) ;
    }
        /* allocate memory for array of pointers to basin atts */
    if ( (basn_list = 
          (struct basnDef **) malloc( (size_t) sizeof( struct basnDef *) * (numBasn+1))) == NULL )
    {
        printf( "Failed to allocate memory for basin (%d)\n ", basins->basnTxt ) ;
        exit( -2 ) ;
    };


    fgets( ss, 220, basInFile ); /* skip the column name header */
    
    while ( fgets( ss, 220, basInFile ) != NULL && !feof( basInFile ) )
    {
        line = ss;
        sscanf (line, "%d\t%s\t%d",&basnID, &basins->basnTxt,&basins->numIR);
        line = Scip( line, '\t' );line = Scip( line, '\t' );line = Scip( line, '\t' );
/* the indicator regions within a hydrologic basin are subscripted starting at 1,
   with the 0'th indicator region being the hydrologic basin itself.  Flok is
   used to check for allowable flows among basins, to determine if user configured
   basins OK (NOT used to constrain flows, just to verify that no unallowed interbasin
   overland flow is occuring) */
        for (ii=0; ii<basins->numIR; ii++) {
            sscanf (line, "%d%", &basins->IR[ii]);
            basins->FLok[ii] = basins->IR[ii]; /* flow is allowed among IRegions in a particular hydro basin (family) */
            basins->numFLok++;
            line = Scip( line, ',' );
        }
        basnCnt++; /* count the number of basins&IRs to check that the # in the file is same as # defined on the map */

/* if there are any FlowOk basins attached to this basin, read them */
        while (1) {
            while ( *line != '#' && *line != '\0' ) line++;
            if(*line != '\0') {
                ++line;
                sscanf (line, "%d%", &basins->FLok[ii]);
                basins->numFLok++;
                ii++;
            }
            else break;
        }

        basn_list[basnID] = basins;
    
            /* Allocate memory for next basin */
        if ( ( basins = (struct basnDef *) malloc( (size_t) sizeof( struct basnDef ))) == NULL )
        {
            printf( "Failed to allocate memory for next basin (%s)\n ", basins->basnTxt ) ;
            exit( -2 ) ;
        }

     
    } /* end of reading basin lines */
    
    free ((char *)basins);
    fclose(basInFile);

    if (basnCnt != numBasn) { sprintf(msgStr, "Error - the %d basins read from basinIR does not match the %d basins in the basins map! Please fix the basinIR file.\n",
                                      basnCnt,numBasn); usrErr(msgStr); exit (-1); }
 
/* count the number of cells in the basins/indicator regions */
    for (ibas=numBasn;ibas>=0;ibas--) numCells[ibas] = 0;
    for(ix=0; ix<=s0+1; ix++) 
        for(iy=0; iy<=s1+1; iy++)
            if (ON_MAP[cellLoc= T(ix,iy)]) { 
                numCells[basn[cellLoc]]++; /* count the number of cells in each basin */
                numCells[0]++; /* count the number of cells in each basin */
            }
        /* whole system (basin 0) is calc'd independently, while each of the hydro basins are
           sums of their respective Indicator Regions */
    for (ibas=numBasn;ibas>=0;ibas--) {
        basins =  basn_list[ibas];
        basins->family = ibas; /* set the basin to initially be it's own family; below it may find that it is a child of a diff family */
        basins->parent = ibas; /* set the basin to initially be a childless parent */
        for (ii=0; ii<basins->numIR; ii++) {
        
            basn_list[basins->IR[ii]]->family = ibas; /* the hydrologic basin family name of this IRegion */
            basn_list[basins->IR[ii]]->parent = 0; /* this IR is a child, not a parent */
            numCells[ibas] += numCells[basins->IR[ii]]; /* add the IRegion cells to the parent basin #cells */
        }
        basins->cm_conv = 100.0/(numCells[ibas]*CELL_SIZE);
        basins->mgm2_conv = 1.0e6/(numCells[ibas]*CELL_SIZE);

    }
} /* end of basinInit() */



/*******
generate sums, avgs, on cell-by-cell basis (not by basin/IRegion here)
******/
void cellAvg()
{
    int ix, iy, cellLoc;
    float avgStep = avgIntvl / DT;
    
/* sums and average (& hydroperiod) calcs, not budget related */
    for(ix=1; ix<=s0; ix++) {
        for(iy=1; iy<=s1; iy++) {

            if(ON_MAP[cellLoc= T(ix,iy)])  {
                    /* annual hydroperiod on Oct 1 = JulDay 273 (need true date fctn) */
                if ( FMOD(DAYJUL, 273.0) ) {
                    if (SURFACE_WAT[cellLoc] > 0.01 )  HydPerAnn[cellLoc] +=  DT; 
                }
                else {
                    HydPerAnn[cellLoc] += DT; 
                }
                    
                    /* average calculations */
                if (FMOD(TIME, avgIntvl) ) /* sum between intervals */
                {
                    SfWatAvg[cellLoc] += SURFACE_WAT[cellLoc]; 
                    TotHeadAvg[cellLoc] += HydTotHd[cellLoc]; 
                    UnsatZavg[cellLoc] += UNSAT_DEPTH[cellLoc]; 
                    UnsatMoistAvg[cellLoc] += UNSAT_MOIST_PRP[cellLoc]; 
                    RainAvg[cellLoc]  += SF_WT_FROM_RAIN[cellLoc];
                    EvapAvg[cellLoc]  += SF_WT_EVAP[cellLoc];
                    TranspAvg[cellLoc]  += (UNSAT_TRANSP[cellLoc]+SAT_WT_TRANSP[cellLoc]);

                    TPSfWatAvg[cellLoc] += TP_SFWT_CONC_MG[cellLoc]; 
                    TPSedWatAvg[cellLoc] += TP_SEDWT_CONCACTMG[cellLoc]; 
                    TPSfUptAvg[cellLoc] += TP_SFWT_UPTAK[cellLoc]; 
                    TPSfMinAvg[cellLoc] += TP_SFWT_MINER[cellLoc]; 
                    TP_settlAvg[cellLoc] += TP_settl[cellLoc]; 
                    TPSedUptAvg[cellLoc] += TP_SEDWT_UPTAKE[cellLoc]; 
                    TPSedMinAvg[cellLoc] += TP_SED_MINER[cellLoc];
                    TPSorbAvg[cellLoc] += TP_SORBCONC[cellLoc];
                    TPtoVOLAvg[cellLoc] +=  TPtoVOL[cellLoc];
                    TPtoSOILAvg[cellLoc] +=  TPtoSOIL[cellLoc];
                    SaltSfAvg[cellLoc] += SAL_SF_WT[cellLoc];
                    SaltSedAvg[cellLoc] += SAL_SED_WT[cellLoc];

                    Floc_fr_phBioAvg[cellLoc]  += Floc_fr_phBio[cellLoc];
                    DOM_fr_stdetAvg[cellLoc]  += DOM_FR_STDET[cellLoc];
                    
                    NC_PeriAvg[cellLoc] += NC_ALG[cellLoc];
                    NC_Peri_nppAvg[cellLoc]  += NC_ALG_NPP[cellLoc];
                    NC_Peri_mortAvg[cellLoc]  += NC_ALG_MORT[cellLoc];
                    NC_PeriRespAvg[cellLoc]  += NC_ALG_RESP[cellLoc];
                    NC_PeriNutCFAvg[cellLoc]  += NC_ALG_NUT_CF[cellLoc];
                    NC_Peri_PCAvg[cellLoc]  += NC_ALG_PCrep[cellLoc];
                    C_PeriAvg[cellLoc] += C_ALG[cellLoc]; 
                    C_Peri_nppAvg[cellLoc]  += C_ALG_NPP[cellLoc];
                    C_Peri_mortAvg[cellLoc]  += C_ALG_MORT[cellLoc];
                    C_PeriRespAvg[cellLoc]  += C_ALG_RESP[cellLoc];
                    C_PeriNutCFAvg[cellLoc]  += C_ALG_NUT_CF[cellLoc];
                    C_Peri_PCAvg[cellLoc]  += C_ALG_PCrep[cellLoc];
                    PeriLiteCFAvg[cellLoc]  += ALG_LIGHT_CF[cellLoc];

                    Mac_nphBioAvg[cellLoc]  += MAC_NOPH_BIOMAS[cellLoc];
                    Mac_phBioAvg[cellLoc]  += MAC_PH_BIOMAS[cellLoc];
                    Mac_nppAvg[cellLoc]  += PHBIO_NPP[cellLoc];
                    Mac_nphMortAvg[cellLoc]  += NPHBIO_MORT[cellLoc];
                    Mac_phMortAvg[cellLoc]  += PHBIO_MORT[cellLoc];
                    LAI_effAvg[cellLoc]  += LAI_eff[cellLoc];
                    Manning_nAvg[cellLoc]  += HYD_MANNINGS_N[cellLoc];
                    MacNutCfAvg[cellLoc]  += MAC_NUT_CF[cellLoc];
                    MacWatCfAvg[cellLoc]  += MAC_WATER_CF[cellLoc];
                    mac_nph_PCAvg[cellLoc]  += mac_nph_PC_rep[cellLoc];
                    mac_ph_PCAvg[cellLoc]  += mac_ph_PC_rep[cellLoc];

                    Std_detrAvg[cellLoc]  += STAND_DETRITUS[cellLoc];
                }
                else /* avg at interval */
                        { 
                            SfWatAvg[cellLoc] = ( SfWatAvg[cellLoc]+ SURFACE_WAT[cellLoc] ) / avgStep;
                            TotHeadAvg[cellLoc] = ( TotHeadAvg[cellLoc]+ HydTotHd[cellLoc] ) / avgStep;
                            UnsatZavg[cellLoc] = ( UnsatZavg[cellLoc]+ UNSAT_DEPTH[cellLoc] ) / avgStep;
                            UnsatMoistAvg[cellLoc] = ( UnsatMoistAvg[cellLoc]+ UNSAT_MOIST_PRP[cellLoc] ) / avgStep;
                            RainAvg[cellLoc]  = (RainAvg[cellLoc]+ SF_WT_FROM_RAIN[cellLoc])/ avgStep ;
                            EvapAvg[cellLoc]  = (EvapAvg[cellLoc]+ SF_WT_EVAP[cellLoc])/ avgStep ;
                            TranspAvg[cellLoc] = (TranspAvg[cellLoc]+ UNSAT_TRANSP[cellLoc]+SAT_WT_TRANSP[cellLoc])/ avgStep ;
                            ETAvg[cellLoc]  = EvapAvg[cellLoc] + TranspAvg[cellLoc];

                            TPSfWatAvg[cellLoc] = ( TPSfWatAvg[cellLoc]+ TP_SFWT_CONC_MG[cellLoc] ) / avgStep;
                            TPSedWatAvg[cellLoc] = ( TPSedWatAvg[cellLoc]+ TP_SEDWT_CONCACTMG[cellLoc] ) / avgStep;
                            TPSfUptAvg[cellLoc] = ( TPSfUptAvg[cellLoc]+ TP_SFWT_UPTAK[cellLoc] ) / avgStep;
                            TPSfMinAvg[cellLoc] = ( TPSfMinAvg[cellLoc]+ TP_SFWT_MINER[cellLoc] ) / avgStep;
                            TP_settlAvg[cellLoc] = ( TP_settlAvg[cellLoc]+ TP_settl[cellLoc] ) / avgStep;
                            TPSedUptAvg[cellLoc] = ( TPSedUptAvg[cellLoc]+ TP_SEDWT_UPTAKE[cellLoc] ) / avgStep;
                            TPSedMinAvg[cellLoc] = ( TPSedMinAvg[cellLoc]+ TP_SED_MINER[cellLoc] ) / avgStep;
                            TPSorbAvg[cellLoc] = ( TPSorbAvg[cellLoc]+ TP_SORBCONC[cellLoc] ) / avgStep *1.0e3; /* mgP/kgOM */
                            TPtoVOLAvg[cellLoc] = ( TPtoVOLAvg[cellLoc] + TPtoVOL[cellLoc] ) / avgStep *1.0e3;  /* kg/m3=> g/m3 == ug/cm3 */
                            TPtoSOILAvg[cellLoc] = (TPtoSOILAvg[cellLoc] + TPtoSOIL[cellLoc]) / avgStep *1.0e6; /* kgP/kgsoil=> mgP/kgsoil*/
                            SaltSfAvg[cellLoc] = ( SaltSfAvg[cellLoc]+ SAL_SF_WT[cellLoc] ) / avgStep;
                            SaltSedAvg[cellLoc] = ( SaltSedAvg[cellLoc]+ SAL_SED_WT[cellLoc] ) / avgStep;

                            Floc_fr_phBioAvg[cellLoc]  = (Floc_fr_phBioAvg[cellLoc]+ Floc_fr_phBio[cellLoc])/ avgStep ;
                            DOM_fr_stdetAvg[cellLoc]  = (DOM_fr_stdetAvg[cellLoc]+ DOM_FR_STDET[cellLoc])/ avgStep ;

                            NC_PeriAvg[cellLoc] = ( NC_PeriAvg[cellLoc]+ NC_ALG[cellLoc] ) / avgStep;
                            NC_Peri_nppAvg[cellLoc] = ( NC_Peri_nppAvg[cellLoc]+ NC_ALG_NPP[cellLoc] ) / avgStep;
                            NC_Peri_mortAvg[cellLoc] = ( NC_Peri_mortAvg[cellLoc]+ NC_ALG_MORT[cellLoc] ) / avgStep;
                            NC_PeriRespAvg[cellLoc] = ( NC_PeriRespAvg[cellLoc]+ NC_ALG_RESP[cellLoc] ) / avgStep;
                            NC_PeriNutCFAvg[cellLoc] = ( NC_PeriNutCFAvg[cellLoc]+ NC_ALG_NUT_CF[cellLoc] ) / avgStep;
                            NC_Peri_PCAvg[cellLoc] = ( NC_Peri_PCAvg[cellLoc]+ NC_ALG_PCrep[cellLoc] ) / avgStep;
                            C_PeriAvg[cellLoc] = ( C_PeriAvg[cellLoc]+ C_ALG[cellLoc] ) / avgStep;
                            C_Peri_nppAvg[cellLoc] = ( C_Peri_nppAvg[cellLoc]+ C_ALG_NPP[cellLoc] ) / avgStep;
                            C_Peri_mortAvg[cellLoc] = ( C_Peri_mortAvg[cellLoc]+ C_ALG_MORT[cellLoc] ) / avgStep;
                            C_PeriRespAvg[cellLoc] = ( C_PeriRespAvg[cellLoc]+ C_ALG_RESP[cellLoc] ) / avgStep;
                            C_PeriNutCFAvg[cellLoc] = ( C_PeriNutCFAvg[cellLoc]+ C_ALG_NUT_CF[cellLoc] ) / avgStep;
                            C_Peri_PCAvg[cellLoc] = ( C_Peri_PCAvg[cellLoc]+ C_ALG_PCrep[cellLoc] ) / avgStep;
                            PeriLiteCFAvg[cellLoc] = ( PeriLiteCFAvg[cellLoc]+ ALG_LIGHT_CF[cellLoc] ) / avgStep;
                            PeriAvg[cellLoc] = NC_PeriAvg[cellLoc] + C_PeriAvg[cellLoc];
                    	
                            Mac_nphBioAvg[cellLoc]  = (Mac_nphBioAvg[cellLoc]+ MAC_NOPH_BIOMAS[cellLoc])/ avgStep ;
                            Mac_phBioAvg[cellLoc]  = (Mac_phBioAvg[cellLoc]+ MAC_PH_BIOMAS[cellLoc])/ avgStep ;
                            Mac_totBioAvg[cellLoc]  = Mac_nphBioAvg[cellLoc] + Mac_phBioAvg[cellLoc];
                            Mac_nppAvg[cellLoc]  = (Mac_nppAvg[cellLoc]+ PHBIO_NPP[cellLoc])/ avgStep ;
                            Mac_nphMortAvg[cellLoc]  = (Mac_nphMortAvg[cellLoc]+ NPHBIO_MORT[cellLoc])/ avgStep ;
                            Mac_phMortAvg[cellLoc]  = (Mac_phMortAvg[cellLoc]+ PHBIO_MORT[cellLoc])/ avgStep ;
                            LAI_effAvg[cellLoc]  = (LAI_effAvg[cellLoc]+ LAI_eff[cellLoc])/ avgStep ;
                            Manning_nAvg[cellLoc]  = (Manning_nAvg[cellLoc]+ HYD_MANNINGS_N[cellLoc])/ avgStep ;
                            MacNutCfAvg[cellLoc]  = (MacNutCfAvg[cellLoc]+ MAC_NUT_CF[cellLoc])/ avgStep ;
                            MacWatCfAvg[cellLoc]  = (MacWatCfAvg[cellLoc]+ MAC_WATER_CF[cellLoc])/ avgStep ;
                            mac_nph_PCAvg[cellLoc]  = (mac_nph_PCAvg[cellLoc]+ mac_nph_PC_rep[cellLoc])/ avgStep ;
                            mac_ph_PCAvg[cellLoc]  = (mac_ph_PCAvg[cellLoc]+ mac_ph_PC_rep[cellLoc])/ avgStep ;

                            Std_detrAvg[cellLoc]  = (Std_detrAvg[cellLoc]+ STAND_DETRITUS[cellLoc])/ avgStep ;
                        }
            }
        }
    } /* end spatial loop for averages */
} /*end of cellAvg() */


/*******
generate summations for basin (and IRegion) budgets - also doing means within basins/IRegions here
******/
void budgSum()
{
    int ix, iy, cellLoc;
    float cellSiz_DT = CELL_SIZE * DT;
   
    for(ix=1; ix<=s0; ix++) 
        for(iy=1; iy<=s1; iy++) 

            if(ON_MAP[cellLoc= T(ix,iy)])  {

/* calculate sums of inputs/outputs, then sum the storages */
/* the summations here are ONLY relating to vertical flows in this source file */
/* horizontal cell<->cell, cell<->canal, and cell<->external_system flows in other source code files */
/****/
/*  sums of water inflow/outflow (m) */
                    /*  vertical system inputs to cells: rain  */
                RAIN[basn[cellLoc]] += (double) SF_WT_FROM_RAIN[cellLoc]*cellSiz_DT ; /* CELL_SIZE*DT */
                RAIN[0]             += (double) SF_WT_FROM_RAIN[cellLoc]*cellSiz_DT; 

                    /*  vertical system outputs from cells: evap, transp, recharge */
                EVAP[basn[cellLoc]] += (double) (SF_WT_EVAP[cellLoc])*cellSiz_DT; 
                EVAP[0]             += (double) (SF_WT_EVAP[cellLoc])*cellSiz_DT; 
                TRANSP[basn[cellLoc]] += (double) (SAT_WT_TRANSP[cellLoc] 
                                                   + UNSAT_TRANSP[cellLoc])*cellSiz_DT; 
                TRANSP[0]             += (double) (SAT_WT_TRANSP[cellLoc] 
                                                   + UNSAT_TRANSP[cellLoc])*cellSiz_DT; 

                    /* Important NOTE: recharge is 0 in elm, not now linked to solute fluxes */
                RCHG[basn[cellLoc]] += (double) (SAT_WT_RECHG[cellLoc])*cellSiz_DT; 
                RCHG[0]             += (double) (SAT_WT_RECHG[cellLoc])*cellSiz_DT; 


                    /* mass (kg P) sums of P inflow/outflow */
                    /* does NOT include fire or consumers, which we don't implement right now */
			
                P_RAIN[basn[cellLoc]] += (double) (TP_FR_RAIN[cellLoc]* DT); 
                P_RAIN[0]             += (double) (TP_FR_RAIN[cellLoc]* DT); 
                P_settl[basn[cellLoc]] += (double) TP_settl[cellLoc]*DT;  /* kgP */
                P_settl[0]             += (double) TP_settl[cellLoc]*DT;  /* kgP */
			
                if (!ESP) { /* not calc'd if running the ESP (TP settling) model */


                    Calg_GPP[basn[cellLoc]] += (double) ( (C_ALG_GPP_P[cellLoc]  ) 
                                                          * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    NCalg_GPP[basn[cellLoc]] += (double) ( (NC_ALG_GPP_P[cellLoc] ) 
                                                           * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    Calg_mort[basn[cellLoc]] += (double) ( (C_ALG_MORT_P[cellLoc]) 
                                                           * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    NCalg_mort[basn[cellLoc]] += (double) ( (NC_ALG_MORT_P[cellLoc]) 
                                                            * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    dop_macIn[basn[cellLoc]] += (double) DOP_nphBio[cellLoc] 
                        * cellSiz_DT;  /* kgP/m2 => kgP */
                    dop_stdIn[basn[cellLoc]] += (double) DOP_STDET[cellLoc] 
                        * cellSiz_DT;  /* kgP/m2 => kgP */
                    dop_sorbIn[basn[cellLoc]] += (double) (TP_SORBTION[cellLoc]>0.0) ? (TP_SORBTION[cellLoc] * DT) : (0.0); /* kgP */
                    dop_decomp[basn[cellLoc]] += (double)  DOP_DECOMP[cellLoc] 
                        * cellSiz_DT;  /* kgP/m2 => kgP */
                    dop_desorb[basn[cellLoc]] += (double)  (TP_SORBTION[cellLoc]<=0.0) ? (-TP_SORBTION[cellLoc] * DT) : (0.0) ; /* kgP */
                    
                    floc_decomp[basn[cellLoc]] += (double)  FlocP_DECOMP[cellLoc]
                        * cellSiz_DT;  /* kgP/m2 => kgP */
                    floc_In[basn[cellLoc]] += (double)  (FlocP_FR_ALGAE[cellLoc] + FlocP_PhBio[cellLoc])
                        * cellSiz_DT;  /* kgP/m2 => kgP */

                    mac_NPP[basn[cellLoc]] += (double) phbio_npp_P[cellLoc] 
                        * cellSiz_DT;  /* kgP/m2 => kgP */
                    mac_mort[basn[cellLoc]] += (double) ( phbio_mort_P[cellLoc]+ nphbio_mort_P[cellLoc]) 
                        * cellSiz_DT;  /* kgP/m2 => kgP */
                    stdet_in[basn[cellLoc]] += (double) stdet_prod_P[cellLoc]  
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    stdet_out[basn[cellLoc]] += (double) stdet_toDOM_P[cellLoc]  
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    wat_sfMiner[basn[cellLoc]] += (double) TP_SFWT_MINER[cellLoc]*DT;  /* kgP */
                    wat_sedMiner[basn[cellLoc]] += (double) TP_SED_MINER[cellLoc]*DT;  /* kgP */
                    wat_sfUpt[basn[cellLoc]] += (double) TP_SFWT_UPTAK[cellLoc] * DT;  /* kgP */
                    wat_sedUpt[basn[cellLoc]] += (double) TP_SEDWT_UPTAKE[cellLoc]*DT;  /* kgP */
			
			
                    Calg_GPP[0] += (double) ( (C_ALG_GPP_P[cellLoc]  ) 
                                              * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    NCalg_GPP[0] += (double) ( (NC_ALG_GPP_P[cellLoc] ) 
                                               * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    Calg_mort[0] += (double) ( (C_ALG_MORT_P[cellLoc]) 
                                               * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    NCalg_mort[0] += (double) ( (NC_ALG_MORT_P[cellLoc]) 
                                                * 0.001 * cellSiz_DT);/* gP/m2 => kgP */
                    dop_macIn[0] += (double) DOP_nphBio[cellLoc] 
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    dop_stdIn[0] += (double) DOP_STDET[cellLoc] 
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    dop_sorbIn[0] += (double) (TP_SORBTION[cellLoc]>0.0) ? (TP_SORBTION[cellLoc] * DT) : (0.0); /* kgP */
                    dop_decomp[0] += (double) DOP_DECOMP[cellLoc] 
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    dop_desorb[0] += (double)  (TP_SORBTION[cellLoc]<=0.0) ? (-TP_SORBTION[cellLoc] * DT) : (0.0) ; /* kgP */
                    floc_decomp[0] += (double)  FlocP_DECOMP[cellLoc]
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    floc_In[0] += (double)  (FlocP_FR_ALGAE[cellLoc] + FlocP_PhBio[cellLoc])
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    mac_NPP[0] += (double) phbio_npp_P[cellLoc] 
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    mac_mort[0] += (double) ( phbio_mort_P[cellLoc]+ nphbio_mort_P[cellLoc]) 
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    stdet_in[0] += (double) stdet_prod_P[cellLoc]  
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    stdet_out[0] += (double) stdet_toDOM_P[cellLoc]  
                        * cellSiz_DT;/* kgP/m2 => kgP */
                    wat_sfMiner[0] += (double) TP_SFWT_MINER[cellLoc]*DT;  /* kgP */
                    wat_sedMiner[0] += (double) TP_SED_MINER[cellLoc]*DT;  /* kgP */
                    wat_sfUpt[0] += (double) TP_SFWT_UPTAK[cellLoc] * DT;  /* kgP */
                    wat_sedUpt[0] += (double) TP_SEDWT_UPTAKE[cellLoc]*DT;  /* kgP */
                }
			
                    /* no salt inflow/outflow to/from system in vertical direction */
			
                    /* sum the storages (budgets) and sum cell avgs in IndRegions at the desired interval */
                if ( !(FMOD(TIME, avgIntvl) ) ) { 

/* get the (non-budget) mean values for cells within indicator regions */
                    DepthAvg[basn[cellLoc]] +=  SfWatAvg[cellLoc];
                    DepthAvg[0]             +=  SfWatAvg[cellLoc];
                    UnsatAvg[basn[cellLoc]] +=  UnsatZavg[cellLoc];
                    UnsatAvg[0]             +=  UnsatZavg[cellLoc];
                    TPsf_avg[basn[cellLoc]] +=  TPSfWatAvg[cellLoc];
                    TPsf_avg[0]             +=  TPSfWatAvg[cellLoc];
                    TPpore_avg[basn[cellLoc]] +=  TPSedWatAvg[cellLoc];
                    TPpore_avg[0]             +=  TPSedWatAvg[cellLoc];
                    TPsoil_avg[basn[cellLoc]] +=  TPtoSOILAvg[cellLoc];
                    TPsoil_avg[0]             +=  TPtoSOILAvg[cellLoc];
                    NCperi_avg[basn[cellLoc]] +=  NC_PeriAvg[cellLoc];
                    NCperi_avg[0]             +=  NC_PeriAvg[cellLoc];
                    Cperi_avg[basn[cellLoc]] +=  C_PeriAvg[cellLoc];
                    Cperi_avg[0]             +=  C_PeriAvg[cellLoc];
                    Mac_avg[basn[cellLoc]] +=  Mac_totBioAvg[cellLoc];
                    Mac_avg[0]             +=  Mac_totBioAvg[cellLoc];
                

				/* water (m * m2) */
                    SUMSF[basn[cellLoc]] += (double) SURFACE_WAT[cellLoc]*CELL_SIZE;
                    SUMSF[0]             += (double) SURFACE_WAT[cellLoc]*CELL_SIZE; 
                    SUMUW[basn[cellLoc]] += (double) UNSAT_WATER[cellLoc]*CELL_SIZE;
                    SUMUW[0]             += (double) UNSAT_WATER[cellLoc]*CELL_SIZE; 
                    SUMGW[basn[cellLoc]] += (double) SAT_WATER[cellLoc]*CELL_SIZE;
                    SUMGW[0]             += (double) SAT_WATER[cellLoc]*CELL_SIZE;  

                      /* most of this not needed when only running ESP, not bothering to clean up now */
				/* phosphorus (units converted to kg P)*/
                        P_Calg[basn[cellLoc]] += (double) (C_ALG_P[cellLoc] ) 
                            * 0.001 * CELL_SIZE; /* gP/m2 => kgP */
                        P_Calg[0] += (double) (C_ALG_P[cellLoc] ) 
                            * 0.001 * CELL_SIZE; /* gP/m2 => kgP */
                        P_NCalg[basn[cellLoc]] += (double) (NC_ALG_P[cellLoc]) 
                            * 0.001 * CELL_SIZE; /* gP/m2 => kgP */
                        P_NCalg[0] += (double) (NC_ALG_P[cellLoc]) 
                            * 0.001 * CELL_SIZE; /* gP/m2 => kgP */
                        P_MAC[basn[cellLoc]] += (double) (mac_nph_P[cellLoc] + mac_ph_P[cellLoc] )  
                            * CELL_SIZE; /* kgP/m2 => kgP */
                        P_MAC[0] += (double) (mac_nph_P[cellLoc] + mac_ph_P[cellLoc] )  
                            * CELL_SIZE; /* kgP/m2 => kgP */

                        P_LIVE_CELL[basn[cellLoc]] = (P_Calg[basn[cellLoc]] + P_NCalg[basn[cellLoc]] + P_MAC[basn[cellLoc]]);
                        P_LIVE_CELL[0] 	       = (P_Calg[0] + P_NCalg[0] + P_MAC[0]);

                        P_DEAD_CELL[basn[cellLoc]] += (double) ( TP_SORB[cellLoc] +
                                                                ( FlocP[cellLoc] + DOP[cellLoc] + stdet_P[cellLoc] ) /* kgP/m2 */ * CELL_SIZE );
                        P_DEAD_CELL[0] 	       += (double) ( TP_SORB[cellLoc] +
                                                                ( FlocP[cellLoc] + DOP[cellLoc] + stdet_P[cellLoc] ) /* kgP/m2 */ * CELL_SIZE );

                        P_WAT_CELL[basn[cellLoc]] += (double) (TP_SED_WT[cellLoc] + TP_SF_WT[cellLoc] ); /*kgP*/
                        P_WAT_CELL[0] 		+= (double) (TP_SED_WT[cellLoc] + TP_SF_WT[cellLoc] ); /*kgP*/
				
                        P_CELL[basn[cellLoc]] = (double) (P_LIVE_CELL[basn[cellLoc]] + P_DEAD_CELL[basn[cellLoc]] + P_WAT_CELL[basn[cellLoc]]);
                        P_CELL[0] 		  = (double) (P_LIVE_CELL[0] + P_DEAD_CELL[0] + P_WAT_CELL[0]);
                    
                    
                    
				/* salt (kgS) */
                    TOT_S_CELL[basn[cellLoc]] += (double) (SALT_SED_WT[cellLoc] + SALT_SURF_WT[cellLoc] ); 
                    TOT_S_CELL[0] +=             (double) (SALT_SED_WT[cellLoc] + SALT_SURF_WT[cellLoc] ); 
                }
            } /* end spatial loop for summations across domain*/

} /* end budgSum() */


/*******
print date stamp on current output record
********/
void DatePrnt()
{
/* date stamp for each record in the budget output files */
    calcdate( Jdate, mo, da, yr, hr, mi, se); /* get the calendar date info from the julian date */
    
    fprintf(IRavg1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=13) fprintf(IRavg2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=26) fprintf(IRavg3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=39) fprintf(IRavg4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=52) fprintf(IRavg5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    
    fprintf(budget_Wacr1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=13) fprintf(budget_Wacr2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=26) fprintf(budget_Wacr3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=39) fprintf(budget_Wacr4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=52) fprintf(budget_Wacr5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 

    fprintf(budget_Wcm1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=13) fprintf(budget_Wcm2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=26) fprintf(budget_Wcm3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=39) fprintf(budget_Wcm4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=52) fprintf(budget_Wcm5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 

    fprintf(budget_P1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] );
    if (numBasn>=13) fprintf(budget_P2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=26) fprintf(budget_P3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=39) fprintf(budget_P4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=52) fprintf(budget_P5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 

    fprintf(budget_Par1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=13) fprintf(budget_Par2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=26) fprintf(budget_Par3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=39) fprintf(budget_Par4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    if (numBasn>=52) fprintf(budget_Par5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 

    fprintf(budget_S1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] );
    if (numBasn>=13) fprintf(budget_S2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] );
    if (numBasn>=26) fprintf(budget_S3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] );
    if (numBasn>=39) fprintf(budget_S4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] );
    if (numBasn>=52) fprintf(budget_S5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] );

    if (!ESP) {
        fprintf(budget_Plive1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=13) fprintf(budget_Plive2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=26) fprintf(budget_Plive3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=39) fprintf(budget_Plive4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=52) fprintf(budget_Plive5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 

        fprintf(budget_Pdead1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=13) fprintf(budget_Pdead2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=26) fprintf(budget_Pdead3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=39) fprintf(budget_Pdead4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=52) fprintf(budget_Pdead5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 

        fprintf(budget_Pwat1, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=13) fprintf(budget_Pwat2, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=26) fprintf(budget_Pwat3, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=39) fprintf(budget_Pwat4, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
        if (numBasn>=52) fprintf(budget_Pwat5, "\n%d/%d/%d\t",yr[0],mo[0],da[0] ); 
    }
} /* end DatePrnt() */



/*******
calculate errors and print out budget data (AND Indicator Region mean values) 
******/
void budgFinal(int ibas)
{
    int Fnum;
    struct basnDef *basins;
    basins = basn_list[ibas];

    Fnum = ((ibas>=52)?(5):
            ((ibas>=39)?(4):
             ((ibas>=26)?(3):
              ((ibas>=13)?(2):
               (1) ) )) );
    
        /* error  = newVol - (oldVol+inputs-outputs) */
    TOT_VOL_ERR[ibas] = TOT_VOL[ibas] - (TOT_VOL_OLD[ibas]+VOL_IN[ibas]-VOL_OUT[ibas] ); 
    TOT_S_ERR[ibas] = TOT_S[ibas] - (TOT_S_OLD[ibas]+S_IN[ibas]-S_OUT[ibas] ); 
    P_ERR[ibas] = P[ibas] - (P_OLD[ibas]+P_IN[ibas]-P_OUT[ibas] ); 
                
        /* cumulative error  */
    TOT_VOL_CUM_ERR[ibas] += TOT_VOL_ERR[ibas]; /* cumulative net error */
    S_ERR_CUM[ibas] += TOT_S_ERR[ibas];
    P_ERR_CUM[ibas] += P_ERR[ibas]; 
                
        /* average inputs and outputs */
    VOL_IN_AVG[ibas] = VOL_IN_SUM[ibas]/(TIME/avgIntvl);
    VOL_OUT_AVG[ibas] = VOL_OUT_SUM[ibas]/(TIME/avgIntvl); 
    S_IN_AVG[ibas] = S_IN_SUM[ibas]/(TIME/avgIntvl);
    S_OUT_AVG[ibas] = S_OUT_SUM[ibas]/(TIME/avgIntvl); 
    P_IN_AVG[ibas] = P_IN_SUM[ibas]/(TIME/avgIntvl);
    P_OUT_AVG[ibas] = P_OUT_SUM[ibas]/(TIME/avgIntvl); 

        /* do same for diff P fractions when running full model */
    if (!ESP) { 
        P_LIVE_ERR[ibas] = P_LIVE[ibas] - (P_LIVE_OLD[ibas]+P_LIVE_IN[ibas]-P_LIVE_OUT[ibas] ); 
        P_DEAD_ERR[ibas] = P_DEAD[ibas] - (P_DEAD_OLD[ibas]+P_DEAD_IN[ibas]-P_DEAD_OUT[ibas] ); 
        P_WAT_ERR[ibas] = P_WAT[ibas] - (P_WAT_OLD[ibas]+P_WAT_IN[ibas]-P_WAT_OUT[ibas] ); 
        P_LIVE_ERR_CUM[ibas] += P_LIVE_ERR[ibas];  
        P_DEAD_ERR_CUM[ibas] += P_DEAD_ERR[ibas]; 
        P_WAT_ERR_CUM[ibas] += P_WAT_ERR[ibas]; 
        P_LIVE_IN_AVG[ibas] = P_LIVE_IN_SUM[ibas]/(TIME/avgIntvl);
        P_LIVE_OUT_AVG[ibas] = P_LIVE_OUT_SUM[ibas]/(TIME/avgIntvl); 
        P_DEAD_IN_AVG[ibas] = P_DEAD_IN_SUM[ibas]/(TIME/avgIntvl);
        P_DEAD_OUT_AVG[ibas] = P_DEAD_OUT_SUM[ibas]/(TIME/avgIntvl); 
        P_WAT_IN_AVG[ibas] = P_WAT_IN_SUM[ibas]/(TIME/avgIntvl);
        P_WAT_OUT_AVG[ibas] = P_WAT_OUT_SUM[ibas]/(TIME/avgIntvl); 
    }
                

/********** PRINTING DATA 
 **********/
/* non-budget, Indicator Region mean values are printed */
    fprintf(   ((Fnum==5)?(IRavg5):
                ((Fnum==4)?(IRavg4):
                   ((Fnum==3)?(IRavg3):
                    ((Fnum==2)?(IRavg2):
                     (IRavg1) ) ) ) ),
               "%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t",
               DepthAvg[ibas]/numCells[ibas], UnsatAvg[ibas]/numCells[ibas],
               TPsf_avg[ibas]/numCells[ibas], TPpore_avg[ibas]/numCells[ibas], TPsoil_avg[ibas]/numCells[ibas],
               NCperi_avg[ibas]/numCells[ibas], Cperi_avg[ibas]/numCells[ibas], Mac_avg[ibas]/numCells[ibas]);

/* now all the various budget files are printed */
        /* print hydrology */
        /* print two files, with volumes and inputs/outputs in thousands acre-feet (VALUE*8.107e-7) OR cm (VALUE*100/(numCells[ibas]*CELL_SIZE) )*/
        /* HYDRO: units used in calcs =  m^3, */
        /* OUTPUT of flows, storages are in thousands of acre-ft and in cm across basin (for SFWMM comp) */
        /* OUTPUT of error analyses use mm height across the basin, m^3*1000.0/(numCells[ibas]*CELL_SIZE) */
        /* m^3 * (2.471e-4acre/m^2) * (3.2808399 ft/m) == m^3 * 0.00081070 acre-ft/m^3 */
        /* m^3 * 8.107e-7 = thousands acre-ft */
    fprintf(  ((Fnum==5)?(budget_Wacr5):
               ((Fnum==4)?(budget_Wacr4):
                   ((Fnum==3)?(budget_Wacr3):
                    ((Fnum==2)?(budget_Wacr2):
                     (budget_Wacr1) ) ) ) ),
               "%9.2f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.2f\t", 
               TOT_VOL_OLD[ibas]*8.107e-7, 
               RAIN[ibas]*8.107e-7, EVAP[ibas]*8.107e-7, TRANSP[ibas]*8.107e-7,RCHG[ibas]*8.107e-7, 
               VOL_IN_STR[ibas]*8.107e-7, VOL_OUT_STR[ibas]*8.107e-7, VOL_IN_OVL[ibas]*8.107e-7, VOL_OUT_OVL[ibas]*8.107e-7, 
               VOL_IN_SPG[ibas]*8.107e-7, VOL_OUT_SPG[ibas]*8.107e-7, VOL_IN_GW[ibas]*8.107e-7,  VOL_OUT_GW[ibas]*8.107e-7,
               (TOT_VOL_OLD[ibas]+VOL_IN[ibas]-VOL_OUT[ibas])*8.107e-7 );
        /* the new volume, error (mm in basin),  error/inflow, avg Total vol In and Out */
    fprintf(   ((Fnum==5)?(budget_Wacr5):
                ((Fnum==4)?(budget_Wacr4):
                   ((Fnum==3)?(budget_Wacr3):
                    ((Fnum==2)?(budget_Wacr2):
                     (budget_Wacr1) ) ) ) ),
               "%9.2f\t%9.4f\t%9.3f\t%9.3f\t%9.3f\t", 
               TOT_VOL[ibas]*8.107e-7, TOT_VOL_ERR[ibas]*10.0*basins->cm_conv, 
               TOT_VOL_CUM_ERR[ibas]*10.0*basins->cm_conv, VOL_IN_AVG[ibas]*8.107e-7, VOL_OUT_AVG[ibas]*8.107e-7 );  
    
    fprintf(   ((Fnum==5)?(budget_Wcm5):
                ((Fnum==4)?(budget_Wcm4):
                   ((Fnum==3)?(budget_Wcm3):
                    ((Fnum==2)?(budget_Wcm2):
                     (budget_Wcm1) ) ) ) ),
               "%9.2f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.3f\t%9.2f\t", 
               TOT_VOL_OLD[ibas]*basins->cm_conv, 
               RAIN[ibas]*basins->cm_conv, EVAP[ibas]*basins->cm_conv, TRANSP[ibas]*basins->cm_conv, RCHG[ibas]*basins->cm_conv, 
               VOL_IN_STR[ibas]*basins->cm_conv, VOL_OUT_STR[ibas]*basins->cm_conv, VOL_IN_OVL[ibas]*basins->cm_conv, VOL_OUT_OVL[ibas]*basins->cm_conv, 
               VOL_IN_SPG[ibas]*basins->cm_conv, VOL_OUT_SPG[ibas]*basins->cm_conv, VOL_IN_GW[ibas]*basins->cm_conv,  VOL_OUT_GW[ibas]*basins->cm_conv,
               (TOT_VOL_OLD[ibas]+VOL_IN[ibas]-VOL_OUT[ibas])*basins->cm_conv );
        /* the new volume, error (mm in basin),  error/inflow, avg Total vol In and Out */
    fprintf(   ((Fnum==5)?(budget_Wcm5):
                ((Fnum==4)?(budget_Wcm4):
                   ((Fnum==3)?(budget_Wcm3):
                    ((Fnum==2)?(budget_Wcm2):
                     (budget_Wcm1) ) ) ) ),
               "%9.2f\t%9.4f\t%9.3f\t%9.3f\t%9.3f\t", 
               TOT_VOL[ibas]*basins->cm_conv, TOT_VOL_ERR[ibas]*10.0*basins->cm_conv, 
               TOT_VOL_CUM_ERR[ibas]*10.0*basins->cm_conv, VOL_IN_AVG[ibas]*basins->cm_conv, VOL_OUT_AVG[ibas]*basins->cm_conv );  

        /* print the salt budget */
        /* mass and inputs/outputs in metric tons (Mg) */
    fprintf(  ((Fnum==5)?(budget_S5):
               ((Fnum==4)?(budget_S4):
                   ((Fnum==3)?(budget_S3):
                    ((Fnum==2)?(budget_S2):
                     (budget_S1) ) ) ) ),
               "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.3f\t", 
               TOT_S_OLD[ibas]*1.0e-3, 
               S_IN_STR[ibas]*1.0e-3, S_OUT_STR[ibas]*1.0e-3, S_IN_OVL[ibas]*1.0e-3, S_OUT_OVL[ibas]*1.0e-3, 
               S_IN_SPG[ibas]*1.0e-3, S_OUT_SPG[ibas]*1.0e-3, S_IN_GW[ibas]*1.0e-3,  S_OUT_GW[ibas]*1.0e-3,
               (TOT_S_OLD[ibas]+S_IN[ibas]-S_OUT[ibas])*1.0e-3 );
        /* the new mass (Mg), error & cumulative error (ug/m2 of basin), cumulative avg Total mass In and Out */
    fprintf(   ((Fnum==5)?(budget_S5):
                ((Fnum==4)?(budget_S4):
                   ((Fnum==3)?(budget_S3):
                    ((Fnum==2)?(budget_S2):
                     (budget_S1) ) ) ) ),
               "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t", 
               TOT_S[ibas]*1.0e-3, TOT_S_ERR[ibas]*1000.0*basins->mgm2_conv, 
               S_ERR_CUM[ibas]*1000.0*basins->mgm2_conv, S_IN_AVG[ibas]*1.0e-3, S_OUT_AVG[ibas]*1.0e-3 );  
                
        /* print all fractions of P */
        /* we print to two files, one with units of Mg per basin, the other in mg/m2 per basin */
    if (ESP) {
        fprintf(   ((Fnum==5)?(budget_P5):
                    ((Fnum==4)?(budget_P4):
                   ((Fnum==3)?(budget_P3):
                    ((Fnum==2)?(budget_P2):
                     (budget_P1) ) ) ) ),
                   "%9.3f\t%9.4f\t%9.4f\t", 
                   P_OLD[ibas]*1.0e-3,P_RAIN[ibas]*1.0e-3, P_settl[ibas]*1.0e-3);
        fprintf(  ((Fnum==5)?(budget_Par5):
                   ((Fnum==4)?(budget_Par4):
                   ((Fnum==3)?(budget_Par3):
                    ((Fnum==2)?(budget_Par2):
                     (budget_Par1) ) ) ) ),
                   "%9.3f\t%9.4f\t%9.4f\t", 
                   P_OLD[ibas]*basins->mgm2_conv,P_RAIN[ibas]*basins->mgm2_conv, P_settl[ibas]*basins->mgm2_conv);
    }
    
    else {
        fprintf(  ((Fnum==5)?(budget_P5):
                   ((Fnum==4)?(budget_P4):
                   ((Fnum==3)?(budget_P3):
                    ((Fnum==2)?(budget_P2):
                     (budget_P1) ) ) ) ),
                   "%9.3f\t%9.4f\t", 
                   P_OLD[ibas]*1.0e-3,P_RAIN[ibas]*1.0e-3);
        fprintf(   ((Fnum==5)?(budget_Par5):
                    ((Fnum==4)?(budget_Par4):
                     ((Fnum==3)?(budget_Par3):
                      ((Fnum==2)?(budget_Par2):
                       (budget_Par1) ) ) ) ),
                   "%9.3f\t%9.4f\t", 
                   P_OLD[ibas]*basins->mgm2_conv,P_RAIN[ibas]*basins->mgm2_conv);
    }
    
    fprintf(   ((Fnum==5)?(budget_P5):
                ((Fnum==4)?(budget_P4):
                   ((Fnum==3)?(budget_P3):
                    ((Fnum==2)?(budget_P2):
                     (budget_P1) ) ) ) ),
               "%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.3f\t", 
               P_IN_STR[ibas]*1.0e-3, P_OUT_STR[ibas]*1.0e-3, P_IN_OVL[ibas]*1.0e-3, P_OUT_OVL[ibas]*1.0e-3, 
               P_IN_SPG[ibas]*1.0e-3, P_OUT_SPG[ibas]*1.0e-3, P_IN_GW[ibas]*1.0e-3,  P_OUT_GW[ibas]*1.0e-3,
               (P_OLD[ibas]+P_IN[ibas]-P_OUT[ibas])*1.0e-3 );
        /* the new mass (Mg), error & cumulative error (ug/m2 of basin), cumulative avg Total mass In and Out */
    fprintf(   ((Fnum==5)?(budget_P5):
                ((Fnum==4)?(budget_P4):
                   ((Fnum==3)?(budget_P3):
                    ((Fnum==2)?(budget_P2):
                     (budget_P1) ) ) ) ),
               "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t", 
               P[ibas]*1.0e-3, P_ERR[ibas]*1000.0*basins->mgm2_conv, 
               P_ERR_CUM[ibas]*1000.0*basins->mgm2_conv, P_IN_AVG[ibas]*1.0e-3, P_OUT_AVG[ibas]*1.0e-3 );  
    
    fprintf(   ((Fnum==5)?(budget_Par5):
                ((Fnum==4)?(budget_Par4):
                   ((Fnum==3)?(budget_Par3):
                    ((Fnum==2)?(budget_Par2):
                     (budget_Par1) ) ) ) ),
               "%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.3f\t", 
               P_IN_STR[ibas]*basins->mgm2_conv, P_OUT_STR[ibas]*basins->mgm2_conv, P_IN_OVL[ibas]*basins->mgm2_conv, P_OUT_OVL[ibas]*basins->mgm2_conv, 
               P_IN_SPG[ibas]*basins->mgm2_conv, P_OUT_SPG[ibas]*basins->mgm2_conv, P_IN_GW[ibas]*basins->mgm2_conv,  P_OUT_GW[ibas]*basins->mgm2_conv,
               (P_OLD[ibas]+P_IN[ibas]-P_OUT[ibas])*basins->mgm2_conv );
        /* the new mass (Mg), error & cumulative error (ug/m2 of basin), cumulative avg Total mass In and Out */
    fprintf(   ((Fnum==5)?(budget_Par5):
                ((Fnum==4)?(budget_Par4):
                   ((Fnum==3)?(budget_Par3):
                    ((Fnum==2)?(budget_Par2):
                     (budget_Par1) ) ) ) ),
               "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t", 
               P[ibas]*basins->mgm2_conv, P_ERR[ibas]*1000.0*basins->mgm2_conv, 
               P_ERR_CUM[ibas]*1000.0*basins->mgm2_conv, P_IN_AVG[ibas]*basins->mgm2_conv, P_OUT_AVG[ibas]*basins->mgm2_conv );
    
/* don't print for ESP, which does not include live, dead, water-borne fractions */
    if (!ESP) { 
            /* print live P fraction */
            /* mass and inputs/outputs in mg/m2 */
        fprintf(   ((Fnum==5)?(budget_Plive5):
                    ((Fnum==4)?(budget_Plive4):
                       ((Fnum==3)?(budget_Plive3):
                        ((Fnum==2)?(budget_Plive2):
                         (budget_Plive1) ) ) ) ),
                   "%9.3f\t%9.3f\t%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.3f\t", 
                   P_MAC[ibas]*basins->mgm2_conv, P_Calg[ibas]*basins->mgm2_conv, P_NCalg[ibas]*basins->mgm2_conv,
                   mac_NPP[ibas]*basins->mgm2_conv, Calg_GPP[ibas]*basins->mgm2_conv, NCalg_GPP[ibas]*basins->mgm2_conv,
                   mac_mort[ibas]*basins->mgm2_conv, Calg_mort[ibas]*basins->mgm2_conv, 
                   NCalg_mort[ibas]*basins->mgm2_conv,(P_LIVE_OLD[ibas]+P_LIVE_IN[ibas]-P_LIVE_OUT[ibas])*basins->mgm2_conv );
            /* the new mass (mg/m2), error & cumulative error (ug/m2 of basin), cumulative avg Total mass In and Out */
        fprintf(   ((Fnum==5)?(budget_Plive5):
                    ((Fnum==4)?(budget_Plive4):
                       ((Fnum==3)?(budget_Plive3):
                        ((Fnum==2)?(budget_Plive2):
                         (budget_Plive1) ) ) ) ),
                   "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t", 
                   P_LIVE[ibas]*basins->mgm2_conv, P_LIVE_ERR[ibas]*1000.0*basins->mgm2_conv, 
                   P_LIVE_ERR_CUM[ibas]*1000.0*basins->mgm2_conv, P_LIVE_IN_AVG[ibas]*basins->mgm2_conv, P_LIVE_OUT_AVG[ibas]*basins->mgm2_conv );  
        
            /* print dead P fraction */
            /* mass and inputs/outputs in mg/m2 */
        fprintf( ((Fnum==5)?(budget_Pdead5):
                  ((Fnum==4)?(budget_Pdead4):
                       ((Fnum==3)?(budget_Pdead3):
                        ((Fnum==2)?(budget_Pdead2):
                         (budget_Pdead1) ) ) ) ),
                 "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.3f\t", 
                 P_DEAD_OLD[ibas]*basins->mgm2_conv, 
                 dop_macIn[ibas]*basins->mgm2_conv, floc_In[ibas]*basins->mgm2_conv, stdet_in[ibas]*basins->mgm2_conv, stdet_out[ibas]*basins->mgm2_conv,
                 (dop_decomp[ibas]+floc_decomp[ibas])*basins->mgm2_conv, P_settl[ibas]*basins->mgm2_conv, dop_sorbIn[ibas]*basins->mgm2_conv, dop_desorb[ibas]*basins->mgm2_conv, 
                 (P_DEAD_OLD[ibas]+P_DEAD_IN[ibas]-P_DEAD_OUT[ibas])*basins->mgm2_conv );
            /* the new mass (mg/m2), error & cumulative error (ug/m2 of basin), cumulative avg Total mass In and Out */
        fprintf(  ((Fnum==5)?(budget_Pdead5):
                   ((Fnum==4)?(budget_Pdead4):
                       ((Fnum==3)?(budget_Pdead3):
                        ((Fnum==2)?(budget_Pdead2):
                         (budget_Pdead1) ) ) ) ),
                 "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t", 
                 P_DEAD[ibas]*basins->mgm2_conv, P_DEAD_ERR[ibas]*1000.0*basins->mgm2_conv, 
                 P_DEAD_ERR_CUM[ibas]*1000.0*basins->mgm2_conv, P_DEAD_IN_AVG[ibas]*basins->mgm2_conv, P_DEAD_OUT_AVG[ibas]*basins->mgm2_conv );  
            /* print the water-borne fraction */
            /* mass and inputs/outputs in mg/m2 */ /* there is a blank column to match the old budget summary template */
        fprintf(  ((Fnum==5)?(budget_Pwat5):
                   ((Fnum==4)?(budget_Pwat4):
                       ((Fnum==3)?(budget_Pwat3):
                        ((Fnum==2)?(budget_Pwat2):
                         (budget_Pwat1) ) ) ) ),
                 "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t%9.3f\t", 
                 P_WAT_OLD[ibas]*basins->mgm2_conv,  P_RAIN[ibas]*basins->mgm2_conv, P_settl[ibas]*basins->mgm2_conv,
                 wat_sfMiner[ibas]*basins->mgm2_conv, wat_sedMiner[ibas]*basins->mgm2_conv, wat_sfUpt[ibas]*basins->mgm2_conv,
                 wat_sedUpt[ibas]*basins->mgm2_conv, dop_desorb[ibas]*basins->mgm2_conv, dop_sorbIn[ibas]*basins->mgm2_conv,
                 P_IN_STR[ibas]*basins->mgm2_conv, P_OUT_STR[ibas]*basins->mgm2_conv,
                 (P_WAT_OLD[ibas]+P_WAT_IN[ibas]-P_WAT_OUT[ibas])*basins->mgm2_conv );
            /* the new mass (mg/m2), error & cumulative error (ug/m2 of basin), cumulative avg Total mass In and Out */
        fprintf(  ((Fnum==5)?(budget_Pwat5):
                   ((Fnum==4)?(budget_Pwat4):
                       ((Fnum==3)?(budget_Pwat3):
                        ((Fnum==2)?(budget_Pwat2):
                         (budget_Pwat1) ) ) ) ),
                 "%9.3f\t%9.4f\t%9.4f\t%9.4f\t%9.4f\t", 
                 P_WAT[ibas]*basins->mgm2_conv, P_WAT_ERR[ibas]*1000.0*basins->mgm2_conv, 
                 P_WAT_ERR_CUM[ibas]*1000.0*basins->mgm2_conv, P_WAT_IN_AVG[ibas]*basins->mgm2_conv, P_WAT_OUT_AVG[ibas]*basins->mgm2_conv );  
    } /* end of non-ESP prints */

} /* end of budgFinal() */



/*******
 for ALL budgets, store the old total volume in array TOT_xxx_OLD
 and reset any summations and IRavgs to 0
******/
void budgReset(ibas)
{
    
        for (ibas = numBasn; ibas >= 0; ibas--) {
            TOT_VOL_OLD[ibas] = TOT_VOL[ibas]; 
            TOT_S_OLD[ibas] = TOT_S[ibas]; 
            P_OLD[ibas] = P[ibas]; 
            if (!ESP) {
                P_LIVE_OLD[ibas] = P_LIVE[ibas]; 
                P_DEAD_OLD[ibas] = P_DEAD[ibas]; 
                P_WAT_OLD[ibas] = P_WAT[ibas];
            }
         
            SUMSF[ibas] = SUMGW[ibas] = SUMUW[ibas] = TOT_VOL[ibas] = TOT_VOL_CAN[ibas] =  0.0;
            RAIN[ibas] = VOL_IN_STR[ibas] = VOL_IN_OVL[ibas] = VOL_IN_SPG[ibas] = VOL_IN_GW[ibas] =  0.0;
            EVAP[ibas] = TRANSP[ibas] = RCHG[ibas] = VOL_OUT_STR[ibas] = VOL_OUT_OVL[ibas] = VOL_OUT_SPG[ibas] = VOL_OUT_GW[ibas] =  0.0;

            TOT_S[ibas] = TOT_S_CELL[ibas] = TOT_S_CAN[ibas] =  0.0;
            S_IN_STR[ibas] = S_IN_OVL[ibas] = S_IN_SPG[ibas] = S_IN_GW[ibas] =  0.0;
            S_OUT_STR[ibas] = S_OUT_OVL[ibas] = S_OUT_SPG[ibas] = S_OUT_GW[ibas] =  0.0;

            P[ibas] = P_CELL[ibas] = TOT_P_CAN[ibas] =  0.0;
            P_RAIN[ibas] = P_IN_STR[ibas] = P_IN_OVL[ibas] = P_IN_SPG[ibas] = P_IN_GW[ibas] =  0.0;
            P_OUT_STR[ibas] = P_OUT_OVL[ibas] = P_OUT_SPG[ibas] = P_OUT_GW[ibas] =  0.0;

            P_LIVE[ibas] = P_LIVE_CELL[ibas] = P_MAC[ibas] = P_Calg[ibas] = P_NCalg[ibas] = 0.0;
            Calg_GPP[ibas] = NCalg_GPP[ibas] = Calg_mort[ibas] = NCalg_mort[ibas] = 0.0;
            mac_NPP[ibas] = mac_mort[ibas] = 0.0;

            P_DEAD[ibas] = P_DEAD_CELL[ibas] = 0.0;
            dop_macIn[ibas] =  dop_stdIn[ibas] = dop_sorbIn[ibas] = floc_In[ibas] = 0.0;
            stdet_in[ibas] = stdet_out[ibas] = dop_decomp[ibas] = dop_desorb[ibas] = floc_decomp[ibas] = 0.0;

            P_WAT[ibas] = P_WAT_CELL[ibas] = 0.0;
            wat_sfMiner[ibas] = wat_sedMiner[ibas] = wat_sfUpt[ibas] = wat_sedUpt[ibas] =  P_settl[ibas] = 0.0;

            DepthAvg[ibas]=UnsatAvg[ibas]=TPsf_avg[ibas]=TPpore_avg[ibas]=TPsoil_avg[ibas]=
                NCperi_avg[ibas]=Cperi_avg[ibas]=Mac_avg[ibas]=0.0;
            
        }


        fflush (IRavg1); 
        if (numBasn>=13) fflush (IRavg2);
        if (numBasn>=26) fflush (IRavg3); 
        if (numBasn>=39) fflush (IRavg4); 
        if (numBasn>=52) fflush (IRavg5); 

        fflush (budget_Wacr1); 
        if (numBasn>=13) fflush (budget_Wacr2);
        if (numBasn>=26) fflush (budget_Wacr3); 
        if (numBasn>=39) fflush (budget_Wacr4); 
        if (numBasn>=52) fflush (budget_Wacr5); 

        fflush (budget_Wcm1); 
        if (numBasn>=13) fflush (budget_Wcm2); 
        if (numBasn>=26) fflush (budget_Wcm3); 
        if (numBasn>=39) fflush (budget_Wcm4); 
        if (numBasn>=52) fflush (budget_Wcm5); 

        fflush (budget_S1); 
        if (numBasn>=13) fflush (budget_S2); 
        if (numBasn>=26) fflush (budget_S3); 
        if (numBasn>=39) fflush (budget_S4); 
        if (numBasn>=52) fflush (budget_S5); 

        fflush (budget_P1); 
        if (numBasn>=13) fflush (budget_P2); 
        if (numBasn>=26) fflush (budget_P3); 
        if (numBasn>=39) fflush (budget_P4); 
        if (numBasn>=52) fflush (budget_P5); 

        fflush (budget_Par1); 
        if (numBasn>=13) fflush (budget_Par2); 
        if (numBasn>=26) fflush (budget_Par3); 
        if (numBasn>=39) fflush (budget_Par4); 
        if (numBasn>=52) fflush (budget_Par5); 

        if (!ESP) { 
            fflush (budget_Plive1);  
            if (numBasn>=13) fflush (budget_Plive2);  
            if (numBasn>=26) fflush (budget_Plive3); 
            if (numBasn>=39) fflush (budget_Plive4); 
            if (numBasn>=52) fflush (budget_Plive5); 

            fflush (budget_Pdead1);  
            if (numBasn>=13) fflush (budget_Pdead2);  
            if (numBasn>=26) fflush (budget_Pdead3); 
            if (numBasn>=39) fflush (budget_Pdead4); 
            if (numBasn>=52) fflush (budget_Pdead5); 

            fflush (budget_Pwat1);  
            if (numBasn>=13) fflush (budget_Pwat2);  
            if (numBasn>=26) fflush (budget_Pwat3); 
            if (numBasn>=39) fflush (budget_Pwat4); 
            if (numBasn>=52) fflush (budget_Pwat5); 
        } 
} /* end of budgReset() */


/*******
open files and create headers
******/
void budg_files()
{
    int Fnum,Fsets,ibasLow,ibasHigh,ibas;
    
    
/********/
/* For the budget & IRavg files, we can have multiple sets of files, with
   >1 sets needed if a large (>12) number of basins/indicator regions are defined.  First,
   we open the files, then go to write headers for them */

    {/*Open the primary files for all of the budgets & IRavgs */
    
/* Indicator region avgs */
        sprintf( mapFileName, "%s/%s/Output/Budget/IRavg1", OutputPath, ProjName ); 
        if ( ( IRavg1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
        {printf( "Can't open IRavg1 file! " );exit(-1) ;} 
/* water budget/massCheck info - units in acre-feet */
        sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wacr1", OutputPath, ProjName ); 
        if ( ( budget_Wacr1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
        {printf( "Can't open budg_Wacr1 file! " );exit(-1) ;} 
/* water budget/massCheck info - units in cm height */
        sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wcm1", OutputPath, ProjName ); 
        if ( ( budget_Wcm1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
        {printf( "Can't open budg_Wcm1 file! " );exit(-1) ;}
/* Phosph budget/massCheck info for all P fractions (units=Mg) */
        sprintf( mapFileName, "%s/%s/Output/Budget/budg_P1", OutputPath, ProjName ); 
        if ( ( budget_P1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
        {printf( "Can't open budg_P1 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=mg/m2) */
        sprintf( mapFileName, "%s/%s/Output/Budget/budg_Par1", OutputPath, ProjName ); 
        if ( ( budget_Par1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
        {printf( "Can't open budg_Par1 file! " );exit(-1) ;} 
/* Salt budget/massCheck info */
        sprintf( mapFileName, "%s/%s/Output/Budget/budg_S1", OutputPath, ProjName ); 
        if ( ( budget_S1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
        {printf( "Can't open budg_S1 file! " );exit(-1) ;} 
        if (!ESP) {
/* Phosph budget/massCheck info for live P fraction */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pliv1", OutputPath, ProjName ); 
            if ( ( budget_Plive1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Pliv1 file! " );exit(-1) ;}
/* Phosph budget/massCheck info for dead P fraction */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pded1", OutputPath, ProjName ); 
            if ( ( budget_Pdead1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Pded1 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for water-borne P fraction */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pwat1", OutputPath, ProjName ); 
            if ( ( budget_Pwat1 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Pwat1 file! " );exit(-1) ;}
        }


        if (numBasn>=13) {
/*Open the secondary files for all of the budgets & IRavgs if we have more than 12 basins */
/* Indicator region avgs */
            sprintf( mapFileName, "%s/%s/Output/Budget/IRavg2", OutputPath, ProjName ); 
            if ( ( IRavg2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open IRavg2 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in acre-feet */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wacr2", OutputPath, ProjName ); 
            if ( ( budget_Wacr2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open budg_Wacr2 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in cm height */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wcm2", OutputPath, ProjName ); 
            if ( ( budget_Wcm2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Wcm2 file! " ); exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=Mg) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_P2", OutputPath, ProjName ); 
            if ( ( budget_P2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_P2 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=mg/m2) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Par2", OutputPath, ProjName ); 
            if ( ( budget_Par2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Par2 file! " );exit(-1) ;} 
/* Salt budget/massCheck info */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_S2", OutputPath, ProjName ); 
            if ( ( budget_S2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_S2 file! " );exit(-1) ;} 

            if (!ESP) {
/* Phosph budget/massCheck info for live P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pliv2", OutputPath, ProjName ); 
                if ( ( budget_Plive2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pliv2 file! " );exit(-1) ;}
/* Phosph budget/massCheck info for dead P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pded2", OutputPath, ProjName ); 
                if ( ( budget_Pdead2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pded2 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for water-borne P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pwat2", OutputPath, ProjName ); 
                if ( ( budget_Pwat2 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pwat2 file! " );exit(-1) ;} 
            }/* end of !ESP */
    
        } /* end of opening secondary files */

        
        if (numBasn>=26) {
/*Open the tertiary files for all of the budgets if we have more than 25 basins */
/* Indicator region avgs */
            sprintf( mapFileName, "%s/%s/Output/Budget/IRavg3", OutputPath, ProjName ); 
            if ( ( IRavg3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open IRavg3 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in acre-feet */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wacr3", OutputPath, ProjName ); 
            if ( ( budget_Wacr3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open budg_Wacr3 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in cm height */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wcm3", OutputPath, ProjName ); 
            if ( ( budget_Wcm3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Wcm3 file! " ); exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=Mg) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_P3", OutputPath, ProjName ); 
            if ( ( budget_P3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_P3 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=mg/m2) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Par3", OutputPath, ProjName ); 
            if ( ( budget_Par3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Par3 file! " );exit(-1) ;} 
/* Salt budget/massCheck info */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_S3", OutputPath, ProjName ); 
            if ( ( budget_S3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_S3 file! " );exit(-1) ;} 

            if (!ESP) {
/* Phosph budget/massCheck info for live P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pliv3", OutputPath, ProjName ); 
                if ( ( budget_Plive3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pliv3 file! " );exit(-1) ;}
/* Phosph budget/massCheck info for dead P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pded3", OutputPath, ProjName ); 
                if ( ( budget_Pdead3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pded3 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for water-borne P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pwat3", OutputPath, ProjName ); 
                if ( ( budget_Pwat3 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pwat3 file! " );exit(-1) ;} 
            }/* end of !ESP */
    
        } /* end of opening tertiary files */
        
        if (numBasn>=39) {
/*Open the fourth set of files for all of the budgets if we have more than 38 basins */
/* Indicator region avgs */
            sprintf( mapFileName, "%s/%s/Output/Budget/IRavg4", OutputPath, ProjName ); 
            if ( ( IRavg4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open IRavg4 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in acre-feet */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wacr4", OutputPath, ProjName ); 
            if ( ( budget_Wacr4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open budg_Wacr4 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in cm height */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wcm4", OutputPath, ProjName ); 
            if ( ( budget_Wcm4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Wcm4 file! " ); exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=Mg) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_P4", OutputPath, ProjName ); 
            if ( ( budget_P4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_P4 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=mg/m2) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Par4", OutputPath, ProjName ); 
            if ( ( budget_Par4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Par4 file! " );exit(-1) ;} 
/* Salt budget/massCheck info */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_S4", OutputPath, ProjName ); 
            if ( ( budget_S4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_S4 file! " );exit(-1) ;} 

            if (!ESP) {
/* Phosph budget/massCheck info for live P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pliv4", OutputPath, ProjName ); 
                if ( ( budget_Plive4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pliv4 file! " );exit(-1) ;}
/* Phosph budget/massCheck info for dead P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pded4", OutputPath, ProjName ); 
                if ( ( budget_Pdead4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pded4 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for water-borne P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pwat4", OutputPath, ProjName ); 
                if ( ( budget_Pwat4 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pwat4 file! " );exit(-1) ;} 
            }/* end of !ESP */
    
        } /* end of opening fourth set of files */
        
        if (numBasn>=52) {
/*Open the fifth set of files for all of the budgets if we have more than 51 basins */
/* Indicator region avgs */
            sprintf( mapFileName, "%s/%s/Output/Budget/IRavg5", OutputPath, ProjName ); 
            if ( ( IRavg5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open IRavg5 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in acre-feet */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wacr5", OutputPath, ProjName ); 
            if ( ( budget_Wacr5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            { printf( "Can't open budg_Wacr5 file! " ); exit(-1) ;} 
/* water budget/massCheck info - units in cm height */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Wcm5", OutputPath, ProjName ); 
            if ( ( budget_Wcm5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Wcm5 file! " ); exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=Mg) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_P5", OutputPath, ProjName ); 
            if ( ( budget_P5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_P5 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for all P fractions (units=mg/m2) */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_Par5", OutputPath, ProjName ); 
            if ( ( budget_Par5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_Par5 file! " );exit(-1) ;} 
/* Salt budget/massCheck info */
            sprintf( mapFileName, "%s/%s/Output/Budget/budg_S5", OutputPath, ProjName ); 
            if ( ( budget_S5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
            {printf( "Can't open budg_S5 file! " );exit(-1) ;} 

            if (!ESP) {
/* Phosph budget/massCheck info for live P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pliv5", OutputPath, ProjName ); 
                if ( ( budget_Plive5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pliv5 file! " );exit(-1) ;}
/* Phosph budget/massCheck info for dead P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pded5", OutputPath, ProjName ); 
                if ( ( budget_Pdead5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pded5 file! " );exit(-1) ;} 
/* Phosph budget/massCheck info for water-borne P fraction */
                sprintf( mapFileName, "%s/%s/Output/Budget/budg_Pwat5", OutputPath, ProjName ); 
                if ( ( budget_Pwat5 = fopen( mapFileName, "w" ) ) ==  NULL ) 
                {printf( "Can't open budg_Pwat5 file! " );exit(-1) ;} 
            }/* end of !ESP */
    
        } /* end of opening fifth set of files */
        
    } /* end of opening all files */



/********/
/* Now we need to print the headers to each set(s) of basin files */
/* First, figure out the number of files sets, and then loop thru that */
        /* there are 13 total basins printed per file (basin 0 is whole system,
           not counted in numBasn, but always printed out in first file) */
    if (numBasn>=52) { /* with more than 58 (plus whole-system basin == 59) basins: */
        Fsets=5;              /* we have five sets of basin files */
    }
    else if (numBasn>=39) { /* with more than 38 (plus whole-system basin == 39) basins: */
        Fsets=4;              /* we have four sets of basin files */
    }
    else if (numBasn>=26) { /* with more than 25 (plus whole-system basin == 26) basins: */
        Fsets=3;              /* we have three sets of basin files */
    }
    else if (numBasn>=13) { /* with more than 12 (plus whole-system basin == 13) basins: */
        Fsets=2;              /* we have two sets of basin files */
    }
    else {
        Fsets=1;       /* otherwise, just one set of files */
    }

    for (Fnum = 1; Fnum <= Fsets; Fnum++) { 
    
        if (Fnum == 1) { /* first file set */
            if (Fsets > 1) {
                ibasLow = 0;        
                ibasHigh = 12;
            }
            else {
                ibasLow = 0;
                ibasHigh = Min(12,numBasn);
            }
        }

        if (Fnum == 2) { /* second file set */
            if (Fsets > 2) {
                ibasLow = 13;        
                ibasHigh = 25;
            }
            else {
                ibasLow = 13;
                ibasHigh = Min(25,numBasn);
            }
        }

        if (Fnum == 3) { /* third file set */
            if (Fsets > 3) {
                ibasLow = 26;        
                ibasHigh = 38;
            }
            else {
                ibasLow = 26;
                ibasHigh = Min(38,numBasn);
            }
        }
        
        if (Fnum == 4) { /* fourth file set */
            if (Fsets > 4) {
                ibasLow = 39;        
                ibasHigh = 51;
            }
            else {
                ibasLow = 39;
                ibasHigh = Min(51,numBasn);
            }
        }
        

        else if (Fnum == 5) {
            ibasLow = 52;        
            ibasHigh = numBasn;
        }

/*****/
/* now print the 3 header lines for all of the budget & IRavg files */

/* LINE 1: first header line, providing scenario ID, units, etc. */

        fprintf ( ((Fnum==5)?(IRavg5):
                   ((Fnum==4)?(IRavg4):
                   ((Fnum==3)?(IRavg3):
                    ((Fnum==2)?(IRavg2):
                     (IRavg1) ) ) ) ), 
                  "%s %s %s %s scenario: Basins/IndicatorRegions (IR): daily mean attributes. \nUnits = Hydro depths== m, TP surface & pore water==mg/L, TP soil==mg/kg, noncalc&calc periph==gC/m2, mac==kgC/m2.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
        fprintf ( ((Fnum==5)?(budget_Wacr5):
                   ((Fnum==4)?(budget_Wacr4):
                   ((Fnum==3)?(budget_Wacr3):
                    ((Fnum==2)?(budget_Wacr2):
                     (budget_Wacr1) ) ) ) ), 
                  "%s %s %s %s scenario: Basins/IndicatorRegions (IR): water budget and mass balance check. \nUnits = thousands of acre-feet per basin, with error (and cumulative net error) reporting in mm height across basin.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
        fprintf ( ((Fnum==5)?(budget_Wcm5):
                   ((Fnum==4)?(budget_Wcm4):
                   ((Fnum==3)?(budget_Wcm3):
                    ((Fnum==2)?(budget_Wcm2):
                     (budget_Wcm1) ) ) ) ), 
                  "%s %s %s %s scenario: Basins/IndicatorRegions (IR): water budget and mass balance check. \nUnits = cm per basin, with error (and cumulative net error) reporting in mm height across basin.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
        fprintf ( ((Fnum==5)?(budget_S5):
                   ((Fnum==4)?(budget_S4):
                   ((Fnum==3)?(budget_S3):
                    ((Fnum==2)?(budget_S2):
                     (budget_S1) ) ) ) ), 
                  "%s %s %s %s scenario: Basins/IndicatorRegions (IR): conservative tracer budget and mass balance check. \nUnits = metric tons (Mg) per basin, with error (and cumulative net error) reporting in ug/m2 in basin.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
        fprintf ( ((Fnum==5)?(budget_P5):
                   ((Fnum==4)?(budget_P4):
                   ((Fnum==3)?(budget_P3):
                    ((Fnum==2)?(budget_P2):
                     (budget_P1) ) ) ) ), 
                  "%s %s %s %s scenario: Basins/IndicatorRegions (IR): Total P budget and mass balance check for all fractions. \nUnits = metric tons (Mg) per basin, with error (and cumulative net error) reporting in ug/m2 in basin.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
        fprintf ( ((Fnum==5)?(budget_Par5):
                   ((Fnum==4)?(budget_Par4):
                   ((Fnum==3)?(budget_Par3):
                    ((Fnum==2)?(budget_Par2):
                     (budget_Par1) ) ) ) ), 
                  "%s %s %s %s scenario: Basins/IndicatorRegions (IR): Total P budget and mass balance check for all fractions. \nUnits = mg/m2 in basin, with error (and cumulative net error) reporting in ug/m2 in basin.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
        if (!ESP) {

            fprintf ( ((Fnum==5)?(budget_Plive5):
                       ((Fnum==4)?(budget_Plive4):
                       ((Fnum==3)?(budget_Plive3):
                        ((Fnum==2)?(budget_Plive2):
                         (budget_Plive1) ) ) ) ), 
                      "%s %s %s %s scenario: Basins/IndicatorRegions (IR): Total P budget and mass balance check for live fraction. \nUnits =  mg/m2 in basin, with error (and cumulative net error) ug/m2.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
            fprintf ( ((Fnum==5)?(budget_Pdead5):
                       ((Fnum==4)?(budget_Pdead4):
                       ((Fnum==3)?(budget_Pdead3):
                        ((Fnum==2)?(budget_Pdead2):
                         (budget_Pdead1) ) ) ) ), 
                      "%s %s %s %s scenario: Basins/IndicatorRegions (IR): Total P budget and mass balance check for dead, non-water-borne fraction. \nUnits =  mg/m2 in basin, with error (and cumulative net error) ug/m2.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
            fprintf ( ((Fnum==5)?(budget_Pwat5):
                       ((Fnum==4)?(budget_Pwat4):
                       ((Fnum==3)?(budget_Pwat3):
                        ((Fnum==2)?(budget_Pwat2):
                         (budget_Pwat1) ) ) ) ), 
                      "%s %s %s %s scenario: Basins/IndicatorRegions (IR): Total P budget and mass balance check for water-borne fraction (some horiz I/O not shown - see budget for all combined fractions). \nUnits =  mg/m2 in basin, with error (and cumulative net error) ug/m2.\n          \t ", &modelName, &modelVers, &SimAlt, &SimModif ); 
        }

/* LINE 2: second header line, looping thru basins, providing basin ID and size */
        for (ibas = ibasHigh; ibas >= ibasLow; ibas--) 
        {
        fprintf ( ((Fnum==5)?(IRavg5):
                  ((Fnum==4)?(IRavg4):
                   ((Fnum==3)?(IRavg3):
                    ((Fnum==2)?(IRavg2):
                     (IRavg1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t",
                      ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) ); 
        fprintf ( ((Fnum==5)?(budget_Wacr5):
                   ((Fnum==4)?(budget_Wacr4):
                   ((Fnum==3)?(budget_Wacr3):
                    ((Fnum==2)?(budget_Wacr2):
                     (budget_Wacr1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                      ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) ); 
        fprintf ( ((Fnum==5)?(budget_Wcm5):
                   ((Fnum==4)?(budget_Wcm4):
                   ((Fnum==3)?(budget_Wcm3):
                    ((Fnum==2)?(budget_Wcm2):
                     (budget_Wcm1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                      ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) ); 
        fprintf ( ((Fnum==5)?(budget_S5):
                   ((Fnum==4)?(budget_S4):
                   ((Fnum==3)?(budget_S3):
                    ((Fnum==2)?(budget_S2):
                     (budget_S1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                      ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) ); 
            if (!ESP) {
                fprintf ( ((Fnum==5)?(budget_P5):
                          ((Fnum==4)?(budget_P4):
                           ((Fnum==3)?(budget_P3):
                            ((Fnum==2)?(budget_P2):
                             (budget_P1) ) ) ) ), 
                          "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                          ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) );
                fprintf ( ((Fnum==5)?(budget_Par5):
                           ((Fnum==4)?(budget_Par4):
                           ((Fnum==3)?(budget_Par3):
                            ((Fnum==2)?(budget_Par2):
                             (budget_Par1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                          ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) );
                fprintf ( ((Fnum==5)?(budget_Plive5):
                           ((Fnum==4)?(budget_Plive4):
                            ((Fnum==3)?(budget_Plive3):
                             ((Fnum==2)?(budget_Plive2):
                              (budget_Plive1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                          ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) ); 
                fprintf ( ((Fnum==5)?(budget_Pdead5):
                           ((Fnum==4)?(budget_Pdead4):
                            ((Fnum==3)?(budget_Pdead3):
                             ((Fnum==2)?(budget_Pdead2):
                              (budget_Pdead1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t          \t        \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                          ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) ); 
                fprintf ( ((Fnum==5)?(budget_Pwat5):
                           ((Fnum==4)?(budget_Pwat4):
                            ((Fnum==3)?(budget_Pwat3):
                             ((Fnum==2)?(budget_Pwat2):
                              (budget_Pwat1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                          ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) ); 
            }
    
            else {
                fprintf ( ((Fnum==5)?(budget_P5):
                           ((Fnum==4)?(budget_P4):
                           ((Fnum==3)?(budget_P3):
                            ((Fnum==2)?(budget_P2):
                             (budget_P1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                          ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) );
                fprintf ( ((Fnum==5)?(budget_Par5):
                           ((Fnum==4)?(budget_Par4):
                           ((Fnum==3)?(budget_Par3):
                            ((Fnum==2)?(budget_Par2):
                             (budget_Par1) ) ) ) ), 
                      "  Basin %2d =\t%6.1fmi^2,\t%6.1fkm^2\t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t         \t",
                          ibas,(numCells[ibas]*CELL_SIZE*3.8610039e-7),(numCells[ibas]*CELL_SIZE*1.0e-6) );
            }
        } /*end of loop for second header line */

/* LINE 3: beginning of third header line */
        fprintf ( ((Fnum==5)?(IRavg5):
                   ((Fnum==4)?(IRavg4):
                   ((Fnum==3)?(IRavg3):
                    ((Fnum==2)?(IRavg2):
                     (IRavg1) ) ) ) ), "\n    Date\t" ); 
        fprintf ( ((Fnum==5)?(budget_Wacr5):
                   ((Fnum==4)?(budget_Wacr4):
                   ((Fnum==3)?(budget_Wacr3):
                    ((Fnum==2)?(budget_Wacr2):
                     (budget_Wacr1) ) ) ) ), "\n    Date\t" ); 
        fprintf ( ((Fnum==5)?(budget_Wcm5):
                   ((Fnum==4)?(budget_Wcm4):
                   ((Fnum==3)?(budget_Wcm3):
                    ((Fnum==2)?(budget_Wcm2):
                     (budget_Wcm1) ) ) ) ), "\n    Date\t" ); 
        fprintf ( ((Fnum==5)?(budget_S5):
                   ((Fnum==4)?(budget_S4):
                   ((Fnum==3)?(budget_S3):
                    ((Fnum==2)?(budget_S2):
                     (budget_S1) ) ) ) ), "\n    Date\t" ); 
        fprintf ( ((Fnum==5)?(budget_P5):
                   ((Fnum==4)?(budget_P4):
                   ((Fnum==3)?(budget_P3):
                    ((Fnum==2)?(budget_P2):
                     (budget_P1) ) ) ) ), "\n    Date\t" ); 
        fprintf ( ((Fnum==5)?(budget_Par5):
                   ((Fnum==4)?(budget_Par4):
                   ((Fnum==3)?(budget_Par3):
                    ((Fnum==2)?(budget_Par2):
                     (budget_Par1) ) ) ) ), "\n    Date\t" ); 
        if (!ESP) {
            fprintf ( ((Fnum==5)?(budget_Plive5):
                       ((Fnum==4)?(budget_Plive4):
                       ((Fnum==3)?(budget_Plive3):
                        ((Fnum==2)?(budget_Plive2):
                         (budget_Plive1) ) ) ) ), "\n    Date\t" ); 
            fprintf ( ((Fnum==5)?(budget_Pdead5):
                       ((Fnum==4)?(budget_Pdead4):
                       ((Fnum==3)?(budget_Pdead3):
                        ((Fnum==2)?(budget_Pdead2):
                         (budget_Pdead1) ) ) ) ), "\n    Date\t" ); 
            fprintf ( ((Fnum==5)?(budget_Pwat5):
                       ((Fnum==4)?(budget_Pwat4):
                       ((Fnum==3)?(budget_Pwat3):
                        ((Fnum==2)?(budget_Pwat2):
                         (budget_Pwat1) ) ) ) ), "\n    Date\t" ); 
        }

/* LINE 3: remainder of third header line, looping thru basins, providing column attributes */
        for (ibas = ibasHigh; ibas >= ibasLow; ibas--) 
        {
        
        fprintf ( ((Fnum==5)?(IRavg5):
                  ((Fnum==4)?(IRavg4):
                   ((Fnum==3)?(IRavg3):
                    ((Fnum==2)?(IRavg2):
                     (IRavg1) ) ) ) ), 
                      "   Depth_%d\t   Unsat_%d\t    TPsf_%d\t  TPpore_%d\t  TPsoil_%d\t  NCperi_%d\t   Cperi_%d\t     Mac_%d\t",
                      ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas); 
        fprintf ( ((Fnum==5)?(budget_Wacr5):
                   ((Fnum==4)?(budget_Wacr4):
                   ((Fnum==3)?(budget_Wacr3):
                    ((Fnum==2)?(budget_Wacr2):
                     (budget_Wacr1) ) ) ) ), 
                      "  VolOld_%d\t    Rain_%d\t    Evap_%d\t  Transp_%d\t    Rchg_%d\t   StrIn_%d\t  StrOut_%d\t   OvlIn_%d\t  OvlOut_%d\t   SpgIn_%d\t  SpgOut_%d\t    GWin_%d\t   GWout_%d\t VolTarg_%d\t  VolNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                      ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas); 
        fprintf ( ((Fnum==5)?(budget_Wcm5):
                   ((Fnum==4)?(budget_Wcm4):
                   ((Fnum==3)?(budget_Wcm3):
                    ((Fnum==2)?(budget_Wcm2):
                     (budget_Wcm1) ) ) ) ), 
                      "  VolOld_%d\t    Rain_%d\t    Evap_%d\t  Transp_%d\t    Rchg_%d\t   StrIn_%d\t  StrOut_%d\t   OvlIn_%d\t  OvlOut_%d\t   SpgIn_%d\t  SpgOut_%d\t    GWin_%d\t   GWout_%d\t VolTarg_%d\t  VolNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                      ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas); 
        fprintf ( ((Fnum==5)?(budget_S5):
                   ((Fnum==4)?(budget_S4):
                   ((Fnum==3)?(budget_S3):
                    ((Fnum==2)?(budget_S2):
                     (budget_S1) ) ) ) ), 
                      "  MasOld_%d\t   StrIn_%d\t  StrOut_%d\t   OvlIn_%d\t  OvlOut_%d\t   SpgIn_%d\t  SpgOut_%d\t    GWin_%d\t   GWout_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                      ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas); 
            if (!ESP) {
                fprintf ( ((Fnum==5)?(budget_P5):
                          ((Fnum==4)?(budget_P4):
                           ((Fnum==3)?(budget_P3):
                            ((Fnum==2)?(budget_P2):
                             (budget_P1) ) ) ) ), 
                      "  MasOld_%d\t    Rain_%d\t   StrIn_%d\t  StrOut_%d\t   OvlIn_%d\t  OvlOut_%d\t   SpgIn_%d\t  SpgOut_%d\t    GWin_%d\t   GWout_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                          ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas);
                fprintf ( ((Fnum==5)?(budget_Par5):
                           ((Fnum==4)?(budget_Par4):
                           ((Fnum==3)?(budget_Par3):
                            ((Fnum==2)?(budget_Par2):
                             (budget_Par1) ) ) ) ), 
                      "  MasOld_%d\t    Rain_%d\t   StrIn_%d\t  StrOut_%d\t   OvlIn_%d\t  OvlOut_%d\t   SpgIn_%d\t  SpgOut_%d\t    GWin_%d\t   GWout_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                          ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas);
                fprintf ( ((Fnum==5)?(budget_Plive5):
                           ((Fnum==4)?(budget_Plive4):
                            ((Fnum==3)?(budget_Plive3):
                             ((Fnum==2)?(budget_Plive2):
                              (budget_Plive1) ) ) ) ), 
                      "  MacBio_%d\t CPerBio_%d\t NCPerBio_%d\t  MacNPP_%d\t CPerGPP_%d\tNCPerGPP_%d\t MacMort_%d\t CalgMort_%d\t NCalgMort_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                          ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas); 
                fprintf ( ((Fnum==5)?(budget_Pdead5):
                           ((Fnum==4)?(budget_Pdead4):
                            ((Fnum==3)?(budget_Pdead3):
                             ((Fnum==2)?(budget_Pdead2):
                              (budget_Pdead1) ) ) ) ), 
                      "  MasOld_%d\tMac-soil_%d\tPer-soil_%d\t Mac-StD_%d\t(StD-soil)_%d\t  Decomp_%d\tSettl_to_%d\t Sorb_to_%d\t  Desorb_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                          ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas); 
                fprintf ( ((Fnum==5)?(budget_Pwat5):
                           ((Fnum==4)?(budget_Pwat4):
                            ((Fnum==3)?(budget_Pwat3):
                             ((Fnum==2)?(budget_Pwat2):
                              (budget_Pwat1) ) ) ) ), 
                      "  MasOld_%d\t  P_rain_%d\tSettl_fr_%d\t SfMiner_%d\tSedMiner_%d\tBlnk_%d\t  AlgUpt_%d\t  MacUpt_%d\t  DeSorb_%d\t Sorb_to_%d\t   StrIn_%d\t  StrOut_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                          ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas); 
            }
            else {
                fprintf ( ((Fnum==5)?(budget_P5):
                           ((Fnum==4)?(budget_P4):
                           ((Fnum==3)?(budget_P3):
                            ((Fnum==2)?(budget_P2):
                             (budget_P1) ) ) ) ), 
                      "  MasOld_%d\t    Rain_%d\t   Settl_%d\t   StrIn_%d\t  StrOut_%d\t   OvlIn_%d\t  OvlOut_%d\t   SpgIn_%d\t  SpgOut_%d\t    GWin_%d\t   GWout_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                          ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas);
                fprintf ( ((Fnum==5)?(budget_Par5):
                           ((Fnum==4)?(budget_Par4):
                           ((Fnum==3)?(budget_Par3):
                            ((Fnum==2)?(budget_Par2):
                             (budget_Par1) ) ) ) ), 
                      "  MasOld_%d\t    Rain_%d\t   Settl_%d\t   StrIn_%d\t  StrOut_%d\t   OvlIn_%d\t  OvlOut_%d\t   SpgIn_%d\t  SpgOut_%d\t    GWin_%d\t   GWout_%d\t MasTarg_%d\t  MasNew_%d\t     Err_%d\t  SumErr_%d\t   InAvg_%d\t  OutAvg_%d\t",
                          ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas,ibas);
            }
        } /* end of loop for third header line */

    } /*end of printing all files' headers */

        
} /* end of budget file initialization */



/*******
 zero the array holding hydroperiod (after printing)
******/
void zero_hydper() 
{
    int ix, iy, cellLoc; 

        for(ix=1; ix<=s0; ix++) 
            for(iy=1; iy<=s1; iy++) 
                if(ON_MAP[cellLoc= T(ix,iy)]) {
                    HydPerAnn[cellLoc] = 0.0;
                }
} 


/*******
 zero the arrays holding averages (after printing)
******/
void zero_avg() 
{
    int ix, iy, cellLoc, ibas; 

    for(ix=1; ix<=s0; ix++) 
        for(iy=1; iy<=s1; iy++) 
            if(ON_MAP[cellLoc= T(ix,iy)]) {
                TotHeadAvg[cellLoc] = 0.0;
                SfWatAvg[cellLoc] = 0.0;
                UnsatZavg[cellLoc] = 0.0;
                UnsatMoistAvg[cellLoc] = 0.0;
                RainAvg[cellLoc] = 0.0;
                EvapAvg[cellLoc] = 0.0;
                TranspAvg[cellLoc] = 0.0;
                ETAvg[cellLoc] = 0.0;

                TPSfWatAvg[cellLoc] = 0.0;
                TPSfUptAvg[cellLoc] = 0.0;
                TPSfMinAvg[cellLoc] = 0.0;
                TP_settlAvg[cellLoc] = 0.0;
                TPSedWatAvg[cellLoc] = 0.0;
                TPSedUptAvg[cellLoc] = 0.0;
                TPSedMinAvg[cellLoc] = 0.0;
                TPSorbAvg[cellLoc] = 0.0;
                TPtoVOLAvg[cellLoc] = 0.0;
                TPtoSOILAvg[cellLoc] = 0.0;

                SaltSfAvg[cellLoc] = 0.0;
                SaltSedAvg[cellLoc] = 0.0;

                Floc_fr_phBioAvg[cellLoc]  = 0.0;
                DOM_fr_stdetAvg[cellLoc]  = 0.0;

                NC_PeriAvg[cellLoc] = 0.0;
                NC_Peri_nppAvg[cellLoc] = 0.0;
                NC_Peri_mortAvg[cellLoc] = 0.0;
                NC_PeriRespAvg[cellLoc] = 0.0;
                NC_PeriNutCFAvg[cellLoc] = 0.0;
                C_Peri_PCAvg[cellLoc] = 0.0;
                C_PeriAvg[cellLoc] = 0.0;
                C_Peri_nppAvg[cellLoc] = 0.0;
                C_Peri_mortAvg[cellLoc] = 0.0;
                C_PeriRespAvg[cellLoc] = 0.0;
                C_PeriNutCFAvg[cellLoc] = 0.0;
                C_Peri_PCAvg[cellLoc] = 0.0;
                PeriAvg[cellLoc] = 0.0;
                PeriLiteCFAvg[cellLoc] = 0.0;

                Mac_nphBioAvg[cellLoc]  = 0.0;
                Mac_phBioAvg[cellLoc]  = 0.0;
                Mac_totBioAvg[cellLoc]  = 0.0;
                Mac_nppAvg[cellLoc]  = 0.0;
                Mac_nphMortAvg[cellLoc]  = 0.0;
                Mac_phMortAvg[cellLoc]  = 0.0;
                LAI_effAvg[cellLoc]  = 0.0;
                Manning_nAvg[cellLoc]  = 0.0;
                MacNutCfAvg[cellLoc]  = 0.0;
                MacWatCfAvg[cellLoc]  = 0.0;
                mac_nph_PCAvg[cellLoc]  = 0.0;
                mac_ph_PCAvg[cellLoc]  = 0.0;

                Std_detrAvg[cellLoc]  = 0.0;
            }   
} /* end of zero_avg() */


/*******
allocate memory for all of these stats
******/
void alloc_mem_stats ()
{
    int ix,iy,cellLoc,ibas, numBasnMax=0;


    for(ix=0; ix<=s0+1; ix++) 
        for(iy=0; iy<=s1+1; iy++)
            if (ON_MAP[cellLoc= T(ix,iy)]) { 
                if (basn[cellLoc] > numBasnMax) numBasnMax = basn[cellLoc]; 
            }
    numBasn = numBasnMax; /* total number of basins in domain */
    
    sprintf (msgStr,"\tUsing %d hydrologic and user-defined basins. ",numBasn); usrErr(msgStr);
    
/* basin budget arrays (number of actual basins plus basin 0, which is whole system) */
    numCells = (int *) nalloc (sizeof(int)*(numBasn+1),"numCells"); /* number of cells in a basin */

/* Indicator region averages (non-budget) */
	DepthAvg = (double *) nalloc(sizeof(double)*(numBasn+1),"DepthAvg");
	init_pvar(DepthAvg,NULL,'b',0.0);
	UnsatAvg = (double *) nalloc(sizeof(double)*(numBasn+1),"UnsatAvg");
	init_pvar(UnsatAvg,NULL,'b',0.0);
	TPsf_avg = (double *) nalloc(sizeof(double)*(numBasn+1),"TPsf_avg");
	init_pvar(TPsf_avg,NULL,'b',0.0);
	TPpore_avg = (double *) nalloc(sizeof(double)*(numBasn+1),"TPpore_avg");
	init_pvar(TPpore_avg,NULL,'b',0.0);
	TPsoil_avg = (double *) nalloc(sizeof(double)*(numBasn+1),"TPsoil_avg");
	init_pvar(TPsoil_avg,NULL,'b',0.0);
	NCperi_avg = (double *) nalloc(sizeof(double)*(numBasn+1),"NCperi_avg");
	init_pvar(NCperi_avg,NULL,'b',0.0);
	Cperi_avg = (double *) nalloc(sizeof(double)*(numBasn+1),"Cperi_avg");
	init_pvar(Cperi_avg,NULL,'b',0.0);
	Mac_avg = (double *) nalloc(sizeof(double)*(numBasn+1),"Mac_avg");
	init_pvar(Mac_avg,NULL,'b',0.0);
/* hydro mass bal vars */
	SUMSF = (double *) nalloc(sizeof(double)*(numBasn+1),"SUMSF");
	init_pvar(SUMSF,NULL,'b',0.0);
	SUMGW = (double *) nalloc(sizeof(double)*(numBasn+1),"SUMGW");
	init_pvar(SUMGW,NULL,'b',0.0);
	SUMUW = (double *) nalloc(sizeof(double)*(numBasn+1),"SUMUW");
	init_pvar(SUMUW,NULL,'b',0.0);
	RAIN = (double *) nalloc(sizeof(double)*(numBasn+1),"RAIN");
	init_pvar(RAIN,NULL,'b',0.0);
	EVAP = (double *) nalloc(sizeof(double)*(numBasn+1),"EVAP");
	init_pvar(EVAP,NULL,'b',0.0);
	TRANSP = (double *) nalloc(sizeof(double)*(numBasn+1),"TRANSP");
	init_pvar(TRANSP,NULL,'b',0.0);
	RCHG = (double *) nalloc(sizeof(double)*(numBasn+1),"RCHG");
	init_pvar(RCHG,NULL,'b',0.0);

	TOT_VOL = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_VOL");
	init_pvar(TOT_VOL,NULL,'b',0.0);
	TOT_VOL_OLD = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_VOL_OLD");
	init_pvar(TOT_VOL_OLD,NULL,'b',0.0);
	VOL_IN = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_IN");
	init_pvar(VOL_IN,NULL,'b',0.0);
	VOL_OUT = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_OUT");
	init_pvar(VOL_OUT,NULL,'b',0.0);
	TOT_VOL_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_VOL_ERR");
	init_pvar(TOT_VOL_ERR,NULL,'b',0.0);
	TOT_VOL_CUM_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_VOL_CUM_ERR");
	init_pvar(TOT_VOL_CUM_ERR,NULL,'b',0.0);
	TOT_VOL_AVG_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_VOL_AVG_ERR");
	init_pvar(TOT_VOL_AVG_ERR,NULL,'b',0.0);
	VOL_ERR_PER_INFL = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_ERR_PER_INFL");
	init_pvar(VOL_ERR_PER_INFL,NULL,'b',0.0);

	VOL_IN_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_IN_SUM");
	init_pvar(VOL_IN_SUM,NULL,'b',0.0);
	VOL_OUT_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_OUT_SUM");
	init_pvar(VOL_OUT_SUM,NULL,'b',0.0);
	VOL_IN_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_IN_AVG");
	init_pvar(VOL_IN_AVG,NULL,'b',0.0);
	VOL_OUT_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_OUT_AVG");
	init_pvar(VOL_OUT_AVG,NULL,'b',0.0);

	TOT_VOL_CAN = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_VOL_CAN");
	init_pvar(TOT_VOL_CAN,NULL,'b',0.0);

	VOL_IN_STR = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_IN_STR");
	init_pvar(VOL_IN_STR,NULL,'b',0.0);
	VOL_IN_OVL = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_IN_OVL");
	init_pvar(VOL_IN_OVL,NULL,'b',0.0);
	VOL_IN_SPG = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_IN_SPG");
	init_pvar(VOL_IN_SPG,NULL,'b',0.0);
	VOL_IN_GW = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_IN_GW");
	init_pvar(VOL_IN_GW,NULL,'b',0.0);

	VOL_OUT_STR = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_OUT_STR");
	init_pvar(VOL_OUT_STR,NULL,'b',0.0);
	VOL_OUT_OVL = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_OUT_OVL");
	init_pvar(VOL_OUT_OVL,NULL,'b',0.0);
	VOL_OUT_SPG = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_OUT_SPG");
	init_pvar(VOL_OUT_SPG,NULL,'b',0.0);
	VOL_OUT_GW = (double *) nalloc(sizeof(double)*(numBasn+1),"VOL_OUT_GW");
	init_pvar(VOL_OUT_GW,NULL,'b',0.0);

/* phosph mass bal vars for all storage fractions */
	P_CELL = (double *) nalloc(sizeof(double)*(numBasn+1),"P_CELL");
	init_pvar(P_CELL,NULL,'b',0.0);
	P_RAIN = (double *) nalloc(sizeof(double)*(numBasn+1),"P_RAIN");
	init_pvar(P_RAIN,NULL,'b',0.0);

	P = (double *) nalloc(sizeof(double)*(numBasn+1),"P");
	init_pvar(P,NULL,'b',0.0);
	P_OLD = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OLD");
	init_pvar(P_OLD,NULL,'b',0.0);
	P_IN = (double *) nalloc(sizeof(double)*(numBasn+1),"P_IN");
	init_pvar(P_IN,NULL,'b',0.0);
	P_OUT = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OUT");
	init_pvar(P_OUT,NULL,'b',0.0);
	P_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"P_ERR");
	init_pvar(P_ERR,NULL,'b',0.0);
	P_ERR_CUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_ERR_CUM");
	init_pvar(P_ERR_CUM,NULL,'b',0.0);

	P_IN_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_IN_SUM");
	init_pvar(P_IN_SUM,NULL,'b',0.0);
	P_OUT_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OUT_SUM");
	init_pvar(P_OUT_SUM,NULL,'b',0.0);
	P_IN_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_IN_AVG");
	init_pvar(P_IN_AVG,NULL,'b',0.0);
	P_OUT_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OUT_AVG");
	init_pvar(P_OUT_AVG,NULL,'b',0.0);

	TOT_P_CAN = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_P_CAN");
	init_pvar(TOT_P_CAN,NULL,'b',0.0);

	P_IN_STR = (double *) nalloc(sizeof(double)*(numBasn+1),"P_IN_STR");
	init_pvar(P_IN_STR,NULL,'b',0.0);
	P_IN_OVL = (double *) nalloc(sizeof(double)*(numBasn+1),"P_IN_OVL");
	init_pvar(P_IN_OVL,NULL,'b',0.0);
	P_IN_SPG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_IN_SPG");
	init_pvar(P_IN_SPG,NULL,'b',0.0);
	P_IN_GW = (double *) nalloc(sizeof(double)*(numBasn+1),"P_IN_GW");
	init_pvar(P_IN_GW,NULL,'b',0.0);

	P_OUT_STR = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OUT_STR");
	init_pvar(P_OUT_STR,NULL,'b',0.0);
	P_OUT_OVL = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OUT_OVL");
	init_pvar(P_OUT_OVL,NULL,'b',0.0);
	P_OUT_SPG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OUT_SPG");
	init_pvar(P_OUT_SPG,NULL,'b',0.0);
	P_OUT_GW = (double *) nalloc(sizeof(double)*(numBasn+1),"P_OUT_GW");
	init_pvar(P_OUT_GW,NULL,'b',0.0);

/* phosph mass bal vars for live fraction */
	P_LIVE_CELL = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_CELL");
	init_pvar(P_LIVE_CELL,NULL,'b',0.0);
	P_MAC = (double *) nalloc(sizeof(double)*(numBasn+1),"P_MAC");
	init_pvar(P_MAC,NULL,'b',0.0);
	P_Calg = (double *) nalloc(sizeof(double)*(numBasn+1),"P_Calg");
	init_pvar(P_Calg,NULL,'b',0.0);
	P_NCalg = (double *) nalloc(sizeof(double)*(numBasn+1),"P_NCalg");
	init_pvar(P_NCalg,NULL,'b',0.0);
	Calg_GPP = (double *) nalloc(sizeof(double)*(numBasn+1),"Calg_GPP");
	init_pvar(Calg_GPP,NULL,'b',0.0);
	NCalg_GPP = (double *) nalloc(sizeof(double)*(numBasn+1),"NCalg_GPP");
	init_pvar(NCalg_GPP,NULL,'b',0.0);
	Calg_mort = (double *) nalloc(sizeof(double)*(numBasn+1),"Calg_mort");
	init_pvar(Calg_mort,NULL,'b',0.0);
	NCalg_mort = (double *) nalloc(sizeof(double)*(numBasn+1),"NCalg_mort");
	init_pvar(NCalg_mort,NULL,'b',0.0);

	mac_NPP = (double *) nalloc(sizeof(double)*(numBasn+1),"mac_NPP");
	init_pvar(mac_NPP,NULL,'b',0.0);
	mac_mort = (double *) nalloc(sizeof(double)*(numBasn+1),"mac_mort");
	init_pvar(mac_mort,NULL,'b',0.0);

	P_LIVE = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE");
	init_pvar(P_LIVE,NULL,'b',0.0);

	P_LIVE_OLD = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_OLD");
	init_pvar(P_LIVE_OLD,NULL,'b',0.0);
	P_LIVE_IN = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_IN");
	init_pvar(P_LIVE_IN,NULL,'b',0.0);
	P_LIVE_OUT = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_OUT");
	init_pvar(P_LIVE_OUT,NULL,'b',0.0);
	P_LIVE_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_ERR");
	init_pvar(P_LIVE_ERR,NULL,'b',0.0);
	P_LIVE_ERR_CUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_ERR_CUM");
	init_pvar(P_LIVE_ERR_CUM,NULL,'b',0.0);

	P_LIVE_IN_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_IN_SUM");
	init_pvar(P_LIVE_IN_SUM,NULL,'b',0.0);
	P_LIVE_OUT_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_OUT_SUM");
	init_pvar(P_LIVE_OUT_SUM,NULL,'b',0.0);
	P_LIVE_IN_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_IN_AVG");
	init_pvar(P_LIVE_IN_AVG,NULL,'b',0.0);
	P_LIVE_OUT_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_LIVE_OUT_AVG");
	init_pvar(P_LIVE_OUT_AVG,NULL,'b',0.0);

/* phosph mass bal vars for dead fraction */
	P_DEAD_CELL = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_CELL");
	init_pvar(P_DEAD_CELL,NULL,'b',0.0);
	dop_macIn = (double *) nalloc(sizeof(double)*(numBasn+1),"dop_macIn");
	init_pvar(dop_macIn,NULL,'b',0.0);
	dop_stdIn = (double *) nalloc(sizeof(double)*(numBasn+1),"dop_stdIn");
	init_pvar(dop_stdIn,NULL,'b',0.0);
	dop_sorbIn = (double *) nalloc(sizeof(double)*(numBasn+1),"dop_sorbIn");
	init_pvar(dop_sorbIn,NULL,'b',0.0);
	dop_decomp = (double *) nalloc(sizeof(double)*(numBasn+1),"dop_decomp");
	init_pvar(dop_decomp,NULL,'b',0.0);
	dop_desorb = (double *) nalloc(sizeof(double)*(numBasn+1),"dop_desorb");
	init_pvar(dop_desorb,NULL,'b',0.0);
	floc_decomp = (double *) nalloc(sizeof(double)*(numBasn+1),"floc_decomp");
	init_pvar(floc_decomp,NULL,'b',0.0);
	floc_In = (double *) nalloc(sizeof(double)*(numBasn+1),"floc_In");
	init_pvar(floc_In,NULL,'b',0.0);
	stdet_in = (double *) nalloc(sizeof(double)*(numBasn+1),"stdet_in");
	init_pvar(stdet_in,NULL,'b',0.0);
	stdet_out = (double *) nalloc(sizeof(double)*(numBasn+1),"stdet_out");
	init_pvar(stdet_out,NULL,'b',0.0);

	P_DEAD = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD");
	init_pvar(P_DEAD,NULL,'b',0.0);

	P_DEAD_OLD = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_OLD");
	init_pvar(P_DEAD_OLD,NULL,'b',0.0);
	P_DEAD_IN = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_IN");
	init_pvar(P_DEAD_IN,NULL,'b',0.0);
	P_DEAD_OUT = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_OUT");
	init_pvar(P_DEAD_OUT,NULL,'b',0.0);
	P_DEAD_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_ERR");
	init_pvar(P_DEAD_ERR,NULL,'b',0.0);
	P_DEAD_ERR_CUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_ERR_CUM");
	init_pvar(P_DEAD_ERR_CUM,NULL,'b',0.0);

	P_DEAD_IN_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_IN_SUM");
	init_pvar(P_DEAD_IN_SUM,NULL,'b',0.0);
	P_DEAD_OUT_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_OUT_SUM");
	init_pvar(P_DEAD_OUT_SUM,NULL,'b',0.0);
	P_DEAD_IN_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_IN_AVG");
	init_pvar(P_DEAD_IN_AVG,NULL,'b',0.0);
	P_DEAD_OUT_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_DEAD_OUT_AVG");
	init_pvar(P_DEAD_OUT_AVG,NULL,'b',0.0);

/* phosph mass bal vars for water-borne fraction */
	P_WAT_CELL = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_CELL");
	init_pvar(P_WAT_CELL,NULL,'b',0.0);
	wat_sfMiner = (double *) nalloc(sizeof(double)*(numBasn+1),"wat_sfMiner");
	init_pvar(wat_sfMiner,NULL,'b',0.0);
	wat_sedMiner = (double *) nalloc(sizeof(double)*(numBasn+1),"wat_sedMiner");
	init_pvar(wat_sedMiner,NULL,'b',0.0);
	wat_sfUpt = (double *) nalloc(sizeof(double)*(numBasn+1),"wat_sfUpt");
	init_pvar(wat_sfUpt,NULL,'b',0.0);
	P_settl = (double *) nalloc(sizeof(double)*(numBasn+1),"P_settl");
	init_pvar(P_settl,NULL,'b',0.0);
	wat_sedUpt = (double *) nalloc(sizeof(double)*(numBasn+1),"wat_sedUpt");
	init_pvar(wat_sedUpt,NULL,'b',0.0);

	P_WAT = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT");
	init_pvar(P_WAT,NULL,'b',0.0);

	P_WAT_OLD = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_OLD");
	init_pvar(P_WAT_OLD,NULL,'b',0.0);
	P_WAT_IN = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_IN");
	init_pvar(P_WAT_IN,NULL,'b',0.0);
	P_WAT_OUT = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_OUT");
	init_pvar(P_WAT_OUT,NULL,'b',0.0);
	P_WAT_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_ERR");
	init_pvar(P_WAT_ERR,NULL,'b',0.0);
	P_WAT_ERR_CUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_ERR_CUM");
	init_pvar(P_WAT_ERR_CUM,NULL,'b',0.0);

	P_WAT_IN_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_IN_SUM");
	init_pvar(P_WAT_IN_SUM,NULL,'b',0.0);
	P_WAT_OUT_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_OUT_SUM");
	init_pvar(P_WAT_OUT_SUM,NULL,'b',0.0);
	P_WAT_IN_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_IN_AVG");
	init_pvar(P_WAT_IN_AVG,NULL,'b',0.0);
	P_WAT_OUT_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"P_WAT_OUT_AVG");
	init_pvar(P_WAT_OUT_AVG,NULL,'b',0.0);

/* salt mass bal vars */
	TOT_S_CELL = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_S_CELL");
	init_pvar(TOT_S_CELL,NULL,'b',0.0);

	TOT_S = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_S");
	init_pvar(TOT_S,NULL,'b',0.0);
	TOT_S_OLD = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_S_OLD");
	init_pvar(TOT_S_OLD,NULL,'b',0.0);
	S_IN = (double *) nalloc(sizeof(double)*(numBasn+1),"S_IN");
	init_pvar(S_IN,NULL,'b',0.0);
	S_OUT = (double *) nalloc(sizeof(double)*(numBasn+1),"S_OUT");
	init_pvar(S_OUT,NULL,'b',0.0);
	TOT_S_ERR = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_S_ERR");
	init_pvar(TOT_S_ERR,NULL,'b',0.0);
	S_ERR_CUM = (double *) nalloc(sizeof(double)*(numBasn+1),"S_ERR_CUM");
	init_pvar(S_ERR_CUM,NULL,'b',0.0);

	S_IN_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"S_IN_SUM");
	init_pvar(S_IN_SUM,NULL,'b',0.0);
	S_OUT_SUM = (double *) nalloc(sizeof(double)*(numBasn+1),"S_OUT_SUM");
	init_pvar(S_OUT_SUM,NULL,'b',0.0);
	S_IN_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"S_IN_AVG");
	init_pvar(S_IN_AVG,NULL,'b',0.0);
	S_OUT_AVG = (double *) nalloc(sizeof(double)*(numBasn+1),"S_OUT_AVG");
	init_pvar(S_OUT_AVG,NULL,'b',0.0);

	TOT_S_CAN = (double *) nalloc(sizeof(double)*(numBasn+1),"TOT_S_CAN");
	init_pvar(TOT_S_CAN,NULL,'b',0.0);

	S_IN_STR = (double *) nalloc(sizeof(double)*(numBasn+1),"S_IN_STR");
	init_pvar(S_IN_STR,NULL,'b',0.0);
	S_IN_OVL = (double *) nalloc(sizeof(double)*(numBasn+1),"S_IN_OVL");
	init_pvar(S_IN_OVL,NULL,'b',0.0);
	S_IN_SPG = (double *) nalloc(sizeof(double)*(numBasn+1),"S_IN_SPG");
	init_pvar(S_IN_SPG,NULL,'b',0.0);
	S_IN_GW = (double *) nalloc(sizeof(double)*(numBasn+1),"S_IN_GW");
	init_pvar(S_IN_GW,NULL,'b',0.0);

	S_OUT_STR = (double *) nalloc(sizeof(double)*(numBasn+1),"S_OUT_STR");
	init_pvar(S_OUT_STR,NULL,'b',0.0);
	S_OUT_OVL = (double *) nalloc(sizeof(double)*(numBasn+1),"S_OUT_OVL");
	init_pvar(S_OUT_OVL,NULL,'b',0.0);
	S_OUT_SPG = (double *) nalloc(sizeof(double)*(numBasn+1),"S_OUT_SPG");
	init_pvar(S_OUT_SPG,NULL,'b',0.0);
	S_OUT_GW = (double *) nalloc(sizeof(double)*(numBasn+1),"S_OUT_GW");
	init_pvar(S_OUT_GW,NULL,'b',0.0);

/* map arrays with summary stats */
	HydPerAnn = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"HydPerAnn");
	init_pvar(HydPerAnn,NULL,'f',0.0);
	SfWatAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"SfWatAvg");
	init_pvar(SfWatAvg,NULL,'f',0.0);
	TotHeadAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TotHeadAvg");
	init_pvar(TotHeadAvg,NULL,'f',0.0);
	UnsatZavg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"UnsatZavg");
	init_pvar(UnsatZavg,NULL,'f',0.0);

	RainAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"RainAvg");
	init_pvar(RainAvg,NULL,'f',0.0);
	ETAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"ETAvg"); 
	init_pvar(ETAvg,NULL,'f',0.0);
	EvapAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"EvapAvg");
	init_pvar(EvapAvg,NULL,'f',0.0);
	TranspAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TranspAvg");
	init_pvar(TranspAvg,NULL,'f',0.0);
	UnsatMoistAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"UnsatMoistAvg");
	init_pvar(UnsatMoistAvg,NULL,'f',0.0);

	TPSfWatAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPSfWatAvg");
	init_pvar(TPSfWatAvg,NULL,'f',0.0);
	TPSfUptAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPSfUptAvg");
	init_pvar(TPSfUptAvg,NULL,'f',0.0);
	TPSfMinAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPSfMinAvg");
	init_pvar(TPSfMinAvg,NULL,'f',0.0);
	TP_settlAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TP_settlAvg");
	init_pvar(TP_settlAvg,NULL,'f',0.0);
	TPSedWatAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPSedWatAvg");
	init_pvar(TPSedWatAvg,NULL,'f',0.0);
	TPSedUptAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPSedUptAvg");
	init_pvar(TPSedUptAvg,NULL,'f',0.0);
	TPSedMinAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPSedMinAvg");
	init_pvar(TPSedMinAvg,NULL,'f',0.0);
	TPSorbAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPSorbAvg");
	init_pvar(TPSorbAvg,NULL,'f',0.0);
	TPtoVOLAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPtoVOLAvg");
	init_pvar(TPtoVOLAvg,NULL,'f',0.0);
	TPtoSOILAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"TPtoSOILAvg");
	init_pvar(TPtoSOILAvg,NULL,'f',0.0);

	SaltSfAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"SaltSfAvg");
	init_pvar(SaltSfAvg,NULL,'f',0.0);
	SaltSedAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"SaltSedAvg");
	init_pvar(SaltSedAvg,NULL,'f',0.0);

	Floc_fr_phBioAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Floc_fr_phBioAvg");
	init_pvar(Floc_fr_phBioAvg,NULL,'f',0.0);
	DOM_fr_stdetAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"DOM_fr_stdetAvg");
	init_pvar(DOM_fr_stdetAvg,NULL,'f',0.0);

	NC_PeriAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"NC_PeriAvg");
	init_pvar(NC_PeriAvg,NULL,'f',0.0);
	NC_Peri_nppAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"NC_Peri_nppAvg");
	init_pvar(NC_Peri_nppAvg,NULL,'f',0.0);
	NC_Peri_mortAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"NC_Peri_mortAvg");
	init_pvar(NC_Peri_mortAvg,NULL,'f',0.0);
	NC_PeriRespAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"NC_PeriRespAvg");
	init_pvar(NC_PeriRespAvg,NULL,'f',0.0);
	NC_PeriNutCFAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"NC_PeriNutCFAvg");
	init_pvar(NC_PeriNutCFAvg,NULL,'f',0.0);
	NC_Peri_PCAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"NC_Peri_PCAvg");
	init_pvar(NC_Peri_PCAvg,NULL,'f',0.0);
	C_PeriAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"C_PeriAvg");
	init_pvar(C_PeriAvg,NULL,'f',0.0);
	C_Peri_nppAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"C_Peri_nppAvg");
	init_pvar(C_Peri_nppAvg,NULL,'f',0.0);
	C_Peri_mortAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"C_Peri_mortAvg");
	init_pvar(C_Peri_mortAvg,NULL,'f',0.0);
	C_PeriRespAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"C_PeriRespAvg");
	init_pvar(C_PeriRespAvg,NULL,'f',0.0);
	C_PeriNutCFAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"C_PeriNutCFAvg");
	init_pvar(C_PeriNutCFAvg,NULL,'f',0.0);
	C_Peri_PCAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"C_Peri_PCAvg");
	init_pvar(C_Peri_PCAvg,NULL,'f',0.0);
	PeriAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"PeriAvg");
	init_pvar(PeriAvg,NULL,'f',0.0);
	PeriLiteCFAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"PeriLiteCFAvg");
	init_pvar(PeriLiteCFAvg,NULL,'f',0.0);

	Mac_nphBioAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Mac_nphBioAvg");
	init_pvar(Mac_nphBioAvg,NULL,'f',0.0);
	Mac_phBioAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Mac_phBioAvg");
	init_pvar(Mac_phBioAvg,NULL,'f',0.0);
	Mac_totBioAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Mac_totBioAvg");
	init_pvar(Mac_totBioAvg,NULL,'f',0.0);
	Mac_nppAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Mac_nppAvg");
	init_pvar(Mac_nppAvg,NULL,'f',0.0);
	Mac_nphMortAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Mac_nphMortAvg");
	init_pvar(Mac_nphMortAvg,NULL,'f',0.0);
	Mac_phMortAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Mac_phMortAvg");
	init_pvar(Mac_phMortAvg,NULL,'f',0.0);
	LAI_effAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"LAI_effAvg");
	init_pvar(LAI_effAvg,NULL,'f',0.0);
	Manning_nAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Manning_nAvg");
	init_pvar(Manning_nAvg,NULL,'f',0.0);
	MacNutCfAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"MacNutCfAvg");
	init_pvar(MacNutCfAvg,NULL,'f',0.0);
	MacWatCfAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"MacWatCfAvg");
	init_pvar(MacWatCfAvg,NULL,'f',0.0);
	mac_nph_PCAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"mac_nph_PCAvg");
	init_pvar(mac_nph_PCAvg,NULL,'f',0.0);
	mac_ph_PCAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"mac_ph_PCAvg");
	init_pvar(mac_ph_PCAvg,NULL,'f',0.0);

	Std_detrAvg = (float *) nalloc(sizeof(float)*(s0+2)*(s1+2),"Std_detrAvg");
	init_pvar(Std_detrAvg,NULL,'f',0.0);

} /* end of budget variables memory alloc */

/********************************/
