/*
SCCS ID: "@(#)grid_io.h	1.8 04/14/95 SFWMD Research and Planning Departments"

Copyright, 1995, South Florida Water Management District

DISCLAIMER:

ANY INFORMATION, INCLUDING BUT NOT LIMITED TO SOFTWARE AND DATA,
RECEIVED FROM THE SOUTH FLORIDA WATER MANAGEMENT DISTRICT ("DISTRICT")
IN FULFILLMENT OF A PUBLIC RECORDS REQUEST IS PROVIDED "AS IS" WITHOUT
WARRANTY OF ANY KIND, AND THE DISTRICT EXPRESSLY DISCLAIMS ALL EXPRESS
AND IMPLIED WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
THE DISTRICT DOES NOT WARRANT, GUARANTEE, OR MAKE ANY REPRESENTATIONS
REGARDING THE USE, OR THE RESULTS OF THE USE, OF THE INFORMATION
PROVIDED TO YOU BY THE DISTRICT IN TERMS OF CORRECTNESS, ACCURACY,
RELIABILITY, TIMELINESS OR OTHERWISE.  THE ENTIRE RISK AS TO THE
RESULTS AND PERFORMANCE OF ANY INFORMATION OBTAINED FROM THE DISTRICT
IS ENTIRELY ASSUMED BY THE RECIPIENT.

*/

/* -------------------------------------------------------------
   header grid_io.h
   This header contains definitions for SFWMM data grid and 
   io routines
   ------------------------------------------------------------- */


/* grid definition record - contains all information necessary to
   define the areal grid */

#define MAX_GRID_ROWS	80

#define GRID_TITLE_LENGTH 80
#define GRID_TAG_LENGTH 80

typedef struct {
	char title[GRID_TITLE_LENGTH];
	int number_of_rows;
	int number_of_nodes;
	struct { float x, y; } size;
} GR_HEADER;

typedef struct {
	int *xstart, *xend;
	int *cum_node_count;
} GR_CONFIG;

typedef struct {
	GR_HEADER header;
	GR_CONFIG config;
} GRID;

/* available routines */

int grid_write_header(), grid_read_header(), grid_write(), grid_read();
int grid_find_tag(), grid_skip(), grid_tag_search();
int grid_top();
int grid_bottom();

/* end of header */

