/* the module that generates the link list to elm grid */
/* version that is linked to ELM */
#include "link_elm_wmm.h"
#include "../Driver_Sources/globals.h" 

int link_wmm_elm_wmm(float *linklist[], int wmmnc[], float elm[], float wmm[], int* wmm_mask)


{
    int     i,j,i1,j1,k,k1,cond,ecly,ecuy,eclx,ecux,ch;
    int	linklistr[wrow+1][wcol][nmax];
    int     linklistc[wrow+1][wcol][nmax];
    int	nc[wrow+1][wcol],ELM_MASK[erow][ecol];
    float   eduy,edly,edux,edlx;
    float   wuy,wly,wux,wlx,euy,ely,eux,elx;
    float	a11,a12,a21,a22,fch;
    int cellLoc;
    FILE    *fw,*fr; 

 /*   char testFile;  temporary to print out WMM -> ELM bound conds */
 /*   FILE *OutFile;  temporary to print out WMM -> ELM bound conds */

    int kmaxx;
    
    for(i = 0; i < wrow+1; i++)
    {
        for(j = 0; j < wcol; j++)
        {
            nc[i][j]  = 0;
            *(wmm_mask + ( i * wcol + j)) = 0;
            
        }
    }

    for(i = 0; i < erow; i++)
    {
        for(j = 0; j < ecol; j++)
        {
            ELM_MASK[i][j] = 0;
        }
    }


            if(H_OPSYS==UNIX) 
   		sprintf( mapFileName, "%s/%s/Data/ELM_MASK", ModelPath, ProjName );
            else sprintf( mapFileName, "%s%s:Data:ELM_MASK", ModelPath, ProjName );

            if ( ( fr = fopen( mapFileName, "r" ) ) ==  NULL )
            {
                printf( "Can't open ELM_MASK file!\n" ) ;
                exit(-1) ;
            }

    for(i = 0; i < erow; i++)
    {
        for(j = 0; j < ecol; j++)
        {
            fscanf(fr, "%d",&ELM_MASK[i][j]);
        }
    }
    
    fclose(fr);




/*   w	water management model */
/*   e	elm model */
/*   wu	wmm unit length 3218.6 meters */
/*   eu	elm unit length 1000.0 meters */
/*   l	elx lower left   side of grid */
/*   u	eux upper right  side of grid */

    for( i = 0; i < wrow+1; i++)
    {
        wly = i * wu + w0y;
        wuy = wly + wu;

        if( wly+eu >= e0y && wuy-eu <= e1y)
        {       /*  if wmm grid intersects elm grid in y direction */

            for( j = 0; j < wcol; j++)
            {
                wlx = j * wu + w0x;
                wux = wlx + wu;

                if(wux+eu >= e0x && wlx-eu <= e1x)
                {       /* if wmm grid intersects elm grid in x direction */
                    edly = e1y - wuy;	/* cal low cell num y dir for elm	*/
                    eduy = e1y - wly;
                    edux = wux - e0x;
                    edlx = wlx - e0x;

                    eclx = edlx/eu;		/* elm cell number col	*/
                    ecux = edux/eu;

                    ecly = edly/eu;		/* elm cell number row	*/
                    ecuy = eduy/eu;

                    for( i1 = ecly; i1 <= ecuy; i1++)
                    {
                        euy = e1y - i1 * eu;
                        ely = euy - eu; 

                        for( j1 = eclx; j1 <= ecux; j1++)
                        {
                            if(ELM_MASK[i1][j1] == 1)
                            {
                                cond = 0;
                                elx = e0x + j1 * eu;
                                eux = elx +  eu;

/*	cond 1 elm grid completely inside wmm grid	*/

                                if(elx > wlx && eux < wux && ely > wly && euy < wuy)
                                    cond = 1;

/*	cond 6 elm grid cut by  wlx	*/

                                if(elx < wlx && eux > wlx && ely > wly && euy < wuy)
                                    cond = 6;

/*	cond 7 elm grid cut by wux	*/
	
                                if(elx < wux &&  eux > wux  && ely > wly && euy < wuy)
                                    cond = 7;

/*	cond 8 elm grid cut by wly 	*/

                                if(ely < wly &&  euy > wly  && elx > wlx && eux < wux)
                                    cond = 8;

/*	cond 9 elm grid cut by wux and wuy	*/

                                if(ely < wuy &&  euy > wuy   && elx > wlx && eux < wux)
                                    cond = 9;


/*	cond 2 elm grid cut by wlx & wly	*/

                                if(elx < wlx && eux > wlx && ely < wly && euy > wly)
                                    cond = 2;

/*	cond 3  elm grid cut by wux wly	*/

                                if(elx < wux && eux > wux &&  ely < wly && euy > wly)
                                    cond = 3;

/*	cond 4 elm grid cut by wlx & wuy 	*/

                                if(ely < wuy && euy > wuy && elx < wlx && eux > wlx)
                                    cond = 4;

/*	cond 5 elm grid cut by wux and wuy	*/

                                if(elx < wux && eux > wux && ely < wuy && euy > wuy)
                                    cond = 5;
                                switch(cond)
                                {
                                    case 1:
                                        linklistr[i][j][nc[i][j]] = i1;
                                        linklistc[i][j][nc[i][j]] = j1;
                                        nc[i][j] = nc[i][j] + 1;
                                        break;

                                    case 2:	/*      cond 2 elm grid cut by wlx  & wyl     */

                                            /*	area of elm grid inside wmm grid larger	*/

                                        a11 = (wlx-elx)*(euy-wly);
                                        a12 = (eux-wlx)*(euy-wly);
                                        a21 = (wlx-elx)*(wly-ely);
                                        a22 = (eux-wlx)*(wly-ely);


                                        if(a12 > a11 && a12 > a21 && a12 > a22)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;
		
                                    case 3:  /*      cond 3  elm grid cut by wux  & wly   */

                                        a11 = (wux-elx)*(euy-wly);
                                        a12 = (eux-wux)*(euy-wly);
                                        a21 = (wux-elx)*(wly-ely);
                                        a22 = (eux-wux)*(wly-ely);

                                        if(a11 > a12 && a11 > a21 && a11 > a22)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;

                                    case 4:  /*      cond 4 elm grid cut by wlx & wuy     */

                                        a11 = (wlx-elx)*(euy-wuy);
                                        a12 = (eux-wlx)*(euy-wuy);
                                        a21 = (wlx-elx)*(wuy-ely);
                                        a22 = (eux-wlx)*(wuy-ely);


                                        if(a22 > a11 && a22 > a12 && a22 > a21)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;

                                    case 5:    /*	cond 5 elm grid cut by wux and wuy	*/

                                        a11 = (wux-elx)*(euy-wuy);
                                        a12 = (eux-wux)*(euy-wuy);
                                        a21 = (wux-elx)*(wuy-ely);
                                        a22 = (eux-wux)*(wuy-ely);

                                        if(a21 > a11 && a21 > a12 && a21 > a22)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;

                                    case 6: /*      cond 6 elm grid cut by wlx  */

                                        a11 = (wlx-elx);
                                        a22 = (eux-wlx);

                                        if(a22 > a11)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;

                                    case 7: /*      cond 7 elm grid cut by wux      */

                                        a11 = (wux-elx);
                                        a22 = (eux-wux);

                                        if(a11 > a22)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;

                                    case 8: /*      cond 8 elm grid cut by wly    */

                                        a11 = (wly-ely);
                                        a22 = (euy-wly);

                                        if(a22 > a11)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;

                                    case 9:	/*      cond 9 elm grid cut by  wuy      */

                                        a11 = (wuy-ely);
                                        a22 = (euy-wuy);

                                        if(a11 > a22)
                                        {
                                            linklistr[i][j][nc[i][j]] = i1;
                                            linklistc[i][j][nc[i][j]] = j1;
                                            nc[i][j] = nc[i][j] + 1;
                                            break;
                                        }
                                        break;

                                    default:
                                        a11 = 0.0;
                                        a12 = 0.0;
                                        a21 = 0.0;
                                        a22 = 0.0;

                                }	/* end switch statement		*/
                                
                            }	/* enf if loop inside j1	*/

                            
                        }	/* end j1 loop			*/
                    }	/* end i1 loop			*/


                }	/* end if loop			*/

                
            }       /* end j loop                   */
	} 	/* end if loop			*/
    }	/* end i loop			*/



/* temporary to print out WMM -> ELM bound conds
                    if ( ( OutFile = fopen( "/vol/hy_ext/SME/Projects/ELM/testFile", "w" ) ) ==  NULL )
                {
                    printf( "I can't open the output file '%s'!\n ", testFile ) ;
                    exit(-1) ;  
                }
 temporary to print out WMM -> ELM bound conds */


    for(i = 0; i < wrow+1; i++)
    {
        for(j = 0; j < wcol; j++)
        {
            for(k = 0; k < nc[i][j]; k++)
            {
                i1 = linklistr[i][j][k];
                j1 = linklistc[i][j][k];


                if(ELM_MASK[i1][j1] == 1)
                {
                    *(wmm_mask + ( i * wcol + j)) = 1;
                        /* boundcond test 
                    BCelm_cell[T(i1+1,j1+1)]->src_row = i;
                    BCelm_cell[T(i1+1,j1+1)]->src_col = j;
                        boundcond test */
                    
          /*    fprintf(OutFile, "%d, %d\n", i,j); temporary to print out WMM -> ELM bound conds */
                    
                }

            }
	}
    }

/*    fclose(OutFile); temporary to print out WMM -> ELM bound conds */

    k1 = 0;
    for(i = 0; i < wrow+1; i++)
    {
        for(j = 0; j < wcol; j++)
        {

            if( *(wmm_mask + ( i * wcol + j)) == 1)
            {

                *(linklist + (k1 *  nmax ))      
                    =       (wmm + ( i * wcol + j));
                *(wmmnc + k1) = nc[i][j];

                for(k = 1; k <= nc[i][j]; k++)
                {
                    i1 = linklistr[i][j][k-1];
                    j1 = linklistc[i][j][k-1];

                    if(ELM_MASK[i1][j1] == 1)
                    {
                        *(linklist + (k1 *  nmax +  k))
                            = 	(elm + ( i1 * ecol + j1));
                    }
                }
                k1 = k1 + 1; /* also can be used to find wmm_nc, the number of wmm cells that contain elm cells */
                if (k>kmaxx) kmaxx=k; /* to find nmax ? */
                
            }
        }
        
    }

    return 1;

}
/**********/
