/* the module that reads sfwmm rain data into memory and calls the code for generating */
/* the link list to elm grid  */
/* version that is linked to ELM */

/* Note: when changing ELM maps, you need to provide a text
   version of the ELM mask (ON_MAP equiv), and you must determine the value of
   wmm_nc and nmax and #define them in the .h file.  This will
   be made generic/automated when time is available */

#include <varargs.h> 
#include "grid_io.h"
#include "link_elm_wmm.h"
#include "../Driver_Sources/globals.h"

GRID grid; /* defined in grid_io.h */
char tag[GRID_TAG_LENGTH]; 
FILE *rainWMM_file;

float e0x,e1x,e0y,e1y,eu;
/* int erow,ecol;    */

float (*wmm_day)[step_size][wrow][wcol];  /* array of multiple days wmm data */
float (*wmm)[wrow+1][wcol];             /* current-day wmm data */

float *values;/*  the SFWMM/NSM rain data in decimal feet */
float *rainELM; /* remapped to the finer resolution, but a slightly diff array size than that passed to ELM */
/* a slightly smaller rainfall array is used here than the rainSME which is passed to the ELM */

int recRead=0,day=0,rain_step;
int initRain = 0, init_skip=0;
char sdate[GRID_TAG_LENGTH];

    static int nc[wmm_nc];
    static int wmmi[wmm_nc],wmmj[wmm_nc];
    static float *linklist[wmm_nc][nmax];

float rain_data_wmm(float *rainSME) /* returns tenths mm rainfall at ELM-SME grid scale */
{


    static int wmm_mask[wrow+1][wcol];
    static int wmmpatch[28][3];

    int	fun,cond;
    int i,j,k,k1,ch,lo,hi;
    int comp,jstart,jend;

    int	strlength; 
    char month[12],yr[5],mo[3],da[3], dig1[2], dig2[2], day_str[5] = "";


    cond = 0; 
/* determine where to go: case 1 is only visited at the initial time */
        /*case 2 reads a new (multi-day/year) set of rainfall arrays (@ wmm resolution) to store in memory */
        /*case 3 generates the daily rainfall maps at the elm grid scale */
    
    if ( TIME == 0 && initRain == 0 ) /* generate the link list at the beginning of sim */
    {
        cond = 1;
        initRain=1; /* flag indicating that the link list has been made */
    }

    else if( day >= recRead ) /* check the number of days simulated vs the number of records (arrays) read so far */
    {
	cond = 2; /* put the arrays into memory, converting to tenths of mm */
    }

    else if( day < recRead ) /* if we already have read enough records (arrays) in memory, remap the data for the day */
	cond = 3; 


/* begin the switch depending on case */
    switch (cond)
    {
	case 1:
/******* make the linked list, advance the rain data file to the starting date */

            if (ELMrun) { /* modelName == ELM */
                e0x = 472711.0;	/* west elm UTM coord  */
                e1x = 580711.0;
                e0y = 2769489.0;       /* south elm UTM coord  */
                e1y = 2953489.0;
                eu = 1000.0;          /* elm grid size (m) */
/*                 erow = 184;  */
/*                 ecol = 108;  */
            }
            else if (CALMrun) {
                e0x = 542711.0;	/* west elm UTM coord  */
                e1x = 575711.0;
                e0y = 2894489.0;       /* south elm UTM coord  */
                e1y = 2928489.0;
                eu = 500.0;          /* elm grid size (m) */
/*                 erow = 68;  */
/*                 ecol = 66;  */
            }
                
            
 
                
            usrErr0("Looking for first rainfall array:"); 


/* the ELM array in this code is slightly smaller than that of the SME code */
                /* the elm variable is allocated (diff from the rainSME passed in */
            rainELM = (float *) nalloc( sizeof(float) * (erow*ecol), "rainELM" ); /* current-day elm grid, not same as rainSME */
            wmm =   nalloc( sizeof(float) * ((wrow+1)*(wcol+1)), "wmm" ); /* current-day wmm data */
            wmm_day =   nalloc( sizeof(float) * (step_size*wrow*wcol), "wmm_day" ); /* array of multiple days wmm data */

            fun = link_wmm_elm_wmm(linklist[0],&nc[0],rainELM,&wmm[0][0],&wmm_mask[0][0]);

                                             
/*            if(H_OPSYS==UNIX) 
   		sprintf( mapFileName, "%s/%s/Data/WMM_MASK", ModelPath, ProjName );
            else sprintf( mapFileName, "%s%s:Data:WMM_MASK", ModelPath, ProjName );

            if ( ( rainWMM_file = fopen( mapFileName, "r" ) ) ==  NULL )
            {
                printf( "Can't open WMM_MASK file!\n" ) ;
                exit(-1) ;
            }
            for(i = 0; i < wrow+1; i++)         
            {                                  
                for(j = 0; j < wcol; j++)         
                {                                
                    fscanf(rainWMM_file, "%d",&wmm_mask[i][j]);  
                }                                 
            }                                
            fclose(rainWMM_file); */


/* this patch file extends the SFWMM/NSM rain data west into the mangrove region */
            if (ELMrun ) {
                if(H_OPSYS==UNIX) 
                    sprintf( mapFileName, "%s/%s/Data/wmmpatch.dat", ModelPath, ProjName );
                else sprintf( mapFileName, "%s%s:Data:wmmpatch.dat", ModelPath, ProjName );

                if ( ( rainWMM_file = fopen( mapFileName, "r" ) ) ==  NULL )
                {
                    printf( "Can't open wmmpatch.dat file!\n" ) ;
                    exit(-1) ;
                }

                for(i = 0; i < 28; i++)
                {
                    fscanf(rainWMM_file,"%d  %d  %d",&wmmpatch[i][0],&wmmpatch[i][1],&wmmpatch[i][2]);
                }
                fclose(rainWMM_file);
            }
            

/* this is the SFWMM v3.5 (not 5.0) version of rain */
            if  ( (rainWMM_file = fopen("/vol/hy_ext/SME/Projects/ELM/Data/rain65_95.dat", "rb")) == NULL) {
                printf( "I can't open the /vol/hy_ext/SME/Projects/ELM/Data/rain65_95.dat file!\n " ) ;
                exit(-1) ;  
            }

            k = 0;
            for(i = 0; i < wrow+1; i++)
            {
                for(j = 0; j < wcol; j++)
                {
                    (*wmm)[i][j] = 0.0;
                    if(wmm_mask[i][j] == 1)    
                    { 
                        wmmi[k] = i;
                        wmmj[k] = j;
                        k = k + 1;
                    }
                }
            }

            if (grid_read_header(rainWMM_file, &grid) != 0) {
                fprintf(stderr, "Unable to read grid header from input file %s\n",rainWMM_file);
                exit (-1);
            }
            values = nalloc(grid.header.number_of_nodes*sizeof(float),"values");

            sscanf(initDateRead, "%4s/%2s/%2s",yr,mo,da); /* initDateRead fmt= 1999/01/01 */
            if (atoi(mo) == 1) strcpy(month,"January ");
            else if (atoi(mo) == 2) strcpy(month,"February ");
            else if (atoi(mo) == 3) strcpy(month,"March ");
            else if (atoi(mo) == 4) strcpy(month,"April ");
            else if (atoi(mo) == 5) strcpy(month,"May ");
            else if (atoi(mo) == 6) strcpy(month,"June ");
            else if (atoi(mo) == 7) strcpy(month,"July ");
            else if (atoi(mo) == 8) strcpy(month,"August ");
            else if (atoi(mo) == 9) strcpy(month,"September ");
            else if (atoi(mo) == 10) strcpy(month,"October ");
            else if (atoi(mo) == 11) strcpy(month,"November ");
            else if (atoi(mo) == 12) strcpy(month,"December ");
            else { printf("Couldn't read the initial date of simulation for use in rainfall.\n"); exit(-1);}
            strcat(sdate,month);
            
            sscanf(da, "%1s%1s\n",dig1,dig2);
            if ( strcmp(dig1,"0") != 0 ) 
                strcpy(day_str,dig1); 
            else strcat(day_str," "); /* need a blank space for days<10 */
            
            strcat(day_str,dig2);
            strcat(day_str,", "); /* put comma and space after day */
            
            strcat(sdate,day_str);
            strcat(sdate,yr); /* tag in grid_io file is "January  1, 1965", "March 11, 1965" */
            
            strlength = strlen(sdate); 
            comp = 1;
            while( comp  != 0)
            {
                if (grid_read(rainWMM_file, &grid, tag, values ) == -1 ) {
                    fprintf(stderr, "Couldn't match starting date for rainfall, date = %s from input file %s\n",sdate,rainWMM_file);
                    exit (-1);
                }
                init_skip++; /* number of records skipped to get to starting date */
                comp = strncmp(tag, sdate, strlength);
                
                if(comp == 0){
                    ch = grid_skip(rainWMM_file, &grid, -1);
                }
                
            }
            sprintf(msgStr," Found %s.",tag); usrErr(msgStr);


	case 2:	

                /*  *****************	*/
                /* read the records, put into memory in step_size (defined in link_elm_wmm.h) blocks of records */
                /* recRead increments w/ the number of records read, up to max of the */
                /* total number of days desired to be simulated (numday is global to model) */
            
            usrErr ("Reading the SFWMM rainfall maps...");
            if (TIME > 0) { /* reopen this file and skip to the appropriate record */
                if  ( (rainWMM_file = fopen("/vol/hy_ext/SME/Projects/ELM/Data/rain65_95.dat", "rb")) == NULL) {
                    printf( "I can't open the /vol/hy_ext/SME/Projects/ELM/Data/rain65_95.dat file!\n " ) ;
                    exit(-1) ;  
                }
                if (grid_read_header(rainWMM_file, &grid) != 0) {
                    fprintf(stderr, "Unable to read grid header from input file %s\n",rainWMM_file);
                    exit (-1);
                }
                ch = grid_skip(rainWMM_file, &grid, (init_skip-1+recRead));
            }
           
            rain_step = 0;
            
            while(  recRead < numday && rain_step < (step_size) )
            {                 				
            
                if (grid_read(rainWMM_file, &grid, tag, values ) != 0 ) {
                    fprintf(stderr, "Unable to read grid value from input file %s\n",rainWMM_file);
                    exit (-1);
                }

                k = 0;
                for(i = 0; i < wrow; i++)
                {
                    jstart =  *(grid.config.xstart+i);
                    jend =    *(grid.config.xend+i);
                    for(j = jstart-1; j < jend; j++)
                    {
                        (*wmm)[(i+1)][(j)] = values[k];
                        k = k + 1;
                    }
                }
                

                if (ELMrun) {
                    for(k = 0; k < 24; k++) 
                    {
                        i = wmmpatch[k][0];
                        lo = wmmpatch[k][1];
                        hi = wmmpatch[k][2];
                        for(j = lo; j <= hi; j++)
                            (*wmm)[(i+1)][j] = (*wmm)[(i+1)][hi+1];
                    }

                    for(k = 24; k < 28; k++) 
                    {
                        i = wmmpatch[k][0];
                        lo = wmmpatch[k][1];
                        hi = wmmpatch[k][2];
                        for(j = lo; j <= hi; j++)
                            (*wmm)[(i+1)][j] = (*wmm)[(i+1)][lo-1];
                    }
                }
                

                for(j = 0; j < wcol; j++)
                    (*wmm)[0][j] = (*wmm)[1][j];  

                for(i = 0; i < wrow; i++)
                    for(j = 0; j < wcol; j++)
                        (* wmm_day)[rain_step][i][j] =  ((*wmm)[i][j]) * 254.0; /* convert inches to tenths of mm */

                recRead = recRead + 1; /* increment the total number of records read */
                rain_step = rain_step +1;        /* increment the number of rain_steps taken in reading this batch of records */
                

            }  /*   end while loop	*/
                
            sprintf( msgStr, "Have accumulated a total of %d records of rainfall data.",recRead );
            usrErr(msgStr); WriteMsg( msgStr,True );

            fclose (rainWMM_file); /*  close the wmm rain file after each group of files read */
            
            rain_step = 0; /* set the rain_step to 0, so that the case 3 statements will start at that beginning*/
            
            

	case 3:

/*	*****************	*/
/* do the daily remapping to the elm grid */
            
            for(i = 0; i < wmm_nc; i++)
            {
                for(j = 1; j <= nc[i]; j++)
                {

                    *(linklist[i][j]) = (*wmm_day)[rain_step][wmmi[i]][wmmj[i]];	  
                }

            }


            for (i = 0; i < erow; i++)
                for (j = 0; j < ecol; j++){
                    rainSME[T((i+1),(j+1))] = rainELM[(int)((ecol*i)+j)];   
                        /* the SME array is slightly larger, and the addressing starts at 1, not 0 like here */
                }
            
            rain_step = rain_step + 1; /* increment the rain_step of the number of records in this interval */
            day = day + 1;   /* increment the total days simulated */
            
    }	/*	end switch	*/

}
