/**********************************************************************
$Id: UTP.h,v 1.1.1.1 1999/11/12 15:01:21 cvs Exp $

$Source: /usr/local/cvsroot/sc99/UTP.h,v $

$Log: UTP.h,v $
Revision 1.1.1.1  1999/11/12 15:01:21  cvs
sc99 code of om3


Revision 1.1  1999/05/12 17:33:23  cvs
Cleaned up compiler errors, added UTP header files, created Makefile.

 * Revision 1.1  1995/10/05  20:52:59  schafer
 * Initial revision
 *
Revision 1.2  1994/10/07  03:54:26  kohr
Added UTP_reset_timer() and UTP_get_accum_time().

Revision 1.1  1994/09/14  06:03:12  kohr
Initial revision


Public declarations for the Unnamed Timing Package (UTP).
**********************************************************************/

#ifndef _UTP_h_
#define _UTP_h_

/**********************************************************************
Publicly-accessible functions.
**********************************************************************/

extern void UTP_init(unsigned numTimers);

extern void UTP_set_filename(const char *outFilename);

extern void UTP_start_timer(unsigned timerNumber);

extern void UTP_stop_timer(unsigned timerNumber);

extern void UTP_reset_timer(unsigned timerNumber);

extern void UTP_get_accum_time(unsigned timerNumber, double *time,
			       int *precision);

extern void UTP_shutdown(void);


/**********************************************************************
Publicly-accessible definitions.
**********************************************************************/

#define UTP_DEFAULT_OUT_FILE_NAME "utp_dump.txt"


#endif /* #ifndef _UTP_h_ */

