/**********************************************************************
$Id: UTP_private.h,v 1.1.1.1 1999/11/12 15:01:22 cvs Exp $

$Source: /usr/local/cvsroot/sc99/UTP_private.h,v $

$Log: UTP_private.h,v $
Revision 1.1.1.1  1999/11/12 15:01:22  cvs
sc99 code of om3


Revision 1.1  1999/05/12 17:33:23  cvs
Cleaned up compiler errors, added UTP header files, created Makefile.

 * Revision 1.1  1995/10/05  20:55:16  schafer
 * Initial revision
 *
Revision 1.5  1994/10/10  23:53:56  kohr
Fixed big bug in UTP_set_filename().

Revision 1.4  1994/10/07  19:25:26  kohr
Minor doc. change.

Revision 1.3  1994/10/07  03:55:26  kohr
Use #error, added UTP_timeToDouble().

Revision 1.2  1994/09/15  00:24:13  kohr
Remove trailing comma in enum-value list.

Revision 1.1  1994/09/14  06:03:55  kohr
Initial revision


Private declarations for the Unnamed Timing Package (UTP).
**********************************************************************/

#ifndef _UTP_private_h_
#define _UTP_private_h_

#include "UTP.h"

/**********************************************************************
Machine-dependent definitions.
**********************************************************************/

/*
Supported machine types are as follows:

UNIX : generic Unix; assumes BSD 4.3-compatible gettimeofday(2) and
	"struct timeval" from <sys/time.h>.  I have not yet seen a modern
	Unix worksation which doesn't have this.
*/

/*
Check that at least one supported machine type macro was defined.
*/

#if !defined(UNIX)
#error "No machine type was defined."
#endif


/*
UTP_TimeValue_t is a machine-dependent type representing a time, at the
highest resolution available.
*/

#if defined(UNIX)

#include <sys/time.h>
typedef struct timeval UTP_TimeValue_t;
/*extern int
gettimeofday(struct timeval *tvp, struct timezone *tzp);*/

extern int errno;	/* Actually need these for non-UNIX clocks also...*/
/*extern char *sys_errlist[];*/

#endif /* #if defined(UNIX) */


/**********************************************************************
Machine-independent definitions.
**********************************************************************/

/*
UTP_TimerState represents the current state of a timer.
*/

typedef enum _UTP_TimerState {
	UTP_TIMER_STOPPED,
	UTP_TIMER_RUNNING
} UTP_TimerState;


/*
UTP_Timer_t contains all data associated with a timer.
*/

typedef struct _UTP_Timer_t {
	UTP_TimerState state;
	UTP_TimeValue_t startTime;	/* If running, when did it start? */
					/* Total time accumulated. */
	UTP_TimeValue_t accumulatedTime;
	unsigned long numEvents;	/* Number of timed events
					   accumulated into the timer. */
	int numTimers;
} UTP_Timer_t;


/**********************************************************************
Private but global functions, to be used only internally by the UTP
package.
**********************************************************************/

/*
Read current clock time, in a machine-dependent way; store result in *tv.
*/

extern void
UTP_readTime(UTP_TimeValue_t *tv);

/*
Place elapsed time between *start and *end into *diff (machine-dependent).
It is permissible for start and/or end to be identical to diff.
*/

extern void
UTP_timeDifference(UTP_TimeValue_t *diff, const UTP_TimeValue_t *start,
		   const UTP_TimeValue_t *end);

/*
Accumulate *newElapsed time into *oldElapsed (machine-dependent).
*/

extern void
UTP_timeAdd(UTP_TimeValue_t *oldElapsed,
	    const UTP_TimeValue_t *newElapsed);

/*
Set *tv to time zero (machine-dependent).
*/

extern void
UTP_timeZero(UTP_TimeValue_t *tv);


/*
Convert *tv to its double-precision floating-point representation; store it
in *time, store number of significant digits after the decimal place in
*precision.  Machine-dependent.
*/

extern void
UTP_timeToDouble(double *time, int *precision, const UTP_TimeValue_t *tv);


/*
Convert *tv to its floating-point string representation, with seconds as
the units; store result in timeString.  Machine-dependent.
*/

extern void
UTP_timeToString(char timeString[], const UTP_TimeValue_t *tv);


/*
Emit the warning message messageStr in some appropriate way.  For the "Str"
and "Int" versions, messageStr is expected to be a printf()-format string
containing at most one conversion specification ("%s" and "%d",
respectively).
*/

extern void
UTP_warn(const char *messageStr);
extern void
UTP_warnStr(const char *messageStr, const char *argStr);
extern void
UTP_warnInt(const char *messageStr, int argInt);

#endif /* #ifndef _UTP_private_h_ */

