#include <stdio.h>
#include <math.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

float 
density_crude (float s, float t, int iz)
{
	float den;

/*
 * simple approximate density for salt water.  To be replaced with
 * std polynomical formula when convection details are important.
 */
	den = 0.2 * (s - base_s[iz]) - 0.2 * (t - base_t[iz]);
	return den / 1030.0;
}

/*
 *  density calculation from:
 *  Wright, D.G., 1997: An equation of state
 *  for use in ocean models: Eckart's formula revisited. Journal of
 *  Atmospheric and Oceanic Technology, v14, p735.
 */

/* ignore thermobaric effect, which is negligible in a shallow bay, pressure is set to 0 */

float density(float theta, float salinity, float pressure)
{
	float den;
	float a[3] = {7.057924e-4, 3.480336e-7, -1.112733e-7};
	float b[6] = {5.790749e+8, 3.516535e+6, -4.002714e+4, 2.084372e+2, 5.944068e+5, -9.643486e+3};
	float c[6] = {1.704853e+5, 7.904722e+2, -7.984422, 5.140652e-2, -2.302158e+2, -3.079464};
	float alpha0, pres0, lamda;

	alpha0 = a[0] + a[1] * theta + a[2] * salinity;
	pres0 = b[0] + b[1] * theta + b[2] * theta * theta + b[3] * theta * theta * theta
		+ b[4] * salinity + b[5] * salinity * theta;
	lamda = c[0] + c[1] * theta + c[2] * theta * theta + c[3] * theta * theta * theta
		+ c[4] * salinity + c[5] * salinity * theta;

	den = (pressure + pres0) / (lamda + alpha0 * (pressure + pres0));
	return den / 1030.0;
}
