#include <stdio.h>
#include <math.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

void 
filt4p_wall_d (float **q,float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy;
	float damp; /* work[My][Mx]; */
	
	float **work = memalloc2dfloat ("work",work,My,Mx);

	damp = 0.5 / 32.0;

	/* Fourth order filter on pressure - pass 1 */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			work[iy][ix] = 0.0;

			if InWater(depth[iy][ix])
			{
				if InWater(depth[iy][ix - 1])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy][ix - 1]);
				}

				if InWater(depth[iy][ix + 1])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy][ix + 1]);
				}

				if InWater(depth[iy - 1][ix])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy - 1][ix]);
				}

				if InWater(depth[iy + 1][ix])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy + 1][ix]);
				}
			}
		}
	}

	wrap_q_wall_d (work,cwest,ceast,csouth,cnorth);

	/* Fourth order conservative dissipation on pressure - pass2 */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(depth[iy][ix])
			{
				if InWater(depth[iy][ix - 1])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy][ix - 1]);
				}

				if InWater(depth[iy][ix + 1])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy][ix + 1]);
				}

				if InWater(depth[iy - 1][ix])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy - 1][ix]);
				}

				if InWater(depth[iy + 1][ix])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy + 1][ix]);
				}
			}
		}
	}
	wrap_q_wall_d (q,cwest,ceast,csouth,cnorth);
	free2d((void **)work);
}
void 
filt4m_wall_d (float ***q,float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, iz;
	float damp; /* work[Mz][My][Mx] */
	float ***work = memalloc3dfloat ("work",work,Mz,My,Mx);

	damp = 0.5 / 32.0;

	/* Fourth order filter on momentum - pass 1 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				work[iz][iy][ix] = 0.0;

				if InWater(uvh[iz][iy][ix])
				{
					if InWater(uvh[iz][iy][ix - 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix - 1]);
					}

					if InWater(uvh[iz][iy][ix + 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix + 1]);
					}

					if InWater(uvh[iz][iy - 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy - 1][ix]);
					}

					if InWater(uvh[iz][iy + 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy + 1][ix]);
					}
				}
			}
		}
	}

	wrap_qz_wall_d (work,cwest,ceast,csouth,cnorth);

	/* Fourth order conservative dissipation on momentum - pass2 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(uvh[iz][iy][ix])
				{
					if InWater(uvh[iz][iy][ix - 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix - 1]);
					}

					if InWater(uvh[iz][iy][ix + 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix + 1]);
					}

					if InWater(uvh[iz][iy - 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy - 1][ix]);
					}

					if InWater(uvh[iz][iy + 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy + 1][ix]);
					}
				}
			}
		}
	}
	wrap_qz_wall_d (q,cwest,ceast,csouth,cnorth);
	free3d((void ***)work,Mz);
}

void 
filt4s_wall_d (float ***q,float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, iz;
	float damp; /* work[Mz][My][Mx] */

	float ***work = memalloc3dfloat ("work",work,Mz,My,Mx);

	damp = 0.5 / 32.0;

	/* Fourth order filter on scalars - pass 1 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				work[iz][iy][ix] = 0.0;

				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix - 1]);
					}

					if InWater(h[iz][iy][ix + 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix + 1]);
					}

					if InWater(h[iz][iy - 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy - 1][ix]);
					}

					if InWater(h[iz][iy + 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy + 1][ix]);
					}
				}
			}
		}
	}

	wrap_qz_wall_d (work,cwest,ceast,csouth,cnorth);

	/* Fourth order conservative dissipation on scalars - pass2 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix - 1]);
					}

					if InWater(h[iz][iy][ix + 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix + 1]);
					}

					if InWater(h[iz][iy - 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy - 1][ix]);
					}

					if InWater(h[iz][iy + 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy + 1][ix]);
					}
				}
			}
		}
	}
	wrap_qz_wall_d (q,cwest,ceast,csouth,cnorth);
	free3d((void ***)work,Mz);
}

#ifdef OLD

void 
filt4s (float q[Mz][My][Mx])
{
	int ix, iy, iz;
	float damp, work[Mz][My][Mx];

	damp = 0.5 / 32.0;

	/* Fourth order filter on scalars - pass 1 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				work[iz][iy][ix] = 0.0;

				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix - 1]);
					}

					if InWater(h[iz][iy][ix + 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix + 1]);
					}

					if InWater(h[iz][iy - 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy - 1][ix]);
					}

					if InWater(h[iz][iy + 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy + 1][ix]);
					}
				}
			}
		}
	}

	wrap_qz (work);

	/* Fourth order conservative dissipation on scalars - pass2 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix - 1]);
					}

					if InWater(h[iz][iy][ix + 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix + 1]);
					}

					if InWater(h[iz][iy - 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy - 1][ix]);
					}

					if InWater(h[iz][iy + 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy + 1][ix]);
					}
				}
			}
		}
	}
	wrap_qz (q);
}

void 
filt4m (float q[Mz][My][Mx])
{
	int ix, iy, iz;
	float damp, work[Mz][My][Mx];

	damp = 0.5 / 32.0;

	/* Fourth order filter on momentum - pass 1 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				work[iz][iy][ix] = 0.0;

				if InWater(uvh[iz][iy][ix])
				{
					if InWater(uvh[iz][iy][ix - 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix - 1]);
					}

					if InWater(uvh[iz][iy][ix + 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix + 1]);
					}

					if InWater(uvh[iz][iy - 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy - 1][ix]);
					}

					if InWater(uvh[iz][iy + 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy + 1][ix]);
					}
				}
			}
		}
	}

	wrap_qz (work);

	/* Fourth order conservative dissipation on momentum - pass2 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(uvh[iz][iy][ix])
				{
					if InWater(uvh[iz][iy][ix - 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix - 1]);
					}

					if InWater(uvh[iz][iy][ix + 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix + 1]);
					}

					if InWater(uvh[iz][iy - 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy - 1][ix]);
					}

					if InWater(uvh[iz][iy + 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy + 1][ix]);
					}
				}
			}
		}
	}
	wrap_qz (q);
}

void 
filt4p (float q[My][Mx])
{
	int ix, iy;
	float damp, work[My][Mx];

	damp = 0.5 / 32.0;

	/* Fourth order filter on pressure - pass 1 */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			work[iy][ix] = 0.0;

			if InWater(depth[iy][ix])
			{
				if InWater(depth[iy][ix - 1])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy][ix - 1]);
				}

				if InWater(depth[iy][ix + 1])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy][ix + 1]);
				}

				if InWater(depth[iy - 1][ix])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy - 1][ix]);
				}

				if InWater(depth[iy + 1][ix])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy + 1][ix]);
				}
			}
		}
	}

	wrap_q (work);

	/* Fourth order conservative dissipation on pressure - pass2 */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(depth[iy][ix])
			{
				if InWater(depth[iy][ix - 1])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy][ix - 1]);
				}

				if InWater(depth[iy][ix + 1])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy][ix + 1]);
				}

				if InWater(depth[iy - 1][ix])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy - 1][ix]);
				}

				if InWater(depth[iy + 1][ix])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy + 1][ix]);
				}
			}
		}
	}
	wrap_q (q);
}

void 
filt4s_wall (float q[Mz][My][Mx],float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, iz;
	float damp, work[Mz][My][Mx];

	damp = 0.5 / 32.0;

	/* Fourth order filter on scalars - pass 1 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				work[iz][iy][ix] = 0.0;

				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix - 1]);
					}

					if InWater(h[iz][iy][ix + 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix + 1]);
					}

					if InWater(h[iz][iy - 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy - 1][ix]);
					}

					if InWater(h[iz][iy + 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy + 1][ix]);
					}
				}
			}
		}
	}

	wrap_qz_wall (work,cwest,ceast,csouth,cnorth);

	/* Fourth order conservative dissipation on scalars - pass2 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix - 1]);
					}

					if InWater(h[iz][iy][ix + 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix + 1]);
					}

					if InWater(h[iz][iy - 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy - 1][ix]);
					}

					if InWater(h[iz][iy + 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy + 1][ix]);
					}
				}
			}
		}
	}
	wrap_qz_wall (q,cwest,ceast,csouth,cnorth);
}

void 
filt4m_wall (float q[Mz][My][Mx],float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, iz;
	float damp, work[Mz][My][Mx];

	damp = 0.5 / 32.0;

	/* Fourth order filter on momentum - pass 1 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				work[iz][iy][ix] = 0.0;

				if InWater(uvh[iz][iy][ix])
				{
					if InWater(uvh[iz][iy][ix - 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix - 1]);
					}

					if InWater(uvh[iz][iy][ix + 1])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy][ix + 1]);
					}

					if InWater(uvh[iz][iy - 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy - 1][ix]);
					}

					if InWater(uvh[iz][iy + 1][ix])
					{
						work[iz][iy][ix] -= (q[iz][iy][ix] - q[iz][iy + 1][ix]);
					}
				}
			}
		}
	}

	wrap_qz_wall (work,cwest,ceast,csouth,cnorth);

	/* Fourth order conservative dissipation on momentum - pass2 */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(uvh[iz][iy][ix])
				{
					if InWater(uvh[iz][iy][ix - 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix - 1]);
					}

					if InWater(uvh[iz][iy][ix + 1])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy][ix + 1]);
					}

					if InWater(uvh[iz][iy - 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy - 1][ix]);
					}

					if InWater(uvh[iz][iy + 1][ix])
					{
						q[iz][iy][ix] += damp * (work[iz][iy][ix] - work[iz][iy + 1][ix]);
					}
				}
			}
		}
	}
	wrap_qz_wall (q,cwest,ceast,csouth,cnorth);
}
void 
filt4p_wall (float q[My][Mx],float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy;
	float damp, work[My][Mx];

	damp = 0.5 / 32.0;

	/* Fourth order filter on pressure - pass 1 */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			work[iy][ix] = 0.0;

			if InWater(depth[iy][ix])
			{
				if InWater(depth[iy][ix - 1])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy][ix - 1]);
				}

				if InWater(depth[iy][ix + 1])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy][ix + 1]);
				}

				if InWater(depth[iy - 1][ix])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy - 1][ix]);
				}

				if InWater(depth[iy + 1][ix])
				{
					work[iy][ix] -= (q[iy][ix] - q[iy + 1][ix]);
				}
			}
		}
	}

	wrap_q_wall (work,cwest,ceast,csouth,cnorth);

	/* Fourth order conservative dissipation on pressure - pass2 */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(depth[iy][ix])
			{
				if InWater(depth[iy][ix - 1])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy][ix - 1]);
				}

				if InWater(depth[iy][ix + 1])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy][ix + 1]);
				}

				if InWater(depth[iy - 1][ix])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy - 1][ix]);
				}

				if InWater(depth[iy + 1][ix])
				{
					q[iy][ix] += damp * (work[iy][ix] - work[iy + 1][ix]);
				}
			}
		}
	}
	wrap_q_wall (q,cwest,ceast,csouth,cnorth);
}

#endif
