#include <stdio.h>
#include <math.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

void 
init_state ()
{
	int ix, iy, iz, jx, jy, jz;
	float lat, omega;

	omega = (366.0 / 365.0) * 2.0 * 3.14159 / (3600.0 * 24.0);
	/* orf why 366/365 ? */
	run_time = 0.0;

	printf("%i Z\n",my_address);

	/* convective adjustment */

	for (iy = 0; iy < My; iy++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			int mixing;

			mixing = 1;
			while (mixing)
			{
				mixing = 0;
				for (iz = Mz - 2; iz >= 0; iz--)
				{
					float d1, d2, snew, tnew;
					if (InWater(h[iz][iy][ix]) && InWater(h[iz + 1][iy][ix]))
					{
						d1 = density (annual_salt[iz][iy][ix], annual_temp[iz][iy][ix], 0.0);
						d2 = density (annual_salt[iz + 1][iy][ix], annual_temp[iz + 1][iy][ix], 0.0);
						if (d2 > (d1 + 2.0e-7)) /* was 1.0e-7 */
						{
							/* if ((d2-d1 > 1.8e-7) || (d2-d1 < 0.0)) printf("%e\n",(d2-d1)); */
							mixing = 1;

							snew = (annual_salt[iz][iy][ix] * h[iz][iy][ix] +
								annual_salt[iz + 1][iy][ix] * h[iz + 1][iy][ix]) /
							(h[iz][iy][ix] + h[iz + 1][iy][ix]);
							annual_salt[iz][iy][ix] = annual_salt[iz + 1][iy][ix] = snew;

							tnew = (annual_temp[iz][iy][ix] * h[iz][iy][ix] +
								annual_temp[iz + 1][iy][ix] * h[iz + 1][iy][ix]) /
							(h[iz][iy][ix] + h[iz + 1][iy][ix]);
							annual_temp[iz][iy][ix] = annual_temp[iz + 1][iy][ix] = tnew;
						}
					}
				}
			}
		}
	}
	printf("%i Y\n",my_address);
	/* set up tracer init state, fill the ocean with tracer, leave the
	 * bay alone */
	for (jz = 0; jz < Mz; jz++)
	{
		for (jy = 0; jy < Ny; jy++)
		{
			iy = jy - row * (My - 2) + 1;

			for (jx = 0; jx < Nx; jx++)
			{
				ix = jx - col * (Mx - 2) + 1;
				if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My)) {
/*					float loc;

					loc = (float) jy - (146./55.) * (float) (jx-20);
					
					if (loc < 0.0) a[jz][iy][ix] = 0.0; else
					a[jz][iy][ix] = 100.0;
*/
					
					if ( (jx == 36) && ( jy == 42) ) {
					  a[jz][iy][ix] = 200.0;
					} else {
					  a[jz][iy][ix] = 0.0;
					}

					al[jz][iy][ix] = ax[jz][iy][ix] = a[jz][iy][ix];
					
				}
			}
		}
	}

	printf("%i X\n",my_address);

	for (iz = 0; iz < Mz; iz++)
	{
		int it;
		for (iy = 0; iy < My; iy++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				ul[iz][iy][ix] = u[iz][iy][ix] = ux[iz][iy][ix] = 0.0;
				vl[iz][iy][ix] = v[iz][iy][ix] = vx[iz][iy][ix] = 0.0;
				/* orf */
				tl[iz][iy][ix] = t[iz][iy][ix] = tx[iz][iy][ix] = annual_temp[iz][iy][ix];
				sl[iz][iy][ix] = s[iz][iy][ix] = sx[iz][iy][ix] = annual_salt[iz][iy][ix];
				/* set all tracers equal to 0.0, SME should initialize them */
				for (it = 0; it < NumTracers; it++)
				{
					tr[it][iz][iy][ix] = trl[it][iz][iy][ix] = trx[it][iz][iy][ix] = 0.0;
				}

			}
		}
	}
	
	printf("%i A\n",my_address);

	for (iy = 0; iy < My; iy++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			ptopl[iy][ix] = ptop[iy][ix] = ptopx[iy][ix] = 0.0;
			t_forcing[iy][ix] = 0.0;
			s_forcing[iy][ix] = 0.0;
		}
	}

	printf("%i B\n",my_address);

	/* set up coriolis and curvature terms */
	for (jy = 0; jy < Ny; jy++)
	{
		float x1, x2, x3, del_lat;
		float to_radians = (3.14159265 / 180.0);
		iy = jy - row * (My - 2) + 1;

		/* our Bay geo starts at SouthLat */

		del_lat =  ((NorthLat - SouthLat) / Ny) * to_radians;
		if ((iy >= 0) && (iy < My))
		{
			lat = (SouthLat + del_lat * jy) * to_radians;
			f[iy] = 2.0 * omega * sin (lat);
			x1 = cos (lat - del_lat);
			x2 = cos (lat);
			x3 = cos (lat + del_lat);

			geo1[iy] = x1/x2;
			geo2[iy] = x3/x2;
			geo3[iy]=1.0/cos(lat);
		 	printf("info: %i lat = %f, f[%3i] = %e g1=%e g2=%e g3=%e\n",my_address,lat,iy,f[iy],geo1[iy],geo2[iy],geo3[iy]); 
		}
	}

	printf("%i C\n",my_address);

	/*
	for (iy = 0; iy < My; iy++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			if InWater(h[Nz - 1][iy][ix])
			{
				taux[iy][ix] = strx[iy][ix] / (1030.0 * h[Nz - 1][iy][ix]);
				tauy[iy][ix] = stry[iy][ix] / (1030.0 * h[Nz - 1][iy][ix]);
			}
			else
			{
				taux[iy][ix] = 0.0;
				tauy[iy][ix] = 0.0;
			}
		}
	}
	wrap_q_wall_d (taux,1.0,1.0,1.0,1.0);
	wrap_q_wall_d (tauy,1.0,1.0,1.0,1.0);
	*/
}

