#include <stdio.h>
#include <math.h>
#include <mpi.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"
 
void
read_geometry ()
{
	int ix, iy, jx, jy, jz;
	FILE *tfile;
	int tt;
	/*
	unsigned char in[2 * Nx], *inptr, t1, t2;
	*/
	unsigned char *in = memalloc1duschar("in",in,2*Nx), *inptr, t1, t2;

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, GeometryFileName);
		tfile = fopen (buff, "r");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on geometry file %s failed.\n",buff);
		exit (89);
	}

	/* read depths of two types of grid levels */
	/* eliminated in cbay */
/*
   if(my_address == 0) fread(in,sizeof(char),2*Nz,tfile);
   MPI_Bcast(in,2*Nz,MPI_CHAR,0,MPI_COMM_WORLD);
   inptr = in;
   for(jz = 0; jz < Nz; jz++)
   {
		t1 = *inptr++; t2 = *inptr++;
		tt = t1*256 + t2;
		uvts_levels[jz] = tt;
		printf("%d %f\n",jz,uvts_levels[jz]);
   }

   if(my_address == 0) fread(in,sizeof(char),2*Nz,tfile);
   MPI_Bcast(in,2*Nz,MPI_CHAR,0,MPI_COMM_WORLD);
   inptr = in;
   for(jz = 0; jz < Nz; jz++)
   {
   t1 = *inptr++; t2 = *inptr++;
   tt = t1*256 + t2;
   w_levels[jz] = tt;
   }
 */

	for (jz = Nz - 1; jz >= 0; jz--)	/* read 3-D topo field */
	{
		for (jy = 0; jy < Ny; jy++)
		{
			iy = jy - row * (My - 2) + 1;
			if (my_address == 0)
			fread (in, sizeof (char), 2 * Nx, tfile);
			MPI_Bcast (in, 2 * Nx, MPI_CHAR, 0, MPI_COMM_WORLD);
			inptr = in;
			for (jx = 0; jx < Nx; jx++)
			{
				ix = jx - col * (Mx - 2) + 1;
				t1 = *inptr++;
				t2 = *inptr++;
				tt = t1 * 256 + t2;
				if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My))
				{
					h[jz][iy][ix] = /* 0.01 * */ (float) tt; /* orf NOTE... multiplied by 100 in readcb.c! this gets us around
														grid resolutions less than 1 meter while still using JA format */
/*
					fprintf(fp_dat,"%i %3i %3i %3i %f\n",my_address,ix,iy,jz,h[jz][iy][ix]);
*/
/*
					if (h[jz][iy][ix] == 1.0)
					h[jz][iy][ix] = 1.01;
*/
				}
			}
		}
	}

	if (my_address == 0)
	fclose (tfile);

	wrap_qz_wall_d (h,1.0,1.0,1.0,1.0);

	fp_dat = fopen ("dat", "w");
	for (iy = 1; iy < My - 1; iy++)	/* fill depth and reciprical depth arrays */
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			depth[iy][ix] = 0.0;
			uvdepth[iy][ix] = 0.0;
			for (jz = 0; jz < Nz; jz++)
			{
				depth[iy][ix] += h[jz][iy][ix];
				/*
				fprintf(fp_dat,"%i %3i %3i %f\n",my_address,ix,iy,depth[iy][ix]);
				*/
				/*
				fprintf(fp_dat,"%f\n",depth[iy][ix]);
				*/

				if (InWater(h[jz][iy][ix + 1]) && InWater(h[jz][iy][ix - 1])
				&& InWater(h[jz][iy + 1][ix]) && InWater(h[jz][iy - 1][ix]))
				{
					uvdepth[iy][ix] += h[jz][iy][ix];
					uvh[jz][iy][ix] = h[jz][iy][ix];
				}
				else
				{
					uvh[jz][iy][ix] = 0.0;
				}
			}
			if InWater(depth[iy][ix])
			rdepth[iy][ix] = 1.0 / depth[iy][ix];
			else
			rdepth[iy][ix] = 0.0;

			if InWater(uvdepth[iy][ix])
			ruvdepth[iy][ix] = 1.0 / uvdepth[iy][ix];
			else
			ruvdepth[iy][ix] = 0.0;
		}
	}

	fclose(fp_dat);

	wrap_q_wall_d (depth,1.0,1.0,1.0,1.0);
	wrap_q_wall_d (uvdepth,1.0,1.0,1.0,1.0);
	wrap_q_wall_d (rdepth,1.0,1.0,1.0,1.0);
	wrap_q_wall_d (ruvdepth,1.0,1.0,1.0,1.0);
	wrap_qz_wall_d (uvh,1.0,1.0,1.0,1.0);
	free(in);
}

void 
read_stress () /* orf will call this when we have real stress data */
{
	int ix, iy, jx, jy;
	FILE *tfile;
	int tt;
	/*
	unsigned char in[2 * Nx], *inptr, t1, t2;
	*/
	unsigned char *in = memalloc1duschar("in",in,2*Nx), *inptr, t1, t2;

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, "om3.stress");
		tfile = fopen (buff, "r");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on stress failed.\n");
		exit (89);
	}


	for (jy = 0; jy < Ny; jy++)	/* read x-stress field */
	{
		iy = jy - row * (My - 2) + 1;
		if (my_address == 0)
		fread (in, sizeof (char), 2 * Nx, tfile);
		MPI_Bcast (in, 2 * Nx, MPI_CHAR, 0, MPI_COMM_WORLD);
		inptr = in;

		for (jx = 0; jx < Nx; jx++)
		{
			ix = jx - col * (Mx - 2) + 1;
			t1 = *inptr++;
			t2 = *inptr++;
			tt = t1 * 256 + t2;
			if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My))
			strx[iy][ix] = ((float) tt / 10000.0) - 0.3;
		}
	}

	for (jy = 0; jy < Ny; jy++)	/* read y-stress field */
	{
		iy = jy - row * (My - 2) + 1;
		if (my_address == 0)
		fread (in, sizeof (char), 2 * Nx, tfile);
		MPI_Bcast (in, 2 * Nx, MPI_CHAR, 0, MPI_COMM_WORLD);
		inptr = in;

		for (jx = 0; jx < Nx; jx++)
		{
			ix = jx - col * (Mx - 2) + 1;
			t1 = *inptr++;
			t2 = *inptr++;
			tt = t1 * 256 + t2;
			if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My))
			stry[iy][ix] = ((float) tt / 10000.0) - 0.3;
		}
	}
	if (my_address == 0)
	fclose (tfile);
	free(in);
}
void 
read_freshwater ()
/* reads a 2d mask array, zero (boolean false) everywhere except where we are at the
 * beginning of a river, where the value is 1 (boolean true) */
{
	int ix, iy, jx, jy;
	FILE *tfile;
	int tt;
	unsigned char *in = memalloc1duschar("in",in,Nx), *inptr, t1, t2;

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, "freshwater.geometry");
		tfile = fopen (buff, "r");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on stress failed.\n");
		exit (89);
	}

	for (jy = 0; jy < Ny; jy++)	/* read freshwater mask field */
	{
		iy = jy - row * (My - 2) + 1;
		if (my_address == 0)
		fread (in, sizeof (char), Nx, tfile);
		MPI_Bcast (in, Nx, MPI_CHAR, 0, MPI_COMM_WORLD);
		inptr = in;

		for (jx = 0; jx < Nx; jx++)
		{
			ix = jx - col * (Mx - 2) + 1;
			t1 = *inptr++;
			if ((ix > 0) && (ix < Mx-1) && (iy > 0) && (iy < My-1))
			{
				freshwater[iy][ix] = (int)t1;
				if(freshwater[iy][ix]==1)
				printf("freshwater:%i %i %i\n",my_address,Ny-jy,jx);
			}
		}
	}
}

void read_annual_temp_simple ()
{
	int ix,iy,iz;

	/* very simple, annual temp is same everywhere */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				annual_temp[iz][iy][ix] = 11.0; /* was 24 */
			}
		}
	}
	wrap_qz_wall_d (annual_temp,1.0,1.0,1.0,1.0);
}

void read_annual_salt_simple ()
{
	int ix, iy, jx, jy, jz;

/* vertically & longitudinally averaged salinity field,
only variation is latitudinal (N/S) */

	for (jz = 0; jz < Mz; jz++)
	{
		for (jy = 0; jy < Ny; jy++)
		{
			iy = jy - row * (My - 2) + 1;

			for (jx = 0; jx < Nx; jx++)
			{
				ix = jx - col * (Mx - 2) + 1;
				if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My))
				{
					float loc;

					/*annual_salt[jz][iy][ix] = flin[jx]; */

/* orf this should be about right for this
 * particular topo file. draw an imaginary line and check which side of
 * this line we are on */
					
/* y=mx+b; y = (146/55) (x - 20) */

					loc = (float) jy - (146./55.) * (float) (jx-100);
					
					if (loc < 0.0 || jy < 60) annual_salt[jz][iy][ix] = 30.0; else
					annual_salt[jz][iy][ix] = 30.0 * ((float)(Ny-jy)/(float)(Ny-60));
					
				}
			}
		}
	}
	wrap_qz_wall_d (annual_salt,1.0,1.0,1.0,1.0);
}

void 
read_annual_temp () /* orf will call this when we have real data */
{
	int ix, iy, jx, jy, jz;
	FILE *tfile;
	int tt;
	/*
	unsigned char in[2 * Nx], *inptr, t1, t2;
	float flin[Nx];
	*/
	unsigned char *in = memalloc1duschar("in",in,2*Nx), *inptr, t1, t2;
	float *flin = memalloc1dfloat ("flin",flin,Nx);

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, "om3.temp");
		tfile = fopen (buff, "r");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on temp failed.\n");
		exit (89);
	}
	
	/* If we get real temp data this will become active, right now it is
	 * base_t is set by hand below */
	for (jz = Nz - 1; jz >= 0; jz--)	/* read 3-D temp field */
	{
		for (jy = 0; jy < Ny; jy++)
		{
			iy = jy - row * (My - 2) + 1;
			if (my_address == 0)
			{
				float fxx;
				fread (in, sizeof (char), 2 * Nx, tfile);
				inptr = in;
				fxx = 0.0;
				for (jx = 0; jx < Nx; jx++)
				{
					t1 = *inptr++;
					t2 = *inptr++;
					tt = t1 * 256 + t2;
					flin[jx] = ((float) tt - 10000.0) / 100.0;
					fxx += flin[jx];
				}
				fxx = fxx / Nx;
				for (jx = 0; jx < Nx; jx++)
				flin[jx] = fxx;
				if (jy == 85)
				base_t[jz] = flin[0];
			}
			/* will discard base_t */
	base_t[15] = 24.0;
	base_t[14] = 24.0;
	base_t[13] = 24.0;
	base_t[12] = 24.0;
	base_t[11] = 24.0;
	base_t[10] = 24.0;
	base_t[9] = 24.0;
	base_t[8] = 24.0;
	base_t[7] = 24.0;
	base_t[6] = 24.0;
	base_t[5] = 24.0;
	base_t[4] = 24.0;
	base_t[3] = 24.0;
	base_t[2] = 24.0;
	base_t[1] = 24.0;
	base_t[0] = 24.0;

			MPI_Bcast (flin, Nx, MPI_FLOAT, 0, MPI_COMM_WORLD);


			for (jx = 0; jx < Nx; jx++)
			{
				ix = jx - col * (Mx - 2) + 1;
				if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My))
				{
					/*annual_temp[jz][iy][ix] = flin[jx]; */
					annual_temp[jz][iy][ix] = base_t[jz];
				}
			}
		}
	}
	if (my_address == 0)
	fclose (tfile);
	MPI_Bcast (base_t, Mz, MPI_FLOAT, 0, MPI_COMM_WORLD);
	wrap_qz_wall_d (annual_temp,1.0,1.0,1.0,1.0);
	free(in);
	free(flin);
}

void 
read_annual_salt () /* will call this when we have real salt data */
{
	int ix, iy, jx, jy, jz;
	FILE *tfile;
	int tt;
	/*
	unsigned char in[2 * Nx], *inptr, t1, t2;
	float flin[Nx];
	*/
	unsigned char *in = memalloc1duschar("in",in,2*Nx), *inptr, t1, t2;
	float *flin = memalloc1dfloat ("flin",flin,Nx);

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, "sal.geometry");
		tfile = fopen (buff, "r");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on salt failed.\n");
		exit (89);
	}

	for (jz = Nz - 1; jz >= 0; jz--)	/* read 3-D salinity field */
	{
		for (jy = 0; jy < Ny; jy++)
		{
			iy = jy - row * (My - 2) + 1;
			if (my_address == 0)
			{
				float fxx;
				fread (in, sizeof (char), 2 * Nx, tfile);
				inptr = in;
				fxx = 0.0;
				for (jx = 0; jx < Nx; jx++)
				{
					t1 = *inptr++;
					t2 = *inptr++;
					tt = t1 * 256 + t2;
					flin[jx] = ((float) tt ) / 100.0;
					/* if (jz==Mz-1) printf("%f\n",flin[jx]); */
					fxx += flin[jx];
				}
				/* why averaged in x?? */
			/*
				fxx = fxx / Nx;
				for (jx = 0; jx < Nx; jx++)
				flin[jx] = fxx;
				if(jy == 85) base_s[jz] = flin[0];
				base_s[jz] = 22.0;
				base_s discarded for cbay
			*/
			}

			MPI_Bcast (flin, Nx, MPI_FLOAT, 0, MPI_COMM_WORLD);

			for (jx = 0; jx < Nx; jx++)
			{
				ix = jx - col * (Mx - 2) + 1;
				if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My))
				{
					annual_salt[jz][iy][ix] = flin[jx];
				}
			}
		}
	}
	if (my_address == 0)
	fclose (tfile);
	MPI_Bcast (base_s, Mz, MPI_FLOAT, 0, MPI_COMM_WORLD);
	wrap_qz_wall_d (annual_salt,1.0,1.0,1.0,1.0);
	free(in);
	free(flin);
}
