#include <stdio.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

float *** memalloc3dfloat (char *varname, float ***a, int nz, int ny, int nx)
{
	int iy, iz;
	int size;

	size = nz * sizeof(float **);

	if ((a = (float ***) malloc (size)) == NULL)
	{
		printf("memalloc3dfloat[%i]: Could not allocate %i bytes for %s, bailing\n",my_address,size,varname);
		exit (-1);
	}

	size = ny * sizeof(float *);

	for (iz = 0; iz < nz; iz++)
	{
		if ((a[iz] = (float **) malloc (size)) == NULL)
		{
			printf("memalloc3dfloat[%i]: Could not allocate %i bytes for %s, bailing\n",my_address,size,varname);
			exit (-1);
		}
	}

	size = nz * ny * nx * sizeof(float);

	if ((a[0][0] = (float *)malloc(size))==NULL) /* one fat contiguous chunk of memory */
	{
		printf("memalloc3dfloat[%i]: Could not allocate %i bytes for %s, bailing\n",my_address,size,varname);
		exit (-1);
	}

 /* this pointer arithmatic sets things up right for referencing
 a 3-d contiguous array, which is assumed for some of the model's
 code. Raggedly allocated memory will cause bad things to happen */

	for(iz = 0; iz < nz; iz++)
	{
		for(iy = 0; iy < ny; iy++)
		{
			a[iz][iy] = a[0][0] + iz * (ny * nx) + iy * nx;
		}
	}

	return a;

}

float ** memalloc2dfloat (char *varname, float **a, int ny, int nx)
{
	int iy;

	/* contiguous a la 3d above */

	if ((a = (float **) malloc (ny * sizeof(float *))) == NULL)
	{
		printf("memalloc2dfloat: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}

	if ((a[0] = (float *)malloc(ny * nx * sizeof(float)))==NULL)
	{
		printf("memalloc2dfloat: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}

	/* this pointer arithmatic makes the array contiguous, which is needed for wrap_q_wall etc */
	for(iy = 1; iy < ny; iy++) a[iy] = a[0] + iy * nx;
	
	return a;

}

float * memalloc1dfloat (char *varname, float *a, int nx)
{

	if ((a = (float *) malloc (nx * sizeof (float))) == NULL)
	{
		printf("memalloc1dfloat: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}
	return a;
}
int ** memalloc2dint (char *varname, int **a, int ny, int nx)
{
	int iy;

	/* contiguous a la 3d above */

	if ((a = (int **) malloc (ny * sizeof(int *))) == NULL)
	{
		printf("memalloc2dint: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}

	if ((a[0] = (int *)malloc(ny * nx * sizeof(int)))==NULL)
	{
		printf("memalloc2dint: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}

	/* this pointer arithmatic makes the array contiguous, which is needed for wrap_q_wall etc */
	for(iy = 1; iy < ny; iy++) a[iy] = a[0] + iy * nx;
	
	return a;

}

unsigned char *** memalloc3duschar (char *varname, unsigned char ***a, int nz, int ny, int nx)
{
	int iy, iz;
	int size;

	size = nz * sizeof(unsigned char **);

	if ((a = (unsigned char ***) malloc (size)) == NULL)
	{
		printf("memalloc3duschar[%i]: Could not allocate %i bytes for %s, bailing\n",my_address,size,varname);
		exit (-1);
	}

	size = ny * sizeof(unsigned char *);

	for (iz = 0; iz < nz; iz++)
	{
		if ((a[iz] = (unsigned char **) malloc (size)) == NULL)
		{
			printf("memalloc3duschar[%i]: Could not allocate %i bytes for %s, bailing\n",my_address,size,varname);
			exit (-1);
		}
	}

	size = nz * ny * nx * sizeof(unsigned char);

	if ((a[0][0] = (unsigned char *)malloc(size))==NULL) /* one fat contiguous chunk of memory */
	{
		printf("memalloc3duschar[%i]: Could not allocate %i bytes for %s, bailing\n",my_address,size,varname);
		exit (-1);
	}

	/* this pointer arithmatic sets things up right for referencing a 3-d  contiguous array, which is
	 * assumed for some of the model's code. Raggedly allocated memory
	 * will cause bad things to happen */

	for(iz = 0; iz < nz; iz++)
	{
		for(iy = 0; iy < ny; iy++)
		{
			a[iz][iy] = a[0][0] + iz * (ny * nx) + iy * nx;
		}
	}

	return a;
}

unsigned char ** memalloc2duschar (char *varname, unsigned char **a, int ny, int nx)
{
	int iy;

	/* contiguous a la 3d above */

	if ((a = (unsigned char **) malloc (ny * sizeof(unsigned char *))) == NULL)
	{
		printf("memalloc2duschar: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}

	if ((a[0] = (unsigned char *)malloc(ny * nx * sizeof(unsigned char)))==NULL)
	{
		printf("memalloc2duschar: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}

	/* this pointer arithmatic makes the array contiguous, which is needed for wrap_q_wall etc */
	for(iy = 1; iy < ny; iy++) a[iy] = a[0] + iy * nx;
	
	return a;

}

unsigned char * memalloc1duschar (char *varname, unsigned char *a, int nx)
{

	if ((a = (unsigned char *) malloc (nx * sizeof (unsigned char))) == NULL)
	{
		printf("memalloc1duschar: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}
	return a;
}

char * memalloc1dchar (char *varname, char *a, int nx)
{

	if ((a = (char *) malloc (nx * sizeof (char))) == NULL)
	{
		printf("memalloc1dchar: Could not allocate memory for %s, bailing\n",varname);
		exit (-1);
	}
	return a;
}

void free3d (void ***a, int nz)
{

	int iz;

	free(a[0][0]);

	for (iz = 0; iz < nz; iz++)
	{
		free(a[iz]);
	}

	free(a);
}

void free2d (void **a)
{

	free(a[0]);
	free(a);
}
