#include <stdio.h>
#include <math.h>
#include <mpi.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"
/*
 * We write a picture one node at a time in cm5 order.
 * In this (non piofs) version each write is staged throught the
 * root node.
 */
void 
write_picture_d (float **a, float vmax)
{
	int ix, iy;
	int len, pixel_val;
	float val, scl;
	char buf[200];

	fflush (of);

	/* write header with Nx, Ny, Ncols, Nrows */

	sprintf (buf, "%d %d %d %d\n", Nx, Ny, Ncols, Nrows);
	len = strlen (buf);
	if (my_address == 0)
	write (ofile, buf, len);

	scl = 40.0 / (vmax);

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)	/* fill buffer in parallel */
		{
			val = scl * a[iy][ix];
			pixel_val = ((int) fabs (val + 0.5)) % 40;

			if (val > 0)
			pixel_val = 41 + pixel_val;	/* red colors in std map */
			else
			pixel_val = 81 + pixel_val;	/* blue colrs in std map */

			if InWater(h[Nz - 1][iy][ix])
			picbuf[iy - 1][ix - 1] = pixel_val;
			else
			picbuf[iy - 1][ix - 1] = 0;	/* zero out dry cells */
		}
	}
	global_write ();
}


void 
global_write ()
{
	int i, j, ierr;
	MPI_Status status;


	ierr = MPI_Bsend (&(picbuf[0][0]), (Mx - 2) * (My - 2), MPI_CHAR, 0, 99, MPI_COMM_WORLD);
	if (ierr != 0)
	{
		printf ("error: OM3 Bsend error %d\n", ierr);
		exit (1);
	}


	if (my_address == 0)
	{
		for (i = 0; i < Nrows; i++)
		{
			for (j = 0; j < Ncols; j++)
			{

				MPI_Recv (&(picbuf[0][0]), (Mx - 2) * (My - 2), MPI_CHAR, i * Ncols + j,
				 99, MPI_COMM_WORLD, &status);

				write (ofile, picbuf, (Mx - 2) * (My - 2));
			}
		}
	}
}

#ifdef OLD 

void 
write_picture (float a[My][Mx], float vmax)
{
	int ix, iy;
	int len, pixel_val;
	float val, scl;
	char buf[200];

	fflush (of);

	/* write header with Nx, Ny, Ncols, Nrows */

	sprintf (buf, "%d %d %d %d\n", Nx, Ny, Ncols, Nrows);
	len = strlen (buf);
	if (my_address == 0)
	write (ofile, buf, len);

	scl = 40.0 / (vmax);

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)	/* fill buffer in parallel */
		{
			val = scl * a[iy][ix];
			pixel_val = ((int) fabs (val + 0.5)) % 40;

			if (val > 0)
			pixel_val = 41 + pixel_val;	/* red colors in std map */
			else
			pixel_val = 81 + pixel_val;	/* blue colrs in std map */

			if InWater(h[Nz - 1][iy][ix])
			picbuf[iy - 1][ix - 1] = pixel_val;
			else
			picbuf[iy - 1][ix - 1] = 0;	/* zero out dry cells */
		}
	}
	global_write ();
}

void 
fwrite_picture (float a[My][Mx], float vmax)
{
	int ix, iy;
	int len, pixel_val;
	float val, scl;
	char buf[200];

	/* write header with Nx, Ny, Ncols, Nrows */
	sprintf (buf, "%d %d %d %d\n", Nx, Ny, Ncols, Nrows);
	len = strlen (buf);
	if (my_address == 0)
	write (ofile, buf, len);

	scl = 40.0 / (vmax);

	for (iy = 1; iy < My; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)	/* fill buffer in parallel */
		{
			if InWater(h[Nz - 1][iy][ix + 1])
			work[iy][ix] = 0.5 * (a[iy][ix] + a[iy][ix + 1]);
			else
			work[iy][ix] = a[iy][ix];
		}
	}

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)	/* fill buffer in parallel */
		{
			if InWater(h[Nz - 1][iy + 1][ix])
			val = scl * 0.5 * (work[iy][ix] + work[iy + 1][ix]);
			else
			val = scl * work[iy][ix];

			pixel_val = ((int) fabs (val + 0.5)) % 40;

			if (val > 0)
			pixel_val = 41 + pixel_val;	/* red colors in std map */
			else
			pixel_val = 81 + pixel_val;	/* blue colrs in std map */

			if InWater(h[Nz - 1][iy][ix])
			picbuf[iy - 1][ix - 1] = pixel_val;
			else
			picbuf[iy - 1][ix - 1] = 0;	/* zero out dry cells */
		}
	}
	global_write ();
}

#endif
