#include <stdio.h>
#include <math.h>
#include <mpi.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

#if (defined(RestartRun) || defined(RestartSave))
void 
load_restart ()
{
	int jz;
	FILE *tfile;

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, RestartRunName);
		tfile = fopen (buff, "r");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on restart read failed.\n");
		fflush (of);
		exit (89);
	}

	for (jz = 0; jz < Nz; jz++)	/* model state fields */
	{
		read_restart_slice_d (u[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_d (ul[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_d (v[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_d (vl[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_d (t[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_d (tl[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_d (s[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_d (sl[jz], tfile);
	}
	read_restart_slice_d (ptop, tfile);
	read_restart_slice_d (ptopl, tfile);

	if (my_address == 0)
	{
		fread (&run_time, sizeof (double), 1, tfile);
	}
	read_restart_slice (t_forcing, tfile);
	read_restart_slice (s_forcing, tfile);

	if (my_address == 0)
	fclose (tfile);
}

void 
load_restart_wall ()
{
	int jz;
	FILE *tfile;

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, RestartRunName);
		tfile = fopen (buff, "r");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on restart read failed.\n");
		fflush (of);
		exit (89);
	}

	for (jz = 0; jz < Nz; jz++)	/* model state fields */
	{
		read_restart_slice_wall_d (u[jz], tfile,-1.0,-1.0,1.0,1.0);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_wall_d (ul[jz], tfile,-1.0,-1.0,1.0,1.0);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_wall_d (v[jz], tfile,1.0,1.0,-1.0,-1.0);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_wall_d (vl[jz], tfile,1.0,1.0,-1.0,-1.0);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_wall_d (t[jz], tfile,1.0,1.0,1.0,1.0);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_wall_d (tl[jz], tfile,1.0,1.0,1.0,1.0);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_wall_d (s[jz], tfile,1.0,1.0,1.0,1.0);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		read_restart_slice_wall_d (sl[jz], tfile, 1.0, 1.0, 1.0, 1.0);
	}
	read_restart_slice_wall_d (ptop, tfile,1.0,1.0,1.0,1.0);
	read_restart_slice_wall_d (ptopl, tfile,1.0,1.0,1.0,1.0);

	if (my_address == 0)
	{
		fread (&run_time, sizeof (double), 1, tfile);
	}
	read_restart_slice_wall_d (t_forcing, tfile,1.0,1.0,1.0,1.0);
	read_restart_slice_wall_d (s_forcing, tfile,1.0,1.0,1.0,1.0);

	if (my_address == 0)
	fclose (tfile);
}

void 
read_restart_slice_d (float **a, FILE * tfile)
{
	int ix, iy, jx, jy;
	float row_in[Nx];

	for (jy = 0; jy < Ny; jy++)	/* read xy field */
	{
		iy = jy - row * (My - 2) + 1;
		if (my_address == 0)
		fread (row_in, sizeof (float), Nx, tfile);
		MPI_Bcast (row_in, Nx, MPI_FLOAT, 0, MPI_COMM_WORLD);
		for (jx = 0; jx < Nx; jx++)
		{
			ix = jx - col * (Mx - 2) + 1;
			if ((ix > 0) && (ix < Mx - 1) && (iy > 0) && (iy < My - 1))
			{
				a[iy][ix] = row_in[jx];
			}
		}
	}
	wrap_q_wall_d (a);
}
void 
read_restart_slice (float a[My][Mx], FILE * tfile)
{
	int ix, iy, jx, jy;
	float row_in[Nx];

	for (jy = 0; jy < Ny; jy++)	/* read xy field */
	{
		iy = jy - row * (My - 2) + 1;
		if (my_address == 0)
		fread (row_in, sizeof (float), Nx, tfile);
		MPI_Bcast (row_in, Nx, MPI_FLOAT, 0, MPI_COMM_WORLD);
		for (jx = 0; jx < Nx; jx++)
		{
			ix = jx - col * (Mx - 2) + 1;
			if ((ix > 0) && (ix < Mx - 1) && (iy > 0) && (iy < My - 1))
			{
				a[iy][ix] = row_in[jx];
			}
		}
	}
	wrap_q (a);
}

void 
read_restart_slice_wall_d (float **a, FILE * tfile,
		float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, jx, jy;
	float row_in[Nx];

	for (jy = 0; jy < Ny; jy++)	/* read xy field */
	{
		iy = jy - row * (My - 2) + 1;
		if (my_address == 0)
		fread (row_in, sizeof (float), Nx, tfile);
		MPI_Bcast (row_in, Nx, MPI_FLOAT, 0, MPI_COMM_WORLD);
		for (jx = 0; jx < Nx; jx++)
		{
			ix = jx - col * (Mx - 2) + 1;
			if ((ix > 0) && (ix < Mx - 1) && (iy > 0) && (iy < My - 1))
			{
				a[iy][ix] = row_in[jx];
			}
		}
	}
	wrap_q_wall_d (a,cwest,ceast,cnorth,csouth);
}
void 
read_restart_slice_wall (float a[My][Mx], FILE * tfile,
		float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, jx, jy;
	float row_in[Nx];

	for (jy = 0; jy < Ny; jy++)	/* read xy field */
	{
		iy = jy - row * (My - 2) + 1;
		if (my_address == 0)
		fread (row_in, sizeof (float), Nx, tfile);
		MPI_Bcast (row_in, Nx, MPI_FLOAT, 0, MPI_COMM_WORLD);
		for (jx = 0; jx < Nx; jx++)
		{
			ix = jx - col * (Mx - 2) + 1;
			if ((ix > 0) && (ix < Mx - 1) && (iy > 0) && (iy < My - 1))
			{
				a[iy][ix] = row_in[jx];
			}
		}
	}
	wrap_q_wall (a,cwest,ceast,cnorth,csouth);
}

void 
save_restart ()
{
	int jz;
	FILE *tfile;

	if (my_address == 0)
	{
		sprintf (buff, "%s/%s", data_directory, RestartSaveName);
		tfile = fopen (buff, "w");
	}
	if ((tfile == 0) && (my_address == 0))
	{
		printf ("error: OM3 fopen on restart write failed.\n");
		fflush (of);
		exit (1);
	}
	else if (my_address == 0)
	{
		printf ("info: OM3 open ok \n");
		fflush (of);
	}

	for (jz = 0; jz < Nz; jz++)	/* model state fields */
	{
		write_restart_slice (u[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		write_restart_slice (ul[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		write_restart_slice (v[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		write_restart_slice (vl[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		write_restart_slice (t[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		write_restart_slice (tl[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		write_restart_slice (s[jz], tfile);
	}
	for (jz = 0; jz < Nz; jz++)
	{
		write_restart_slice (sl[jz], tfile);
	}
	write_restart_slice (ptop, tfile);
	write_restart_slice (ptopl, tfile);

	if (my_address == 0)
	{
		fwrite (&run_time, sizeof (double), 1, tfile);
	}
	write_restart_slice (t_forcing, tfile);
	write_restart_slice (s_forcing, tfile);

	if (my_address == 0)
	fclose (tfile);
}

void 
write_restart_slice_d (float **a, FILE * tfile)
{
	int jrow, jcol, jy, iy;

	float row_out[Mx - 2];
	MPI_Status status;
	int ierr;


	for (jy = 0; jy < Ny; jy++)	/* write xy field in natural order */
	{
		jrow = jy / (My - 2);
		iy = jy - jrow * (My - 2) + 1;
		for (jcol = 0; jcol < Ncols; jcol++)	/* write in column order */
		{
			if ((col == jcol) && (row == jrow))		/* Select source processor */
			{
				ierr = MPI_Bsend (&(a[iy][1]), Mx - 2, MPI_FLOAT, 0, 99, MPI_COMM_WORLD);
				if (ierr != 0)
				{
					printf ("error: OM3 Bsend error in write_restart_slice: %d\n", ierr);
					fflush (of);
					exit (1);
				}
			}
			if (my_address == 0)
			{
				MPI_Recv (row_out, Mx - 2, MPI_FLOAT, jrow * Ncols + jcol,
				 99, MPI_COMM_WORLD, &status);
				fwrite (row_out, sizeof (float), Mx - 2, tfile);
			}
			MPI_Barrier (MPI_COMM_WORLD);

		}
	}
}
void 
write_restart_slice (float a[My][Mx], FILE * tfile)
{
	int jrow, jcol, jy, iy;

	float row_out[Mx - 2];
	MPI_Status status;
	int ierr;


	for (jy = 0; jy < Ny; jy++)	/* write xy field in natural order */
	{
		jrow = jy / (My - 2);
		iy = jy - jrow * (My - 2) + 1;
		for (jcol = 0; jcol < Ncols; jcol++)	/* write in column order */
		{
			if ((col == jcol) && (row == jrow))		/* Select source processor */
			{
				ierr = MPI_Bsend (&(a[iy][1]), Mx - 2, MPI_FLOAT, 0, 99, MPI_COMM_WORLD);
				if (ierr != 0)
				{
					printf ("error: OM3 Bsend error in write_restart_slice: %d\n", ierr);
					fflush (of);
					exit (1);
				}
			}
			if (my_address == 0)
			{
				MPI_Recv (row_out, Mx - 2, MPI_FLOAT, jrow * Ncols + jcol,
				 99, MPI_COMM_WORLD, &status);
				fwrite (row_out, sizeof (float), Mx - 2, tfile);
			}
			MPI_Barrier (MPI_COMM_WORLD);

		}
	}
}
#endif
